/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.comm;

import com.cisco.dcbu.sme.comm.SessionKey;
import com.cisco.dcbu.sme.comm.Vsh;
import com.cisco.dcbu.sme.comm.VshWrap;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.exception.SMESwitchCommunicationException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SwitchCommFactory {
    private static SwitchCommFactory s_instance = null;
    private static ArrayList<SessionKey> sessions = new ArrayList();
    private static ArrayList<SessionKey> oneTimeSessions = new ArrayList();
    private static String SME_FM_CONNECT = "sme-fm-connect\n";
    private static int id = 0;
    static Logger _Logger = Logger.getLogger((String)"SME");

    private SwitchCommFactory() {
        SMESessionWorker worker = new SMESessionWorker();
        worker.start();
    }

    public static synchronized SwitchCommFactory getInstance() {
        if (s_instance == null) {
            s_instance = new SwitchCommFactory();
        }
        return s_instance;
    }

    public Vsh getCLISshSession(String clusterName, String host, String userName, String pwd, boolean isEncrypted) throws SMEException {
        _Logger.debug((Object)("Opening a new CLI session for user " + userName + " cluster " + clusterName + " to switch " + host));
        Vsh _vsh = null;
        if (host == null) {
            _Logger.warn((Object)("Failed to open new CLI session for user " + userName + " cluster " + clusterName + " to switch " + host));
            throw new SMESwitchCommunicationException("Failed to open new CLI session for user " + userName + " cluster " + clusterName + " to switch " + host);
        }
        try {
            _vsh = SwitchCommFactory.connectCLI(host, userName, pwd, isEncrypted);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to open new CLI session for user " + userName + " cluster " + clusterName + " to switch " + host + " Error: " + se.getMessage()));
            throw se;
        }
        if (_vsh == null) {
            _Logger.warn((Object)("Failed to open new CLI session for user " + userName + " cluster " + clusterName + " to switch " + host));
            throw new SMESwitchCommunicationException("Failed to open new CLI session for user " + userName + " cluster " + clusterName + " to switch " + host);
        }
        _Logger.debug((Object)("New CLI session opened for user " + userName + " cluster " + clusterName + " to switch " + host));
        return _vsh;
    }

    private static Vsh connectCLI(String host, String user, String pass, boolean isEncrypted) throws SMEException {
        boolean connected = false;
        Vsh _vsh = new Vsh(host, user, pass, null);
        _vsh.setTimeout(0);
        try {
            connected = _vsh.connect(isEncrypted);
        }
        catch (Exception e) {
            _vsh = SwitchCommFactory.cleanupVsh(_vsh);
            throw new SMESwitchCommunicationException("Failed to communicate with switch: " + host + " Error: " + e.getMessage());
        }
        if (!connected) {
            _vsh = SwitchCommFactory.cleanupVsh(_vsh);
            throw new SMESwitchCommunicationException("Failed to communicate with switch: " + host);
        }
        return _vsh;
    }

    public VshWrap getSMESshSession(String clusterName, String host, String userName, String pwd, boolean isEncrypted) throws SMEException {
        return this.getSMESshSession(clusterName, host, userName, pwd, isEncrypted, false);
    }

    public VshWrap getSMESshSession(String clusterName, String host, String userName, String pwd, boolean isEncrypted, boolean forceNew) throws SMEException {
        VshWrap _vshWrap = null;
        if (!forceNew) {
            _vshWrap = SwitchCommFactory.getSession(clusterName, userName, host);
        }
        if (_vshWrap == null) {
            _Logger.debug((Object)("Opening a new session for user " + userName + " cluster " + clusterName + " to switch " + host));
            Vsh _vsh = null;
            if (host == null) {
                _Logger.warn((Object)("Failed to open new session for user " + userName + " cluster " + clusterName + " to switch " + host));
                throw new SMESwitchCommunicationException("Failed to open new session for user " + userName + " cluster " + clusterName + " to switch " + host);
            }
            try {
                _vsh = SwitchCommFactory.connectSME(host, userName, pwd, isEncrypted);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to open new session for user " + userName + " cluster " + clusterName + " to switch " + host + " Error: " + se.getMessage()));
                throw se;
            }
            if (_vsh != null) {
                _Logger.debug((Object)("New session opened for user " + userName + " cluster " + clusterName + " to switch " + host));
                SessionKey sess = new SessionKey(clusterName, host, userName, _vsh, id);
                if (forceNew) {
                    oneTimeSessions.add(sess);
                } else {
                    SwitchCommFactory.addSshSession(sess);
                }
                _vshWrap = new VshWrap(_vsh, id++, host);
            } else {
                _Logger.warn((Object)("Failed to open new session for user " + userName + " cluster " + clusterName + " to switch " + host));
                throw new SMESwitchCommunicationException("Failed to open new session for user " + userName + " cluster " + clusterName + " to switch " + host);
            }
        }
        return _vshWrap;
    }

    private static synchronized VshWrap getSession(String cluster, String userName, String hostName) {
        for (SessionKey sess : sessions) {
            if (sess == null || !sess.isAvailable(cluster, userName, hostName)) continue;
            sess.setInUse(true);
            VshWrap _vshWrap = new VshWrap(sess.getVsh(), sess.getId(), sess.getHost());
            return _vshWrap;
        }
        return null;
    }

    private static Vsh connectSME(String host, String user, String pass, boolean isEncrypted) throws SMEException {
        boolean connected = false;
        Vsh _vsh = new Vsh(host, user, pass, null);
        _vsh.setTimeout(0);
        try {
            connected = _vsh.connect(isEncrypted);
            if (connected) {
                _vsh.send(SME_FM_CONNECT);
                _vsh.readLine();
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            _vsh = SwitchCommFactory.cleanupVsh(_vsh);
            throw new SMESwitchCommunicationException("Failed to communicate with switch: " + host + " Error: " + e.getMessage());
        }
        if (!connected) {
            _vsh = SwitchCommFactory.cleanupVsh(_vsh);
            throw new SMESwitchCommunicationException("Failed to communicate with switch: " + host);
        }
        return _vsh;
    }

    private static Vsh cleanupVsh(Vsh _vsh) {
        if (_vsh != null) {
            _vsh.disconnect();
            _vsh = null;
        }
        return _vsh;
    }

    public static synchronized void addSshSession(SessionKey sess) {
        sessions.add(sess);
    }

    public static synchronized void releaseSshSession(String clusterName, String host, String userName, int id) {
        for (SessionKey sess : sessions) {
            if (sess == null || !sess.match(clusterName, host, userName, id)) continue;
            sess.setInUse(false);
            return;
        }
    }

    public static synchronized void closeSshSession(String clusterName, String host, String userName, int id) {
        for (SessionKey sess : sessions) {
            if (sess == null || !sess.match(clusterName, host, userName, id)) continue;
            sess.getVsh().disconnect();
            sessions.remove(sess);
            sess = null;
            _Logger.info((Object)("Closing session for user " + userName + " for clusterName " + clusterName + " switch " + host));
            return;
        }
    }

    class SMESessionWorker
    extends Thread {
        boolean _keepRunning = true;

        SMESessionWorker() {
        }

        void shut() {
            this._keepRunning = false;
        }

        boolean keepRunning() {
            return this._keepRunning;
        }

        @Override
        public synchronized void run() {
            _Logger.warn((Object)"Starting SME session Manager");
            while (this._keepRunning) {
                try {
                    SMESessionWorker.sleep(30000L);
                    for (SessionKey sess : sessions) {
                        if (sess == null || sess.isInUse() || System.currentTimeMillis() - sess.getLastUseTime() <= 300000L) continue;
                        _Logger.warn((Object)("Disconnecting un-used session for user " + sess.getUserName() + " clusterName " + sess.getClusterName() + " for switch " + sess.getHost()));
                        sess.getVsh().disconnect();
                        sessions.remove(sess);
                        sess = null;
                        break;
                    }
                    for (SessionKey sess : oneTimeSessions) {
                        if (sess == null || sess.isInUse() || System.currentTimeMillis() - sess.getLastUseTime() <= 300000L) continue;
                        _Logger.warn((Object)("Disconnecting onetime session for user " + sess.getUserName() + " clusterName " + sess.getClusterName() + " for switch " + sess.getHost()));
                        sess.getVsh().disconnect();
                        sessions.remove(sess);
                        sess = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

