/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.comm.service;

import com.cisco.dcbu.sme.ckmc.ejb.api.CKMCMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ReplicationConfigMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.SyncDBMgrCKMC;
import com.cisco.dcbu.sme.comm.service.CKMCMgrMMBean;
import com.cisco.dcbu.sme.comm.service.CKMCReceiver;
import com.cisco.dcbu.sme.comm.service.CKMCWorker;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

@DependsOn(value={"user:service=QuartzService,name=QuartzService"})
@Singleton
@Startup
public class CKMCMgrM
implements Serializable,
CKMCMgrMMBean {
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;
    private CKMCMgr ckmcBean;
    private SyncDBMgrCKMC syncDBckmcBean;
    private ReplicationConfigMgr replicationBean;
    static Logger _Logger = Logger.getLogger((String)"KMC");
    private CKMCReceiver _ckmcReceiver;

    @EJB
    public void setCkmcBean(CKMCMgr ckmcBean) {
        this.ckmcBean = ckmcBean;
    }

    @EJB
    public void setSyncDBckmcBean(SyncDBMgrCKMC syncDBckmcBean) {
        this.syncDBckmcBean = syncDBckmcBean;
    }

    @EJB
    public void setReplicationBean(ReplicationConfigMgr replicationBean) {
        this.replicationBean = replicationBean;
    }

    @Override
    @PostConstruct
    public void create() throws Exception {
        this.registerInJMX();
        this._ckmcReceiver = new CKMCReceiver();
        this.start();
    }

    @Override
    public void start() throws Exception {
        this.startCKMCListenerService();
    }

    @Override
    public void stop() {
        this.stopCKMCListenerService();
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.stop();
        this.unregisterFromJMX();
        this._ckmcReceiver = null;
    }

    @Override
    public void startCKMCListenerService() throws Exception {
        this.ckmcBean.updateKMCStatus("CKMC starting.");
        this._ckmcReceiver.startService();
    }

    @Override
    public void stopCKMCListenerService() {
        this._ckmcReceiver.stopService();
        this.ckmcBean.updateKMCStatus("CKMC stopped.");
    }

    @Override
    public boolean isNonSecureKMCRunning() {
        return this._ckmcReceiver.isNonSecureKMCRunning();
    }

    @Override
    public boolean isSecureKMCRunning() {
        return this._ckmcReceiver.isSecureKMCRunning();
    }

    @Override
    public CKMCWorker getCKMCWorker(String clusterName) {
        return this._ckmcReceiver.getMainWorker(clusterName);
    }

    @Override
    public boolean isClusterConnected(String clusterName) {
        return this._ckmcReceiver.hasWorker(clusterName);
    }

    public void registerInJMX() {
        try {
            _Logger.warn((Object)"********* Registering dcm:service=CKMCManager");
            this.objectName = new ObjectName("dcm:service=CKMCManager");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }
}

