/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.comm.service;

import com.cisco.dcbu.sme.ckmc.ejb.api.ReplicationConfigMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.SyncDBMgrCKMC;
import com.cisco.dcbu.sme.comm.service.AbstractReceiver;
import com.cisco.dcbu.sme.comm.service.CKMCWorker;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.KeyManagerEnum;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class CKMCReceiver
extends AbstractReceiver
implements Serializable {
    private SyncDBMgrCKMC syncDBckmcBean;
    private ReplicationConfigMgr replicationBean;
    static int _CKMCPort;
    static int _CKMCSSLPort;
    CKMCDaemon _daemon;
    CKMCSecureDaemon _secureDaemon;
    private ArrayList<CKMCWorker> workers;
    protected boolean logXMLMessages = false;
    static Logger _Logger;

    @EJB
    public void setSyncDBckmcBean(SyncDBMgrCKMC syncDBckmcBean) {
        this.syncDBckmcBean = syncDBckmcBean;
    }

    @EJB
    public void setReplicationBean(ReplicationConfigMgr replicationBean) {
        this.replicationBean = replicationBean;
    }

    CKMCReceiver() {
        Config conf = Config.getInstance();
        this.logXMLMessages = conf.isLogXMLMessages();
        if (conf.isSyncKMCDB()) {
            this.doKMCDBSync();
        }
        _CKMCPort = conf.getKmcPort();
        _CKMCSSLPort = conf.getKmcSSLPort();
        this.workers = new ArrayList();
    }

    public void startService() {
        Config conf = Config.getInstance();
        try {
            InitialContext ctx = new InitialContext();
            ReplicationConfigMgr replicationBean = (ReplicationConfigMgr)ctx.lookup("java:global/dcm/dcm/ReplicationConfigMgrBean");
            this.setReplicationBean(replicationBean);
            _Logger.info((Object)(" FOUND replicationBean: " + replicationBean));
            replicationBean.fixQuartzJobs();
        }
        catch (Exception e) {
            _Logger.info((Object)"Exception in the SME Quartz job handler", (Throwable)e);
        }
        if (conf.getKeyManager() == KeyManagerEnum.CISCO || conf.getKeyManager() == KeyManagerEnum.RSA) {
            if (conf.getKmcServerCertFileName() == null || conf.getKmcServerCertFileName() != null && conf.getKmcServerCertFileName().length() == 0) {
                _Logger.info((Object)"Starting listener");
                this._daemon = new CKMCDaemon();
                if (this._daemon.keepRunning()) {
                    this._daemon.start();
                }
            }
            if (conf.getKmcServerCertFileName() != null && conf.getKmcServerCertFileName().length() > 0) {
                _Logger.info((Object)"Starting secure listener");
                this._secureDaemon = new CKMCSecureDaemon();
                if (this._secureDaemon.keepRunning()) {
                    this._secureDaemon.start();
                }
            }
        } else {
            _Logger.warn((Object)"No Key Manager configured. KMC listener service not started.");
        }
    }

    public void stopService() {
        if (this._daemon != null) {
            _Logger.info((Object)"Stopping KMC listener");
            this._daemon.shut();
            this._daemon.interrupt();
            this._daemon = null;
        }
        if (this._secureDaemon != null) {
            _Logger.info((Object)"Stopping KMC secure listener");
            this._secureDaemon.shut();
            this._secureDaemon.interrupt();
            this._secureDaemon = null;
        }
    }

    public boolean isNonSecureKMCRunning() {
        if (this._daemon != null) {
            return this._daemon.isRunning();
        }
        return false;
    }

    public boolean isSecureKMCRunning() {
        if (this._secureDaemon != null) {
            return this._secureDaemon.isRunning();
        }
        return false;
    }

    public void doKMCDBSync() {
        try {
            InitialContext ctx = new InitialContext();
            SyncDBMgrCKMC syncDBckmcBean = (SyncDBMgrCKMC)ctx.lookup("java:global/dcm/dcm/SyncDBMgrCKMCBean!" + SyncDBMgrCKMC.class.getName());
            this.setSyncDBckmcBean(syncDBckmcBean);
            syncDBckmcBean.perform();
        }
        catch (NamingException e) {
            _Logger.warn((Object)("Failed to locate database manager. " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private int randhex() {
        Random rn = new Random();
        int i = rn.nextInt() % 15;
        if (i < 0) {
            i = -i;
        }
        if (i < 10) {
            return 48 + i;
        }
        return 97 + (i -= 10);
    }

    public CKMCWorker getMainWorker(String clusterName) {
        for (CKMCWorker worker : this.workers) {
            if (!worker.isMaster() || !worker.getClusterName().equals(clusterName) || !worker.isAlive() || !worker.isConnected()) continue;
            return worker;
        }
        _Logger.warn((Object)("Failed to get switch connection for cluster" + clusterName));
        return null;
    }

    public boolean hasWorker(String clusterName) {
        for (CKMCWorker worker : this.workers) {
            if (!worker.isMaster() || !worker.getClusterName().equals(clusterName) || !worker.isAlive() || !worker.isConnected()) continue;
            return true;
        }
        _Logger.warn((Object)("Failed to check switch connection for cluster" + clusterName));
        return false;
    }

    static {
        _Logger = Logger.getLogger((String)"KMC");
    }

    class CKMCSecureDaemon
    extends Thread {
        private Socket sock;
        boolean _keepRunning;
        boolean running;
        private SSLServerSocket socket;

        CKMCSecureDaemon() {
            try {
                ServerSocketFactory foo = this.getServerSocketFactory();
                if (foo == null) {
                    _Logger.warn((Object)("Failed to start secure listener on port: " + _CKMCSSLPort));
                    return;
                }
                this.socket = (SSLServerSocket)foo.createServerSocket(_CKMCSSLPort);
                this.socket.setNeedClientAuth(true);
                String[] limit = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA"};
                this.socket.setEnabledCipherSuites(limit);
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to start secure listener on port: " + _CKMCSSLPort + ". Error:" + e.getMessage()));
                e.printStackTrace();
                this.running = false;
                return;
            }
            this._keepRunning = true;
            this.running = true;
        }

        private ServerSocketFactory getServerSocketFactory() {
            SSLContext sslcontext = null;
            TrustManagerFactory trustmanagerfactory = null;
            KeyManagerFactory keymanagerfactory = null;
            Config conf = Config.getInstance();
            try {
                sslcontext = SSLContext.getInstance("TLSv1");
                trustmanagerfactory = TrustManagerFactory.getInstance("X.509");
            }
            catch (Exception ex) {
                _Logger.warn((Object)("Secure Listener - Failed to initialize trust manager :" + ex.getMessage()));
                return null;
            }
            try {
                keymanagerfactory = KeyManagerFactory.getInstance("SunX509");
            }
            catch (Exception ex) {
                _Logger.warn((Object)("Secure Listener - Failed to initialize key manager :" + ex.getMessage()));
                return null;
            }
            try {
                if (conf.getKMCServerCerts() == null) {
                    _Logger.warn((Object)"Secure Listener - KMC Server certifiate not available or could not be loaded");
                    return null;
                }
                keymanagerfactory.init(conf.getKMCServerCerts(), conf.getKmcServerPassword().toCharArray());
                if (conf.getKMCTrustCerts() == null) {
                    _Logger.warn((Object)"Secure Listener - KMC Trust certifiate not available or could not be loaded");
                    return null;
                }
                trustmanagerfactory.init(conf.getKMCTrustCerts());
                sslcontext.init(keymanagerfactory.getKeyManagers(), trustmanagerfactory.getTrustManagers(), null);
            }
            catch (Exception ex) {
                _Logger.warn((Object)("Secure Listener - Failed to initialize SSL context :" + ex.getMessage()));
                return null;
            }
            return sslcontext.getServerSocketFactory();
        }

        void shut() {
            this._keepRunning = false;
            try {
                if (!this.keepRunning() && this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to close secure KMC socket: " + this.sock + ". Error:" + e.getMessage()));
                e.printStackTrace();
            }
        }

        boolean keepRunning() {
            return this._keepRunning;
        }

        boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            _Logger.info((Object)("Started secure listener on secure port: " + _CKMCSSLPort));
            try {
                while (this.keepRunning()) {
                    Iterator it = CKMCReceiver.this.workers.iterator();
                    while (it.hasNext()) {
                        CKMCWorker worker = (CKMCWorker)it.next();
                        if (worker.isAlive()) continue;
                        worker.shut();
                        worker.interrupt();
                        it.remove();
                    }
                    this.sock = this.socket.accept();
                    CKMCWorker worker = new CKMCWorker(this.sock);
                    worker.start();
                    CKMCReceiver.this.workers.add(worker);
                    _Logger.info((Object)("Received new secure connection from " + this.sock.getRemoteSocketAddress() + ". Start new worker"));
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to receive new secure connection. Error:" + e.getMessage()));
                e.printStackTrace();
            }
            finally {
                try {
                    if (!this.keepRunning()) {
                        this.socket.close();
                        _Logger.info((Object)"closing secure socket ");
                    }
                }
                catch (Exception e) {
                    _Logger.warn((Object)("Failed to close secure listener socket: " + this.sock + ". Error:" + e.getMessage()));
                    e.printStackTrace();
                }
                Iterator it = CKMCReceiver.this.workers.iterator();
                while (it.hasNext()) {
                    CKMCWorker worker = (CKMCWorker)it.next();
                    worker.shut();
                    worker.interrupt();
                    it.remove();
                }
            }
            this.running = false;
            _Logger.info((Object)("Stopped secure listener on secure port: " + _CKMCSSLPort));
        }
    }

    class CKMCDaemon
    extends Thread {
        private Socket sock;
        boolean _keepRunning;
        boolean running;
        private ServerSocket socket;

        CKMCDaemon() {
            try {
                ServerSocketFactory foo = ServerSocketFactory.getDefault();
                this.socket = foo.createServerSocket(_CKMCPort);
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to start listener on port: " + _CKMCPort + ". Error:" + e.getMessage()));
                e.printStackTrace();
                this.running = false;
                return;
            }
            this.running = true;
            this._keepRunning = true;
        }

        void shut() {
            this._keepRunning = false;
            _Logger.info((Object)"shutted ");
            try {
                if (!this.keepRunning() && this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to close KMC socket: " + this.sock + ". Error:" + e.getMessage()));
                e.printStackTrace();
            }
        }

        boolean keepRunning() {
            return this._keepRunning;
        }

        boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            _Logger.info((Object)("Started listener on port: " + _CKMCPort));
            try {
                while (this.keepRunning()) {
                    Iterator it = CKMCReceiver.this.workers.iterator();
                    while (it.hasNext()) {
                        CKMCWorker worker = (CKMCWorker)it.next();
                        if (worker.isAlive()) continue;
                        worker.shut();
                        worker.interrupt();
                        it.remove();
                    }
                    this.sock = this.socket.accept();
                    CKMCWorker worker = new CKMCWorker(this.sock);
                    worker.start();
                    CKMCReceiver.this.workers.add(worker);
                    _Logger.info((Object)("Received new connection from " + this.sock.getRemoteSocketAddress() + ". Start new worker"));
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to receive new connection. Error:" + e.getMessage()));
                e.printStackTrace();
            }
            finally {
                try {
                    if (!this.keepRunning()) {
                        this.socket.close();
                        _Logger.info((Object)"closing socket ");
                    }
                }
                catch (Exception e) {
                    _Logger.warn((Object)("Failed to close listener socket: " + this.sock + ". Error:" + e.getMessage()));
                    e.printStackTrace();
                }
                Iterator it = CKMCReceiver.this.workers.iterator();
                while (it.hasNext()) {
                    CKMCWorker worker = (CKMCWorker)it.next();
                    worker.shut();
                    worker.interrupt();
                    it.remove();
                }
            }
            this.running = false;
            _Logger.info((Object)("Stopped listener on port: " + _CKMCPort));
        }
    }
}

