/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.common;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sme.ckmc.ejb.api.CKMCMgr;
import com.cisco.dcbu.sme.common.ConfigProperties;
import com.cisco.dcbu.sme.common.KeyManagerConfig;
import com.cisco.dcbu.sme.common.KeyManagerEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class Config
implements ConfigProperties {
    private CKMCMgr ckmcBean;
    static Logger _Logger = Logger.getLogger((String)"SME");
    private KeyManagerConfig kmConfig;
    String property = null;
    Properties config = new Properties();
    Properties fmConfig = new Properties();
    private boolean useIP = false;
    private boolean clearDiscovery = false;
    private long itNexsusDiscoverySleepTime = 40000L;
    private String userName;
    private String password;
    private int kmcPort = 8800;
    private int kmcSSLPort = 8900;
    private boolean syncKMCDB = false;
    private boolean logXMLMessages = false;
    private boolean forceRekey = false;
    private String forceRekeyCluster;
    private boolean sslICN = false;
    private boolean retainImportedKeyState = false;
    private boolean archiveAccountingLog = false;
    private int archiveAccountingLogFreq = 3;
    private int replicationFreq = 5;
    private int replicationExpiry = 24;
    private String kmcIP = "";
    private boolean limitKeyAdminRole = false;
    private boolean limitKeyAdminQuorum = false;
    private String vpnKMC = "";
    private ArrayList<String> vpnPrefixList = new ArrayList();
    private static Config s_instance = null;

    public void setCkmcBean(CKMCMgr ckmcBean) {
        this.ckmcBean = ckmcBean;
    }

    public static synchronized Config getInstance() {
        if (s_instance == null || Config.s_instance.ckmcBean == null) {
            s_instance = new Config();
        }
        return s_instance;
    }

    private Config() {
        try {
            CKMCMgr mgr = EjbRegistry.getInstance().getCKMCMgr();
            this.setCkmcBean(mgr);
        }
        catch (Exception e) {
            _Logger.error((Object)"Error getting CKMCMgrBean reference", (Throwable)e);
        }
        this.loadConfig();
        this.readUseIP();
        this.readClearDiscovery();
        this.readItNexsusDiscoverySleepTime();
        this.readKmcPort();
        this.readKmcSSLPort();
        this.readUserName();
        this.readPassword();
        this.readForceRekeyCluster();
        this.readLogXMLMessages();
        this.readSyncKMCDB();
        this.readSslICN();
        this.readRetainImportedKeyState();
        if (this.getKeyManager() == KeyManagerEnum.RSA) {
            this.readRsaServerName();
            this.readRsaServerPort();
            this.readRsaClientCertFileName();
            this.readRsaTrustedServerCertFileName();
            this.readRsaClientPassword();
        }
        this.readKmcServerCertFileName();
        this.readKmcServerPassword();
        this.readKmcTrustCertFileName();
        this.readPeerKmcServerCertFileName();
        this.readPeerKmcServerPassword();
        this.readPeerKmcTrustCertFileName();
        if (this.kmConfig != null) {
            this.readKmcServerType();
        }
        this.readArchiveAccountingLog();
        this.readArchiveAccountingLogFrequency();
        this.readReplicationFrequency();
        this.readReplicationExpiry();
        this.readKeyAdminLimitQuorum();
        this.readKeyAdminLimitRole();
        this.readVpnKMC();
        this.readVpnPrefix();
        this.loadFMConfig();
        this.readBindAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        String configFile = ClientCache.getConfDir() + "smeserver.properties";
        File f = new File(configFile);
        if (f.exists()) {
            _Logger.info((Object)("File " + f.getAbsolutePath() + " found"));
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                this.config.load(fis);
            }
            catch (IOException ex) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex2) {}
                }
            }
        } else {
            _Logger.error((Object)("File " + f.getAbsolutePath() + " not found"));
        }
        this.getKeyManagerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFMConfig() {
        String configFile = ClientCache.getConfDir() + "server.properties";
        File f = new File(configFile);
        if (f.exists()) {
            _Logger.info((Object)("File " + f.getAbsolutePath() + " found"));
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                this.fmConfig.load(fis);
            }
            catch (IOException ex) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex2) {}
                }
            }
        } else {
            _Logger.error((Object)("File " + f.getAbsolutePath() + " not found"));
        }
    }

    public void getKeyManagerConfig() {
        try {
            if (this.ckmcBean != null) {
                this.kmConfig = this.ckmcBean.getKeyManagerConfig();
            } else {
                _Logger.error((Object)"Failed to retriving Key Manager configuration.");
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("Error retriving Key Manager configuration: Exception: " + e.getMessage()));
        }
    }

    public OperationStatus saveKeyManagerConfig() {
        OperationStatus ret = new OperationStatus();
        try {
            ret = this.ckmcBean.saveKeyManagerConfig(this.kmConfig);
            if (this.kmConfig.getKeyManager() == KeyManagerEnum.RSA) {
                this.config.setProperty("sme.rsa.key.manager.server", this.kmConfig.getRsaServerName());
                this.config.setProperty("sme.rsa.key.manager.server.port", "" + this.kmConfig.getRsaServerPort());
                this.config.setProperty("sme.rsa.key.manager.server.ks", this.kmConfig.getRsaTrustedServerCertFileName());
                this.config.setProperty("sme.rsa.key.manager.client.ks", this.kmConfig.getRsaClientCertFileName());
                if (this.kmConfig.getRsaClientPassword() != null && this.kmConfig.getRsaClientPassword().length() > 0) {
                    this.config.setProperty("sme.rsa.key.manager.client.ks.password", StringEncrypter.encryptString("DESede", this.kmConfig.getRsaClientPassword()));
                } else {
                    this.config.setProperty("sme.rsa.key.manager.client.ks.password", "");
                }
            }
            if (this.kmConfig.getKmcServerType() != null) {
                this.config.setProperty("sme.kmc.server.type", this.kmConfig.getKmcServerType());
            }
            ret = this.saveConfig();
        }
        catch (Exception e) {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Error saving Key Manager configuration: Exception: " + e.getMessage());
            _Logger.error((Object)("Error saving Key Manager configuration: Exception: " + e.getMessage()));
        }
        return ret;
    }

    public OperationStatus saveKeyManagerSSLConfig() {
        OperationStatus ret = new OperationStatus();
        try {
            if (this.kmConfig.getKmcServerType() != null) {
                this.config.setProperty("sme.kmc.server.type", this.kmConfig.getKmcServerType());
            }
            if (this.kmConfig.getKmcTrustCertFileName() != null) {
                this.config.setProperty("sme.kmc.trust.ks", this.kmConfig.getKmcTrustCertFileName());
            }
            if (this.kmConfig.getKmcServerCertFileName() != null) {
                this.config.setProperty("sme.kmc.server.ks", this.kmConfig.getKmcServerCertFileName());
            }
            if (this.kmConfig.getKmcServerPassword() != null && this.kmConfig.getKmcServerPassword().length() > 0) {
                this.config.setProperty("sme.kmc.server.ks.password", StringEncrypter.encryptString("DESede", this.kmConfig.getKmcServerPassword()));
            } else {
                this.config.setProperty("sme.kmc.server.ks.password", "");
            }
            if (this.kmConfig.getPeerKmcTrustCertFileName() != null) {
                this.config.setProperty("sme.peer.kmc.trust.ks", this.kmConfig.getPeerKmcTrustCertFileName());
            }
            if (this.kmConfig.getPeerKmcServerCertFileName() != null) {
                this.config.setProperty("sme.peer.kmc.server.ks", this.kmConfig.getPeerKmcServerCertFileName());
            }
            if (this.kmConfig.getPeerKmcServerPassword() != null && this.kmConfig.getPeerKmcServerPassword().length() > 0) {
                this.config.setProperty("sme.peer.kmc.server.ks.password", StringEncrypter.encryptString("DESede", this.kmConfig.getPeerKmcServerPassword()));
            } else {
                this.config.setProperty("sme.peer.kmc.server.ks.password", "");
            }
            ret = this.saveConfig();
        }
        catch (Exception e) {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Error saving Key Manager SSL configuration: Exception: " + e.getMessage());
            _Logger.error((Object)("Error saving Key Manager SSL configuration: Exception: " + e.getMessage()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus saveConfig() {
        OperationStatus ret = new OperationStatus();
        String configFile = ClientCache.getConfDir() + "smeserver.properties";
        File f = new File(configFile);
        if (f.exists()) {
            _Logger.info((Object)("File " + f.getAbsolutePath() + " found"));
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                this.config.store(fos, "");
                ret.setStatus(OperationStatusEnum.Success);
                ret.setDescription("Success");
                _Logger.info((Object)"Sucessfully updated Properties");
            }
            catch (IOException ex) {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Error accessing " + configFile + " Exception:" + ex.getMessage());
                _Logger.error((Object)("Error accessing " + configFile + " Exception:" + ex.getMessage()));
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex2) {
                        ret.setStatus(OperationStatusEnum.Failure);
                        ret.setDescription("Error closing " + configFile + " Exception:" + ex2.getMessage());
                        _Logger.error((Object)("Error closing " + configFile + " Exception:" + ex2.getMessage()));
                    }
                }
            }
        } else {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("File " + f.getAbsolutePath() + " not found");
            _Logger.error((Object)("File " + f.getAbsolutePath() + " not found"));
        }
        return ret;
    }

    public void readUseIP() {
        this.property = this.config.getProperty("sme.useIP");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.useIP = true;
            } else if (this.property.trim().toLowerCase().compareTo("false") == 0) {
                this.useIP = false;
            } else {
                _Logger.warn((Object)"Invalid value for sme.useIP. Using default value false.");
                this.useIP = false;
            }
        }
    }

    public void readClearDiscovery() {
        this.property = this.config.getProperty("sme.ITNexus.discovery.clear");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.clearDiscovery = true;
            } else if (this.property.trim().toLowerCase().compareTo("false") == 0) {
                this.clearDiscovery = false;
            } else {
                _Logger.warn((Object)"Invalid value for sme.ITNexus.discovery.clear. Using default value false.");
                this.clearDiscovery = false;
            }
        }
    }

    public void readItNexsusDiscoverySleepTime() {
        this.property = this.config.getProperty("sme.ITNexus.discovery.interval");
        if (this.property != null) {
            this.itNexsusDiscoverySleepTime = Integer.valueOf(this.property).intValue();
            if (this.itNexsusDiscoverySleepTime < 10000L) {
                _Logger.warn((Object)"Invalid value for sme.ITNexus.discovery.interval. Using default value false.");
                this.itNexsusDiscoverySleepTime = 40000L;
            }
        }
    }

    public void readKmcPort() {
        this.property = this.config.getProperty("sme.kmc.listener.port");
        if (this.property != null) {
            this.kmcPort = Integer.valueOf(this.property);
            if (this.kmcPort < 0) {
                _Logger.warn((Object)"Invalid value for sme.kmc.listener.port. Using default value 8800");
                this.kmcPort = 8800;
            }
        }
    }

    public void readKmcSSLPort() {
        this.property = this.config.getProperty("sme.kmc.ssl.listener.port");
        if (this.property != null) {
            this.kmcSSLPort = Integer.valueOf(this.property);
            if (this.kmcSSLPort < 0) {
                _Logger.warn((Object)"Invalid value for sme.kmc.ssl.listener.port. Using default value 8900");
                this.kmcSSLPort = 8900;
            }
        }
    }

    public void readUserName() {
        this.property = this.config.getProperty("sme.switch.user");
        if (this.property != null) {
            this.userName = this.property;
        }
    }

    public void readPassword() {
        this.property = this.config.getProperty("sme.switch.user.password");
        if (this.property != null) {
            this.password = this.property;
        }
    }

    public void readForceRekeyCluster() {
        this.property = this.config.getProperty("sme.force.rekey");
        if (this.property != null) {
            this.forceRekeyCluster = this.property;
            this.forceRekey = true;
        } else {
            this.forceRekeyCluster = null;
            this.forceRekey = false;
        }
    }

    public void readLogXMLMessages() {
        this.property = this.config.getProperty("sme.kmc.log.xml.message");
        this.logXMLMessages = this.property != null ? (this.property.trim().toLowerCase().compareTo("true") == 0 ? true : (this.property.trim().toLowerCase().compareTo("false") == 0 ? false : false)) : false;
    }

    public void readSyncKMCDB() {
        this.property = this.config.getProperty("sme.kmc.sync.model.at.startup");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.syncKMCDB = true;
            } else if (this.property.trim().toLowerCase().compareTo("false") == 0) {
                this.syncKMCDB = false;
            } else {
                _Logger.warn((Object)"Invalid value for sme.kmc.sync.model.at.startup. Using default value false.");
                this.syncKMCDB = false;
            }
        }
    }

    public void readSslICN() {
        this.property = this.config.getProperty("sme.ssl.icn");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.sslICN = true;
            } else if (this.property.trim().toLowerCase().compareTo("false") == 0) {
                this.sslICN = false;
            } else {
                _Logger.warn((Object)"Invalid value for sme.ssl.icn. Using default value false.");
                this.sslICN = false;
            }
        }
    }

    public void readRetainImportedKeyState() {
        this.property = this.config.getProperty("sme.retain.imported.key.state");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.retainImportedKeyState = true;
            } else if (this.property.trim().toLowerCase().compareTo("false") == 0) {
                this.retainImportedKeyState = false;
            } else {
                _Logger.warn((Object)"Invalid value for sme.retain.imported.key.state. Using default value false.");
                this.retainImportedKeyState = false;
            }
        }
    }

    public void readArchiveAccountingLog() {
        this.property = this.config.getProperty("sme.kmc.archive.accounting.log");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.archiveAccountingLog = true;
            } else if (this.property.trim().toLowerCase().compareTo("false") == 0) {
                this.archiveAccountingLog = false;
            } else {
                _Logger.warn((Object)"Invalid value for sme.kmc.archive.accounting.log. Using default value true.");
                this.archiveAccountingLog = true;
            }
        }
    }

    public void readArchiveAccountingLogFrequency() {
        this.property = this.config.getProperty("sme.kmc.archive.accounting.log.frequency");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("hourly") == 0) {
                this.archiveAccountingLogFreq = 1;
            } else if (this.property.trim().toLowerCase().compareTo("daily") == 0) {
                this.archiveAccountingLogFreq = 2;
            } else if (this.property.trim().toLowerCase().compareTo("weekly") == 0) {
                this.archiveAccountingLogFreq = 3;
            } else if (this.property.trim().toLowerCase().compareTo("monthly") == 0) {
                this.archiveAccountingLogFreq = 4;
            } else if (this.property.trim().toLowerCase().compareTo("test") == 0) {
                this.archiveAccountingLogFreq = 5;
            } else {
                _Logger.warn((Object)"Invalid value for sme.kmc.archive.accounting.log.frequency. Using default value weekly.");
                this.archiveAccountingLogFreq = 3;
            }
        }
    }

    public void readReplicationFrequency() {
        this.property = this.config.getProperty("sme.kmc.replication.frequency");
        if (this.property != null) {
            this.setReplicationFreq(Integer.parseInt(this.property));
            _Logger.debug((Object)("Replication Frequency: " + this.getReplicationFreq() + " sec"));
        } else {
            this.setReplicationFreq(5);
            _Logger.warn((Object)"No Replication Frequency Configured. Using default 5 sec");
        }
    }

    public void readReplicationExpiry() {
        this.property = this.config.getProperty("sme.kmc.replication.expiry");
        if (this.property != null) {
            this.setReplicationExpiry(Integer.parseInt(this.property));
            _Logger.debug((Object)("Replication Expiry: " + this.getReplicationFreq() + " hours"));
        } else {
            this.setReplicationExpiry(24);
            _Logger.warn((Object)"No Replication Ex Configured. Using default 24 hours");
        }
    }

    public void readRsaServerName() {
        this.property = this.config.getProperty("sme.rsa.key.manager.server");
        if (this.property != null) {
            this.setRsaServerName(this.property);
            _Logger.debug((Object)("RSA Key Manager Server: " + this.getRsaServerName()));
        } else {
            _Logger.warn((Object)"No RSA Key Manager Server Cconfigured");
        }
    }

    public void readRsaServerPort() {
        this.property = this.config.getProperty("sme.rsa.key.manager.server.port");
        if (this.property != null) {
            this.setRsaServerPort(Integer.parseInt(this.property));
            _Logger.debug((Object)("RSA Key Manager Server Port: " + this.getRsaServerPort()));
        } else {
            _Logger.warn((Object)"No RSA Key Manager Server Port Configured");
        }
    }

    public void readRsaClientCertFileName() {
        this.property = this.config.getProperty("sme.rsa.key.manager.client.ks");
        if (this.property != null) {
            this.setRsaClientCertFileName(this.property);
            _Logger.debug((Object)("RSA Key Manager Client Keystore: " + this.getRsaClientCertFileName()));
        } else {
            _Logger.warn((Object)"No RSA Key Manager Client Keystore Configured");
        }
    }

    public void readRsaTrustedServerCertFileName() {
        this.property = this.config.getProperty("sme.rsa.key.manager.server.ks");
        if (this.property != null) {
            this.setRsaTrustedServerCertFileName(this.property);
            _Logger.debug((Object)("RSA Key Manager Sevrer Trust Keystore: " + this.getRsaTrustedServerCertFileName()));
        } else {
            _Logger.warn((Object)"No RSA Key Manager Server Trust Keystore Configured");
        }
    }

    public void readRsaClientPassword() {
        try {
            this.property = this.config.getProperty("sme.rsa.key.manager.client.ks.password");
            if (this.property != null && this.property.length() > 0) {
                this.setRsaClientPassword(StringEncrypter.decryptString("DESede", this.property));
                _Logger.debug((Object)("RSA Key Manager Client Keystore Password: " + this.getRsaClientPassword()));
            } else {
                _Logger.warn((Object)"No RSA Key Manager Client Keystore Password Configured");
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)("Exception in readRsaClientPassword. Exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void readKmcServerCertFileName() {
        this.property = this.config.getProperty("sme.kmc.server.ks");
        if (this.property != null) {
            this.setKmcServerCertFileName(this.property);
            _Logger.debug((Object)("KMC Server Keystore: " + this.getKmcServerCertFileName()));
        } else {
            _Logger.warn((Object)"No KMC Server Keystore Configured");
        }
    }

    public void readKmcServerPassword() {
        try {
            this.property = this.config.getProperty("sme.kmc.server.ks.password");
            if (this.property != null && this.property.length() > 0) {
                this.setKmcServerPassword(StringEncrypter.decryptString("DESede", this.property));
                _Logger.debug((Object)("KMC Sevrer Keystore Password: " + this.getKmcServerPassword()));
            } else {
                _Logger.warn((Object)"No KMC Server Keystore Password Configured");
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)("Exception in readKmcServerPassword. Exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void readKmcTrustCertFileName() {
        this.property = this.config.getProperty("sme.kmc.trust.ks");
        if (this.property != null) {
            this.setKmcTrustCertFileName(this.property);
            _Logger.debug((Object)("KMC Server Trust Keystore: " + this.getKmcTrustCertFileName()));
        } else {
            _Logger.warn((Object)"No KMC Server Trust Keystore Configured");
        }
    }

    public void readKmcServerType() {
        this.property = this.config.getProperty("sme.kmc.server.type");
        if (this.property != null) {
            this.setKmcServerType(this.property);
            _Logger.debug((Object)("KMC Server Type: " + this.getKmcServerType()));
        } else {
            _Logger.warn((Object)"No KMC Server Type Configured");
        }
    }

    public void readPeerKmcServerCertFileName() {
        this.property = this.config.getProperty("sme.peer.kmc.server.ks");
        if (this.property != null) {
            this.setPeerKmcServerCertFileName(this.property);
            _Logger.debug((Object)("Peer KMC Server Keystore: " + this.getPeerKmcServerCertFileName()));
        } else {
            _Logger.warn((Object)"No Peer KMC Server Keystore Configured");
        }
    }

    public void readPeerKmcServerPassword() {
        try {
            this.property = this.config.getProperty("sme.peer.kmc.server.ks.password");
            if (this.property != null && this.property.length() > 0) {
                this.setPeerKmcServerPassword(StringEncrypter.decryptString("DESede", this.property));
                _Logger.debug((Object)("Peer KMC Sevrer Keystore Password: " + this.getPeerKmcServerPassword()));
            } else {
                _Logger.warn((Object)"No Peer KMC Server Keystore Password Configured");
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)("Exception in readPeerKmcServerPassword. Exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void readPeerKmcTrustCertFileName() {
        this.property = this.config.getProperty("sme.peer.kmc.trust.ks");
        if (this.property != null) {
            this.setPeerKmcTrustCertFileName(this.property);
            _Logger.debug((Object)("Peer KMC Server Trust Keystore: " + this.getPeerKmcTrustCertFileName()));
        } else {
            _Logger.warn((Object)"No Peer KMC Server Trust Keystore Configured");
        }
    }

    public void readBindAddr() {
        this.property = this.fmConfig.getProperty("server.bindaddrs");
        if (this.property != null) {
            this.kmcIP = this.property;
            _Logger.debug((Object)("KMC Server Bind IP: " + this.kmcIP));
        } else {
            _Logger.warn((Object)"No KMC Server IP Binding Configured");
        }
    }

    private void readKeyAdminLimitQuorum() {
        this.property = this.config.getProperty("sme.kmc.limit.quorum");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.limitKeyAdminQuorum = true;
            } else {
                _Logger.warn((Object)"Invalid value for sme.kmc.limit.quorum. Using default value false.");
                this.sslICN = false;
            }
        }
    }

    private void readKeyAdminLimitRole() {
        this.property = this.config.getProperty("sme.kmc.limit.role");
        if (this.property != null) {
            if (this.property.trim().toLowerCase().compareTo("true") == 0) {
                this.limitKeyAdminRole = true;
            } else {
                _Logger.warn((Object)"Invalid value for sme.kmc.limit.role. Using default value false.");
                this.sslICN = false;
            }
        }
    }

    private void readVpnKMC() {
        this.property = this.config.getProperty("sme.kmc.vpn");
        if (this.property != null) {
            this.vpnKMC = this.property;
            _Logger.debug((Object)("KMC VPN IP: " + this.vpnKMC));
        }
    }

    private void readVpnPrefix() {
        String[] list;
        this.property = this.config.getProperty("sme.kmc.prefix.vpn");
        if (this.property != null && (list = this.property.split(",")) != null) {
            for (String s : list) {
                this.vpnPrefixList.add(s);
                _Logger.debug((Object)("KMC VPN prefix: " + s));
            }
        }
    }

    public KeyStore getCertStoreFromPemFile(FileInputStream trustedServerCertsFile, String alias) throws Exception {
        KeyStore trustedServerCerts = null;
        trustedServerCerts = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedServerCerts.load(null, null);
        BufferedInputStream bis = new BufferedInputStream(trustedServerCertsFile);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        int certNum = 0;
        while (bis.available() > 0) {
            Certificate cert = cf.generateCertificate(bis);
            String aliasCert = certNum == 0 ? alias : alias + certNum;
            trustedServerCerts.setCertificateEntry(aliasCert, cert);
            ++certNum;
        }
        return trustedServerCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKMCServerCerts() {
        KeyStore kmcServerCerts = null;
        String fileName = ClientCache.getConfDir() + "cert/" + this.kmConfig.getKmcServerCertFileName();
        FileInputStream kmcServerCertsFile = null;
        try {
            if (this.kmConfig.getKmcServerCertFileName() != null) {
                kmcServerCertsFile = new FileInputStream(fileName);
                if (this.kmConfig.getKmcServerCertFileName().endsWith(".jks")) {
                    kmcServerCerts = KeyStore.getInstance("JKS");
                    kmcServerCerts.load(kmcServerCertsFile, this.kmConfig.getKmcServerPassword().toCharArray());
                } else if (this.kmConfig.getKmcServerCertFileName().endsWith(".p12")) {
                    kmcServerCerts = KeyStore.getInstance("PKCS12");
                    kmcServerCerts.load(kmcServerCertsFile, this.kmConfig.getKmcServerPassword().toCharArray());
                } else {
                    _Logger.error((Object)("Error loading KMC Server keystore " + fileName));
                    this.ckmcBean.updateKMCStatus("Error loading KMC Server keystore");
                    kmcServerCerts = null;
                }
            } else {
                _Logger.warn((Object)"KMC Server keystore not configured. ");
                this.ckmcBean.updateKMCStatus("Error loading KMC Server keystore");
                kmcServerCerts = null;
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("Error loading KMC Server keystore " + fileName + " Exception: " + e.getMessage()));
            this.ckmcBean.updateKMCStatus("Error loading SSL.  Possible bad password or certificate(s).");
            kmcServerCerts = null;
        }
        finally {
            try {
                if (kmcServerCertsFile != null) {
                    kmcServerCertsFile.close();
                }
            }
            catch (Exception e) {
                _Logger.error((Object)("Error closing KMC Server keystore " + fileName + " Exception: " + e.getMessage()));
                kmcServerCerts = null;
            }
        }
        return kmcServerCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKMCTrustCerts() {
        KeyStore kmcTrustCerts = null;
        String fileName = ClientCache.getConfDir() + "cert/" + this.kmConfig.getKmcTrustCertFileName();
        FileInputStream kmcTrustCertsFile = null;
        try {
            if (this.kmConfig.getKmcTrustCertFileName() != null) {
                kmcTrustCertsFile = new FileInputStream(fileName);
                if (this.kmConfig.getKmcTrustCertFileName().endsWith(".jks")) {
                    kmcTrustCerts = KeyStore.getInstance("JKS");
                    kmcTrustCerts.load(kmcTrustCertsFile, null);
                } else if (this.kmConfig.getKmcTrustCertFileName().endsWith(".p12")) {
                    kmcTrustCerts = KeyStore.getInstance("PKCS12");
                    kmcTrustCerts.load(kmcTrustCertsFile, null);
                } else if (this.kmConfig.getKmcTrustCertFileName().endsWith(".der") || this.kmConfig.getKmcTrustCertFileName().endsWith(".pem")) {
                    kmcTrustCerts = this.getCertStoreFromPemFile(kmcTrustCertsFile, "sme_kmc_trust");
                } else {
                    _Logger.error((Object)("Error loading KMC Trust keystore " + fileName));
                    this.ckmcBean.updateKMCStatus("Error loading KMC Trust keystore");
                    kmcTrustCerts = null;
                }
            } else {
                _Logger.warn((Object)"KMC Trust keystore not configured. ");
                this.ckmcBean.updateKMCStatus("KMC Trust keystore not configured");
                kmcTrustCerts = null;
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("Error loading KMC Trust keystore " + fileName + " Exception: " + e.getMessage()));
            this.ckmcBean.updateKMCStatus("Error loading KMC Trust keystore");
            kmcTrustCerts = null;
        }
        finally {
            try {
                if (kmcTrustCertsFile != null) {
                    kmcTrustCertsFile.close();
                }
            }
            catch (Exception e) {
                _Logger.error((Object)("Error closing KMC Trust keystore " + fileName + " Exception: " + e.getMessage()));
            }
        }
        return kmcTrustCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getRSATrustedServerCerts() {
        KeyStore rsaTrustedServerCerts = null;
        String fileName = ClientCache.getConfDir() + "cert/" + this.kmConfig.getRsaTrustedServerCertFileName();
        FileInputStream rsaTrustedServerCertsFile = null;
        try {
            if (this.kmConfig.getRsaTrustedServerCertFileName() != null) {
                rsaTrustedServerCertsFile = new FileInputStream(fileName);
                if (this.kmConfig.getRsaTrustedServerCertFileName().endsWith(".jks")) {
                    rsaTrustedServerCerts = KeyStore.getInstance("JKS");
                    rsaTrustedServerCerts.load(rsaTrustedServerCertsFile, null);
                } else if (this.kmConfig.getRsaTrustedServerCertFileName().endsWith(".p12")) {
                    rsaTrustedServerCerts = KeyStore.getInstance("PKCS12");
                    rsaTrustedServerCerts.load(rsaTrustedServerCertsFile, null);
                } else if (this.kmConfig.getRsaTrustedServerCertFileName().endsWith(".der") || this.kmConfig.getRsaTrustedServerCertFileName().endsWith(".pem")) {
                    rsaTrustedServerCerts = this.getCertStoreFromPemFile(rsaTrustedServerCertsFile, "sme_rkm_trust");
                } else {
                    _Logger.error((Object)("Error loading RSA trusted server keystore " + fileName));
                }
            } else {
                _Logger.warn((Object)"RSA Trust keystore not configured. ");
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("Error loading RSA trusted server keystore " + fileName + " Exception: " + e.getMessage()));
        }
        finally {
            try {
                if (rsaTrustedServerCertsFile != null) {
                    rsaTrustedServerCertsFile.close();
                }
            }
            catch (Exception e) {
                _Logger.error((Object)("Error closing KMC Trust keystore " + fileName + " Exception: " + e.getMessage()));
            }
        }
        return rsaTrustedServerCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getRSAClientCert() {
        KeyStore rsaClientCerts = null;
        String fileName = ClientCache.getConfDir() + "cert/" + this.kmConfig.getRsaClientCertFileName();
        FileInputStream rsaClientCertsFile = null;
        try {
            if (this.kmConfig.getRsaClientCertFileName() != null) {
                rsaClientCertsFile = new FileInputStream(fileName);
                if (this.kmConfig.getRsaClientCertFileName().endsWith(".jks")) {
                    rsaClientCerts = KeyStore.getInstance("JKS");
                    rsaClientCerts.load(rsaClientCertsFile, null);
                } else if (this.kmConfig.getRsaClientCertFileName().endsWith(".p12")) {
                    rsaClientCerts = KeyStore.getInstance("PKCS12");
                    rsaClientCerts.load(rsaClientCertsFile, this.kmConfig.getRsaClientPassword().toCharArray());
                } else {
                    _Logger.error((Object)("Error loading RSA Client keystore " + fileName));
                }
            } else {
                _Logger.warn((Object)"RSA Client keystore not configured. ");
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("Error loading RSA Client keystore " + fileName + " Exception: " + e.getMessage()));
        }
        finally {
            try {
                if (rsaClientCertsFile != null) {
                    rsaClientCertsFile.close();
                }
            }
            catch (Exception e) {
                _Logger.error((Object)("Error closing KMC Trust keystore " + fileName + " Exception: " + e.getMessage()));
            }
        }
        return rsaClientCerts;
    }

    public KeyManagerEnum getKeyManager() {
        if (this.kmConfig == null) {
            return KeyManagerEnum.NONE;
        }
        return this.kmConfig.getKeyManager();
    }

    public void setKeyManager(KeyManagerEnum keyManager) {
        this.kmConfig.setKeyManager(keyManager);
    }

    public boolean isUseIP() {
        return this.useIP;
    }

    public void setUseIP(boolean useIP) {
        this.useIP = useIP;
    }

    public long getItNexsusDiscoverySleepTime() {
        return this.itNexsusDiscoverySleepTime;
    }

    public void setItNexsusDiscoverySleepTime(long itNexsusDiscoverySleepTime) {
        this.itNexsusDiscoverySleepTime = itNexsusDiscoverySleepTime;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getKmcPort() {
        return this.kmcPort;
    }

    public void setKmcPort(int kmcPort) {
        this.kmcPort = kmcPort;
    }

    public int getKmcSSLPort() {
        return this.kmcSSLPort;
    }

    public void setKmcSSLPort(int kmcSSLPort) {
        this.kmcSSLPort = kmcSSLPort;
    }

    public boolean isClearDiscovery() {
        return this.clearDiscovery;
    }

    public void setClearDiscovery(boolean clearDiscovery) {
        this.clearDiscovery = clearDiscovery;
    }

    public boolean isSyncKMCDB() {
        return this.syncKMCDB;
    }

    public void setSyncKMCDB(boolean syncKMCDB) {
        this.syncKMCDB = syncKMCDB;
    }

    public boolean isForceRekey(String clusterName) {
        if (this.forceRekey) {
            return this.forceRekeyCluster.equals(clusterName);
        }
        return this.forceRekey;
    }

    public void setForceRekey(boolean forceRekey) {
        this.forceRekey = forceRekey;
    }

    public boolean isLogXMLMessages() {
        return this.logXMLMessages;
    }

    public void setLogXMLMessages(boolean logXMLMessages) {
        this.logXMLMessages = logXMLMessages;
    }

    public boolean isSslICN() {
        return this.sslICN;
    }

    public void setSslICN(boolean sslICN) {
        this.sslICN = sslICN;
    }

    public ArrayList<String> getCertificateList() {
        FilenameFilter filter;
        File dir = new File(ClientCache.getConfDir() + "cert/");
        String[] certificateList = dir.list(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jks") || name.endsWith(".p12") || name.endsWith(".pem") || name.endsWith(".der");
            }
        });
        if (certificateList == null) {
            _Logger.warn((Object)("Either " + ClientCache.getConfDir() + "cert/" + " does not exist or is not a directory"));
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(certificateList));
    }

    public String getForceRekeyCluster() {
        return this.forceRekeyCluster;
    }

    public void setForceRekeyCluster(String forceRekeyCluster) {
        this.forceRekeyCluster = forceRekeyCluster;
    }

    public boolean isRetainImportedKeyState() {
        return this.retainImportedKeyState;
    }

    public void setRetainImportedKeyState(boolean retainImportedKeyState) {
        this.retainImportedKeyState = retainImportedKeyState;
    }

    public boolean isForceRekey() {
        return this.forceRekey;
    }

    public String getRsaClientCertFileName() {
        return this.kmConfig.getRsaClientCertFileName();
    }

    public String getRsaClientPassword() {
        return this.kmConfig.getRsaClientPassword();
    }

    public String getRsaServerName() {
        return this.kmConfig.getRsaServerName();
    }

    public int getRsaServerPort() {
        return this.kmConfig.getRsaServerPort();
    }

    public String getRsaTrustedServerCertFileName() {
        return this.kmConfig.getRsaTrustedServerCertFileName();
    }

    public void setRsaClientCertFileName(String rsaClientCertFileName) {
        if (this.kmConfig != null) {
            this.kmConfig.setRsaClientCertFileName(rsaClientCertFileName);
        }
    }

    public void setRsaClientPassword(String rsaClientPassword) {
        this.kmConfig.setRsaClientPassword(rsaClientPassword);
    }

    public void setRsaServerName(String rsaServerName) {
        if (this.kmConfig != null) {
            this.kmConfig.setRsaServerName(rsaServerName);
        }
    }

    public void setRsaServerPort(int rsaServerPort) {
        this.kmConfig.setRsaServerPort(rsaServerPort);
    }

    public void setRsaTrustedServerCertFileName(String rsaTrustedServerCertFileName) {
        if (this.kmConfig != null) {
            this.kmConfig.setRsaTrustedServerCertFileName(rsaTrustedServerCertFileName);
        }
    }

    public String getKmcServerCertFileName() {
        return this.kmConfig.getKmcServerCertFileName();
    }

    public void setKmcServerCertFileName(String kmcServerCertFileName) {
        if (this.kmConfig != null) {
            this.kmConfig.setKmcServerCertFileName(kmcServerCertFileName);
        }
    }

    public String getKmcServerPassword() {
        return this.kmConfig.getKmcServerPassword();
    }

    public void setKmcServerPassword(String kmcServerPassword) {
        if (this.kmConfig != null) {
            this.kmConfig.setKmcServerPassword(kmcServerPassword);
        }
    }

    public String getKmcTrustCertFileName() {
        return this.kmConfig.getKmcTrustCertFileName();
    }

    public void setKmcTrustCertFileName(String kmcTrustCertFileName) {
        if (this.kmConfig != null) {
            this.kmConfig.setKmcTrustCertFileName(kmcTrustCertFileName);
        }
    }

    public String getPrimaryKMCAddr() {
        return this.kmConfig.getPrimaryKMCAddr();
    }

    public void setPrimaryKMCAddr(String primaryKMCAddr) {
        if (this.kmConfig != null) {
            this.kmConfig.setPrimaryKMCAddr(primaryKMCAddr);
        }
    }

    public String getSecondaryKMCAddr() {
        return this.kmConfig.getSecondaryKMCAddr();
    }

    public void setSecondaryKMCAddr(String secondaryKMCAddr) {
        if (this.kmConfig != null) {
            this.kmConfig.setSecondaryKMCAddr(secondaryKMCAddr);
        }
    }

    public String getPeerKmcServerCertFileName() {
        return this.kmConfig.getPeerKmcServerCertFileName();
    }

    public void setPeerKmcServerCertFileName(String peerKmcServerCertFileName) {
        if (this.kmConfig != null) {
            this.kmConfig.setPeerKmcServerCertFileName(peerKmcServerCertFileName);
        }
    }

    public String getPeerKmcServerPassword() {
        return this.kmConfig.getPeerKmcServerPassword();
    }

    public void setPeerKmcServerPassword(String peerKmcServerPassword) {
        if (this.kmConfig != null) {
            this.kmConfig.setPeerKmcServerPassword(peerKmcServerPassword);
        }
    }

    public String getPeerKmcTrustCertFileName() {
        return this.kmConfig.getPeerKmcTrustCertFileName();
    }

    public void setPeerKmcTrustCertFileName(String peerKmcTrustCertFileName) {
        if (this.kmConfig != null) {
            this.kmConfig.setPeerKmcTrustCertFileName(peerKmcTrustCertFileName);
        }
    }

    public String getKmcServerType() {
        return this.kmConfig.getKmcServerType();
    }

    public void setKmcServerType(String kmcServerType) {
        if (this.kmConfig != null) {
            this.kmConfig.setKmcServerType(kmcServerType);
        }
    }

    public boolean isArchiveAccountingLog() {
        return this.archiveAccountingLog;
    }

    public void setArchiveAccountingLog(boolean archiveAccountingLog) {
        this.archiveAccountingLog = archiveAccountingLog;
    }

    public int getArchiveAccountingLogFreq() {
        return this.archiveAccountingLogFreq;
    }

    public void setArchiveAccountingLogFreq(int archiveAccountingLogFreq) {
        this.archiveAccountingLogFreq = archiveAccountingLogFreq;
    }

    public int getReplicationFreq() {
        return this.replicationFreq;
    }

    public void setReplicationFreq(int replicationFreq) {
        this.replicationFreq = replicationFreq;
    }

    public int getReplicationExpiry() {
        return this.replicationExpiry;
    }

    public void setReplicationExpiry(int replicationExpiry) {
        this.replicationExpiry = replicationExpiry;
    }

    public String getKmcIP() {
        return this.kmcIP;
    }

    public void setKmcIP(String kmcIP) {
        this.kmcIP = kmcIP;
    }

    public void setLimitKeyAdminRole(boolean limitKeyAdminRole) {
        this.limitKeyAdminRole = limitKeyAdminRole;
    }

    public boolean isLimitKeyAdminRole() {
        return this.limitKeyAdminRole;
    }

    public void setLimitKeyAdminQuorum(boolean limitKeyAdminQuorum) {
        this.limitKeyAdminQuorum = limitKeyAdminQuorum;
    }

    public boolean isLimitKeyAdminQuorum() {
        return this.limitKeyAdminQuorum;
    }

    public String getVpnKMC() {
        return this.vpnKMC;
    }

    public void setVpnKMC(String vpnKMC) {
        this.vpnKMC = vpnKMC;
    }

    public ArrayList<String> getVpnPrefixList() {
        return this.vpnPrefixList;
    }

    public void setVpnPrefixList(ArrayList<String> vpnPrefixList) {
        this.vpnPrefixList = vpnPrefixList;
    }

    public boolean isTestVpn() {
        return this.vpnPrefixList.size() > 0;
    }
}

