/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.common;

import com.cisco.dcbu.sme.common.DiskGroupBase;
import com.cisco.dcbu.sme.common.DiskSignatureInfo;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.DiskVPD;
import java.io.Serializable;

public class DiskInfo
extends DiskGroupBase
implements Serializable,
Comparable<DiskGroupBase> {
    private static final long serialVersionUID = 1L;
    private String diskName;
    private String id;
    private int totalPaths;
    private String capacity;
    private DiskVPD vpd;
    private String wwn;
    private DiskStatusEnum status;
    private boolean encryptionEnabled;
    private String statusDescription;
    private int progress;
    private boolean prepareData;
    private String prepareDataTimeLeft;
    private String dataPreparationDescription;
    private String verificationStatus;
    private boolean rrSource = false;
    private boolean rrDest = false;
    private boolean signatureMode = true;
    private DiskSignatureInfo signature;

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capactity) {
        this.capacity = capactity;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public DiskStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(DiskStatusEnum status) {
        this.status = status;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public void setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
    }

    public boolean isCrypto() {
        return DiskStatusEnum.Crypto.equals((Object)this.status) || DiskStatusEnum.Suspend.equals((Object)this.status) && this.encryptionEnabled;
    }

    public boolean isClear() {
        return DiskStatusEnum.Clear.equals((Object)this.status) || DiskStatusEnum.Suspend.equals((Object)this.status) && !this.encryptionEnabled;
    }

    @Override
    public int compareTo(DiskInfo otherDisk) {
        return this.diskName.compareTo(otherDisk.getDiskName());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isPrepareData() {
        return this.prepareData;
    }

    public void setPrepareData(boolean prepareData) {
        this.prepareData = prepareData;
    }

    public String getPrepareDataTimeLeft() {
        return this.prepareDataTimeLeft;
    }

    public void setPrepareDataTimeLeft(String prepareDataTimeLeft) {
        this.prepareDataTimeLeft = prepareDataTimeLeft;
    }

    public String getDataPreparationDescription() {
        return this.dataPreparationDescription;
    }

    public void setDataPreparationDescription(String dataPreparationDescription) {
        this.dataPreparationDescription = dataPreparationDescription;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public int getTotalPaths() {
        return this.totalPaths;
    }

    public void setTotalPaths(int totalPaths) {
        this.totalPaths = totalPaths;
    }

    public DiskVPD getVpd() {
        return this.vpd;
    }

    public void setVpd(DiskVPD vpd) {
        this.vpd = vpd;
    }

    public String getWwn() {
        return this.wwn;
    }

    public void setWwn(String wwn) {
        this.wwn = wwn;
    }

    public String getStatusIcon() {
        String icon = "";
        icon = this.getStatus() == DiskStatusEnum.None || this.getStatus() == DiskStatusEnum.Failure || this.getStatus() == DiskStatusEnum.Offline || this.getStatus() == DiskStatusEnum.WaitEnable || this.getStatus() == DiskStatusEnum.Suspend ? "status_red.gif" : "status_green.gif";
        return "<img src=\"/sme/icons/" + icon + "\" border=\"0\" class=\"smeIcon\" />";
    }

    public String getHtmlStatus() {
        String style = "";
        style = this.status == DiskStatusEnum.Crypto || this.status == DiskStatusEnum.Clear ? "color: #336666" : "color: #990000";
        return "<span style=\"" + style + "\">" + this.getStatusString() + "</span>";
    }

    public String getStatusString() {
        String retString = "";
        if (this.status == DiskStatusEnum.Crypto) {
            retString = "Crypto";
        } else if (this.status == DiskStatusEnum.Clear) {
            retString = "Clear";
        } else if (this.status == DiskStatusEnum.Online) {
            retString = "Online";
        } else if (this.status == DiskStatusEnum.Offline) {
            retString = "Archived";
        } else if (this.status == DiskStatusEnum.Preparing) {
            retString = "Preparing";
        } else if (this.status == DiskStatusEnum.Suspend) {
            retString = "Suspend";
        } else if (this.status == DiskStatusEnum.Init) {
            retString = "Init";
        } else if (this.status == DiskStatusEnum.Archived) {
            retString = "Archived";
        } else if (this.status == DiskStatusEnum.Failure) {
            retString = "Failure";
        } else if (this.status == DiskStatusEnum.WaitEnable) {
            retString = "Wait SME Enable";
        }
        if (this.statusDescription != null && this.statusDescription.length() > 0 && retString.length() > 0 && !this.statusDescription.equals(retString)) {
            retString = this.status == DiskStatusEnum.Preparing ? retString + " (progress " + this.progress + "%, remaining time " + this.prepareDataTimeLeft + ")" : retString + " (" + this.statusDescription + ")";
        }
        return retString;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiskInfo)) {
            return false;
        }
        DiskInfo di = (DiskInfo)obj;
        if (!this.getClusterName().equals(di.getClusterName())) {
            return false;
        }
        if (!this.getDiskGroupName().equals(di.getDiskGroupName())) {
            return false;
        }
        return this.getDiskName().equals(di.getDiskName());
    }

    public boolean isRrDest() {
        return this.rrDest;
    }

    public void setRrDest(boolean rrDest) {
        this.rrDest = rrDest;
    }

    public boolean isRrSource() {
        return this.rrSource;
    }

    public void setRrSource(boolean rrSource) {
        this.rrSource = rrSource;
    }

    public boolean isSignatureMode() {
        return this.signatureMode;
    }

    public void setSignatureMode(boolean signatureMode) {
        this.signatureMode = signatureMode;
    }

    public DiskSignatureInfo getSignature() {
        return this.signature;
    }

    public void setSignature(DiskSignatureInfo signature) {
        this.signature = signature;
    }

    public String getNotifications() {
        String retString = "";
        retString = this.rrSource && !this.rrDest ? retString + "<img src=\"/sme/icons/source.png\" border=\"0\" class=\"smeIcon\" title=\"This disk is a source disk in a remote replication relationship.\" />&nbsp;" : (this.rrDest && !this.rrSource ? retString + "<img src=\"/sme/icons/destination.png\" border=\"0\" class=\"smeIcon\" title=\"This disk is a destination disk in a remote replication relationship.\" />&nbsp;" : (this.rrSource && this.rrDest ? retString + "<img src=\"/sme/icons/chained.png\" border=\"0\" class=\"smeIcon\" title=\"This disk is both a source and destination disk in a remote replication relationship.\" />&nbsp;" : "&nbsp;"));
        return retString;
    }

    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
    }
}

