/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.common;

import com.cisco.dcbu.sme.common.SerialQualiferInfo;
import com.cisco.dcbu.sme.common.SerialQualifierNoneInfo;
import com.cisco.dcbu.sme.common.SerialQualifierRangeInfo;
import com.cisco.dcbu.sme.common.SerialQualifierRegexInfo;
import com.cisco.dcbu.sme.common.SerialQualifierTypeEnum;
import com.cisco.dcbu.sme.common.SerialRangeInfo;
import com.cisco.dcbu.sme.common.TapeGroupBase;
import com.cisco.dcbu.sme.common.TapeVolumeGroupStatusEnum;
import org.apache.log4j.Logger;

public class TapeVolumeGroupInfo
extends TapeGroupBase
implements Comparable<TapeGroupBase> {
    private static final long serialVersionUID = 1L;
    private String volumeGroupName;
    private SerialQualiferInfo qualifier = new SerialQualifierNoneInfo();
    private TapeVolumeGroupStatusEnum status;
    private String sharedKeyGUID;
    private String wrapKeyGUID;
    static Logger _Logger = Logger.getLogger((String)"SME");

    public TapeVolumeGroupStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(TapeVolumeGroupStatusEnum status) {
        this.status = status;
    }

    public String getVolumeGroupName() {
        return this.volumeGroupName;
    }

    public void setVolumeGroupName(String volumeGroupName) {
        this.volumeGroupName = volumeGroupName;
    }

    public SerialQualiferInfo getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(SerialQualiferInfo qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void print() {
        super.print();
        _Logger.debug((Object)("Volume Group Name: " + this.volumeGroupName));
        _Logger.debug((Object)("Volume Group Type: " + this.qualifier.getType().value()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return false;
        }
        if (!(obj instanceof TapeVolumeGroupInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.volumeGroupName.equals(((TapeVolumeGroupInfo)obj).getVolumeGroupName());
    }

    public String getStatusIcon() {
        String icon = "";
        icon = this.status == TapeVolumeGroupStatusEnum.Active ? "status_green.gif" : "status_red.gif";
        return "<img src=\"/sme/icons/" + icon + "\" border=\"0\" class=\"smeIcon\" />";
    }

    public String getHtmlStatus() {
        String style = "";
        style = this.status == TapeVolumeGroupStatusEnum.Active ? "color: #336666" : "color: #990000";
        return "<span style=\"" + style + "\">" + (this.status == TapeVolumeGroupStatusEnum.Archived ? "Deactivated" : this.status) + "</span>";
    }

    public String getFilterMethodText() {
        String rt = "";
        SerialQualifierTypeEnum type = this.getQualifier().getType();
        rt = rt + type.toString();
        switch (type) {
            case Regex: {
                SerialQualifierRegexInfo sqrei = (SerialQualifierRegexInfo)this.getQualifier();
                rt = rt + " (" + sqrei.getRegex() + ")";
                break;
            }
            case Range: {
                SerialQualifierRangeInfo sqrai = (SerialQualifierRangeInfo)this.getQualifier();
                rt = rt + " (";
                for (SerialRangeInfo sri : sqrai.getRangeList()) {
                    rt = rt + sri.getStart() + "-" + sri.getEnd() + ", ";
                }
                if (rt.indexOf(",") != -1) {
                    rt = rt.substring(0, rt.length() - 2);
                }
                rt = rt + ")";
                break;
            }
        }
        return rt;
    }

    @Override
    public int compareTo(TapeVolumeGroupInfo otherTVGI) {
        return this.volumeGroupName.compareTo(otherTVGI.getVolumeGroupName());
    }

    public String getSharedKeyGUID() {
        return this.sharedKeyGUID;
    }

    public void setSharedKeyGUID(String sharedKeyGUID) {
        this.sharedKeyGUID = sharedKeyGUID;
    }

    public String getWrapKeyGUID() {
        return this.wrapKeyGUID;
    }

    public void setWrapKeyGUID(String wrapKeyGUID) {
        this.wrapKeyGUID = wrapKeyGUID;
    }
}

