/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.common.mapper;

import com.cisco.dcbu.sme.common.DiskGroupStatusEnum;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.xml.SMELunStatusEnum;

public class LunStatusMapper {
    public static DiskGroupStatusEnum convertStatusToDiskGroup(SMELunStatusEnum lunStatus) {
        if (lunStatus == null) {
            return DiskGroupStatusEnum.Active;
        }
        if (SMELunStatusEnum.SME___LUN___CLEAR.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Disabled;
        }
        if (SMELunStatusEnum.SME___LUN___CRYPTO.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Enabled;
        }
        if (SMELunStatusEnum.SME___LUN___OFFLINE.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.None;
        }
        if (SMELunStatusEnum.SME___LUN___ONLINE.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Ready;
        }
        if (SMELunStatusEnum.SME___LUN___PREPARING.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Encrypting;
        }
        if (SMELunStatusEnum.SME___LUN___SUSPEND.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Disabled;
        }
        if (SMELunStatusEnum.SME___LUN___FAILURE.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Failed;
        }
        if (SMELunStatusEnum.SME___LUN___WAIT___SME___ENABLE.equals((Object)lunStatus)) {
            return DiskGroupStatusEnum.Init;
        }
        return DiskGroupStatusEnum.Active;
    }

    public static DiskStatusEnum convertStatusToDisk(SMELunStatusEnum lunStatus) {
        if (lunStatus == null) {
            return DiskStatusEnum.None;
        }
        if (SMELunStatusEnum.SME___LUN___FAILURE.equals((Object)lunStatus)) {
            return DiskStatusEnum.Failure;
        }
        if (SMELunStatusEnum.SME___LUN___ONLINE.equals((Object)lunStatus)) {
            return DiskStatusEnum.Online;
        }
        if (SMELunStatusEnum.SME___LUN___OFFLINE.equals((Object)lunStatus)) {
            return DiskStatusEnum.Offline;
        }
        if (SMELunStatusEnum.SME___LUN___PREPARING.equals((Object)lunStatus)) {
            return DiskStatusEnum.Preparing;
        }
        if (SMELunStatusEnum.SME___LUN___CLEAR.equals((Object)lunStatus)) {
            return DiskStatusEnum.Clear;
        }
        if (SMELunStatusEnum.SME___LUN___CRYPTO.equals((Object)lunStatus)) {
            return DiskStatusEnum.Crypto;
        }
        if (SMELunStatusEnum.SME___LUN___SUSPEND.equals((Object)lunStatus)) {
            return DiskStatusEnum.Suspend;
        }
        if (SMELunStatusEnum.SME___LUN___WAIT___SME___ENABLE.equals((Object)lunStatus)) {
            return DiskStatusEnum.WaitEnable;
        }
        return DiskStatusEnum.None;
    }

    public static SMELunStatusEnum convertStatusToLun(DiskStatusEnum diskStatus) {
        if (diskStatus == null) {
            return SMELunStatusEnum.SME___LUN___FAILURE;
        }
        if (DiskStatusEnum.Failure.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___FAILURE;
        }
        if (DiskStatusEnum.Online.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___ONLINE;
        }
        if (DiskStatusEnum.Offline.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___OFFLINE;
        }
        if (DiskStatusEnum.Preparing.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___PREPARING;
        }
        if (DiskStatusEnum.Clear.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___CLEAR;
        }
        if (DiskStatusEnum.Crypto.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___CRYPTO;
        }
        if (DiskStatusEnum.Suspend.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___SUSPEND;
        }
        if (DiskStatusEnum.WaitEnable.equals((Object)diskStatus)) {
            return SMELunStatusEnum.SME___LUN___WAIT___SME___ENABLE;
        }
        return SMELunStatusEnum.SME___LUN___FAILURE;
    }
}

