/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.sme.comm.SmeXmlHandler;
import com.cisco.dcbu.sme.common.InterfaceInfo;
import com.cisco.dcbu.sme.common.Limits;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.SwitchInfo;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.InterfaceMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.message.ClusterMessage;
import com.cisco.dcbu.sme.tree.InterfaceTreeNode;
import com.cisco.dcbu.sme.xml.SMEClusterInterfaceData;
import com.cisco.dcbu.sme.xml.SMEClusterInterfaceIndex;
import com.cisco.dcbu.sme.xml.SMEClusterInterfaceObject;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class InterfaceMgrBean
extends MgrHelper
implements Serializable,
InterfaceMgr {
    static Logger _Logger = Logger.getLogger((String)"SME");

    @EJB
    public void setModelBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setClusterBean(ClusterMgr clusterBean) {
        this.clusterBean = clusterBean;
    }

    @Override
    public ArrayList<InterfaceTreeNode> getInterfaceTreeNodes(SMEContext ctx) {
        ArrayList<InterfaceTreeNode> interfaces = null;
        if (ctx == null || ctx.getCluster() == null || ctx.getCluster().getClusterName() == null) {
            return interfaces;
        }
        String clusterName = ctx.getCluster().getClusterName();
        interfaces = new ArrayList<InterfaceTreeNode>();
        InterfaceInfo interfaceInfo = new InterfaceInfo();
        interfaceInfo.setClusterName(clusterName);
        ClusterMessage clusterMessage = new ClusterMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = clusterMessage.prepareClusterInterfaceGetReq(interfaceInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = clusterMessage.parseSMEClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(smeMessage)) break;
                List clusterList = smeMessage.getTable_Data().getCluster_Get_Resp().getInterface();
                Iterator it = clusterList.iterator();
                while (it.hasNext()) {
                    InterfaceTreeNode smeInterfaceNode = new InterfaceTreeNode();
                    SMEClusterInterfaceObject clusterInterfaceObject = (SMEClusterInterfaceObject)it.next();
                    SMEClusterInterfaceIndex index = clusterInterfaceObject.getIndex();
                    SMEClusterInterfaceData data = clusterInterfaceObject.getData();
                    smeInterfaceNode.setClusterName(index.getCluster_Name());
                    SwitchInfo swInfo = new SwitchInfo();
                    swInfo.setSwitchName(index.getNode_Name());
                    swInfo.setMaster(data.isIs_Master());
                    swInfo.setMemberLocal(data.isIs_Member_Local());
                    smeInterfaceNode.setSwitchInfo(swInfo);
                    smeInterfaceNode.setInterfaceId(String.valueOf(index.getIf_Index()));
                    if (index.getCluster_Name().equals(clusterName)) {
                        interfaces.add(smeInterfaceNode);
                    }
                    interfaceInfo.setClusterName(smeInterfaceNode.getClusterName());
                    interfaceInfo.setSwitchInfo(swInfo);
                    interfaceInfo.setInterfaceId(smeInterfaceNode.getInterfaceId());
                    ++receivedCount;
                }
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed response received from switch " + se.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
        return interfaces;
    }
}

