/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.jnm.WwnVendor;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SMEPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sm.common.rif.SanServiceRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterSourceEnum;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.FabricInfo;
import com.cisco.dcbu.sme.common.HostEnclosure;
import com.cisco.dcbu.sme.common.IfindexHelper;
import com.cisco.dcbu.sme.common.Initiator;
import com.cisco.dcbu.sme.common.InterfaceInfo;
import com.cisco.dcbu.sme.common.InterfaceStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.SwitchInfo;
import com.cisco.dcbu.sme.common.Target;
import com.cisco.dcbu.sme.common.VsanInfo;
import com.cisco.dcbu.sme.common.ZoneInfo;
import com.cisco.dcbu.sme.common.ZoneMemberInfo;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.tree.ClusterTreeNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class ModelMgrBean
implements ModelMgr {
    static Logger _Logger = Logger.getLogger((String)"SME");
    ConcurrentHashMap<Integer, SanServiceRif> sanServices = new ConcurrentHashMap();
    public static final short CLUSTER_TYPE_SME = 1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SanServiceRif getSanServiceBean(SMEContext ctx, FabricPK pk) {
        SanServiceRif sanServiceBean = null;
        try {
            String fmAddress = FMServerImpl.getInstance().getServerForFabric(pk);
            if (fmAddress != null && (sanServiceBean = this.getSanServiceBean(ctx, fmAddress)) == null) return sanServiceBean;
        }
        catch (Exception e) {
            // empty catch block
        }
        return sanServiceBean;
    }

    private ArrayList<FabricPK> getFabricPKs(SMEContext ctx) {
        ArrayList fPKs = null;
        _Logger.debug((Object)"Get all fabrics from global view");
        fPKs = (ArrayList)GlobalFabricManager.getInstance().getAllFabricPKs();
        if (fPKs == null) {
            _Logger.warn((Object)"GlobalFabricManager.getFabricBases - return null");
        }
        return fPKs;
    }

    @Override
    public ArrayList<ClusterTreeNode> getClusterTreeNodes(SMEContext ctx) {
        _Logger.debug((Object)"modelMgr.getClusterTreeNodes - entry");
        ArrayList<ClusterTreeNode> clusterNodes = new ArrayList<ClusterTreeNode>();
        ArrayList<FabricPK> fabrics = null;
        try {
            fabrics = this.getFabricPKs(ctx);
            if (fabrics == null) {
                _Logger.warn((Object)"getAllFabricPks - return null");
                return clusterNodes;
            }
            _Logger.debug((Object)("Found " + fabrics.size() + " fabrics "));
            for (FabricPK fabric : fabrics) {
                if (fabric == null) continue;
                _Logger.debug((Object)("  fabric " + fabric.getName()));
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
                if (sanServiceBean == null) continue;
                SwitchBase[] switchArray = sanServiceBean.findAllSwitches();
                ClusterBase[] cba = sanServiceBean.findClusters(fabric);
                for (int j = 0; j < cba.length; ++j) {
                    if (cba[j].getType() != 1) continue;
                    _Logger.debug((Object)("    has cluster " + cba[j].getName()));
                    boolean found = false;
                    for (ClusterTreeNode cn : clusterNodes) {
                        if (cn.getClusterName().compareTo(cba[j].getName()) != 0) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ClusterTreeNode node = new ClusterTreeNode();
                    node.setClusterName(cba[j].getName());
                    node.setClusterId(cba[j].getClusterId());
                    if (cba[j].getMasterInetAddr() == null || cba[j].getMasterInetAddr().length() == 0) {
                        _Logger.debug((Object)("    cluster has broken ip: " + cba[j].getMasterInetAddr() + " by pass."));
                        continue;
                    }
                    String masterIp = this.getIp(cba[j].getMasterInetAddr(), switchArray);
                    node.setMasterIPAddr(masterIp);
                    node.setStatus(ClusterStatusEnum.Online);
                    node.setSource(ClusterSourceEnum.FM_MODEL);
                    clusterNodes.add(node);
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception getClusterTreeNodes: " + e.getMessage()));
        }
        _Logger.debug((Object)("Returning list of " + clusterNodes.size() + " clusterTreeNodes"));
        return clusterNodes;
    }

    @Override
    public ClusterInfo getClusterInfo(SMEContext ctx, String clusterName) {
        _Logger.debug((Object)"modelMgr.getClusterInfo - entry");
        _Logger.debug((Object)("  looking for cluster info for " + clusterName));
        com.cisco.dcbu.sme.common.ClusterBase clusterInfo = null;
        ArrayList<FabricInfo> fabricInfoList = new ArrayList<FabricInfo>();
        ArrayList<FabricPK> fabrics = null;
        try {
            fabrics = this.getFabricPKs(ctx);
            if (fabrics == null) {
                _Logger.warn((Object)"getAllFabricPks - return null");
                return null;
            }
            _Logger.debug((Object)("Found " + fabrics.size() + " fabrics "));
            for (FabricPK fabric : fabrics) {
                if (fabric == null) continue;
                _Logger.debug((Object)("  fabric " + fabric.getName()));
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
                if (sanServiceBean == null) continue;
                SwitchBase[] switchArray = sanServiceBean.findAllSwitches();
                ClusterBase[] cba = sanServiceBean.findClusters(fabric);
                for (int j = 0; j < cba.length; ++j) {
                    if (cba[j].getType() != 1) continue;
                    _Logger.debug((Object)("    has cluster " + cba[j].getName()));
                    if (clusterName.compareTo(cba[j].getName()) != 0) continue;
                    if (clusterInfo == null) {
                        clusterInfo = new ClusterInfo();
                        clusterInfo.setClusterName(cba[j].getName());
                        clusterInfo.setClusterId(cba[j].getClusterId());
                        String masterIp = this.getIp(cba[j].getMasterInetAddr(), switchArray);
                        clusterInfo.setMasterIPAddr(masterIp);
                        clusterInfo.setSource(ClusterSourceEnum.FM_MODEL);
                    }
                    FabricInfo info = new FabricInfo();
                    info.setFabricId("" + fabric.get_fid());
                    info.setFabricName(fabric.getName());
                    fabricInfoList.add(info);
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception getClusterInfo: " + e.getMessage()));
            return null;
        }
        if (clusterInfo != null) {
            _Logger.debug((Object)("Got cluster from FM model: " + clusterInfo.getClusterName() + " Master Inet Address: " + clusterInfo.getMasterIPAddr()));
            ((ClusterInfo)clusterInfo).setFabrics(fabricInfoList);
        } else {
            _Logger.warn((Object)("Could not get cluster from FM model: " + clusterName));
        }
        return clusterInfo;
    }

    public String getIp(String ipCheck, SwitchBase[] switchArray) {
        if (ipCheck == null) {
            return ipCheck;
        }
        try {
            InetAddress inetAddr = InetAddress.getByName(ipCheck);
            return inetAddr.getHostAddress();
        }
        catch (UnknownHostException e) {
            if (switchArray != null) {
                for (SwitchBase sb : switchArray) {
                    if (sb.getSysName() == null || !sb.getSysName().equals(ipCheck)) continue;
                    if (sb.getIpAddress() == null) {
                        return ipCheck;
                    }
                    return sb.getIpAddress();
                }
            }
            return ipCheck;
        }
    }

    @Override
    public ArrayList<VsanInfo> getVSANs(SMEContext ctx, String clusterName) {
        _Logger.debug((Object)"modelMgr.getVSANS - entry");
        ArrayList<VsanInfo> vsanList = new ArrayList<VsanInfo>();
        ArrayList<FabricPK> fabrics = null;
        try {
            fabrics = this.getFabricPKs(ctx);
            if (fabrics == null) {
                _Logger.warn((Object)"getAllFabricPks - return null");
                return null;
            }
            _Logger.debug((Object)("Found " + fabrics.size() + " fabrics "));
            for (FabricPK fabric : fabrics) {
                if (fabric == null) continue;
                _Logger.debug((Object)("  fabric " + fabric.getName()));
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
                if (sanServiceBean == null) continue;
                ClusterBase[] cba = sanServiceBean.findClusters(fabric);
                for (int j = 0; j < cba.length; ++j) {
                    if (cba[j].getType() != 1 || clusterName.compareTo(cba[j].getName()) != 0) continue;
                    VsanBase[] vbase = sanServiceBean.findVsans(fabric);
                    for (int k = 0; k < vbase.length; ++k) {
                        _Logger.debug((Object)("    cluster " + cba[j].getName() + " has Vsan " + vbase[k].getName()));
                        VsanInfo info = new VsanInfo();
                        info.setFabricName(fabric.getName());
                        info.setVsanId(vbase[k].getId());
                        if (vbase[k].isSegmented()) {
                            if (vbase[k].getSeedSwitchPK() != null) {
                                info.setVsanName(vbase[k].getName() + "(" + this.getSwitchName(ctx, fabric, vbase[k].getSeedSwitchPK()._wwn) + ")");
                            } else {
                                info.setVsanName(vbase[k].getName() + "(Unknown)");
                            }
                        } else {
                            info.setVsanName(vbase[k].getName());
                        }
                        info.setVsanPK(vbase[k].getVsanPK().getVsanPKAsString());
                        vsanList.add(info);
                    }
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception getVSANs: " + e.getMessage()));
        }
        Collections.sort(vsanList);
        _Logger.debug((Object)("Returning list of " + vsanList.size() + " vsans"));
        return vsanList;
    }

    @Override
    public ArrayList<VsanInfo> getVsansForFabric(SMEContext ctx, FabricInfo fabricInfo) {
        _Logger.debug((Object)"modelMgr.getVsansForFabric - entry");
        ArrayList<VsanInfo> vsanList = new ArrayList<VsanInfo>();
        if (fabricInfo == null) {
            _Logger.warn((Object)"getVsansForFabric - FabricInfo is null");
            return vsanList;
        }
        FabricPK pk = new FabricPK(Integer.valueOf(fabricInfo.getFabricId()));
        try {
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pk);
            if (sanServiceBean != null) {
                VsanBase[] vbase = sanServiceBean.findVsans(pk);
                _Logger.debug((Object)("Found " + vbase.length + " vsans"));
                for (int k = 0; k < vbase.length; ++k) {
                    _Logger.debug((Object)("  vsan " + vbase[k].getName() + " (id=" + vbase[k].getId() + ")"));
                    VsanInfo info = new VsanInfo();
                    info.setFabricName(fabricInfo.getFabricName());
                    info.setVsanId(vbase[k].getId());
                    if (vbase[k].isSegmented()) {
                        if (vbase[k].getSeedSwitchPK() != null) {
                            info.setVsanName(vbase[k].getName() + "(" + this.getSwitchName(ctx, pk, vbase[k].getSeedSwitchPK()._wwn) + ")");
                        } else {
                            info.setVsanName(vbase[k].getName() + "(Unknown)");
                        }
                    } else {
                        info.setVsanName(vbase[k].getName());
                    }
                    info.setVsanPK(vbase[k].getVsanPK().getVsanPKAsString());
                    vsanList.add(info);
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception getVsansForFabric: " + e.getMessage()));
        }
        Collections.sort(vsanList);
        _Logger.debug((Object)("Returning list of " + vsanList.size() + " vsans"));
        return vsanList;
    }

    @Override
    public ArrayList<FabricInfo> getFabrics(SMEContext ctx) {
        _Logger.debug((Object)"modelMgr.getFabrics - entry");
        ArrayList<FabricInfo> fabricList = new ArrayList<FabricInfo>();
        ArrayList<FabricPK> fabrics = null;
        fabrics = this.getFabricPKs(ctx);
        if (fabrics == null) {
            _Logger.warn((Object)"getAllFabricPks - return null");
            return null;
        }
        _Logger.debug((Object)("Found " + fabrics.size() + " fabrics "));
        for (FabricPK fabric : fabrics) {
            if (fabric == null) continue;
            _Logger.debug((Object)("  fabric " + fabric.getName() + " (id=" + fabric.get_fid() + ")"));
            FabricInfo info = new FabricInfo();
            info.setFabricId(new String("" + fabric.get_fid()));
            info.setFabricName(fabric.getName());
            fabricList.add(info);
        }
        Collections.sort(fabricList);
        _Logger.debug((Object)("Returning list of " + fabricList.size() + " fabrics"));
        return fabricList;
    }

    @Override
    public ArrayList<FabricInfo> getFabricsByCluster(SMEContext ctx, String clusterName) {
        _Logger.debug((Object)("modelMgr.getFabricsByCluster - entry " + clusterName));
        ArrayList<FabricInfo> fabricList = new ArrayList<FabricInfo>();
        if (clusterName == null) {
            return fabricList;
        }
        try {
            ArrayList<FabricPK> fabrics = this.getFabricPKs(ctx);
            if (fabrics == null) {
                _Logger.warn((Object)"getAllFabricPks - return null");
                return null;
            }
            _Logger.debug((Object)("Found " + fabrics.size() + " fabrics "));
            for (FabricPK fabric : fabrics) {
                if (fabric == null) continue;
                _Logger.debug((Object)("  fabric " + fabric.getName()));
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
                if (sanServiceBean == null) continue;
                ClusterBase[] cba = sanServiceBean.findClusters(fabric);
                for (int j = 0; j < cba.length; ++j) {
                    String cbaName;
                    if (cba[j] == null || cba[j].getType() != 1 || (cbaName = cba[j].getName()) == null || clusterName.compareTo(cbaName) != 0) continue;
                    _Logger.debug((Object)("  fabric " + fabric.getName() + " (id=" + fabric.get_fid() + ")"));
                    FabricInfo info = new FabricInfo();
                    info.setFabricId(new String("" + fabric.get_fid()));
                    info.setFabricName(fabric.getName());
                    fabricList.add(info);
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception getFabricsByCluster: " + e.getMessage()));
        }
        Collections.sort(fabricList);
        _Logger.debug((Object)("Returning list of " + fabricList.size() + " fabrics"));
        return fabricList;
    }

    @Override
    public ArrayList<InterfaceInfo> getSMEInterfacesforFabric(SMEContext ctx, FabricInfo fabric) {
        _Logger.debug((Object)"modelMgr.getSMEInterfacesforFabric - entry");
        ArrayList<InterfaceInfo> interfaceList = new ArrayList<InterfaceInfo>();
        Config conf = Config.getInstance();
        try {
            FabricPK pk = new FabricPK(Integer.valueOf(fabric.getFabricId()));
            pk.setName(fabric.getFabricName());
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pk);
            if (sanServiceBean != null) {
                SMEPortBase[] ports = sanServiceBean.findSMEInterfaces(pk);
                if (ports == null) {
                    _Logger.warn((Object)"sanService.findSMEInterfaces - null, returning empty list");
                    return interfaceList;
                }
                _Logger.debug((Object)("Found " + ports.length + " sme interfaces for fabric " + fabric.getFabricName()));
                for (int i = 0; i < ports.length; ++i) {
                    String ifIndex = IfindexHelper.getSMEIfName(ports[i].getFcPort().getIfIndex());
                    _Logger.debug((Object)("  SME interface " + ifIndex));
                    if (ports[i].getFcPort().getClusterId() != null && ports[i].getFcPort().getClusterId().length() != 0) {
                        _Logger.debug((Object)("    is already in use by cluster: " + ports[i].getFcPort().getClusterId()));
                        continue;
                    }
                    InterfaceInfo info = new InterfaceInfo();
                    info.setInterfaceId("" + ports[i].getFcPort().getIfIndex());
                    info.setIfIndex(ports[i].getFcPort().getIfIndex());
                    info.setKey(ports[i].getSwitchPK());
                    SwitchInfo swInfo = new SwitchInfo();
                    swInfo.setFabricName(fabric.getFabricName());
                    info.setInterfaceId(ifIndex);
                    swInfo.setIpAddress(ports[i].getIpAddr());
                    if (conf.isUseIP()) {
                        swInfo.setSwitchName(ports[i].getIpAddr());
                    } else {
                        swInfo.setSwitchName(ports[i].getSysName());
                    }
                    info.setSwitchInfo(swInfo);
                    switch (ports[i].getFcPort().getSMEState()) {
                        case 0: {
                            info.setStatus(InterfaceStatusEnum.Initializing);
                            break;
                        }
                        case 1: {
                            info.setStatus(InterfaceStatusEnum.Online);
                            break;
                        }
                        default: {
                            info.setStatus(InterfaceStatusEnum.Offline);
                        }
                    }
                    interfaceList.add(info);
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception getSMEInterfacesforFabric: " + e.getMessage()));
        }
        _Logger.debug((Object)("Returning list of " + interfaceList.size() + " SMEInterfaces"));
        return interfaceList;
    }

    @Override
    public String getEndPortNameByWwn(SMEContext ctx, String fabricName, String wwn) {
        _Logger.debug((Object)"modelMgr.getEndPortNameByWwn - entry");
        FabricPK fpk = this.getFabricPK(ctx, fabricName);
        return this.getEndPortNameByWwn(ctx, fpk, wwn);
    }

    @Override
    public String getEndPortNameByWwn(SMEContext ctx, FabricPK fabric, String wwn) {
        _Logger.debug((Object)"modelMgr.getEndPortNameByWwn - entry");
        String endPortName = "";
        if (wwn.length() == 0) {
            return wwn;
        }
        if (fabric == null) {
            return wwn;
        }
        WwnKey key = new WwnKey(new Wwn(wwn, true));
        try {
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
            if (sanServiceBean != null) {
                endPortName = sanServiceBean.findEndPortNameByWwn(key);
                _Logger.debug((Object)("Found name:" + endPortName));
                if (endPortName == null) {
                    _Logger.debug((Object)("No name found, using wwn instead:" + endPortName));
                    endPortName = wwn;
                }
            }
        }
        catch (RemoteException e) {
            _Logger.info((Object)("Exception: " + e.getMessage()));
            _Logger.debug((Object)("Exception in getting name, using wwn instead:" + endPortName));
            endPortName = wwn;
        }
        return endPortName;
    }

    private FabricBase getFabricBase(SMEContext ctx, ArrayList<FabricInfo> modelFabrics, Initiator init) {
        FabricBase fa = null;
        for (FabricInfo fInfo : modelFabrics) {
            if (!init.getFabricName().equalsIgnoreCase(fInfo.getFabricName())) continue;
            try {
                FabricPK pk = new FabricPK(Integer.valueOf(fInfo.getFabricId()));
                pk.setName(fInfo.getFabricName());
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pk);
                if (sanServiceBean == null) break;
                fa = sanServiceBean.findFabric(pk);
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("No fabrics found for initiator  " + init.getHostName()));
            }
            break;
        }
        return fa;
    }

    private VsanBase getVsanBase(SMEContext ctx, FabricBase fa, Initiator init) {
        VsanBase vsan;
        block3: {
            vsan = null;
            try {
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fa.getPK());
                if (sanServiceBean == null) break block3;
                VsanBase[] vbase = sanServiceBean.findVsans(fa.getPK());
                _Logger.debug((Object)("Found " + vbase.length + " vsans"));
                for (int k = 0; k < vbase.length; ++k) {
                    if (init.getVsanId() != vbase[k].getId() || !init.getVsanPK().equals(vbase[k].getVsanPK().getVsanPKAsString())) continue;
                    vsan = vbase[k];
                    break;
                }
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("No vsans found for initiator  " + init.getHostName()));
            }
        }
        return vsan;
    }

    @Override
    public ArrayList<ZoneInfo> getZonesForVSAN(SMEContext ctx, ArrayList<VsanInfo> vsanList) {
        ArrayList<ZoneInfo> zoneList = new ArrayList<ZoneInfo>();
        for (VsanInfo vsan : vsanList) {
            FabricPK fpk = this.getFabricPK(ctx, vsan.getFabricName());
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fpk);
            if (sanServiceBean == null) continue;
            try {
                ZoneBase[] zones = sanServiceBean.getZonesForVsan(fpk, vsan.getVsanPK());
                if (zones == null) continue;
                for (ZoneBase z : zones) {
                    ZoneInfo zi = new ZoneInfo();
                    zi.setFabricName(vsan.getFabricName());
                    zi.setVsanId(vsan.getVsanId());
                    zi.setVsanName(vsan.getVsanName());
                    zi.setZoneName(z.getName());
                    zi.setVsanPK(vsan.getVsanPK());
                    zoneList.add(zi);
                }
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("Problem getting zones for vsan " + vsan.getVsanName()), (Throwable)e);
            }
        }
        return zoneList;
    }

    @Override
    public ArrayList<ZoneInfo> getZonesForIVR(SMEContext ctx) {
        ArrayList<ZoneInfo> zoneList = new ArrayList<ZoneInfo>();
        ArrayList<FabricInfo> fabricList = this.getFabricsByCluster(ctx, ctx.getCluster().getClusterName());
        for (FabricInfo fi : fabricList) {
            FabricPK fpk = this.getFabricPK(ctx, fi.getFabricName());
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fpk);
            if (sanServiceBean == null) continue;
            try {
                ZoneBase[] zones = sanServiceBean.getIvrZones(fpk);
                if (zones == null) continue;
                for (ZoneBase z : zones) {
                    ZoneInfo zi = new ZoneInfo();
                    zi.setFabricName(fi.getFabricName());
                    zi.setVsanId(-1);
                    zi.setZoneName(z.getName());
                    zi.setVsanPK("IVR");
                    zi.setIVR(true);
                    zoneList.add(zi);
                }
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("Problem getting zones for ivr in fabric " + fi.getFabricName()), (Throwable)e);
            }
        }
        return zoneList;
    }

    @Override
    public ArrayList<ZoneMemberInfo> getZoneMembers(SMEContext ctx, ZoneInfo zoneInfo) {
        ArrayList<ZoneMemberInfo> memberList = new ArrayList<ZoneMemberInfo>();
        FabricPK fpk = this.getFabricPK(ctx, zoneInfo.getFabricName());
        SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fpk);
        if (sanServiceBean != null) {
            FabricBase fa = null;
            try {
                fa = sanServiceBean.findFabric(fpk);
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("Problem getting zone members for zone " + zoneInfo.getZoneName()), (Throwable)e);
            }
            if (fa == null) {
                return memberList;
            }
            VsanBase[] vbaseList = null;
            try {
                vbaseList = sanServiceBean.findVsans(fa.getPK());
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("Problem getting zone members for zone " + zoneInfo.getZoneName()), (Throwable)e);
            }
            if (vbaseList == null) {
                return memberList;
            }
            VsanBase vsanBase = null;
            for (int k = 0; k < vbaseList.length; ++k) {
                if (zoneInfo.getVsanId() != vbaseList[k].getId() || !zoneInfo.getVsanPK().equals(vbaseList[k].getVsanPK().getVsanPKAsString())) continue;
                vsanBase = vbaseList[k];
                break;
            }
            if (vsanBase == null) {
                return memberList;
            }
            ZoneBase[] zones = null;
            try {
                zones = sanServiceBean.getZonesForVsan(fpk, zoneInfo.getVsanPK());
            }
            catch (RemoteException e) {
                _Logger.warn((Object)("Problem getting zone members for zone " + zoneInfo.getZoneName()), (Throwable)e);
            }
            if (zones != null) {
                for (ZoneBase z : zones) {
                    Array zoneMembers;
                    if (!z.getName().equals(zoneInfo.getZoneName()) || (zoneMembers = z.getMembers()) == null) continue;
                    ZoneInfo zi = new ZoneInfo();
                    zi.setFabricName(zoneInfo.getFabricName());
                    zi.setVsanId(zoneInfo.getVsanId());
                    zi.setZoneName(z.getName());
                    for (int i = 0; i < zoneMembers.size(); ++i) {
                        ZoneMemberBase zmb = (ZoneMemberBase)zoneMembers.elementAt(i);
                        Wwn memWwn = this.getZoneMemberWwn(zmb, vsanBase, fa);
                        if (memWwn == null) continue;
                        ZoneMemberInfo zmi = new ZoneMemberInfo();
                        String strwwn = SnmpString.toHexString(memWwn.getValue());
                        zmi.setWwn(strwwn);
                        zmi.setZoneName(z.getName());
                        memberList.add(zmi);
                    }
                }
            }
        }
        return memberList;
    }

    @Override
    public ArrayList<Target> getTargetsZonedforHosts(SMEContext ctx, ArrayList<Initiator> hosts, int type) {
        return this.getTargetsZonedforHosts(ctx, hosts, type, null);
    }

    @Override
    public ArrayList<Target> getTargetsZonedforHosts(SMEContext ctx, ArrayList<Initiator> hosts, int type, ArrayList<ZoneInfo> zoneFilterList) {
        _Logger.debug((Object)"getTargetsZonedforHosts - entry");
        String clusterName = ctx.getCluster().getClusterName();
        ArrayList<Target> targetList = new ArrayList<Target>();
        ArrayList<FabricInfo> modelFabrics = this.getFabricsByCluster(ctx, clusterName);
        if (modelFabrics == null) {
            _Logger.debug((Object)("No fabrics found for cluster  " + clusterName));
            return targetList;
        }
        ArrayList<HostEnclosure> hostEncList = new ArrayList<HostEnclosure>();
        for (Initiator init : hosts) {
            EnclosureBase initEnclosure;
            WwnKey key;
            block17: {
                key = new WwnKey(new Wwn(init.getWwn(), true));
                try {
                    _Logger.debug((Object)("looking for enclosure for KEY " + init.getWwn()));
                    SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, this.getFabricPK(ctx, init.getFabricName()));
                    if (sanServiceBean != null) {
                        initEnclosure = sanServiceBean.findEnclosureByWwn(key);
                        _Logger.debug((Object)("Found enclosure: " + initEnclosure.getEnclosureName()));
                        break block17;
                    }
                    _Logger.warn((Object)("Error looking for enclosure for key: " + init.getWwn() + ". Failed to access San Service"));
                }
                catch (RemoteException e) {
                    _Logger.warn((Object)("Exception looking for enclosure for KEY: " + init.getWwn() + " Error: " + e.getMessage()));
                }
                continue;
            }
            init.setWwnKey(key);
            HostEnclosure newHe = new HostEnclosure();
            newHe.setEnclosureName(init.getEnclosureName());
            newHe.setEnclosure(initEnclosure);
            newHe.setFabricName(init.getFabricName());
            newHe.setVsanId(init.getVsanId());
            boolean found = false;
            for (HostEnclosure he : hostEncList) {
                if (!he.equals(newHe)) continue;
                he.getInitList().add(init);
                found = true;
                break;
            }
            if (found) continue;
            FabricBase fa = this.getFabricBase(ctx, modelFabrics, init);
            VsanBase vsan = this.getVsanBase(ctx, fa, init);
            newHe.setFa(fa);
            newHe.setVsan(vsan);
            newHe.getInitList().add(init);
            hostEncList.add(newHe);
        }
        for (HostEnclosure he : hostEncList) {
            ArrayList<ZoneInfo> matchingZones = new ArrayList<ZoneInfo>();
            if (zoneFilterList != null) {
                for (ZoneInfo z : zoneFilterList) {
                    if (!z.getVsanPK().equals(he.getVsan().getVsanPK().getVsanPKAsString())) continue;
                    matchingZones.add(z);
                }
            }
            String[] stringZones = new String[matchingZones.size()];
            for (int i = 0; i < matchingZones.size(); ++i) {
                stringZones[i] = ((ZoneInfo)matchingZones.get(i)).getZoneName();
            }
            for (int j = 0; j < he.getInitList().size(); ++j) {
                EnclosureBase[] targets;
                block18: {
                    EnclosureBase host = new EnclosureBase(he.getEnclosure().getEnclosureName(), he.getInitList().get(j).getIpAddress(), he.getInitList().get(j).isVirtual());
                    host.addEndPort(he.getInitList().get(j).getWwnKey());
                    _Logger.debug((Object)("Finding targets for host " + he.getEnclosure().getEnclosureName()));
                    targets = null;
                    try {
                        SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, he.getFa().getPK());
                        if (sanServiceBean == null) break block18;
                        targets = zoneFilterList != null ? sanServiceBean.findTargetEnclosures(host, he.getVsan(), he.getFa(), stringZones) : sanServiceBean.findTargetEnclosures(host, he.getVsan(), he.getFa());
                    }
                    catch (RemoteException e) {
                        _Logger.warn((Object)("Exception getTargetsZonedforHosts: " + e.getMessage()));
                        continue;
                    }
                }
                if (targets == null) continue;
                _Logger.debug((Object)("found " + targets.length + " targets"));
                for (int i = 0; i < targets.length; ++i) {
                    EnclosureBase eb = targets[i];
                    boolean match = false;
                    for (int w = 0; w < eb.getEndPortPKs().size(); ++w) {
                        byte[] wwnAr = eb.getEndPortPKs().get((int)w)._wwn.getValue();
                        String wwn = SnmpString.toHexString(wwnAr);
                        WwnVendor epType = WwnDictionary.getWwnVendor(wwnAr);
                        if (epType != null && (epType.getType() & type) == 0) {
                            WwnVendor testType = new WwnVendor(1, "", type);
                            _Logger.warn((Object)("  skipped target " + wwn + " due to explicit type mismatch.  Expect: " + testType.getTypeString() + " found: " + epType.getTypeString() + ".  If this is an error update your OUI definitions"));
                            continue;
                        }
                        for (int k = 0; k < targetList.size(); ++k) {
                            Target check = targetList.get(k);
                            if (check.getWwn().compareTo(wwn) != 0) continue;
                            check.addZonedInitiator(he.getInitList().get(j).getWwn());
                            match = true;
                            _Logger.debug((Object)("  target " + wwn + " already known"));
                            break;
                        }
                        if (match) continue;
                        Target t = new Target();
                        t.setFabricName(he.getInitList().get(j).getFabricName());
                        t.setWwn(wwn);
                        String targetName = this.getEndPortNameByWwn(ctx, t.getFabricName(), t.getWwn());
                        t.setTargetName(targetName);
                        t.setVsanId(he.getInitList().get(j).getVsanId());
                        t.setZonedToInitiatorWwn(he.getInitList().get(j).getWwn());
                        t.addZonedInitiator(he.getInitList().get(j).getWwn());
                        t.setEnclosureName(eb.getEnclosureName());
                        _Logger.debug((Object)("  target " + wwn + " unknown, adding!"));
                        targetList.add(t);
                    }
                }
            }
        }
        Collections.sort(targetList);
        _Logger.debug((Object)("Returning list of " + targetList.size() + " Targets"));
        return targetList;
    }

    @Override
    public ArrayList<Target> getIVRTargetsZonedforHosts(SMEContext ctx, ArrayList<Initiator> hosts, ArrayList<VsanInfo> vsanList, int type) {
        return this.getIVRTargetsZonedforHosts(ctx, hosts, vsanList, type, null);
    }

    @Override
    public ArrayList<Target> getIVRTargetsZonedforHosts(SMEContext ctx, ArrayList<Initiator> hosts, ArrayList<VsanInfo> vsanFilterList, int type, ArrayList<ZoneInfo> zoneFilterList) {
        _Logger.debug((Object)"modelMgr.getIVRTargetsZonedforHosts - entry");
        String clusterName = ctx.getCluster().getClusterName();
        ArrayList<Target> targetList = new ArrayList<Target>();
        if (hosts.isEmpty()) {
            return targetList;
        }
        ArrayList<FabricInfo> modelFabrics = this.getFabricsByCluster(ctx, clusterName);
        if (modelFabrics == null) {
            _Logger.debug((Object)("No fabrics found for cluster  " + clusterName));
            return targetList;
        }
        for (Initiator init : hosts) {
            SanServiceRif sanServiceBean;
            VsanBase[] vsanBases;
            ZoneBase[] ivrZoneBases;
            VsanBase vsanBase;
            FabricBase fa;
            WwnKey key;
            block20: {
                key = new WwnKey(new Wwn(init.getWwn(), true));
                FabricPK pk = this.getFabricPK(ctx, init.getFabricName());
                fa = this.getFabricBase(ctx, modelFabrics, init);
                vsanBase = this.getVsanBase(ctx, fa, init);
                ivrZoneBases = null;
                vsanBases = null;
                sanServiceBean = null;
                try {
                    sanServiceBean = this.getSanServiceBean(ctx, pk);
                    if (sanServiceBean == null) break block20;
                    ivrZoneBases = sanServiceBean.getIvrZones(pk);
                    vsanBases = sanServiceBean.findVsans(fa.getPK());
                }
                catch (RemoteException e) {
                    String errStr = "Exception getTargetsZonedforHosts: fabric=" + init.getFabricName();
                    if (init.getWwn() != null) {
                        errStr = errStr + " host wwn=" + init.getWwn();
                    }
                    _Logger.warn((Object)errStr, (Throwable)e);
                    continue;
                }
            }
            if (ivrZoneBases == null || vsanBases == null) continue;
            for (ZoneBase zone : ivrZoneBases) {
                ZoneMemberBase mem;
                int k;
                Array members;
                if (zoneFilterList != null) {
                    boolean filtermatch = false;
                    for (ZoneInfo zi : zoneFilterList) {
                        if (!zi.isIVR() || !zone.getName().equals(zi.getZoneName())) continue;
                        filtermatch = true;
                    }
                    if (!filtermatch) continue;
                }
                if ((members = zone.getMembers()) == null || members.getData() == null || members.size() <= 0) continue;
                E[] allMembers = members.getData();
                boolean hostFound = false;
                for (k = 0; k < members.size(); ++k) {
                    Wwn memWwn;
                    mem = (ZoneMemberBase)allMembers[k];
                    if (init.getVsanId() != mem.getIvrVsanId() || (memWwn = this.getZoneMemberWwn(mem, vsanBase, fa)) == null || !memWwn.equals(key._wwn)) continue;
                    hostFound = true;
                }
                if (!hostFound) continue;
                for (k = 0; k < members.size(); ++k) {
                    Wwn memWwn;
                    mem = (ZoneMemberBase)allMembers[k];
                    boolean vsanFilterMatch = false;
                    if (vsanFilterList != null) {
                        for (VsanInfo vi : vsanFilterList) {
                            if (vi.getVsanId() != init.getVsanId() && vi.getVsanId() != mem.getIvrVsanId()) continue;
                            vsanFilterMatch = true;
                        }
                        if (!vsanFilterMatch) continue;
                    }
                    VsanBase vsanMatch = null;
                    for (VsanBase vi : vsanBases) {
                        if (vi.getVsanPK()._id != mem.getIvrVsanId()) continue;
                        vsanMatch = vi;
                    }
                    if (vsanMatch == null || (memWwn = this.getZoneMemberWwn(mem, vsanMatch, fa)) == null) continue;
                    EndPortBase epb = null;
                    try {
                        epb = sanServiceBean.findEndPortBaseByWwn(new WwnKey(memWwn));
                    }
                    catch (RemoteException e) {
                        continue;
                    }
                    if (epb == null || !epb.isTarget()) continue;
                    byte[] wwnAr = memWwn.getValue();
                    String wwn = SnmpString.toHexString(wwnAr);
                    WwnVendor epType = WwnDictionary.getWwnVendor(wwnAr);
                    if (epType != null && (epType.getType() & type) == 0) {
                        WwnVendor testType = new WwnVendor(1, "", type);
                        _Logger.warn((Object)("  skipped target " + wwn + " due to explicit type mismatch.  Expect: " + testType.getTypeString() + " found: " + epType.getTypeString() + ".  If this is an error update your OUI definitions"));
                        continue;
                    }
                    boolean match = false;
                    for (Target check : targetList) {
                        if (check.getWwn().compareTo(wwn) != 0) continue;
                        check.addZonedInitiator(init.getWwn());
                        _Logger.debug((Object)("  target " + wwn + " already known"));
                        match = true;
                        break;
                    }
                    if (match) continue;
                    EnclosureBase eb = null;
                    try {
                        eb = sanServiceBean.findEnclosureByWwn(new WwnKey(memWwn));
                    }
                    catch (RemoteException e) {
                        continue;
                    }
                    Target t = new Target();
                    t.setFabricName(init.getFabricName());
                    t.setWwn(wwn);
                    t.setTargetName(this.getEndPortNameByWwn(ctx, t.getFabricName(), t.getWwn()));
                    t.setVsanId(vsanMatch.getVsanPK()._id);
                    t.setZonedToInitiatorWwn(init.getWwn());
                    t.addZonedInitiator(init.getWwn());
                    t.setEnclosureName(eb.getEnclosureName());
                    _Logger.debug((Object)("  target " + wwn + " unknown, adding!"));
                    targetList.add(t);
                }
            }
        }
        Collections.sort(targetList);
        _Logger.debug((Object)("Returning list of " + targetList.size() + " Targets"));
        return targetList;
    }

    private Wwn getZoneMemberWwn(ZoneMemberBase mem, VsanBase vsan, FabricBase fa) {
        switch (mem.getType()) {
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                EndPortBase epb = ZoneService.getEndPort(mem.getType(), mem.getId(), vsan, fa);
                if (epb == null) break;
                Wwn epbWwn = epb.getPortWwn();
                return epbWwn;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList endportList = ZoneService.getAttachedEndPorts(fa, mem.getType(), mem.getId(), vsan);
                if (endportList == null) break;
                for (int i = 0; i < endportList.size(); ++i) {
                    EndPortBase epb = (EndPortBase)endportList.get(i);
                    if (epb == null) continue;
                    Wwn epbWwn = epb.getPortWwn();
                    return epbWwn;
                }
                break;
            }
        }
        return null;
    }

    @Override
    public ArrayList<EnclosureBase> findHostEnclosures(SMEContext ctx, String fabricName, VsanPK pkey) {
        FabricPK fpk = this.getFabricPK(ctx, fabricName);
        return this.findHostEnclosures(ctx, fpk, pkey);
    }

    private ArrayList<EnclosureBase> findHostEnclosures(SMEContext ctx, FabricPK fabric, VsanPK pkey) {
        _Logger.debug((Object)"modelMgr.findHostEnclosures - entry");
        _Logger.debug((Object)("looking for hosts for vsan " + pkey.getVsanPKAsString()));
        ArrayList<EnclosureBase> list = new ArrayList<EnclosureBase>();
        EnclosureBase[] hosts = null;
        try {
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
            if (sanServiceBean != null) {
                hosts = sanServiceBean.findHostEnclosures(pkey);
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception findHostEnclosures: " + e.getMessage()));
            return list;
        }
        if (hosts != null) {
            _Logger.debug((Object)("found " + hosts.length + " hosts"));
            for (int i = 0; i < hosts.length; ++i) {
                list.add(hosts[i]);
            }
        }
        _Logger.debug((Object)("Returning list of " + list.size() + " Hosts"));
        return list;
    }

    @Override
    public ArrayList<Initiator> getHostsByVsan(SMEContext ctx, ArrayList<VsanInfo> vsans, ArrayList<ZoneInfo> zones) {
        _Logger.debug((Object)"modelMgr.getHostsByVsan - entry");
        ArrayList<Initiator> initiatorList = new ArrayList<Initiator>();
        if (vsans == null) {
            _Logger.debug((Object)"modelMgr.getHostsByVsan - vsan list is null, returning");
            return initiatorList;
        }
        if (vsans.size() == 0) {
            _Logger.debug((Object)"modelMgr.getHostsByVsan - vsan list is empty, returning");
            return initiatorList;
        }
        if (zones == null) {
            _Logger.debug((Object)"modelMgr.getHostsByVsan - zone list is null, returning");
            return initiatorList;
        }
        if (zones.size() == 0) {
            _Logger.debug((Object)"modelMgr.getHostsByVsan - zone list is empty, returning");
            return initiatorList;
        }
        for (VsanInfo info : vsans) {
            VsanPK pk = VsanPK.getVsanPKFromString(info.getVsanPK());
            _Logger.debug((Object)("looking for hosts for vsan " + info.getVsanId()));
            ArrayList<ZoneMemberInfo> membersList = new ArrayList<ZoneMemberInfo>();
            for (ZoneInfo zi : zones) {
                if (!zi.getVsanPK().equals(info.getVsanPK())) continue;
                _Logger.debug((Object)("looking for members for zone " + zi.getZoneName()));
                membersList.addAll(this.getZoneMembers(ctx, zi));
            }
            FabricPK fpk = this.getFabricPK(ctx, info.getFabricName());
            if (fpk == null) {
                _Logger.debug((Object)"fabric lookup failed, skipping to next vsan");
                continue;
            }
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fpk);
            if (sanServiceBean == null) {
                _Logger.debug((Object)"san service lookup failed, skipping to next vsan");
                continue;
            }
            ArrayList<EnclosureBase> hosts = this.findHostEnclosures(ctx, fpk, pk);
            if (hosts == null) {
                _Logger.debug((Object)("no host enclosures found for vsan " + info.getVsanId()));
                continue;
            }
            _Logger.debug((Object)("looking through " + hosts.size() + " host enclosures"));
            for (EnclosureBase host : hosts) {
                if (host == null) {
                    _Logger.debug((Object)"Skipped null host");
                    continue;
                }
                if (host.getEndPortPKs() == null) {
                    _Logger.debug((Object)("Skipped host: " + host.getEnclosureName() + " null list of endports"));
                    continue;
                }
                _Logger.debug((Object)("found host " + host.getEnclosureName() + " with " + host.getEndPortPKs().size() + " ports"));
                for (int w = 0; w < host.getEndPortPKs().size(); ++w) {
                    EndPortBase port = null;
                    try {
                        port = sanServiceBean.findEndPortBaseByWwn(host.getEndPortPKs().get(w));
                    }
                    catch (RemoteException e) {
                        _Logger.warn((Object)"Failed to get end port from FM model");
                        continue;
                    }
                    if (port == null) continue;
                    if (port.getFabricPK() == null) {
                        _Logger.debug((Object)"end port missing fabric, skipping");
                        continue;
                    }
                    if (port.getFabricPK().getName() == null) {
                        _Logger.debug((Object)"end port missing fabric name, skipping");
                        continue;
                    }
                    if (!info.getFabricName().equals(port.getFabricPK().getName())) {
                        _Logger.debug((Object)("end port " + port.getNodeWwn() + " fabricName different, expected: " + info.getFabricName() + " got: " + port.getFabricPK().getName() + " skipping"));
                    }
                    ZoneMemberInfo zmiCheck = new ZoneMemberInfo();
                    zmiCheck.setWwn(SnmpString.toHexString(host.getEndPortPKs().get((int)w)._wwn.getValue()));
                    if (!membersList.contains(zmiCheck)) {
                        _Logger.debug((Object)("skipping wwn not found in members " + zmiCheck.getWwn()));
                        continue;
                    }
                    if (port.isInternal()) {
                        _Logger.debug((Object)("end port " + port.getNodeWwn() + " is internal, skipping"));
                        continue;
                    }
                    if (!port.isPresent()) {
                        _Logger.debug((Object)("end port " + port.getNodeWwn() + " is not present, skipping"));
                        continue;
                    }
                    short[] portVsans = port.getVsanMembership();
                    if (portVsans == null || portVsans.length == 0) {
                        _Logger.debug((Object)("end port " + port.getNodeWwn() + " has no vsan membership, skipping"));
                        continue;
                    }
                    boolean found = false;
                    for (int i = 0; i < portVsans.length; ++i) {
                        _Logger.debug((Object)("end port " + port.getNodeWwn() + " is member of vsan " + portVsans[i]));
                        if (info.getVsanId() != portVsans[i]) continue;
                        Initiator init = new Initiator();
                        init.setFabricName(port.getFabricPK().getName());
                        init.setWwn(SnmpString.toHexString(host.getEndPortPKs().get((int)w)._wwn.getValue()));
                        init.setHostName(this.getEndPortNameByWwn(ctx, port.getFabricPK(), init.getWwn()));
                        init.setVsanId(portVsans[i]);
                        init.setVsanPK(port.getVsanPK(init.getVsanId()).getVsanPKAsString());
                        init.setIpAddress(host.getIpAddress());
                        init.setVirtual(host.isVirtual());
                        init.setEnclosureName(host.getEnclosureName());
                        if (!initiatorList.contains(init)) {
                            _Logger.debug((Object)("adding end port " + port.getNodeWwn()));
                            initiatorList.add(init);
                            continue;
                        }
                        _Logger.debug((Object)("found match for end port " + port.getNodeWwn() + " but its already in the list"));
                    }
                }
            }
        }
        Collections.sort(initiatorList);
        _Logger.debug((Object)("Returning list of " + initiatorList.size() + " Hosts"));
        return initiatorList;
    }

    @Override
    public ClusterBase createCluster(SMEContext ctx, FabricPK pkey, String clusterId, String name, short state, short masterInetAddrType, String masterInetAddr) throws RemoteException {
        _Logger.debug((Object)("Created cluster in FM model: " + name + " Master Inet Address: " + masterInetAddr));
        ClusterBase cluster = null;
        SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pkey);
        if (sanServiceBean != null) {
            cluster = sanServiceBean.createCluster(pkey, clusterId, name, (short)1, state, masterInetAddrType, masterInetAddr);
        }
        return cluster;
    }

    @Override
    public void deleteCluster(SMEContext ctx, FabricPK pkey, String clusterId, String name) throws RemoteException {
        _Logger.debug((Object)("Deleted cluster in FM model: " + name));
        SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pkey);
        if (sanServiceBean != null) {
            sanServiceBean.deleteCluster(pkey, clusterId, name);
        }
    }

    @Override
    public void setClusterId(SMEContext ctx, WwnKey pkey, int ifIndex, String clusterId, String fabricName) throws RemoteException {
        FabricPK fpk = this.getFabricPK(ctx, fabricName);
        if (fpk != null) {
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fpk);
            if (sanServiceBean != null) {
                _Logger.debug((Object)("Set Cluster " + clusterId + " for " + ifIndex + " on fabric " + fabricName + " switch " + pkey));
                sanServiceBean.setClusterId(pkey, ifIndex, clusterId);
            }
        } else {
            _Logger.debug((Object)("Attempt to set Cluster " + clusterId + " for " + ifIndex + " on fabric " + fabricName + " failed"));
        }
    }

    @Override
    public void clearInterface(SMEContext ctx, String clusterName, FabricInfo fabric) throws RemoteException {
        SMEPortBase[] ports;
        _Logger.debug((Object)"modelMgr.clearInterface - entry");
        _Logger.debug((Object)("clearing interface for cluster " + clusterName + " on fabric " + fabric.getFabricName()));
        FabricPK pk = new FabricPK(Integer.valueOf(fabric.getFabricId()));
        pk.setName(fabric.getFabricName());
        SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pk);
        if (sanServiceBean != null && (ports = sanServiceBean.findSMEInterfaces(pk)) != null) {
            _Logger.debug((Object)("findSMEInterfaces got " + ports.length + "SMEInterfaces"));
            for (int i = 0; i < ports.length; ++i) {
                String portClusterId;
                FcPortBase fcport;
                SMEPortBase smeport = ports[i];
                if (smeport == null || (fcport = smeport.getFcPort()) == null || (portClusterId = fcport.getClusterId()) == null || portClusterId.length() == 0 || portClusterId.compareTo(clusterName) != 0) continue;
                _Logger.debug((Object)("found a match for interface " + fcport.getIfIndex() + ", clearing clusterId"));
                this.setClusterId(ctx, smeport.getSwitchPK(), fcport.getIfIndex(), null, fabric.getFabricName());
            }
        }
    }

    @Override
    public void clearInterface(SMEContext ctx, String clusterName, String nodeName) throws RemoteException {
        _Logger.debug((Object)"modelMgr.clearInterface - entry");
        _Logger.debug((Object)("clearing interface for cluster " + clusterName + " node " + nodeName));
        ArrayList<FabricInfo> modelFabrics = this.getFabricsByCluster(ctx, clusterName);
        if (modelFabrics == null) {
            _Logger.warn((Object)("No fabrics found for cluster  " + clusterName + ". Couldnot remove interfaces for node " + nodeName));
            return;
        }
        for (FabricInfo fInfo : modelFabrics) {
            SMEPortBase[] ports;
            FabricPK pk = new FabricPK(Integer.valueOf(fInfo.getFabricId()));
            pk.setName(fInfo.getFabricName());
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pk);
            if (sanServiceBean == null || (ports = sanServiceBean.findSMEInterfaces(pk)) == null) continue;
            _Logger.debug((Object)("findSMEInterfaces got " + ports.length + " SME interfaces"));
            for (int i = 0; i < ports.length; ++i) {
                String portClusterId;
                FcPortBase fcport;
                SMEPortBase smeport = ports[i];
                String switchName = smeport.getSysName();
                String switchIP = smeport.getIpAddr();
                if (nodeName.compareTo(switchIP) != 0 && nodeName.compareTo(switchName) != 0 || smeport == null || (fcport = smeport.getFcPort()) == null || (portClusterId = fcport.getClusterId()) == null || portClusterId.length() == 0 || portClusterId.compareTo(clusterName) != 0) continue;
                _Logger.debug((Object)("found a match for interface " + fcport.getIfIndex() + ", clearing clusterId"));
                this.setClusterId(ctx, smeport.getSwitchPK(), fcport.getIfIndex(), null, fInfo.getFabricName());
            }
        }
    }

    @Override
    public void clearInterface(SMEContext ctx, String clusterName, String nodeName, int ifIndex) throws RemoteException {
        _Logger.debug((Object)"modelMgr.clearInterface - entry");
        _Logger.debug((Object)("clearing interface for cluster " + clusterName + " node " + nodeName + " ifIndex " + ifIndex));
        ArrayList<FabricInfo> modelFabrics = this.getFabricsByCluster(ctx, clusterName);
        if (modelFabrics == null) {
            _Logger.warn((Object)("No fabrics found for cluster  " + clusterName + ". Couldnot remove interface " + ifIndex));
            return;
        }
        for (FabricInfo fInfo : modelFabrics) {
            FabricPK pk = new FabricPK(Integer.valueOf(fInfo.getFabricId()));
            pk.setName(fInfo.getFabricName());
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, pk);
            if (sanServiceBean == null) continue;
            SwitchBase matchingSwitch = null;
            SwitchBase[] switchList = sanServiceBean.findAllSwitches();
            if (switchList != null) {
                for (int i = 0; i < switchList.length; ++i) {
                    SwitchBase sw = switchList[i];
                    if (sw.getIpAddress() != null && sw.getIpAddress().equals(nodeName)) {
                        matchingSwitch = sw;
                        continue;
                    }
                    if (sw.getName() == null || !sw.getName().equals(nodeName)) continue;
                    matchingSwitch = sw;
                }
            }
            if (matchingSwitch == null) {
                _Logger.debug((Object)("No matching switch " + nodeName + " found in fabric " + fInfo.getFabricName()));
                continue;
            }
            _Logger.debug((Object)("Switch " + nodeName + " found in fabric " + fInfo.getFabricName()));
            SMEPortBase[] ports = sanServiceBean.findSMEInterfaces(pk);
            if (ports == null) continue;
            _Logger.debug((Object)("findSMEInterfaces got " + ports.length + "SMEInterfaces"));
            for (int i = 0; i < ports.length; ++i) {
                String portClusterId;
                FcPortBase fcport;
                SMEPortBase smeport = ports[i];
                if (smeport == null || (fcport = smeport.getFcPort()) == null || (portClusterId = fcport.getClusterId()) == null || portClusterId.length() == 0 || portClusterId.compareTo(clusterName) != 0 || fcport.getIfIndex() != ifIndex || !smeport.getSwitchPK()._wwn.equals(matchingSwitch.getWwn())) continue;
                _Logger.debug((Object)("found a match for interface " + fcport.getIfIndex() + ", clearing clusterId"));
                this.setClusterId(ctx, smeport.getSwitchPK(), fcport.getIfIndex(), null, fInfo.getFabricName());
            }
        }
    }

    private String getSwitchName(SMEContext ctx, FabricPK fabric, Wwn wwn) {
        try {
            SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fabric);
            if (sanServiceBean != null) {
                return sanServiceBean.getSwitchName(wwn);
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return SnmpWWN.toHexString(wwn.getValue());
    }

    @Override
    public FabricInfo getFabricInfo(SMEContext ctx, String fabricName, String clusterName) {
        if (fabricName == null || clusterName == null) {
            return null;
        }
        ArrayList<FabricInfo> fabrics = this.getFabricsByCluster(ctx, clusterName);
        for (FabricInfo f : fabrics) {
            if (!f.getFabricName().equals(fabricName)) continue;
            return f;
        }
        _Logger.debug((Object)("No matching fabric found in model for fabric " + fabricName + " cluster " + clusterName));
        return null;
    }

    @Override
    public ArrayList<EnclosureBase> findHostsForCluster(SMEContext ctx, String clusterName) {
        _Logger.debug((Object)"hostMgr.findHostsForCluster - entry");
        _Logger.debug((Object)("looking for hosts for cluster " + clusterName));
        ArrayList<EnclosureBase> hostEnclosureList = new ArrayList<EnclosureBase>();
        HashSet<EnclosureBase> hostEnclosures = new HashSet<EnclosureBase>();
        ArrayList<FabricInfo> fabrics = this.getFabricsByCluster(ctx, clusterName);
        try {
            if (fabrics == null) {
                _Logger.warn((Object)"sanService.findFabrics - return null");
                return hostEnclosureList;
            }
            _Logger.debug((Object)("Found " + fabrics.size() + " fabrics "));
            for (FabricInfo fInfo : fabrics) {
                if (fInfo == null) continue;
                _Logger.debug((Object)("  fabric" + fInfo.getFabricName()));
                FabricPK fpk = new FabricPK(Integer.valueOf(fInfo.getFabricId()));
                fpk.setName(fInfo.getFabricName());
                SanServiceRif sanServiceBean = this.getSanServiceBean(ctx, fpk);
                if (sanServiceBean == null) continue;
                VsanBase[] vbase = sanServiceBean.findVsans(fpk);
                for (int k = 0; k < vbase.length; ++k) {
                    ArrayList<EnclosureBase> encVsanList = this.findHostEnclosures(ctx, fpk, vbase[k].getVsanPK());
                    for (int p = 0; p < encVsanList.size(); ++p) {
                        hostEnclosures.add(encVsanList.get(p));
                    }
                }
            }
        }
        catch (RemoteException e) {
            _Logger.warn((Object)("Exception findHostsForCluster: " + e.getMessage()));
        }
        Iterator it = hostEnclosures.iterator();
        while (it.hasNext()) {
            hostEnclosureList.add((EnclosureBase)it.next());
        }
        _Logger.debug((Object)("Returning list of " + hostEnclosureList.size() + " Hosts"));
        return hostEnclosureList;
    }

    @Override
    public FabricPK getFabricPK(SMEContext ctx, String fabricName) {
        _Logger.debug((Object)"modelMgr.getFabricsByCluster - entry");
        if (fabricName == null) {
            return null;
        }
        List<FabricPK> fPKs = null;
        _Logger.debug((Object)"Get all fabrics from global view");
        fPKs = GlobalFabricManager.getInstance().getAllFabricPKs();
        if (fPKs == null) {
            _Logger.warn((Object)"GlobalFabricManager.getFabricBases - return null");
            return null;
        }
        for (FabricPK fPK : fPKs) {
            if (fPK == null || fPK.getName().compareTo(fabricName) != 0) continue;
            return fPK;
        }
        _Logger.debug((Object)("No fabric found in model " + fabricName));
        return null;
    }

    private SanServiceRif getSanServiceBean(SMEContext ctx, String ipAddr) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        String port = System.getProperty("server.port", "4447");
        try {
            return (SanServiceRif)EjbRegistry.getInstance().getRemoteService(ipAddr, port, _useSsl, "SanServiceBean", SanServiceRif.class.getName());
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation connecting to " + ipAddr + ":" + port), (Throwable)e);
            return null;
        }
    }
}

