/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.comm.SmeXmlHandler;
import com.cisco.dcbu.sme.common.ClusterBase;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.DiskDetailInfo;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.DiskOperationDisable;
import com.cisco.dcbu.sme.common.DiskOperationEnable;
import com.cisco.dcbu.sme.common.DiskOperationModifyKey;
import com.cisco.dcbu.sme.common.DiskOperationRecover;
import com.cisco.dcbu.sme.common.DiskOperationResume;
import com.cisco.dcbu.sme.common.DiskOperationSuspend;
import com.cisco.dcbu.sme.common.DiskRecoverOptionEnum;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.DiskVPD;
import com.cisco.dcbu.sme.common.KeyInfo;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.RKCFilterInfo;
import com.cisco.dcbu.sme.common.RKCFilterTypeEnum;
import com.cisco.dcbu.sme.common.RKCImport;
import com.cisco.dcbu.sme.common.RKCRelationshipInfo;
import com.cisco.dcbu.sme.common.RKCRelationshipMapInfo;
import com.cisco.dcbu.sme.common.RKCRelationshipStatusEnum;
import com.cisco.dcbu.sme.common.RKCRelationshipTypeEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.mapper.LunStatusMapper;
import com.cisco.dcbu.sme.dkr.xml.DKRRelation;
import com.cisco.dcbu.sme.dkr.xml.DKRRelationTypeEnum;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.DiskGroupMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.ejb.api.RKCMgr;
import com.cisco.dcbu.sme.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.message.RKCMessage;
import com.cisco.dcbu.sme.tree.ClusterTreeNode;
import com.cisco.dcbu.sme.xml.SMEAslGetStatusEnum;
import com.cisco.dcbu.sme.xml.SMEDiskASLGetResp;
import com.cisco.dcbu.sme.xml.SMEDiskAslIDResp;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEResponseStatusEnum;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@Stateless
public class RKCMgrBean
extends MgrHelper
implements Serializable,
RKCMgr {
    private static final long serialVersionUID = 1L;
    static Logger _Logger = Logger.getLogger((String)"DKR");
    protected DiskGroupMgr diskBean;
    HashMap<String, CKMCFacade> ckmcCache = new HashMap();

    @EJB
    public void setModelMgrBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setClusterMgrBean(ClusterMgr clusterBean) {
        this.clusterBean = clusterBean;
    }

    @EJB
    public void setDiskGroupMgrBean(DiskGroupMgr diskBean) {
        this.diskBean = diskBean;
    }

    @Override
    public ArrayList<RKCRelationshipInfo> getRKCRelationshipList(SMEContext ctx, ArrayList<RKCFilterInfo> filterList) {
        _Logger.debug((Object)"--------------------------------------------------");
        _Logger.debug((Object)"getRKCRelationshipList - entry");
        ArrayList<RKCRelationshipInfo> list = new ArrayList<RKCRelationshipInfo>();
        HashMap<String, CKMCFacade> ckmcList = new HashMap<String, CKMCFacade>();
        HashMap<String, CKMCFacade> cluster2ckmcList = new HashMap<String, CKMCFacade>();
        HashMap<String, ClusterInfo> clusterList = new HashMap<String, ClusterInfo>();
        HashMap clusterUseList = new HashMap();
        HashMap rkcMap = new HashMap();
        boolean filterCluster = false;
        if (filterList != null) {
            for (RKCFilterInfo filter : filterList) {
                if (!RKCFilterTypeEnum.Cluster.equals((Object)filter.getType())) continue;
                filterCluster = true;
            }
        }
        _Logger.debug((Object)"getRKCRelationshipList - treenodes");
        ArrayList<ClusterTreeNode> clusterTreeNodes = this.modelBean.getClusterTreeNodes(ctx);
        for (ClusterTreeNode ctn : clusterTreeNodes) {
            String kmcIP;
            CKMCFacade ckmcTest;
            boolean use = false;
            if (ctn == null || ctn.getClusterName() == null) continue;
            if (filterCluster) {
                for (RKCFilterInfo filter : filterList) {
                    if (!RKCFilterTypeEnum.Cluster.equals((Object)filter.getType()) || !ctn.getClusterName().equals(filter.getValue())) continue;
                    use = true;
                }
            } else {
                use = true;
            }
            _Logger.debug((Object)("getRKCRelationshipList - getting clusterInfo for " + ctn.getClusterName()));
            ClusterInfo c1 = this.clusterBean.getClusterInfo(ctx, ctn.getClusterName());
            if (c1 == null || ClusterStatusEnum.Offline.equals((Object)c1.getStatus()) || ClusterStatusEnum.Archived.equals((Object)c1.getStatus()) || ClusterStatusEnum.Deprecated.equals((Object)c1.getStatus())) continue;
            clusterList.put(c1.getClusterName(), c1);
            CKMCFacade ckmcBean = this.getCKMCBean(ctx, c1);
            if (ckmcBean == null) {
                _Logger.debug((Object)("getRKCRelationshipList - there does not appear to be a Key Manager for Cluster " + c1.getClusterName()));
                continue;
            }
            cluster2ckmcList.put(c1.getClusterName(), ckmcBean);
            if (!use || (ckmcTest = (CKMCFacade)ckmcList.get(kmcIP = c1.getPrimaryKeyMgmtServer())) != null) continue;
            ckmcList.put(kmcIP, ckmcBean);
            _Logger.debug((Object)("getRKCRelationshipList - added kmcIP=" + kmcIP + " for object " + ckmcBean.hashCode()));
        }
        for (CKMCFacade ckmcBean : ckmcList.values()) {
            _Logger.debug((Object)("getRKCRelationshipList - adding for ckmc " + ckmcBean.hashCode()));
            list.addAll(ckmcBean.getRKCRelationshipList(filterList));
        }
        _Logger.debug((Object)("getRKCRelationshipList - list contains " + list.size() + " entries"));
        for (RKCRelationshipInfo rel : list) {
            ArrayList<RKCRelationshipInfo> l1 = (ArrayList<RKCRelationshipInfo>)rkcMap.get(rel.getSourceClusterName());
            ArrayList<RKCRelationshipInfo> l2 = (ArrayList<RKCRelationshipInfo>)rkcMap.get(rel.getDestClusterName());
            if (rel.getSourceClusterName().equals(rel.getDestClusterName())) {
                l2 = l1;
            }
            if (l1 == null) {
                l1 = new ArrayList<RKCRelationshipInfo>();
                rkcMap.put(rel.getSourceClusterName(), l1);
            }
            if (l2 == null) {
                l2 = new ArrayList<RKCRelationshipInfo>();
                rkcMap.put(rel.getDestClusterName(), l2);
            }
            l1.add(rel);
            l2.add(rel);
        }
        _Logger.debug((Object)"getRKCRelationshipList - sorted for vpw lookups");
        HashMap<DiskVPD, ArrayList<RKCRelationshipInfo>> vpw2rkcLookup = new HashMap<DiskVPD, ArrayList<RKCRelationshipInfo>>();
        for (String clusterKey : rkcMap.keySet()) {
            _Logger.debug((Object)("getRKCRelationshipList - searching rels for " + clusterKey + " match"));
            ArrayList relList = (ArrayList)rkcMap.get(clusterKey);
            ArrayList<DiskVPD> vpwList = new ArrayList<DiskVPD>();
            for (RKCRelationshipInfo rel : relList) {
                ArrayList<RKCRelationshipInfo> rkcList;
                DiskVPD vpw;
                if (clusterKey.equals(rel.getSourceClusterName())) {
                    vpw = new DiskVPD(rel.getSourceVendor(), rel.getSourceProduct(), rel.getSourceWwn());
                    if (!vpwList.contains(vpw)) {
                        vpwList.add(vpw);
                    }
                    if ((rkcList = (ArrayList<RKCRelationshipInfo>)vpw2rkcLookup.get(vpw)) == null) {
                        rkcList = new ArrayList<RKCRelationshipInfo>();
                        vpw2rkcLookup.put(vpw, rkcList);
                    }
                    rkcList.add(rel);
                }
                if (!clusterKey.equals(rel.getDestClusterName())) continue;
                vpw = new DiskVPD(rel.getDestVendor(), rel.getDestProduct(), rel.getDestWwn());
                if (!vpwList.contains(vpw)) {
                    vpwList.add(vpw);
                }
                if ((rkcList = (ArrayList)vpw2rkcLookup.get(vpw)) == null) {
                    rkcList = new ArrayList();
                    vpw2rkcLookup.put(vpw, rkcList);
                }
                rkcList.add(rel);
            }
            _Logger.debug((Object)("getRKCRelationshipList - vpw lookup for " + clusterKey));
            ArrayList<DiskDetailInfo> resultList = this.diskListLookup(ctx, (ClusterInfo)clusterList.get(clusterKey), vpwList);
            for (DiskDetailInfo di : resultList) {
                for (RKCRelationshipInfo rel : relList) {
                    if (di.getClusterName().equals(rel.getSourceClusterName()) && di.getWwn().equals(rel.getSourceWwn()) && di.getVpd().getVendorId().equals(rel.getSourceVendor())) {
                        rel.setSourceStatus(di.getStatus());
                        rel.setSourceEncrypted(di.isEncryptionEnabled());
                        rel.setSourceGUID(di.getGUID());
                        continue;
                    }
                    if (!di.getClusterName().equals(rel.getDestClusterName()) || !di.getWwn().equals(rel.getDestWwn()) || !di.getVpd().getVendorId().equals(rel.getDestVendor())) continue;
                    rel.setDestStatus(di.getStatus());
                    rel.setDestEncrypted(di.isEncryptionEnabled());
                    rel.setDestGUID(di.getGUID());
                }
            }
            _Logger.debug((Object)("getRKCRelationshipList - vpw lookup done for cluster " + clusterKey));
        }
        _Logger.debug((Object)"getRKCRelationshipList - sync checking");
        for (RKCRelationshipInfo rel : list) {
            boolean syncrequired = false;
            if (!RKCRelationshipStatusEnum.Active.equals((Object)rel.getStatus())) continue;
            if (rel.isSourceCrypto()) {
                if (rel.isDestClear()) {
                    syncrequired = true;
                } else if (rel.isDestCrypto()) {
                    String sourceGuid = rel.getSourceGUID();
                    String destGuid = rel.getDestGUID();
                    syncrequired = true;
                    CKMCFacade c1 = (CKMCFacade)cluster2ckmcList.get(rel.getSourceClusterName());
                    KeyInfo srcKey = c1.getActiveDiskKey(ctx, rel.getSourceClusterName(), rel.getSourceGroupName(), rel.getSourceName());
                    CKMCFacade c2 = (CKMCFacade)cluster2ckmcList.get(rel.getDestClusterName());
                    KeyInfo dstKey = c2.getActiveDiskKey(ctx, rel.getDestClusterName(), rel.getDestGroupName(), rel.getDestName());
                    boolean isError = false;
                    String errString = "";
                    if (srcKey == null) {
                        isError = true;
                        errString = "src key lookup failed ";
                    } else if (dstKey == null) {
                        isError = true;
                        errString = "dst key lookup failed ";
                    } else if (!srcKey.getGuid().equals(sourceGuid)) {
                        isError = true;
                        errString = "src guid check failed";
                    } else if (!dstKey.getGuid().equals(destGuid)) {
                        isError = true;
                        errString = "dst guid check failed";
                    }
                    if (isError) {
                        isError = true;
                        rel.setStatus(RKCRelationshipStatusEnum.Error);
                        rel.setStatus_desc(errString);
                        continue;
                    }
                    if (srcKey.getGuid().equals(dstKey.getGuid())) {
                        syncrequired = false;
                    } else if (srcKey.getGuid().equals(dstKey.getClonedFromGuid())) {
                        syncrequired = false;
                    } else if (srcKey.getClonedFromGuid().equals(dstKey.getGuid())) {
                        syncrequired = false;
                    } else if (!srcKey.getClonedFromGuid().equals("0000000000000000-0000000000000000") && srcKey.getClonedFromGuid().equals(dstKey.getClonedFromGuid())) {
                        syncrequired = false;
                    }
                }
            } else if (rel.isSourceClear() && rel.isDestCrypto()) {
                syncrequired = true;
            }
            rel.setSyncRequired(syncrequired);
        }
        _Logger.debug((Object)"getRKCRelationshipList - chain check");
        for (RKCRelationshipInfo rel : list) {
            RKCRelationshipInfo test;
            int i;
            if (!RKCRelationshipStatusEnum.Active.equals((Object)rel.getStatus())) continue;
            if (DiskStatusEnum.Preparing.equals((Object)rel.getSourceStatus())) {
                DiskDetailInfo sourceDisk = this.diskBean.getDiskDetailInfo(ctx, rel.getSourceClusterName(), rel.getSourceGroupName(), rel.getSourceName());
                rel.setSourceProgress(sourceDisk.getProgress());
            }
            DiskVPD srcvpw = new DiskVPD(rel.getSourceVendor(), rel.getSourceProduct(), rel.getSourceWwn());
            DiskVPD dstvpw = new DiskVPD(rel.getDestVendor(), rel.getDestProduct(), rel.getDestWwn());
            ArrayList rkcSrcList = (ArrayList)vpw2rkcLookup.get(srcvpw);
            ArrayList rkcDstList = (ArrayList)vpw2rkcLookup.get(dstvpw);
            if (rkcSrcList.size() == 1 && rkcDstList.size() == 1) continue;
            if (rkcSrcList.size() > 1) {
                for (i = 0; i < rkcSrcList.size(); ++i) {
                    test = (RKCRelationshipInfo)rkcSrcList.get(i);
                    if (rel.equals(test) || !RKCRelationshipStatusEnum.Active.equals((Object)test.getStatus())) continue;
                    rel.setChained(true);
                }
            }
            if (rkcDstList.size() <= 1) continue;
            for (i = 0; i < rkcDstList.size(); ++i) {
                test = (RKCRelationshipInfo)rkcDstList.get(i);
                if (rel.equals(test) || !RKCRelationshipStatusEnum.Active.equals((Object)test.getStatus())) continue;
                rel.setChained(true);
            }
        }
        _Logger.debug((Object)"getRKCRelationshipList - done");
        return list;
    }

    @Override
    public OperationStatus create(SMEContext ctx, RKCRelationshipInfo relationship) {
        _Logger.setLevel(Level.DEBUG);
        return this.create(ctx, relationship, true);
    }

    @Override
    public ArrayList<OperationStatus> processRKCImport(SMEContext ctx, RKCImport rkcImport) {
        _Logger.info((Object)"--------------------------------------------------");
        _Logger.info((Object)"IMPORT called");
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        String defaultClusterName = ctx.getCluster().getClusterName();
        if (rkcImport == null || rkcImport.getRkc() == null) {
            OperationStatus op = new OperationStatus();
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("DKR Import file appears to be empty or corrupt. Verify its contents.");
            statusList.add(op);
        } else if (rkcImport.getRkc().getRelations() == null || rkcImport.getRkc().getRelations().isEmpty()) {
            OperationStatus op = new OperationStatus();
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("DKR Import file appears to have no DKR Relationships or is corrupt.  Verify its contents.");
            statusList.add(op);
        } else {
            for (DKRRelation rel : rkcImport.getRkc().getRelations()) {
                RKCRelationshipInfo relInfo;
                OperationStatus op = new OperationStatus();
                if (rel.isSetSource() && !rel.getSource().isSetCluster_Name()) {
                    rel.getSource().setCluster_Name(defaultClusterName);
                }
                if (rel.isSetDestination() && !rel.getDestination().isSetCluster_Name() && rel.isSetSource()) {
                    rel.getDestination().setCluster_Name(rel.getSource().getCluster_Name());
                }
                if (RKCRelationshipStatusEnum.Error.equals((Object)(relInfo = this.map(rel)).getStatus())) {
                    op.setStatus(OperationStatusEnum.Failure);
                    op.setDescription(relInfo.getStatus_desc());
                } else {
                    op = this.create(ctx, relInfo, false);
                }
                statusList.add(op);
            }
        }
        return statusList;
    }

    @Override
    public ArrayList<OperationStatus> delete(SMEContext ctx, RKCRelationshipInfo relationship) {
        _Logger.info((Object)"--------------------------------------------------");
        _Logger.info((Object)"DELETE called on relationship:");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        OperationStatus resumeStatus = null;
        CKMCFacade ckmc = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
        if (ckmc == null) {
            OperationStatus op = new OperationStatus();
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName());
            _Logger.error((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
            statusList.add(op);
            return statusList;
        }
        OperationStatus op = ckmc.delete(relationship);
        _Logger.info((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
        statusList.add(op);
        DiskDetailInfo dst = this.destinationDiskLookup(ctx, relationship);
        if (dst != null && DiskStatusEnum.Suspend.equals((Object)dst.getStatus())) {
            OperationStatus status = this.diskBean.modifyDisk(ctx, dst, new DiskOperationResume(), false);
            if (!OperationStatusEnum.Success.equals(status.getStatus())) {
                resumeStatus = new OperationStatus();
                resumeStatus.set(OperationStatusEnum.Failure, "Warning: failed to resume destination disk " + dst.getClusterName() + ":" + dst.getDiskGroupName() + " " + dst.getDiskName() + " (" + relationship.getDestWwn() + ")");
                _Logger.warn((Object)resumeStatus.getDescription());
            } else {
                _Logger.info((Object)("Resumed destination disk " + dst.getClusterName() + ":" + dst.getDiskGroupName() + "" + dst.getDiskName() + " (" + relationship.getDestWwn() + ")"));
            }
        }
        if (resumeStatus != null) {
            statusList.add(resumeStatus);
        }
        return statusList;
    }

    @Override
    public ArrayList<OperationStatus> modify(SMEContext ctx, RKCRelationshipInfo relationship) {
        _Logger.info((Object)"--------------------------------------------------");
        _Logger.info((Object)("MODIFY called on relationship to set state " + relationship.getStatus().name() + ":"));
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        OperationStatus op = new OperationStatus();
        CKMCFacade ckmc = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
        if (ckmc == null) {
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName() + " operation failed.");
            _Logger.error((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
            statusList.add(op);
            return statusList;
        }
        RKCRelationshipInfo fromDb = ckmc.getRKCRelationship(relationship);
        if (fromDb == null) {
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Disk replication relationship " + relationship.srcDestString() + " lookup failed.");
            _Logger.info((Object)"Relationship Lookup failed");
            statusList.add(op);
            return statusList;
        }
        if (fromDb.getStatus().equals((Object)relationship.getStatus())) {
            op.set(OperationStatusEnum.Success, "Disk replication relationship " + relationship.srcDestString() + " updated successfully.");
            _Logger.info((Object)"Relationship already in requested state, returning success");
            statusList.add(op);
            return statusList;
        }
        relationship.setStatus_desc("");
        if (RKCRelationshipStatusEnum.Active.equals((Object)relationship.getStatus())) {
            ArrayList<OperationStatus> enableStatus = this.enable(ctx, ckmc, relationship);
            statusList.addAll(enableStatus);
        } else if (RKCRelationshipStatusEnum.Disabled.equals((Object)relationship.getStatus())) {
            ArrayList<OperationStatus> disableStatus = this.disable(ctx, ckmc, relationship);
            statusList.addAll(disableStatus);
        } else {
            op.set(OperationStatusEnum.Failure, "Relationship update failed, unsupported modification attempt");
            statusList.add(op);
            _Logger.info((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
        }
        return statusList;
    }

    @Override
    public ArrayList<OperationStatus> sync(SMEContext ctx, RKCRelationshipInfo relationship) {
        _Logger.info((Object)"--------------------------------------------------");
        _Logger.info((Object)"SYNC called on relationship:");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        OperationStatus op = new OperationStatus();
        if (!RKCRelationshipStatusEnum.Active.equals((Object)relationship.getStatus())) {
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to Sync relationship: " + relationship.srcDestString() + "unless it is active.");
            _Logger.info((Object)op.getDescription());
            statusList.add(op);
            return statusList;
        }
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
        if (ckmcBean == null) {
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName());
            _Logger.error((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
            statusList.add(op);
            return statusList;
        }
        RKCRelationshipMapInfo rkcMap = ckmcBean.getRKCRelationshipMap(relationship.getDestClusterName(), relationship.getDestVendor(), relationship.getDestProduct(), relationship.getDestWwn());
        _Logger.info((Object)"Suspending dependencies");
        this.suspendChain(ctx, rkcMap, 1);
        OperationStatus syncStatus = this.syncSingle(ctx, relationship);
        _Logger.info((Object)("Sync: " + syncStatus.getStatus().name() + " Description: " + syncStatus.getDescription()));
        statusList.add(syncStatus);
        if (!OperationStatusEnum.Success.equals(syncStatus.getStatus())) {
            return statusList;
        }
        _Logger.info((Object)"Syncing dependencies");
        ArrayList<OperationStatus> syncChain = this.syncChain(ctx, rkcMap, 1);
        statusList.addAll(syncChain);
        return statusList;
    }

    @Override
    public ArrayList<OperationStatus> switchover(SMEContext ctx, RKCRelationshipInfo relationship) {
        _Logger.info((Object)"--------------------------------------------------");
        _Logger.info((Object)"SWITCHOVER called on relationship:");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        OperationStatus op = new OperationStatus();
        if (!RKCRelationshipStatusEnum.Disabled.equals((Object)relationship.getStatus())) {
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to Switchover relationship: " + relationship.srcDestString() + "unless it is disabled.");
            _Logger.info((Object)op.getDescription());
            statusList.add(op);
            return statusList;
        }
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
        if (ckmcBean == null) {
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName());
            _Logger.error((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
            statusList.add(op);
            return statusList;
        }
        op = ckmcBean.switchover(relationship);
        _Logger.info((Object)(op.getStatus() + " " + op.getDescription()));
        statusList.add(op);
        return statusList;
    }

    private OperationStatus create(SMEContext ctx, RKCRelationshipInfo relationship, boolean checkDest) {
        OperationStatus op;
        _Logger.info((Object)"--------------------------------------------------");
        _Logger.info((Object)"CREATE called on relationship:");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        OperationStatus status = relationship.sanityCheckInput();
        if (relationship.getType() == null) {
            relationship.setType(RKCRelationshipTypeEnum.Mirror);
        }
        if (!OperationStatusEnum.Success.equals(status.getStatus())) {
            DiskDetailInfo srcDI = this.diskBean.getDiskDetailInfo(ctx, relationship.getSourceClusterName(), relationship.getSourceGroupName(), relationship.getSourceName());
            if (srcDI == null || srcDI.getVpd() == null) {
                String text = "Failed to create DKR relationship: source disk lookup failed";
                _Logger.error((Object)text);
                status.set(OperationStatusEnum.Failure, text);
                return status;
            }
            DiskDetailInfo dstDI = this.diskBean.getDiskDetailInfo(ctx, relationship.getDestClusterName(), relationship.getDestGroupName(), relationship.getDestName());
            if (checkDest && (dstDI == null || dstDI.getVpd() == null)) {
                String text = "Failed to create DKR relationship: destination disk lookup failed";
                _Logger.error((Object)text);
                status.set(OperationStatusEnum.Failure, text);
                return status;
            }
            relationship.setSourceVendor(srcDI.getVpd().getVendorId());
            relationship.setSourceProduct(srcDI.getVpd().getProductId());
            relationship.setSourceDevice(srcDI.getVpd().getDeviceId());
            relationship.setSourceWwn(srcDI.getWwn());
            relationship.setSourceStatus(srcDI.getStatus());
            if (checkDest || dstDI != null && dstDI.getVpd() != null) {
                relationship.setDestVendor(dstDI.getVpd().getVendorId());
                relationship.setDestProduct(dstDI.getVpd().getProductId());
                relationship.setDestDevice(dstDI.getVpd().getDeviceId());
                relationship.setDestWwn(dstDI.getWwn());
                relationship.setDestStatus(dstDI.getStatus());
            }
        } else {
            DiskDetailInfo src = this.sourceDiskLookup(ctx, relationship);
            if (src == null) {
                status.set(OperationStatusEnum.Failure, "Failed to create DKR relationship: source Disk lookup failed");
                _Logger.info((Object)"source lookup failed");
                return status;
            }
            DiskDetailInfo dst = this.destinationDiskLookup(ctx, relationship);
            if (checkDest && dst == null) {
                status.set(OperationStatusEnum.Failure, "Failed to create DKR relationship: destination Disk lookup failed");
                _Logger.info((Object)"destination lookup failed");
                return status;
            }
            if (src.getClusterName() == null || !src.getClusterName().equals(relationship.getSourceClusterName())) {
                status.set(OperationStatusEnum.Failure, "Failed to create DKR relationship: source Disk has clusterName mismatch!");
                _Logger.info((Object)("source has cluster name mismatch: switch says: " + src.getClusterName() + "  expected:" + relationship.getSourceClusterName()));
                return status;
            }
            if (this.isEmpty(src.getDiskGroupName()) || this.isEmpty(src.getDiskName()) || !this.isEmpty(relationship.getSourceGroupName()) && !src.getDiskGroupName().equals(relationship.getSourceGroupName()) || !this.isEmpty(relationship.getSourceName()) && !src.getDiskName().equals(relationship.getSourceName())) {
                status.set(OperationStatusEnum.Failure, "Failed to create DKR relationship: source Disk Group and Disk names must match if configured.");
                _Logger.info((Object)"source disk not configured");
                return status;
            }
            if (checkDest && (dst.getClusterName() == null || !dst.getClusterName().equals(relationship.getDestClusterName()))) {
                status.set(OperationStatusEnum.Failure, "Failed to create DKR relationship: dest Disk has clusterName mismatch!");
                _Logger.info((Object)("destination has cluster name mismatch: switch says: " + dst.getClusterName() + "  expected:" + relationship.getDestClusterName()));
                return status;
            }
            status = relationship.sanityCheckPopulate(src, dst);
            if (!OperationStatusEnum.Success.equals(status.getStatus())) {
                String text = "Failed to create DKR relationship " + status.getDescription();
                _Logger.error((Object)text);
                status.setDescription(text);
                return status;
            }
        }
        _Logger.info((Object)"Post verification / lookup relationship now looks like: ");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        CKMCFacade ckmc = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
        if (ckmc == null) {
            op = new OperationStatus();
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName());
            _Logger.error((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
            return op;
        }
        relationship.setStatus(RKCRelationshipStatusEnum.Disabled);
        op = ckmc.create(relationship);
        _Logger.info((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
        return op;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private OperationStatus syncSingle(SMEContext ctx, RKCRelationshipInfo relationship) {
        DiskOperationResume resumeOper;
        OperationStatus resumeStatus;
        DiskDetailInfo dst;
        OperationStatus status;
        SMEContext ctxmod;
        block42: {
            KeyInfo srcKey;
            CKMCFacade ckmcBean;
            DiskDetailInfo src;
            block43: {
                block45: {
                    block44: {
                        String text;
                        _Logger.info((Object)"sync called on relationship");
                        _Logger.info((Object)relationship.sourceToString());
                        _Logger.info((Object)relationship.destinationToString());
                        ctxmod = ctx;
                        if (!ctx.getCluster().getClusterName().equals(relationship.getDestClusterName())) {
                            ClusterInfo destCluster = this.modelBean.getClusterInfo(ctx, relationship.getDestClusterName());
                            ctxmod = new SMEContext();
                            ctxmod.setUserName(ctx.getUserName());
                            ctxmod.setPassword(ctx.getPassword());
                            ctxmod.setSessionId(ctx.getSessionId());
                            ClusterBase cb = new ClusterBase();
                            cb.setClusterName(relationship.getDestClusterName());
                            cb.setMasterIPAddr(destCluster.getMasterIPAddr());
                            ctxmod.setCluster(cb);
                        }
                        if (!OperationStatusEnum.Success.equals((status = relationship.sanityCheckInput()).getStatus())) {
                            text = "Failed to sync DKR relationship: " + relationship.srcDestString() + "due to:" + status.getDescription();
                            _Logger.error((Object)text);
                            status.setDescription(text);
                            return status;
                        }
                        if (RKCRelationshipStatusEnum.Disabled.equals((Object)relationship.getStatus())) {
                            text = "Failed to sync DKR relationship: " + relationship.srcDestString() + " it is disabled.";
                            _Logger.error((Object)text);
                            status.set(OperationStatusEnum.Failure, text);
                            return status;
                        }
                        src = this.sourceDiskLookup(ctx, relationship);
                        if (src == null) {
                            status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "source Disk lookup failed");
                            _Logger.info((Object)"Source Lookup failed");
                            return status;
                        }
                        dst = this.destinationDiskLookup(ctxmod, relationship);
                        if (dst == null) {
                            status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + " destination Disk lookup failed");
                            _Logger.info((Object)"Destination Lookup failed");
                            return status;
                        }
                        if (DiskStatusEnum.Failure.equals((Object)src.getStatus())) {
                            if (!DiskStatusEnum.Suspend.equals((Object)dst.getStatus())) {
                                this.diskBean.modifyDisk(ctxmod, dst, new DiskOperationSuspend(), false);
                            }
                            status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "source Disk in failed state");
                            _Logger.info((Object)status.getDescription());
                            return status;
                        }
                        if (!src.isClear()) break block43;
                        if (!dst.isClear()) break block44;
                        status.set(OperationStatusEnum.Success, "Sync DKR relationship: " + relationship.srcDestString() + "complete (already in same state)");
                        break block42;
                    }
                    if (!dst.isCrypto()) break block45;
                    DiskOperationDisable diskOper = new DiskOperationDisable();
                    diskOper.setDkrSync(true);
                    OperationStatus diskChange = this.diskBean.modifyDisk(ctxmod, dst, diskOper, false);
                    if (!OperationStatusEnum.Success.equals(diskChange.getStatus())) {
                        status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + " destination Disk modification failed.");
                        _Logger.info((Object)status.getDescription());
                        return status;
                    }
                    status.set(OperationStatusEnum.Success, "Destination Disk syncronized in relationship:" + relationship.srcDestString());
                    break block42;
                }
                if (DiskStatusEnum.Failure.equals((Object)dst.getStatus())) {
                    DiskOperationRecover diskRecover = new DiskOperationRecover();
                    diskRecover.setDkrSync(true);
                    diskRecover.setOption(DiskRecoverOptionEnum.Clear);
                    OperationStatus recoverDiskStatus = this.diskBean.modifyDisk(ctxmod, dst, diskRecover, false);
                    if (recoverDiskStatus != null) {
                        if (!OperationStatusEnum.Success.equals(recoverDiskStatus.getStatus())) {
                            status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "destination Disk modification failed.");
                            _Logger.info((Object)status.getDescription());
                            return status;
                        }
                        status.set(OperationStatusEnum.Success, "Sync DKR relationship: " + relationship.srcDestString() + "complete");
                    }
                    break block42;
                } else {
                    relationship.setStatus(RKCRelationshipStatusEnum.Disabled);
                    CKMCFacade ckmcBean2 = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
                    OperationStatus disableRel = ckmcBean2.modify(relationship);
                    if (OperationStatusEnum.Success.equals(disableRel.getStatus())) {
                        status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "destination Disk in non stable state, disabled relationship.");
                    } else {
                        status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "destination Disk in non stable state, failed to disable relationship.");
                    }
                    _Logger.info((Object)status.getDescription());
                    return status;
                }
            }
            if (!src.isCrypto()) {
                status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "due to: source Disk in non stable state");
                _Logger.info((Object)status.getDescription());
                return status;
            }
            if (dst.isClear()) {
                ckmcBean = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
                srcKey = ckmcBean.getActiveDiskKey(ctx, relationship.getSourceClusterName(), src.getDiskGroupName(), src.getDiskName());
                if (srcKey == null) {
                    status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed, source key lookup failed");
                    _Logger.info((Object)status.getDescription());
                    return status;
                }
                KeyInfo imported = ckmcBean.replicateDiskKey(ctx, srcKey, dst);
                if (imported == null) {
                    status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed due to unknown key sync error");
                    _Logger.info((Object)status.getDescription());
                    return status;
                }
                DiskOperationEnable diskOper = new DiskOperationEnable();
                diskOper.setGUID(imported.getGuid());
                diskOper.setUseExistingKey(true);
                diskOper.setDkrSync(true);
                OperationStatus diskChange = this.diskBean.modifyDisk(ctxmod, dst, diskOper, false);
                ckmcBean.purgeDiskKey(ctx, imported.getClusterName(), dst.getDiskGroupName(), dst.getDiskName(), imported.getGuid());
                if (!OperationStatusEnum.Success.equals(diskChange.getStatus())) {
                    status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + " failed, key sync error: " + diskChange.getDescription());
                    _Logger.info((Object)status.getDescription());
                    return status;
                }
                status.set(OperationStatusEnum.Success, "Sync DKR relationship: " + relationship.srcDestString() + "complete");
            } else if (dst.isCrypto()) {
                ckmcBean = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
                srcKey = ckmcBean.getActiveDiskKey(ctx, relationship.getSourceClusterName(), src.getDiskGroupName(), src.getDiskName());
                KeyInfo dstKey = ckmcBean.getActiveDiskKey(ctxmod, relationship.getDestClusterName(), dst.getDiskGroupName(), dst.getDiskName());
                boolean error = false;
                String errString = "";
                if (srcKey == null) {
                    error = true;
                    errString = "Source key lookup failed";
                }
                if (dstKey == null) {
                    errString = "Destination key lookup failed";
                    error = true;
                }
                if (error) {
                    relationship.setStatus(RKCRelationshipStatusEnum.Disabled);
                    OperationStatus disableRel = ckmcBean.modify(relationship);
                    if (OperationStatusEnum.Success.equals(disableRel.getStatus())) {
                        status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed, key sync error: " + errString + ", disabled relationship");
                    } else {
                        status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed, key sync error: " + errString + ", failed to disable relationship");
                    }
                    _Logger.info((Object)status.getDescription());
                    return status;
                }
                if (srcKey.getGuid().equals(dstKey.getClonedFromGuid()) || !srcKey.getClonedFromGuid().equals("0000000000000000-0000000000000000") && srcKey.getClonedFromGuid().equals(dstKey.getClonedFromGuid()) || srcKey.getClonedFromGuid().equals(dstKey.getGuid())) {
                    status.set(OperationStatusEnum.Success, "Sync DKR relationship: " + relationship.srcDestString() + "complete GUID check indicates they are already in sync");
                    _Logger.info((Object)status.getDescription());
                } else {
                    KeyInfo imported;
                    if (DiskStatusEnum.Crypto.equals((Object)dst.getStatus())) {
                        DiskOperationSuspend suspendOper = new DiskOperationSuspend();
                        OperationStatus suspendStatus = this.diskBean.modifyDisk(ctxmod, dst, suspendOper, false);
                        if (!OperationStatusEnum.Success.equals(suspendStatus.getStatus())) {
                            status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed, couldn't suspend destination disk for sync");
                            _Logger.info((Object)status.getDescription());
                            return status;
                        }
                        dst.setStatus(DiskStatusEnum.Suspend);
                    }
                    if ((imported = ckmcBean.replicateDiskKey(ctx, srcKey, dst)) == null) {
                        status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed due to unknown key sync error");
                        _Logger.info((Object)status.getDescription());
                        return status;
                    }
                    DiskOperationModifyKey diskOper = new DiskOperationModifyKey();
                    diskOper.setGUID(imported.getGuid());
                    diskOper.setDkrSync(true);
                    diskOper.setUseExistingKey(true);
                    OperationStatus diskChange = this.diskBean.modifyDisk(ctxmod, dst, diskOper, false);
                    ckmcBean.purgeDiskKey(ctx, imported.getClusterName(), dst.getDiskGroupName(), dst.getDiskName(), imported.getGuid());
                    if (!OperationStatusEnum.Success.equals(diskChange.getStatus())) {
                        status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed, key sync error: " + diskChange.getDescription());
                        _Logger.info((Object)status.getDescription());
                        return status;
                    }
                    status.set(OperationStatusEnum.Success, "Sync DKR relationship: " + relationship.srcDestString() + "complete");
                }
            } else if (DiskStatusEnum.Failure.equals((Object)dst.getStatus())) {
                ckmcBean = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
                srcKey = ckmcBean.getActiveDiskKey(ctx, relationship.getSourceClusterName(), src.getDiskGroupName(), src.getDiskName());
                DiskOperationRecover diskRecover = new DiskOperationRecover();
                diskRecover.setGUID(srcKey.getGuid());
                diskRecover.setOption(DiskRecoverOptionEnum.Crypto);
                diskRecover.setDkrSync(true);
                KeyInfo imported = null;
                imported = ckmcBean.replicateDiskKey(ctx, srcKey, dst);
                if (imported == null) {
                    status.set(OperationStatusEnum.Failure, "Sync DKR relationship: " + relationship.srcDestString() + "failed due to unknown key sync error");
                    _Logger.info((Object)status.getDescription());
                    return status;
                }
                diskRecover.setGUID(imported.getGuid());
                OperationStatus recoverDiskStatus = this.diskBean.modifyDisk(ctxmod, dst, diskRecover, false);
                if (imported != null) {
                    ckmcBean.purgeDiskKey(ctxmod, imported.getClusterName(), dst.getDiskGroupName(), dst.getDiskName(), imported.getGuid());
                }
                if (recoverDiskStatus != null) {
                    if (!OperationStatusEnum.Success.equals(recoverDiskStatus.getStatus())) {
                        status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "due to: destination Disk modification failed.");
                        _Logger.info((Object)status.getDescription());
                        return status;
                    }
                    status.set(OperationStatusEnum.Success, "Destination Disk syncronized in relationship: " + relationship.srcDestString());
                }
            } else {
                relationship.setStatus(RKCRelationshipStatusEnum.Disabled);
                CKMCFacade ckmcBean3 = this.getCKMCBean(ctx, relationship.getSourceClusterName(), relationship.getDestClusterName());
                OperationStatus disableRel = ckmcBean3.modify(relationship);
                if (OperationStatusEnum.Success.equals(disableRel.getStatus())) {
                    status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "due to: destination Disk in non stable state, disabled relationship.");
                } else {
                    status.set(OperationStatusEnum.Failure, "Failed to sync DKR relationship: " + relationship.srcDestString() + "due to: destination Disk in non stable state, failed to disable relationship.");
                }
                _Logger.info((Object)status.getDescription());
                return status;
            }
        }
        _Logger.info((Object)("Sync Completed " + status.getDescription()));
        if (DiskStatusEnum.Suspend.equals((Object)dst.getStatus()) && !OperationStatusEnum.Success.equals((resumeStatus = this.diskBean.modifyDisk(ctxmod, dst, resumeOper = new DiskOperationResume(), false)).getStatus())) {
            _Logger.warn((Object)("Sync DKR relationship complete, failed to resume the destination disk " + dst.getDiskGroupName() + " " + dst.getDiskName() + " reason: " + resumeStatus.getDescription()));
            status.setDescription("Sync DKR relationship: " + relationship.srcDestString() + "complete, WARNING: failed to resume destination disk");
        }
        return status;
    }

    private DiskDetailInfo diskLookup(SMEContext ctx, String clusterName, String vendor, String product, String wwn) {
        SMEMessage smeMessage;
        _Logger.debug((Object)"--------------------------------------------------");
        _Logger.debug((Object)("ASL Token Lookup - entry for: " + clusterName + "-" + vendor + "-" + product + "-" + wwn));
        RKCMessage rkcMessage = new RKCMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        DiskVPD vpw = new DiskVPD(vendor, product, wwn);
        ArrayList<DiskVPD> vpwList = new ArrayList<DiskVPD>();
        vpwList.add(vpw);
        String msgOut = rkcMessage.prepareASLDiskListGetReq(clusterName, vpwList, SMEOperationEnum.SME___OP___GET);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.debug((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null && (smeMessage = rkcMessage.parseSMERKCResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.debug((Object)"DiskLookup failed.");
                return null;
            }
            SMEDiskASLGetResp respList = smeMessage.getTable_Data().getDisk_Get_ASL_ID_List_Resp();
            if (respList == null || !respList.isSetASL()) {
                return null;
            }
            SMEDiskAslIDResp id = (SMEDiskAslIDResp)respList.getASL().get(0);
            if (id != null) {
                if (!SMEAslGetStatusEnum.SME___ASL___GET___STATUS___SUCCESS.equals((Object)id.getError_Status())) {
                    return null;
                }
                DiskDetailInfo di = this.map(id);
                _Logger.debug((Object)("ASL Token Lookup - found GUID:" + di.getGUID() + " status:" + di.getStatusString() + " " + di.getDiskGroupName() + ":" + di.getDiskName()));
                return di;
            }
        }
        _Logger.debug((Object)"DiskLookup failed. empty response message.");
        return null;
    }

    private ArrayList<OperationStatus> enable(SMEContext ctx, CKMCFacade ckmcBean, RKCRelationshipInfo relationship) {
        _Logger.info((Object)"enable called on relationship");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        ClusterInfo c1 = this.clusterBean.getClusterInfo(ctx, relationship.getSourceClusterName());
        ClusterInfo c2 = this.clusterBean.getClusterInfo(ctx, relationship.getDestClusterName());
        if (c1 == null || c2 == null) {
            OperationStatus clusterStat = new OperationStatus();
            clusterStat.set(OperationStatusEnum.Failure, "Unable to look up cluster status.");
            statusList.add(clusterStat);
            return statusList;
        }
        if (!c1.getType().equals((Object)c2.getType())) {
            OperationStatus clusterStat = new OperationStatus();
            clusterStat.set(OperationStatusEnum.Failure, "Cluster types incompatible.  See configuration guide for more information.");
            statusList.add(clusterStat);
            return statusList;
        }
        OperationStatus enableStatus = this.enableNoSync(ctx, ckmcBean, relationship);
        statusList.add(enableStatus);
        if (OperationStatusEnum.Success.equals(enableStatus.getStatus())) {
            OperationStatus stat;
            DiskInfo di = this.diskBean.getDisk(ctx, relationship.getDestClusterName(), relationship.getDestGroupName(), relationship.getDestName());
            if (!(di.getStatus().equals((Object)DiskStatusEnum.Failure) || di.getStatus().equals((Object)DiskStatusEnum.Suspend) || OperationStatusEnum.Success.equals((stat = this.diskBean.modifyDisk(ctx, di, new DiskOperationSuspend(), false)).getStatus()))) {
                _Logger.info((Object)("Warning: There was a problem suspending disk for " + relationship.getDestClusterName() + " " + relationship.getDestGroupName() + " " + relationship.getDestName()));
                statusList.add(stat);
            }
            RKCRelationshipMapInfo rkcMap = ckmcBean.getRKCRelationshipMap(relationship.getDestClusterName(), relationship.getDestVendor(), relationship.getDestProduct(), relationship.getDestWwn());
            _Logger.info((Object)"Suspending dependencies");
            this.suspendChain(ctx, rkcMap, 1);
            ArrayList<OperationStatus> syncStatus = this.sync(ctx, relationship);
            statusList.addAll(syncStatus);
        }
        return statusList;
    }

    private void suspendChain(SMEContext ctx, RKCRelationshipMapInfo rkcMap, int level) {
        _Logger.info((Object)("suspend chain called at level " + level));
        if (level > 4) {
            _Logger.info((Object)"suspend chain depth exceeded, bailing");
            return;
        }
        HashMap<String, CKMCFacade> cluster2ckmcList = new HashMap<String, CKMCFacade>();
        for (RKCRelationshipInfo rel : rkcMap.getSourceList()) {
            CKMCFacade ckmcBean;
            OperationStatus stat;
            if (!RKCRelationshipStatusEnum.Active.equals((Object)rel.getStatus())) continue;
            DiskInfo di = this.diskBean.getDisk(ctx, rel.getDestClusterName(), rel.getDestGroupName(), rel.getDestName());
            if (!(di.getStatus().equals((Object)DiskStatusEnum.Failure) || di.getStatus().equals((Object)DiskStatusEnum.Suspend) || OperationStatusEnum.Success.equals((stat = this.diskBean.modifyDisk(ctx, di, new DiskOperationSuspend(), false)).getStatus()))) {
                _Logger.info((Object)("Warning: There was a problem suspending disk for " + rel.getDestClusterName() + " " + rel.getDestGroupName() + " " + rel.getDestName()));
            }
            if ((ckmcBean = (CKMCFacade)cluster2ckmcList.get(rel.getDestClusterName())) == null) {
                ckmcBean = this.getCKMCBean(ctx, rel.getDestClusterName());
                cluster2ckmcList.put(rel.getDestClusterName(), ckmcBean);
            }
            RKCRelationshipMapInfo recurseMap = ckmcBean.getRKCRelationshipMap(rel.getDestClusterName(), rel.getDestVendor(), rel.getDestProduct(), rel.getDestWwn());
            if (!rkcMap.isActiveSource()) continue;
            this.suspendChain(ctx, recurseMap, ++level);
        }
    }

    private ArrayList<OperationStatus> syncChain(SMEContext ctx, RKCRelationshipMapInfo rkcMap, int level) {
        OperationStatus syncDone = new OperationStatus();
        syncDone.set(OperationStatusEnum.Success, "Recursive Sync completed");
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        _Logger.info((Object)("sync chain called at level " + level));
        if (level > 4) {
            syncDone.set(OperationStatusEnum.Success, "Recursive Sync exceeded depth, exited");
            _Logger.info((Object)"sync chain depth exceeded, bailing");
            statusList.add(syncDone);
            return statusList;
        }
        HashMap<String, CKMCFacade> cluster2ckmcList = new HashMap<String, CKMCFacade>();
        for (RKCRelationshipInfo rel : rkcMap.getSourceList()) {
            if (!RKCRelationshipStatusEnum.Active.equals((Object)rel.getStatus())) continue;
            syncDone = this.syncSingle(ctx, rel);
            statusList.add(syncDone);
            if (!OperationStatusEnum.Success.equals(syncDone.getStatus())) {
                _Logger.info((Object)("Warning: There was a problem syncing rel for destination disk " + rel.getDestClusterName() + " " + rel.getDestGroupName() + " " + rel.getDestName()));
                continue;
            }
            CKMCFacade ckmcBean = (CKMCFacade)cluster2ckmcList.get(rel.getDestClusterName());
            if (ckmcBean == null) {
                ckmcBean = this.getCKMCBean(ctx, rel.getDestClusterName());
                cluster2ckmcList.put(rel.getDestClusterName(), ckmcBean);
            }
            RKCRelationshipMapInfo recurseMap = ckmcBean.getRKCRelationshipMap(rel.getDestClusterName(), rel.getDestVendor(), rel.getDestProduct(), rel.getDestWwn());
            if (!rkcMap.isActiveSource()) continue;
            ArrayList<OperationStatus> subStatusList = this.syncChain(ctx, recurseMap, ++level);
            statusList.addAll(subStatusList);
        }
        return statusList;
    }

    private OperationStatus enableNoSync(SMEContext ctx, CKMCFacade ckmc, RKCRelationshipInfo relationship) {
        OperationStatus status = new OperationStatus();
        status.set(OperationStatusEnum.Success, "");
        DiskDetailInfo src = this.sourceDiskLookup(ctx, relationship);
        if (src == null) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "due to: source Disk lookup failed");
            return status;
        }
        if (!(DiskStatusEnum.Clear.equals((Object)src.getStatus()) || DiskStatusEnum.Crypto.equals((Object)src.getStatus()) || DiskStatusEnum.Failure.equals((Object)src.getStatus()))) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "due to: source Disk in non stable state");
            return status;
        }
        DiskDetailInfo dst = this.destinationDiskLookup(ctx, relationship);
        if (dst == null) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "due to: destination Disk lookup failed");
            return status;
        }
        if (!(DiskStatusEnum.Clear.equals((Object)dst.getStatus()) || DiskStatusEnum.Crypto.equals((Object)dst.getStatus()) || DiskStatusEnum.Failure.equals((Object)dst.getStatus()))) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "due to: destination Disk in non stable state");
            return status;
        }
        if (src.getClusterName() == null || !src.getClusterName().equals(relationship.getSourceClusterName())) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "source Disk has clusterName mismatch!");
            return status;
        }
        if (this.isEmpty(src.getDiskGroupName()) || this.isEmpty(src.getDiskName()) || !this.isEmpty(relationship.getSourceGroupName()) && !src.getDiskGroupName().equals(relationship.getSourceGroupName()) || !this.isEmpty(relationship.getSourceName()) && !src.getDiskName().equals(relationship.getSourceName())) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "source Disk must be configured");
            return status;
        }
        if (dst.getClusterName() == null || !dst.getClusterName().equals(relationship.getDestClusterName())) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "source Disk has clusterName mismatch!");
            return status;
        }
        if (this.isEmpty(dst.getDiskGroupName()) || this.isEmpty(dst.getDiskName()) || !this.isEmpty(relationship.getDestGroupName()) && !dst.getDiskGroupName().equals(relationship.getDestGroupName()) || !this.isEmpty(relationship.getDestName()) && !dst.getDiskName().equals(relationship.getDestName())) {
            status.set(OperationStatusEnum.Failure, "Failed to enable DKR relationship: " + relationship.srcDestString() + "destination Disk must be configured");
            return status;
        }
        _Logger.info((Object)"Setting relationship active:");
        _Logger.info((Object)relationship.sourceToString());
        _Logger.info((Object)relationship.destinationToString());
        relationship.setStatus(RKCRelationshipStatusEnum.Active);
        if (ckmc == null) {
            OperationStatus op = new OperationStatus();
            op.setStatus(OperationStatusEnum.Failure);
            op.setDescription("Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName());
            _Logger.error((Object)("Returning: " + op.getStatus().name() + " Description: " + op.getDescription()));
            return op;
        }
        return ckmc.modify(relationship);
    }

    private ArrayList<OperationStatus> disable(SMEContext ctx, CKMCFacade ckmc, RKCRelationshipInfo relationship) {
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        OperationStatus disableStatus = new OperationStatus();
        disableStatus.set(OperationStatusEnum.Failure, "Error disabling disk replication relationship " + relationship.srcDestString());
        OperationStatus resumeStatus = null;
        DiskDetailInfo dst = this.destinationDiskLookup(ctx, relationship);
        if (dst != null && DiskStatusEnum.Suspend.equals((Object)dst.getStatus())) {
            OperationStatus status = this.diskBean.modifyDisk(ctx, dst, new DiskOperationResume(), false);
            if (!OperationStatusEnum.Success.equals(status.getStatus())) {
                resumeStatus = new OperationStatus();
                resumeStatus.set(OperationStatusEnum.Failure, "Warning: failed to resume destination disk " + dst.getClusterName() + ":" + dst.getDiskGroupName() + " " + dst.getDiskName() + " (" + relationship.getDestWwn() + ")");
                _Logger.warn((Object)resumeStatus.getDescription());
            } else {
                _Logger.info((Object)("Resumed destination disk " + dst.getClusterName() + ":" + dst.getDiskGroupName() + "" + dst.getDiskName() + " (" + relationship.getDestWwn() + ")"));
            }
        }
        relationship.setStatus(RKCRelationshipStatusEnum.Disabled);
        if (ckmc == null) {
            disableStatus.set(OperationStatusEnum.Failure, "Unable to associate with KMC for DKR relationship between " + relationship.getSourceClusterName() + " & " + relationship.getDestClusterName());
            _Logger.error((Object)("Returning: " + disableStatus.getStatus().name() + " Description: " + disableStatus.getDescription()));
        } else {
            disableStatus = ckmc.modify(relationship);
            _Logger.info((Object)("Returning: " + disableStatus.getStatus().name() + " Description: " + disableStatus.getDescription()));
        }
        statusList.add(disableStatus);
        if (resumeStatus != null) {
            statusList.add(resumeStatus);
        }
        return statusList;
    }

    private CKMCFacade getCKMCBean(SMEContext ctx, String cluster1, String cluster2) {
        CKMCFacade ckmcBean = null;
        CKMCFacade check1 = this.ckmcCache.get(cluster1);
        CKMCFacade check2 = this.ckmcCache.get(cluster2);
        if (check1 != null && check2 != null) {
            if (check1.equals(check2)) {
                return check1;
            }
            boolean connected = false;
            if (check1.isClusterConnected(cluster2)) {
                _Logger.info((Object)"check1 c1 and c2 connected");
                connected = true;
            }
            if (check2.isClusterConnected(cluster1)) {
                _Logger.info((Object)"check2 c1 and c2 connected");
                connected = true;
            }
            if (connected) {
                return check1;
            }
        }
        ClusterInfo c1 = null;
        ClusterInfo c2 = null;
        c1 = this.clusterBean.getClusterInfo(ctx, cluster1);
        if (c1 == null || c1.getPrimaryKeyMgmtServer() == null) {
            return null;
        }
        if (check1 == null) {
            ckmcBean = this.getCKMCBean(ctx, c1);
            if (ckmcBean == null) {
                return null;
            }
            this.ckmcCache.put(cluster1, ckmcBean);
            check1 = ckmcBean;
        }
        if ((c2 = this.clusterBean.getClusterInfo(ctx, cluster2)) == null || c2.getPrimaryKeyMgmtServer() == null) {
            return null;
        }
        if (c1.getPrimaryKeyMgmtServer().equals(c2.getPrimaryKeyMgmtServer())) {
            if (check2 == null) {
                this.ckmcCache.put(cluster2, check1);
            }
            return check1;
        }
        return null;
    }

    private DiskDetailInfo sourceDiskLookup(SMEContext ctx, RKCRelationshipInfo relationship) {
        DiskDetailInfo src = new DiskDetailInfo();
        src = this.diskLookup(ctx, relationship.getSourceClusterName(), relationship.getSourceVendor(), relationship.getSourceProduct(), relationship.getSourceWwn());
        return src;
    }

    private DiskDetailInfo destinationDiskLookup(SMEContext ctx, RKCRelationshipInfo relationship) {
        DiskDetailInfo dst = new DiskDetailInfo();
        dst = this.diskLookup(ctx, relationship.getDestClusterName(), relationship.getDestVendor(), relationship.getDestProduct(), relationship.getDestWwn());
        return dst;
    }

    private ArrayList<DiskDetailInfo> diskListLookup(SMEContext ctx, ClusterInfo clusterInfo, ArrayList<DiskVPD> vpwList) {
        ArrayList<DiskDetailInfo> diskInfoList = new ArrayList<DiskDetailInfo>();
        if (vpwList.isEmpty()) {
            return diskInfoList;
        }
        if (clusterInfo == null) {
            return diskInfoList;
        }
        RKCMessage rkcMessage = new RKCMessage();
        String masterSwitchIP = clusterInfo.getMasterIPAddr();
        String clusterName = clusterInfo.getClusterName();
        _Logger.debug((Object)"--------------------------------------------------");
        _Logger.debug((Object)("ASL Token Lookup - entry for cluster " + clusterName));
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        int fromIndex = 0;
        int toIndex = 0;
        int maxNumLookup = 60;
        do {
            SMEMessage smeMessage;
            fromIndex = toIndex;
            toIndex = vpwList.size();
            if (toIndex - fromIndex > maxNumLookup) {
                toIndex = fromIndex + maxNumLookup;
            }
            List<DiskVPD> subList = vpwList.subList(fromIndex, toIndex);
            String msgOut = rkcMessage.prepareASLDiskListGetReq(clusterName, subList, SMEOperationEnum.SME___OP___GET);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                break;
            }
            if (msgIn == null || !(smeMessage = rkcMessage.parseSMERKCResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)("Multiple Disk ASL Lookup failed for " + clusterName));
                return diskInfoList;
            }
            SMEDiskASLGetResp respList = smeMessage.getTable_Data().getDisk_Get_ASL_ID_List_Resp();
            if (respList == null || !respList.isSetASL()) {
                return diskInfoList;
            }
            for (SMEDiskAslIDResp id : respList.getASL()) {
                if (id == null) continue;
                DiskDetailInfo di = this.map(id);
                diskInfoList.add(di);
                _Logger.debug((Object)("ASL Token Lookup - found GUID:" + di.getGUID() + " status:" + di.getStatusString() + " " + di.getDiskGroupName() + ":" + di.getDiskName()));
            }
        } while (toIndex < vpwList.size());
        _Logger.debug((Object)("ASL Token Lookup - returning " + diskInfoList.size() + " results."));
        return diskInfoList;
    }

    private DiskDetailInfo map(SMEDiskAslIDResp id) {
        DiskDetailInfo di = new DiskDetailInfo();
        di.setClusterName(id.getDisk_Index().getCluster_Name());
        di.setWwn(id.getDisk_Device_ID());
        DiskVPD vpd = new DiskVPD(id.getDisk_Index().getDisk_VPD().getVendor_ID(), id.getDisk_Index().getDisk_VPD().getProduct_ID(), id.getDisk_Index().getDisk_VPD().getDevice_ID());
        di.setVpd(vpd);
        if (!SMEAslGetStatusEnum.SME___ASL___GET___STATUS___SUCCESS.equals((Object)id.getError_Status())) {
            di.setStatus(DiskStatusEnum.None);
            return di;
        }
        di.setStatus(LunStatusMapper.convertStatusToDisk(id.getStatus()));
        di.setDiskName(id.getDisk_Index().getDisk_Name());
        di.setDiskGroupName(id.getDisk_Index().getDisk_Group_Name());
        di.setGUID(id.getGUID());
        di.setEncryptionEnabled(id.isEncryption_Enabled());
        return di;
    }

    private void validateString(String in, String label, int maxlen, RKCRelationshipInfo rel) {
        if (in != null && in.length() > 0) {
            if (!in.matches("^[a-zA-Z_0-9-]*$")) {
                rel.setStatus(RKCRelationshipStatusEnum.Error);
                rel.setStatus_desc("DKR relationship " + label + " contains invalid characters.");
            } else if (in.length() > maxlen) {
                rel.setStatus(RKCRelationshipStatusEnum.Error);
                rel.setStatus_desc("DKR relationship " + label + " exceeds the " + maxlen + " character limit.");
            }
        }
    }

    private RKCRelationshipInfo map(DKRRelation rel) {
        RKCRelationshipInfo relInfo = new RKCRelationshipInfo();
        if (rel == null) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship corrupt or empty");
        } else if (rel.getSource() == null || rel.getSource().getIdentifier() == null) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship source corrupt or empty");
        } else if (rel.getDestination() == null || rel.getDestination().getIdentifier() == null) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship destination corrupt or empty");
        } else if (rel.getSource().getIdentifier() == null || rel.getSource().getIdentifier().getVPW() == null || rel.getSource().getIdentifier().getVPW().getVendor() == null || rel.getSource().getIdentifier().getVPW().getProduct() == null || rel.getSource().getIdentifier().getVPW().getWWN() == null) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship source identifiers corrupt or empty");
        } else if (rel.getDestination().getIdentifier() == null || rel.getDestination().getIdentifier().getVPW() == null || rel.getDestination().getIdentifier().getVPW().getVendor() == null || rel.getDestination().getIdentifier().getVPW().getProduct() == null || rel.getDestination().getIdentifier().getVPW().getWWN() == null) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship destination identifiers corrupt or empty");
        }
        RKCRelationshipTypeEnum type = this.map(rel.getType());
        if (type == null) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship type corrupt or empty");
        }
        if (RKCRelationshipTypeEnum.Snapshot.equals((Object)type)) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("Snapshots not supported in DKR relationships.");
        }
        if (rel.getDestination().getIdentifier().getVPW().getWWN().equals(rel.getSource().getIdentifier().getVPW().getWWN())) {
            relInfo.setStatus(RKCRelationshipStatusEnum.Error);
            relInfo.setStatus_desc("DKR relationship source and dest cannot be the same.");
        }
        this.validateString(rel.getSource().getLabel(), "source label", 32, relInfo);
        this.validateString(rel.getDestination().getLabel(), "destination label", 32, relInfo);
        this.validateString(rel.getSource().getDisk_Group_Name(), "source group name", 32, relInfo);
        this.validateString(rel.getDestination().getDisk_Group_Name(), "destination group name", 32, relInfo);
        this.validateString(rel.getSource().getDisk_Name(), "source name", 32, relInfo);
        this.validateString(rel.getDestination().getDisk_Name(), "destination name", 32, relInfo);
        if (RKCRelationshipStatusEnum.Error.equals((Object)relInfo.getStatus())) {
            return relInfo;
        }
        relInfo.setSourceClusterName(rel.getSource().getCluster_Name());
        if (rel.getSource().isSetDisk_Group_Name()) {
            relInfo.setSourceGroupName(rel.getSource().getDisk_Group_Name());
        }
        if (rel.getSource().isSetDisk_Name()) {
            relInfo.setSourceName(rel.getSource().getDisk_Name());
        }
        relInfo.setSourceVendor(this.trim(8, rel.getSource().getIdentifier().getVPW().getVendor()));
        relInfo.setSourceProduct(this.trim(16, rel.getSource().getIdentifier().getVPW().getProduct()));
        relInfo.setSourceWwn(rel.getSource().getIdentifier().getVPW().getWWN());
        relInfo.setSourceLabel(rel.getSource().getLabel());
        relInfo.setDestClusterName(rel.getDestination().getCluster_Name());
        if (rel.getDestination().isSetDisk_Group_Name()) {
            relInfo.setDestGroupName(rel.getDestination().getDisk_Group_Name());
        }
        if (rel.getDestination().isSetDisk_Name()) {
            relInfo.setDestName(rel.getDestination().getDisk_Name());
        }
        relInfo.setDestVendor(this.trim(8, rel.getDestination().getIdentifier().getVPW().getVendor()));
        relInfo.setDestProduct(this.trim(16, rel.getDestination().getIdentifier().getVPW().getProduct()));
        relInfo.setDestWwn(rel.getDestination().getIdentifier().getVPW().getWWN());
        relInfo.setDestLabel(rel.getDestination().getLabel());
        relInfo.setStatus(RKCRelationshipStatusEnum.Disabled);
        relInfo.setType(type);
        return relInfo;
    }

    private String trim(int len, String src) {
        if (src == null) {
            return null;
        }
        if (src.length() > len) {
            return src.substring(0, len);
        }
        while (src.length() < len) {
            src = src + " ";
        }
        return src;
    }

    private RKCRelationshipTypeEnum map(DKRRelationTypeEnum type) {
        RKCRelationshipTypeEnum ret = null;
        if (type == null) {
            return null;
        }
        switch (type) {
            case SME___DKR___MIRROR: {
                ret = RKCRelationshipTypeEnum.Mirror;
                break;
            }
            case SME___DKR___SNAPSHOT: {
                ret = RKCRelationshipTypeEnum.Snapshot;
                break;
            }
        }
        return ret;
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

