/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.sme.accounting.Accounting;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.comm.SmeXmlHandler;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterLockEnum;
import com.cisco.dcbu.sme.common.ClusterSmartcardInfo;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.FilterInfo;
import com.cisco.dcbu.sme.common.ImportObject;
import com.cisco.dcbu.sme.common.KeyInfo;
import com.cisco.dcbu.sme.common.Limits;
import com.cisco.dcbu.sme.common.MasterkeyRekeyInfo;
import com.cisco.dcbu.sme.common.MasterkeyRekeyStateEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.PathInfo;
import com.cisco.dcbu.sme.common.PathStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.SerialQualifierNoneInfo;
import com.cisco.dcbu.sme.common.SerialQualifierRangeInfo;
import com.cisco.dcbu.sme.common.SerialQualifierRegexInfo;
import com.cisco.dcbu.sme.common.SerialRangeInfo;
import com.cisco.dcbu.sme.common.TapeDeviceDetailInfo;
import com.cisco.dcbu.sme.common.TapeDeviceInfo;
import com.cisco.dcbu.sme.common.TapeDevicePathInfo;
import com.cisco.dcbu.sme.common.TapeGroupInfo;
import com.cisco.dcbu.sme.common.TapeGroupStatusEnum;
import com.cisco.dcbu.sme.common.TapeInfo;
import com.cisco.dcbu.sme.common.TapeVolumeGroupInfo;
import com.cisco.dcbu.sme.common.TapeVolumeGroupStatusEnum;
import com.cisco.dcbu.sme.common.TapeVolumeInfo;
import com.cisco.dcbu.sme.common.TapeVolumes;
import com.cisco.dcbu.sme.common.mapper.OperationStatusSMEMapper;
import com.cisco.dcbu.sme.common.mapper.PathStatusMapper;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.ejb.api.TapeGroupMgr;
import com.cisco.dcbu.sme.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.exception.SMEInvalidMessageException;
import com.cisco.dcbu.sme.exception.SMEKMCCommunicationException;
import com.cisco.dcbu.sme.exception.SMEProcessingException;
import com.cisco.dcbu.sme.message.ITNexusMessage;
import com.cisco.dcbu.sme.message.TapeGroupMessage;
import com.cisco.dcbu.sme.replication.SMEReplicationRelationship;
import com.cisco.dcbu.sme.tree.TapeDeviceTreeNode;
import com.cisco.dcbu.sme.tree.TapeGroupTreeNode;
import com.cisco.dcbu.sme.tree.TapeVolumeGroupTreeNode;
import com.cisco.dcbu.sme.xml.SMEITLObject;
import com.cisco.dcbu.sme.xml.SMEITLStatusEnum;
import com.cisco.dcbu.sme.xml.SMEITNexusObject;
import com.cisco.dcbu.sme.xml.SMELunPathConfigEnum;
import com.cisco.dcbu.sme.xml.SMELunPathUserConfig;
import com.cisco.dcbu.sme.xml.SMELunStatusEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPath;
import com.cisco.dcbu.sme.xml.SMERange;
import com.cisco.dcbu.sme.xml.SMEResponseStatusEnum;
import com.cisco.dcbu.sme.xml.SMETapeBackupGroupData;
import com.cisco.dcbu.sme.xml.SMETapeBackupGroupIndex;
import com.cisco.dcbu.sme.xml.SMETapeBackupGroupObject;
import com.cisco.dcbu.sme.xml.SMETapeDeviceIndex;
import com.cisco.dcbu.sme.xml.SMETapeDeviceObject;
import com.cisco.dcbu.sme.xml.SMETapeDevicePathIndex;
import com.cisco.dcbu.sme.xml.SMETapeDevicePathObject;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupData;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupIndex;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupObject;
import com.cisco.dcbu.sme.xml.SMETapeVolumeIndex;
import com.cisco.dcbu.sme.xml.SMETapeVolumeObject;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class TapeGroupMgrBean
extends MgrHelper
implements Serializable,
TapeGroupMgr {
    static Logger _Logger = Logger.getLogger((String)"SME");
    private Accounting accountingBean;

    @EJB
    public void setModelMgrBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setClusterMgrBean(ClusterMgr clusterBean) {
        this.clusterBean = clusterBean;
    }

    @Override
    public OperationStatus createTapeGroup(SMEContext ctx, TapeGroupInfo tapeGroupInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeGroupInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(tapeGroupInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeGroupSetReq(tapeGroupInfo, SMEOpcodeEnum.CREATE___TAPE___GROUP);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to create Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to create Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to create Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
            } else {
                String logMsg = "Failed to create Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Unable to communicate with switch.";
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus addTapeDevice(SMEContext ctx, TapeDeviceInfo tapeGroupDeviceInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeGroupDeviceInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(tapeGroupDeviceInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeDeviceSetReq(tapeGroupDeviceInfo, SMEOpcodeEnum.CREATE___TAPE___DEVICE);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to create Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to create Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to create Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
            } else {
                String logMsg = "Failed to create Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Unable to communicate with switch.";
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus enableTapeDevice(SMEContext ctx, TapeDeviceInfo tapeGroupDeviceInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeGroupDeviceInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(tapeGroupDeviceInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeDeviceSetReq(tapeGroupDeviceInfo, SMEOpcodeEnum.ENABLE___TAPE___DEVICE);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to enable Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to enable Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to enable Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
            } else {
                String logMsg = "Failed to enable Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Unable to communicate with switch.";
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus addTapeVolumeGroup(SMEContext ctx, TapeVolumeGroupInfo tapeVolumeGroupInfo) {
        OperationStatus ret;
        block18: {
            String logMsg;
            String logMsg2;
            String logMsg3;
            SMEMessage smeMessage;
            String msgIn;
            String msgOut;
            SmeXmlHandler smeXmlHandler;
            TapeGroupMessage tapeGroupMessage;
            block17: {
                ret = new OperationStatus();
                tapeGroupMessage = new TapeGroupMessage();
                String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeVolumeGroupInfo.getClusterName());
                smeXmlHandler = new SmeXmlHandler(tapeVolumeGroupInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
                msgOut = tapeGroupMessage.prepareTapeVolumeGroupSetReq(tapeVolumeGroupInfo, SMEOpcodeEnum.CREATE___TAPE___VOLUME___GROUP);
                msgIn = null;
                try {
                    msgIn = smeXmlHandler.sendReceive(msgOut);
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                }
                if (msgIn != null) {
                    smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                    try {
                        if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                            ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                            ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                            break block17;
                        }
                        logMsg3 = "Failed to create Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                        ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg3);
                        _Logger.warn((Object)logMsg3);
                    }
                    catch (SMEInvalidMessageException se) {
                        logMsg2 = "Failed to create Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                        ret.set(OperationStatusEnum.Failure, logMsg2);
                        _Logger.warn((Object)logMsg2);
                    }
                    catch (SMEException se) {
                        logMsg2 = "Failed to create Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                        ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg2);
                        _Logger.warn((Object)logMsg2);
                    }
                } else {
                    logMsg = "Failed to create Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Unable to communicate with switch.";
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
            }
            if (ret.getStatus() == OperationStatusEnum.Success) {
                msgOut = tapeGroupMessage.prepareTapeVolumeGroupSetReq(tapeVolumeGroupInfo, SMEOpcodeEnum.UPDATE___TAPE___VOLUME___GROUP___BARCODE___MATCHING___RULE);
                msgIn = null;
                try {
                    msgIn = smeXmlHandler.sendReceive(msgOut);
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                }
                if (msgIn != null) {
                    smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                    try {
                        if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                            ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                            ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                            break block18;
                        }
                        logMsg3 = "Failed to add rules for  Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                        ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg3);
                        _Logger.warn((Object)logMsg3);
                    }
                    catch (SMEInvalidMessageException se) {
                        logMsg2 = "Failed to add rules for  Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                        ret.set(OperationStatusEnum.Failure, logMsg2);
                        _Logger.warn((Object)logMsg2);
                    }
                    catch (SMEException se) {
                        logMsg2 = "Failed to add rules for  Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                        ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg2);
                        _Logger.warn((Object)logMsg2);
                    }
                } else {
                    logMsg = "Failed to add rules for Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Unable to communicate with switch.";
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
            }
        }
        return ret;
    }

    @Override
    public OperationStatus modifyTapeVolumeGroup(SMEContext ctx, TapeVolumeGroupInfo tapeVolumeGroupInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeVolumeGroupInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(tapeVolumeGroupInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeVolumeGroupSetReq(tapeVolumeGroupInfo, SMEOpcodeEnum.UPDATE___TAPE___VOLUME___GROUP___BARCODE___MATCHING___RULE);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to update rules for  Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to update rules for  Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to update rules for  Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
            } else {
                String logMsg = "Failed to update rules for Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Unable to communicate with switch.";
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus addTapeDevicePath(SMEContext ctx, TapeDevicePathInfo tapeDevicePathInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeDevicePathInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(tapeDevicePathInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeDevicePathSetReq(tapeDevicePathInfo, SMEOpcodeEnum.CREATE___TAPE___PATH);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to create Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to create Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to create Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ". Error: " + se.getMessage();
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                    _Logger.warn((Object)logMsg);
                }
            } else {
                String logMsg = "Failed to create Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ". Unable to communicate with switch.";
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        }
        return ret;
    }

    @Override
    public TapeGroupInfo getTapeGroup(SMEContext ctx, String clusterName, String tapeGroupName) {
        TapeGroupInfo tapeGroupInfo = null;
        tapeGroupInfo = new TapeGroupInfo();
        tapeGroupInfo.setClusterName(clusterName);
        tapeGroupInfo.setTapeGroupName(tapeGroupName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = tapeGroupMessage.prepareTapeGroupGetReq(tapeGroupInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                List tapebackupGroupList;
                Iterator it;
                if (tapeGroupMessage.analyzeResponse(smeMessage) && (it = (tapebackupGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_BackupGroup()).iterator()).hasNext()) {
                    SMETapeBackupGroupObject tapeGroupObject = (SMETapeBackupGroupObject)it.next();
                    SMETapeBackupGroupIndex index = tapeGroupObject.getIndex();
                    SMETapeBackupGroupData data = tapeGroupObject.getData();
                    tapeGroupInfo.setClusterName(index.getCluster_Name());
                    tapeGroupInfo.setTapeGroupName(index.getTape_BackupGroup_Name());
                    tapeGroupInfo.setTotalDevices(data.getTotal_Devices());
                    tapeGroupInfo.setTotalVolumeGroups(data.getTotal_VolumeGroups());
                    tapeGroupInfo.setStatus(TapeGroupStatusEnum.Active);
                    tapeGroupInfo.setId(data.getID().toString());
                }
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to get inforamtion for tape group " + tapeGroupName + " for cluster " + clusterName + ". Error: " + se.getMessage()));
            }
        }
        return tapeGroupInfo;
    }

    @Override
    public ArrayList<TapeGroupInfo> getTapeGroupInfoList(SMEContext ctx, String clusterName) {
        ArrayList<TapeGroupInfo> tapeGroups = null;
        tapeGroups = new ArrayList<TapeGroupInfo>();
        TapeGroupInfo tapeGroupInfo = new TapeGroupInfo();
        tapeGroupInfo.setClusterName(clusterName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeGroupGetReq(tapeGroupInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_BACKUPGROUPS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return tapeGroups;
            }
            List tapebackupGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_BackupGroup();
            Iterator it = tapebackupGroupList.iterator();
            while (it.hasNext()) {
                TapeGroupInfo tg = new TapeGroupInfo();
                SMETapeBackupGroupObject tapeGroupObject = (SMETapeBackupGroupObject)it.next();
                SMETapeBackupGroupIndex index = tapeGroupObject.getIndex();
                SMETapeBackupGroupData data = tapeGroupObject.getData();
                tg.setClusterName(index.getCluster_Name());
                tg.setTapeGroupName(index.getTape_BackupGroup_Name());
                tg.setTotalDevices(data.getTotal_Devices());
                tg.setTotalVolumeGroups(data.getTotal_VolumeGroups());
                tg.setStatus(TapeGroupStatusEnum.Active);
                tg.setId(data.getID().toString());
                tapeGroups.add(tg);
                tapeGroupInfo.setClusterName(tg.getClusterName());
                tapeGroupInfo.setTapeGroupName(tg.getTapeGroupName());
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_TAPE_BACKUPGROUPS_IN_REQUEST);
        return tapeGroups;
    }

    @Override
    public ArrayList<TapeGroupTreeNode> getTapeGroupTreeNodes(SMEContext ctx) {
        ArrayList<TapeGroupTreeNode> tapeGroups = null;
        tapeGroups = new ArrayList<TapeGroupTreeNode>();
        TapeGroupInfo tapeGroupInfo = new TapeGroupInfo();
        tapeGroupInfo.setClusterName(ctx.getCluster().getClusterName());
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeGroupGetReq(tapeGroupInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_BACKUPGROUPS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                    List tapebackupGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_BackupGroup();
                    Iterator it = tapebackupGroupList.iterator();
                    while (it.hasNext()) {
                        TapeGroupTreeNode tapeGroupTreeNode = new TapeGroupTreeNode();
                        SMETapeBackupGroupObject tapeGroupObject = (SMETapeBackupGroupObject)it.next();
                        tapeGroupTreeNode.setClusterName(tapeGroupObject.getIndex().getCluster_Name());
                        tapeGroupTreeNode.setTapeGroupName(tapeGroupObject.getIndex().getTape_BackupGroup_Name());
                        tapeGroupTreeNode.setStatus(TapeGroupStatusEnum.Active);
                        tapeGroupTreeNode.setTapeDevices(this.getTapeDeviceTreeNodes(ctx, tapeGroupTreeNode.getTapeGroupName()));
                        ArrayList<TapeVolumeGroupTreeNode> volumeGroups = this.getTapeVolumeGroupTreeNodes(ctx, tapeGroupTreeNode.getTapeGroupName());
                        tapeGroupTreeNode.setVolumeGroups(volumeGroups);
                        tapeGroups.add(tapeGroupTreeNode);
                        tapeGroupInfo.setClusterName(tapeGroupTreeNode.getClusterName());
                        tapeGroupInfo.setTapeGroupName(tapeGroupTreeNode.getTapeGroupName());
                        ++receivedCount;
                    }
                    continue;
                }
                return tapeGroups;
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed response received from switch " + se.getMessage()));
            }
        } while (receivedCount == Limits.MAX_TAPE_BACKUPGROUPS_IN_REQUEST);
        return tapeGroups;
    }

    private ArrayList<TapeDeviceTreeNode> getTapeDeviceTreeNodes(SMEContext ctx, String tapeGroupName) {
        ArrayList<TapeDeviceTreeNode> tapeDevices = new ArrayList<TapeDeviceTreeNode>();
        TapeDeviceInfo tapeDeviceInfo = new TapeDeviceInfo();
        tapeDeviceInfo.setClusterName(ctx.getCluster().getClusterName());
        tapeDeviceInfo.setTapeGroupName(tapeGroupName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeDeviceGetReq(tapeDeviceInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_DEVICES_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return tapeDevices;
            }
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            List tapeDeviceList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_Device();
            Iterator it = tapeDeviceList.iterator();
            while (it.hasNext()) {
                TapeDeviceTreeNode tapeDeviceTreeNode = new TapeDeviceTreeNode();
                SMETapeDeviceObject tapeDeviceObject = (SMETapeDeviceObject)it.next();
                tapeDeviceTreeNode.setTapeDeviceName(tapeDeviceObject.getIndex().getTape_Device_Name());
                tapeDevices.add(tapeDeviceTreeNode);
                tapeDeviceInfo.setClusterName(tapeDeviceObject.getIndex().getCluster_Name());
                tapeDeviceInfo.setTapeGroupName(tapeDeviceObject.getIndex().getTape_BackupGroup_Name());
                tapeDeviceInfo.setDeviceName(tapeDeviceObject.getIndex().getTape_Device_Name());
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_TAPE_DEVICES_IN_REQUEST);
        return tapeDevices;
    }

    private ArrayList<TapeVolumeGroupTreeNode> getTapeVolumeGroupTreeNodes(SMEContext ctx, String tapeGroupName) {
        ArrayList<TapeVolumeGroupTreeNode> tapeVolumeGroups = new ArrayList<TapeVolumeGroupTreeNode>();
        TapeVolumeGroupInfo tapeGroupVolumeGroupInfo = new TapeVolumeGroupInfo();
        tapeGroupVolumeGroupInfo.setClusterName(ctx.getCluster().getClusterName());
        tapeGroupVolumeGroupInfo.setTapeGroupName(tapeGroupName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeVolumeGroupGetReq(tapeGroupVolumeGroupInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_VOLUME_GROUPS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return tapeVolumeGroups;
            }
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            List tapeVolumeGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_VolumeGroup();
            Iterator it = tapeVolumeGroupList.iterator();
            while (it.hasNext()) {
                TapeVolumeGroupTreeNode tapeVolumeGroupTreeNode = new TapeVolumeGroupTreeNode();
                SMETapeVolumeGroupObject tapeVolumeGroupObject = (SMETapeVolumeGroupObject)it.next();
                tapeVolumeGroupTreeNode.setVolumeGroupName(tapeVolumeGroupObject.getIndex().getTape_VolumeGroup_Name());
                tapeVolumeGroupTreeNode.setStatus(TapeVolumeGroupStatusEnum.Active);
                tapeVolumeGroups.add(tapeVolumeGroupTreeNode);
                tapeGroupVolumeGroupInfo.setClusterName(tapeVolumeGroupObject.getIndex().getCluster_Name());
                tapeGroupVolumeGroupInfo.setTapeGroupName(tapeVolumeGroupObject.getIndex().getTape_BackupGroup_Name());
                tapeGroupVolumeGroupInfo.setTapeGroupName(tapeVolumeGroupObject.getIndex().getTape_VolumeGroup_Name());
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_TAPE_VOLUME_GROUPS_IN_REQUEST);
        return tapeVolumeGroups;
    }

    @Override
    public ArrayList<TapeDevicePathInfo> getTapeDevicePathInfoList(SMEContext ctx, String clusterName, String tapeGroupName, String deviceName) {
        ArrayList<TapeDevicePathInfo> tapeDevicePaths = null;
        tapeDevicePaths = new ArrayList<TapeDevicePathInfo>();
        TapeDevicePathInfo tapeDevicePathInfo = new TapeDevicePathInfo();
        tapeDevicePathInfo.setClusterName(clusterName);
        tapeDevicePathInfo.setTapeGroupName(tapeGroupName);
        tapeDevicePathInfo.setTapeDeviceName(deviceName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeDevicePathGetReq(tapeDevicePathInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_PATHS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return tapeDevicePaths;
            }
            List tapeDevicePathList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_Device_Path();
            for (SMETapeDevicePathObject tapeDevicePathObject : tapeDevicePathList) {
                TapeDevicePathInfo tapePath = new TapeDevicePathInfo();
                SMETapeDevicePathIndex index = tapeDevicePathObject.getIndex();
                tapePath.setClusterName(index.getCluster_Name());
                tapePath.setTapeGroupName(index.getTape_BackupGroup_Name());
                tapePath.setTapeDeviceName(index.getTape_Device_Name());
                SMELunPathUserConfig lunPath = index.getPath();
                SMEPath smePath = lunPath.getPath();
                PathInfo path = new PathInfo();
                path.setInitiator(smePath.getInitiator());
                path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getInitiator()));
                path.setTarget(smePath.getTarget());
                path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getTarget()));
                path.setVsanId(smePath.getVSAN());
                path.setFabricName(smePath.getFabric());
                path.setLunId(lunPath.getLun());
                tapePath.setPath(path);
                tapeDevicePaths.add(tapePath);
                tapeDevicePathInfo.setPath(path);
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_TAPE_PATHS_IN_REQUEST);
        ITNexusMessage itNexusMessage = new ITNexusMessage();
        for (TapeDevicePathInfo tdpi : tapeDevicePaths) {
            List itlobjList;
            SMEMessage smeMessage;
            PathInfo pi = tdpi.getPath();
            String msgOut = itNexusMessage.prepareITLGetReq(ctx, clusterName, pi, SMEOperationEnum.SME___OP___GET, Limits.MAX_TAPE_PATHS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null || !(smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp() || (itlobjList = smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Ls()).size() != 1) continue;
            SMEITLObject itlobj = (SMEITLObject)itlobjList.get(0);
            SMELunStatusEnum statusEnum = itlobj.getData().getLun_Path().getLun().getStatus();
            pi.setStatus(PathStatusMapper.mapPathStatusCode(statusEnum));
            SMELunPathConfigEnum configEnum = itlobj.getData().getLun_Path().getIsConfigured();
            if (configEnum == SMELunPathConfigEnum.SME___LUN___PATH___NOT___CONFIGURED) {
                pi.setStatus(PathStatusEnum.NotConfigured);
            }
            tdpi.setDescription(itlobj.getData().getLun_Path().getLun().getDescription());
            tdpi.setSerialNumber(itlobj.getData().getLun_Path().getLun().getSerial_Number());
        }
        return tapeDevicePaths;
    }

    @Override
    public TapeDeviceDetailInfo getTapeDeviceDetailInfo(SMEContext ctx, String clusterName, String tapeGroupName, String deviceName) {
        SMEMessage smeMessage;
        String msgIn;
        String msgOut;
        TapeDeviceDetailInfo tddi = new TapeDeviceDetailInfo();
        tddi.setClusterName(clusterName);
        tddi.setTapeGroupName(tapeGroupName);
        tddi.setTapeDeviceName(deviceName);
        tddi.setDescription("");
        tddi.setSerialNumber("");
        ArrayList<PathInfo> pathInfoList = new ArrayList<PathInfo>();
        tddi.setPaths(pathInfoList);
        TapeDevicePathInfo tapeDevicePathInfo = new TapeDevicePathInfo();
        tapeDevicePathInfo.setClusterName(clusterName);
        tapeDevicePathInfo.setTapeGroupName(tapeGroupName);
        tapeDevicePathInfo.setTapeDeviceName(deviceName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut2 = tapeGroupMessage.prepareTapeDevicePathGetReq(tapeDevicePathInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_PATHS_IN_REQUEST);
            String msgIn2 = null;
            try {
                msgIn2 = smeXmlHandler.sendReceive(msgOut2);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn2 == null) break;
            SMEMessage smeMessage2 = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn2.getBytes()));
            try {
                if (!tapeGroupMessage.analyzeResponse(smeMessage2)) continue;
                List tapeDevicePathList = smeMessage2.getTable_Data().getTapeGroup_Get_Resp().getTape_Device_Path();
                for (SMETapeDevicePathObject tapeDevicePathObject : tapeDevicePathList) {
                    TapeDevicePathInfo tapePath = new TapeDevicePathInfo();
                    SMETapeDevicePathIndex index = tapeDevicePathObject.getIndex();
                    tapePath.setClusterName(index.getCluster_Name());
                    tapePath.setTapeGroupName(index.getTape_BackupGroup_Name());
                    tapePath.setTapeDeviceName(index.getTape_Device_Name());
                    SMELunPathUserConfig lunPath = index.getPath();
                    SMEPath smePath = lunPath.getPath();
                    PathInfo path = new PathInfo();
                    path.setInitiator(smePath.getInitiator());
                    path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getInitiator()));
                    path.setTarget(smePath.getTarget());
                    path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getTarget()));
                    path.setVsanId(smePath.getVSAN());
                    path.setFabricName(smePath.getFabric());
                    path.setLunId(lunPath.getLun());
                    path.setStatus(PathStatusEnum.Offline);
                    pathInfoList.add(path);
                    tapeDevicePathInfo.setPath(path);
                    ++receivedCount;
                }
            }
            catch (SMEException e) {
                _Logger.warn((Object)("TapeDeviceDetails - problem fetching info: " + e.getMessage()));
                return tddi;
            }
        } while (receivedCount == Limits.MAX_TAPE_PATHS_IN_REQUEST);
        ITNexusMessage itNexusMessage = new ITNexusMessage();
        for (PathInfo pi : pathInfoList) {
            msgOut = itNexusMessage.prepareITLGetReq(ctx, clusterName, pi, SMEOperationEnum.SME___OP___GET, Limits.MAX_TAPE_PATHS_IN_REQUEST);
            msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                continue;
            }
            if (msgIn == null) continue;
            smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                List itlobjList;
                if (!itNexusMessage.analyzeResponse(smeMessage) || (itlobjList = smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Ls()).size() != 1) continue;
                SMEITLObject itlobj = (SMEITLObject)itlobjList.get(0);
                SMEITLStatusEnum statusEnum = itlobj.getData().getLun_Path().getStatus();
                pi.setStatus(PathStatusMapper.mapPathStatusCode(statusEnum));
                SMELunPathConfigEnum configEnum = itlobj.getData().getLun_Path().getIsConfigured();
                if (configEnum == SMELunPathConfigEnum.SME___LUN___PATH___NOT___CONFIGURED) {
                    pi.setStatus(PathStatusEnum.NotConfigured);
                }
                tddi.setDescription(itlobj.getData().getLun_Path().getLun().getDescription());
                tddi.setSerialNumber(itlobj.getData().getLun_Path().getLun().getSerial_Number());
            }
            catch (SMEException e) {
                _Logger.warn((Object)("TapeDeviceDetails - problem fetching status info: " + e.getMessage()));
            }
        }
        itNexusMessage = new ITNexusMessage();
        for (PathInfo pi : pathInfoList) {
            msgOut = itNexusMessage.prepareITNexusGetReq(ctx, pi, SMEOperationEnum.SME___OP___GET, Limits.MAX_TAPE_PATHS_IN_REQUEST);
            msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                continue;
            }
            if (msgIn == null) continue;
            smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                List itnexusobjList;
                if (!itNexusMessage.analyzeResponse(smeMessage) || (itnexusobjList = smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Nexuses()).size() != 1) continue;
                SMEITNexusObject itnobj = (SMEITNexusObject)itnexusobjList.get(0);
                String intf = itnobj.getData().getInterface().getNode_Name() + "-";
                intf = intf + itnobj.getData().getInterface().getIf_Index();
                pi.setSmeInterface(intf);
            }
            catch (SMEException e) {
                _Logger.warn((Object)("TapeDeviceDetails - problem fetching interface info: " + e.getMessage()));
            }
        }
        return tddi;
    }

    @Override
    public TapeDeviceInfo getTapeDevice(SMEContext ctx, String clusterName, String tapeGroupName, String deviceName) {
        List tapeDeviceList;
        Iterator it;
        SMEMessage smeMessage;
        TapeDeviceInfo tapeDeviceInfo = null;
        tapeDeviceInfo = new TapeDeviceInfo();
        tapeDeviceInfo.setClusterName(clusterName);
        tapeDeviceInfo.setTapeGroupName(tapeGroupName);
        tapeDeviceInfo.setDeviceName(deviceName);
        tapeDeviceInfo.setDescription("");
        tapeDeviceInfo.setSerialNumber("");
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = tapeGroupMessage.prepareTapeDeviceGetReq(tapeDeviceInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null && (smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp() && (it = (tapeDeviceList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_Device()).iterator()).hasNext()) {
            SMETapeDeviceObject tapeDeviceObject = (SMETapeDeviceObject)it.next();
            SMETapeDeviceIndex index = tapeDeviceObject.getIndex();
            tapeDeviceInfo.setClusterName(index.getCluster_Name());
            tapeDeviceInfo.setTapeGroupName(index.getTape_BackupGroup_Name());
            tapeDeviceInfo.setDeviceName(index.getTape_Device_Name());
            tapeDeviceInfo.setDescription("");
            tapeDeviceInfo.setSerialNumber("");
        }
        return tapeDeviceInfo;
    }

    @Override
    public ArrayList<TapeDeviceInfo> getTapeDeviceInfoList(SMEContext ctx, String clusterName, String tapeGroupName) {
        ArrayList<TapeDeviceInfo> tapeDevices = new ArrayList<TapeDeviceInfo>();
        TapeDeviceInfo tapeDeviceInfo = new TapeDeviceInfo();
        tapeDeviceInfo.setClusterName(clusterName);
        tapeDeviceInfo.setTapeGroupName(tapeGroupName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeDeviceGetReq(tapeDeviceInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_DEVICES_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return tapeDevices;
            }
            List tapeDeviceList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_Device();
            Iterator it = tapeDeviceList.iterator();
            while (it.hasNext()) {
                TapeDeviceInfo td = new TapeDeviceInfo();
                SMETapeDeviceObject tapeDeviceObject = (SMETapeDeviceObject)it.next();
                SMETapeDeviceIndex index = tapeDeviceObject.getIndex();
                td.setClusterName(index.getCluster_Name());
                td.setTapeGroupName(index.getTape_BackupGroup_Name());
                td.setDeviceName(index.getTape_Device_Name());
                td.setDescription("");
                tapeDevices.add(td);
                tapeDeviceInfo.setClusterName(index.getCluster_Name());
                tapeDeviceInfo.setTapeGroupName(index.getTape_BackupGroup_Name());
                tapeDeviceInfo.setDeviceName(index.getTape_Device_Name());
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_TAPE_DEVICES_IN_REQUEST);
        for (TapeDeviceInfo tdi : tapeDevices) {
            TapeDeviceDetailInfo tddi = this.getTapeDeviceDetailInfo(ctx, clusterName, tapeGroupName, tdi.getDeviceName());
            tdi.setDescription(tddi.getDescription());
        }
        Collections.sort(tapeDevices);
        return tapeDevices;
    }

    @Override
    public TapeVolumeInfo getTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String volumeGroupName, String barCode) {
        List tapebackupGroupList;
        Iterator it;
        SMEMessage smeMessage;
        TapeVolumeInfo tapeVolumeInfo = null;
        tapeVolumeInfo = new TapeVolumeInfo();
        tapeVolumeInfo.setClusterName(clusterName);
        tapeVolumeInfo.setTapeGroupName(tapeGroupName);
        tapeVolumeInfo.setVolumeGroupName(volumeGroupName);
        tapeVolumeInfo.setBarCode(barCode);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = tapeGroupMessage.prepareTapeVolumeGetReq(tapeVolumeInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null && (smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp() && (it = (tapebackupGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_BackupGroup()).iterator()).hasNext()) {
            SMETapeVolumeObject tapeVolumeObject = (SMETapeVolumeObject)it.next();
            SMETapeVolumeIndex index = tapeVolumeObject.getIndex();
            tapeVolumeInfo.setClusterName(index.getCluster_Name());
            tapeVolumeInfo.setTapeGroupName(index.getTape_BackupGroup_Name());
            tapeVolumeInfo.setVolumeGroupName(index.getTape_VolumeGroup_Name());
            tapeVolumeInfo.setBarCode(index.getBarcode());
        }
        return tapeVolumeInfo;
    }

    @Override
    public TapeVolumeGroupInfo getTapeVolumeGroup(SMEContext ctx, String clusterName, String tapeGroupName, String volumeGroupName) {
        TapeVolumeGroupInfo tapeVolumeGroupInfo = null;
        tapeVolumeGroupInfo = new TapeVolumeGroupInfo();
        tapeVolumeGroupInfo.setClusterName(clusterName);
        tapeVolumeGroupInfo.setTapeGroupName(tapeGroupName);
        tapeVolumeGroupInfo.setVolumeGroupName(volumeGroupName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = tapeGroupMessage.prepareTapeVolumeGroupGetReq(tapeVolumeGroupInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                List tapevolumeGroupList;
                Iterator it;
                if (tapeGroupMessage.analyzeResponse(smeMessage) && (it = (tapevolumeGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_VolumeGroup()).iterator()).hasNext()) {
                    SMETapeVolumeGroupObject tapeVolumeGroupObject = (SMETapeVolumeGroupObject)it.next();
                    SMETapeVolumeGroupIndex index = tapeVolumeGroupObject.getIndex();
                    SMETapeVolumeGroupData data = tapeVolumeGroupObject.getData();
                    tapeVolumeGroupInfo.setClusterName(index.getCluster_Name());
                    tapeVolumeGroupInfo.setTapeGroupName(index.getTape_BackupGroup_Name());
                    tapeVolumeGroupInfo.setVolumeGroupName(index.getTape_VolumeGroup_Name());
                    List rangeList = data.getRange();
                    if (rangeList.size() == 0) {
                        String regex = data.getBarcode_Regex();
                        if (regex == null || regex.length() == 0) {
                            tapeVolumeGroupInfo.setQualifier(new SerialQualifierNoneInfo());
                        } else {
                            tapeVolumeGroupInfo.setQualifier(new SerialQualifierRegexInfo(regex));
                        }
                    } else {
                        SerialQualifierRangeInfo qualRangeInfo = new SerialQualifierRangeInfo();
                        tapeVolumeGroupInfo.setQualifier(qualRangeInfo);
                        for (SMERange r : rangeList) {
                            SerialRangeInfo ri = new SerialRangeInfo();
                            ri.setStart(r.getStart());
                            ri.setEnd(r.getEnd());
                            qualRangeInfo.addRange(ri);
                        }
                    }
                    tapeVolumeGroupInfo.setStatus(TapeVolumeGroupStatusEnum.Active);
                    tapeVolumeGroupInfo.setSharedKeyGUID(data.getShare_GUID());
                    tapeVolumeGroupInfo.setWrapKeyGUID(data.getWrap_GUID());
                }
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to get inforamtion for tape volume group " + volumeGroupName + " for tape group " + tapeGroupName + " for cluster " + clusterName + ". Error: " + se.getMessage()));
            }
        }
        return tapeVolumeGroupInfo;
    }

    @Override
    public ArrayList<TapeVolumeGroupInfo> getTapeVolumeGroupInfoList(SMEContext ctx, String clusterName, String tapeGroupName) {
        ArrayList<TapeVolumeGroupInfo> tapeVolumeGroups = null;
        tapeVolumeGroups = new ArrayList<TapeVolumeGroupInfo>();
        TapeVolumeGroupInfo tapeVolumeGroupInfo = new TapeVolumeGroupInfo();
        tapeVolumeGroupInfo.setClusterName(clusterName);
        tapeVolumeGroupInfo.setTapeGroupName(tapeGroupName);
        TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = tapeGroupMessage.prepareTapeVolumeGroupGetReq(tapeVolumeGroupInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_TAPE_VOLUME_GROUPS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return tapeVolumeGroups;
            }
            List tapeVolumeGroupList = smeMessage.getTable_Data().getTapeGroup_Get_Resp().getTape_VolumeGroup();
            Iterator it = tapeVolumeGroupList.iterator();
            while (it.hasNext()) {
                TapeVolumeGroupInfo tvg = new TapeVolumeGroupInfo();
                SMETapeVolumeGroupObject tapeVolumeGroupObject = (SMETapeVolumeGroupObject)it.next();
                SMETapeVolumeGroupIndex index = tapeVolumeGroupObject.getIndex();
                tvg.setClusterName(index.getCluster_Name());
                tvg.setTapeGroupName(index.getTape_BackupGroup_Name());
                tvg.setVolumeGroupName(index.getTape_VolumeGroup_Name());
                tvg.setStatus(TapeVolumeGroupStatusEnum.Active);
                tapeVolumeGroups.add(tvg);
                tapeVolumeGroupInfo.setClusterName(tvg.getClusterName());
                tapeVolumeGroupInfo.setTapeGroupName(tvg.getTapeGroupName());
                tapeVolumeGroupInfo.setVolumeGroupName(tvg.getVolumeGroupName());
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_TAPE_VOLUME_GROUPS_IN_REQUEST);
        Collections.sort(tapeVolumeGroups);
        return tapeVolumeGroups;
    }

    @Override
    public TapeVolumes getTapeVolumeInfoList(SMEContext ctx, String clusterName, String tapeGroupName, String volumeGroupName) throws SMEException {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            return ckmcBean.getTapeVolumeInfoList(ctx, clusterName, tapeGroupName, volumeGroupName);
        }
        throw new SMEKMCCommunicationException("Failed to get information about volumes. Unable to access KMC server");
    }

    @Override
    public OperationStatus deleteTapeDevice(SMEContext ctx, String clusterName, String tapeGroupName, String tapeDeviceName) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeDeviceInfo tapeGroupDeviceInfo = new TapeDeviceInfo();
            tapeGroupDeviceInfo.setClusterName(clusterName);
            tapeGroupDeviceInfo.setTapeGroupName(tapeGroupName);
            tapeGroupDeviceInfo.setDeviceName(tapeDeviceName);
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeDeviceSetReq(tapeGroupDeviceInfo, SMEOpcodeEnum.DELETE___TAPE___DEVICE);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to delete Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to delete Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to delete Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
            } else {
                String logMsg = "Failed to delete Tape Device: " + tapeGroupDeviceInfo.getDeviceName() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus deleteTapeGroup(SMEContext ctx, String clusterName, String tapeGroupName) {
        OperationStatus ret = new OperationStatus();
        if (ctx.getClusterStatus() == ClusterStatusEnum.Offline) {
            String logMsg = "Failed to delete Tape  Group " + tapeGroupName + " in cluster " + clusterName + ". Unable to communicate with switch.";
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
            return ret;
        }
        if (ctx.getClusterStatus() == ClusterStatusEnum.Online) {
            TapeGroupInfo tapeGroupInfo = this.getTapeGroup(ctx, clusterName, tapeGroupName);
            if (tapeGroupInfo != null && tapeGroupInfo.getStatus() == TapeGroupStatusEnum.Active) {
                ret = this.deleteOnlineTapeGroup(ctx, clusterName, tapeGroupName);
            } else {
                CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
                if (ckmcBean != null) {
                    ret = ckmcBean.deleteTapeGroup(ctx, clusterName, tapeGroupName);
                } else {
                    String logMsg = "Failed to delete Tape Group " + tapeGroupName + " in cluster " + clusterName + ". Unable to communicate with KMC.";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
            }
        } else {
            CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
            if (ckmcBean != null) {
                ret = ckmcBean.deleteTapeGroup(ctx, clusterName, tapeGroupName);
            } else {
                String logMsg = "Failed to delete Tape Group " + tapeGroupName + " in cluster " + clusterName + ". Unable to communicate with KMC.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        if (ret.getStatus() == OperationStatusEnum.Success) {
            this.deleteSrcReplicationRelationship(ctx, clusterName, tapeGroupName, null);
            this.deleteDestReplicationRelationship(ctx, clusterName, tapeGroupName, null);
        }
        return ret;
    }

    public OperationStatus deleteOnlineTapeGroup(SMEContext ctx, String clusterName, String tapeGroupName) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupInfo tapeGroupInfo = new TapeGroupInfo();
            tapeGroupInfo.setClusterName(clusterName);
            tapeGroupInfo.setTapeGroupName(tapeGroupName);
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeGroupSetReq(tapeGroupInfo, SMEOpcodeEnum.DELETE___TAPE___GROUP);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to delete Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to delete Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to delete Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
            } else {
                String logMsg = "Failed to delete Tape Group: " + tapeGroupInfo.getTapeGroupName() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus deleteTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeVolumeInfo tapeVolumeInfo = new TapeVolumeInfo();
            tapeVolumeInfo.setClusterName(clusterName);
            tapeVolumeInfo.setTapeGroupName(tapeGroupName);
            tapeVolumeInfo.setVolumeGroupName(tapeVolumeGroupName);
            tapeVolumeInfo.setBarCode(barCode);
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeVolumeSetReq(tapeVolumeInfo, SMEOpcodeEnum.DELETE___TAPE___VOLUME);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to delete Tape Volume: " + tapeVolumeInfo.getBarCode() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to delete Tape Volume: " + tapeVolumeInfo.getBarCode() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to delete Tape Volume: " + tapeVolumeInfo.getBarCode() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
            } else {
                String logMsg = "Failed to delete Tape Volume: " + tapeVolumeInfo.getBarCode() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus deleteActiveTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode, String guid) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            ret = ckmcBean.deleteActiveTapeVolume(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, barCode, guid);
        } else {
            String logMsg = "Failed to access KMC server for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus purgeActiveTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode, String guid) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            ret = ckmcBean.purgeActiveTapeVolume(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, barCode, guid);
        } else {
            String logMsg = "Failed to access KMC server for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus purgeArchivedTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode, String guid) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            ret = ckmcBean.purgeArchivedTapeVolume(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, barCode, guid);
        } else {
            String logMsg = "Failed to access KMC server for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus purgeTapeVolumeGroupKey(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String guid) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            ret = ckmcBean.purgeTapeVolumeGroupKey(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, guid);
        } else {
            String logMsg = "Failed to access KMC server for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus deleteTapeVolumeGroup(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        OperationStatus ret = new OperationStatus();
        if (ctx.getClusterStatus() == ClusterStatusEnum.Offline) {
            String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupName + " in Tape Group " + tapeGroupName + " in cluster " + clusterName + ". Unable to communicate with switch.";
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
            return ret;
        }
        if (ctx.getClusterStatus() == ClusterStatusEnum.Online && ctx.getTapeGroupStatus() == TapeGroupStatusEnum.Active) {
            TapeVolumeGroupInfo tapeVolumeGroupInfo = this.getTapeVolumeGroup(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
            if (tapeVolumeGroupInfo != null && tapeVolumeGroupInfo.getStatus() == TapeVolumeGroupStatusEnum.Active) {
                ret = this.deleteOnlineTapeVolumeGroup(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
            } else {
                CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
                if (ckmcBean != null) {
                    ret = ckmcBean.deleteTapeVolumeGroup(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
                } else {
                    String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupName + " in Tape Group " + tapeGroupName + " in cluster " + clusterName + ". Unable to communicate with KMC.";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
            }
        } else {
            CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
            if (ckmcBean != null) {
                ret = ckmcBean.deleteTapeVolumeGroup(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
            } else {
                String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupName + " in Tape Group " + tapeGroupName + " in cluster " + clusterName + ". Unable to communicate with KMC.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        if (ret.getStatus() == OperationStatusEnum.Success) {
            this.deleteSrcReplicationRelationship(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
            this.deleteDestReplicationRelationship(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
        }
        return ret;
    }

    @Override
    public OperationStatus rekeyTapeVolumeGroup(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        OperationStatus ret;
        block13: {
            ret = new OperationStatus();
            if (ctx.getClusterStatus() == ClusterStatusEnum.Offline) {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to rotate keys for Tape Volume Group: switch communication failed.");
                return ret;
            }
            if (ctx.getClusterStatus() == ClusterStatusEnum.Online && ctx.getTapeGroupStatus() == TapeGroupStatusEnum.Active) {
                TapeVolumeGroupInfo tapeVolumeGroupInfo = this.getTapeVolumeGroup(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
                if (tapeVolumeGroupInfo != null && tapeVolumeGroupInfo.getStatus() == TapeVolumeGroupStatusEnum.Active) {
                    TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
                    String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
                    SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
                    String msgOut = tapeGroupMessage.prepareTapeVolumeGroupSetReq(tapeVolumeGroupInfo, SMEOpcodeEnum.REKEY___TAPE___VOLUME___GROUP);
                    String msgIn = null;
                    try {
                        msgIn = smeXmlHandler.sendReceive(msgOut);
                    }
                    catch (SMEException se) {
                        _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                    }
                    if (msgIn != null) {
                        SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                        try {
                            if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                                break block13;
                            }
                            String logMsg = "Failed to rotate keys for Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                        }
                        catch (SMEInvalidMessageException se) {
                            String logMsg = "Failed to rotate keys for Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusEnum.Failure, logMsg);
                        }
                        catch (SMEException se) {
                            String logMsg = "Failed to rotate keys for Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                        }
                    } else {
                        String logMsg = "Failed to rotate keys for Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Unable to communicate with switch.";
                        _Logger.warn((Object)logMsg);
                        ret.set(OperationStatusEnum.Failure, logMsg);
                    }
                } else {
                    String logMsg = "Rotating keys for deactivated volumegroup key is not allowed.";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
            } else {
                String logMsg = "Rotating keys for deactivated volumegroup key is not allowed.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    public OperationStatus deleteOnlineTapeVolumeGroup(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeVolumeGroupInfo tapeVolumeGroupInfo = new TapeVolumeGroupInfo();
            tapeVolumeGroupInfo.setClusterName(clusterName);
            tapeVolumeGroupInfo.setTapeGroupName(tapeGroupName);
            tapeVolumeGroupInfo.setVolumeGroupName(tapeVolumeGroupName);
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeVolumeGroupSetReq(tapeVolumeGroupInfo, SMEOpcodeEnum.DELETE___TAPE___VOLUME___GROUP);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
            } else {
                String logMsg = "Failed to delete Tape Volume Group: " + tapeVolumeGroupInfo.getVolumeGroupName() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus deleteTapeDevicePath(SMEContext ctx, TapeDevicePathInfo tapeDevicePathInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            TapeGroupMessage tapeGroupMessage = new TapeGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, tapeDevicePathInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(tapeDevicePathInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = tapeGroupMessage.prepareTapeDevicePathSetReq(tapeDevicePathInfo, SMEOpcodeEnum.DELETE___TAPE___PATH);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = tapeGroupMessage.parseSMETapeGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (tapeGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to delete Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ", Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to delete Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ", Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to delete Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ", Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
            } else {
                String logMsg = "Failed to delete Path Tape Device: " + tapeDevicePathInfo.getTapeDeviceName() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public byte[] doExport(SMEContext ctx, String clusterId, TapeVolumeGroupInfo tapeVolumeGroup, String password) throws SMEException {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            return ckmcBean.doExport(ctx, clusterId, tapeVolumeGroup, password);
        }
        String logMsg = "Export Failed. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
        _Logger.warn((Object)logMsg);
        throw new SMEProcessingException(logMsg);
    }

    @Override
    public byte[] doExportFilter(SMEContext ctx, String clusterId, TapeVolumeGroupInfo tapeVolumeGroup, String password, FilterInfo filter) throws SMEException {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            return ckmcBean.doExportFilter(ctx, clusterId, tapeVolumeGroup, password, filter);
        }
        String logMsg = "Export Failed. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
        _Logger.warn((Object)logMsg);
        throw new SMEProcessingException(logMsg);
    }

    @Override
    public OperationStatus doImport(SMEContext ctx, TapeVolumeGroupInfo tapeVolumeGroup, ImportObject importObject, String password) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.doImport(ctx, tapeVolumeGroup, importObject, password);
        } else {
            String logMsg = "Import Failed. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public ArrayList<TapeInfo> tapeDeviceNameFix(SMEContext ctx, String tapeGroupName, ArrayList<TapeInfo> tapeInfoList) {
        int id = this.getTapeDeviceTreeNodes(ctx, tapeGroupName).size();
        for (TapeInfo ti : tapeInfoList) {
            ti.setTapeDeviceName("td" + id++);
        }
        return tapeInfoList;
    }

    @Override
    public ArrayList<KeyInfo> getTapeVolumeGroupKeyList(SMEContext ctx, String clusterName, String tapeGroupName, String volumeGroupName) {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            return ckmcBean.getTapeVolumeGroupKeyList(ctx, clusterName, tapeGroupName, volumeGroupName);
        }
        return new ArrayList<KeyInfo>();
    }

    @Override
    public OperationStatus rekeyVolumeGroups(SMEContext ctx) {
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        ArrayList<TapeVolumeGroupInfo> volumeGroups = new ArrayList<TapeVolumeGroupInfo>();
        ArrayList<TapeGroupInfo> tapeGroups = this.getTapeGroupInfoList(ctx, ctx.getCluster().getClusterName());
        for (TapeGroupInfo tgi : tapeGroups) {
            ArrayList<TapeVolumeGroupInfo> vgs = this.getTapeVolumeGroupInfoList(ctx, tgi.getClusterName(), tgi.getTapeGroupName());
            volumeGroups.addAll(vgs);
        }
        for (TapeVolumeGroupInfo tvgi : volumeGroups) {
            ctx.setTapeGroupStatus(TapeGroupStatusEnum.Active);
            ret = this.rekeyTapeVolumeGroup(ctx, tvgi.getClusterName(), tvgi.getTapeGroupName(), tvgi.getVolumeGroupName());
            if (ret.getStatus() != OperationStatusEnum.Success) {
                _Logger.warn((Object)(" Failed to re-key Tape Volume Group " + tvgi.getVolumeGroupName() + " in Tape Group " + tvgi.getTapeGroupName() + " in cluster " + tvgi.getClusterName()));
                continue;
            }
            _Logger.warn((Object)(" Re-keyed Tape Volume Group " + tvgi.getVolumeGroupName() + " in Tape Group " + tvgi.getTapeGroupName() + " in cluster " + tvgi.getClusterName()));
        }
        return ret;
    }

    @Override
    public OperationStatus createReplicationRelationship(SMEContext ctx, TapeVolumeGroupInfo source, TapeVolumeGroupInfo destination) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.createReplicationRelationship(ctx, source, destination);
        } else {
            String logMsg = "Failed to create replication relationship. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus deleteReplicationRelationship(SMEContext ctx, TapeVolumeGroupInfo source, TapeVolumeGroupInfo destination) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.deleteReplicationRelationship(ctx, source, destination);
        } else {
            String logMsg = "Failed to delete replication relationship. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    private OperationStatus deleteSrcReplicationRelationship(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.deleteSrcReplicationRelationship(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
        } else {
            String logMsg = "Failed to delete replication relationship from cluster " + clusterName + " Tape Group " + tapeGroupName + " Tape Volume Group Name " + tapeVolumeGroupName + ". Failed to access KMC server";
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    private OperationStatus deleteDestReplicationRelationship(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.deleteDestReplicationRelationship(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
        } else {
            String logMsg = "Failed to delete replication relationship to cluster " + clusterName + " Tape Group " + tapeGroupName + " Tape Volume Group Name " + tapeVolumeGroupName + ". Failed to access KMC server";
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    @Override
    public ArrayList<SMEReplicationRelationship> getReplicationRelationships(SMEContext ctx, TapeVolumeGroupInfo source) {
        ArrayList<SMEReplicationRelationship> list = null;
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            list = ckmcBean.getReplicationRelationships(source);
        } else {
            String logMsg = "Failed to get replication relationship. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            _Logger.warn((Object)logMsg);
        }
        return list;
    }

    @Override
    public MasterkeyRekeyInfo masterKeyRekey(SMEContext ctx, String masterKeyGuid) {
        ArrayList<KeyInfo> sanityWrapKeyList;
        MasterkeyRekeyInfo stateMgr = new MasterkeyRekeyInfo();
        String clusterName = ctx.getCluster().getClusterName();
        String entityIndexWC = clusterName + ":%";
        String currentMasterKeyGuid = null;
        stateMgr = new MasterkeyRekeyInfo();
        stateMgr.setState(MasterkeyRekeyStateEnum.None);
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean == null) {
            String logMsg = "KMC server access failed for Cluster " + clusterName;
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        ClusterInfo cluster = this.clusterBean.getClusterInfo(ctx, clusterName);
        if (cluster != null) {
            currentMasterKeyGuid = cluster.getMasterKeyGuid();
            stateMgr.setNewMasterKeyGUID(currentMasterKeyGuid);
        }
        if (currentMasterKeyGuid == null) {
            String logMsg = "Query of new master key for " + clusterName + "failed";
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (masterKeyGuid == null || masterKeyGuid.length() == 0) {
            ArrayList<ClusterSmartcardInfo> cscList = ckmcBean.getClusterSmarcardInfo(clusterName, currentMasterKeyGuid);
            int currentVersion = 0;
            for (ClusterSmartcardInfo csci : cscList) {
                if (!csci.getMasterKeyGUID().equals(currentMasterKeyGuid)) continue;
                currentVersion = Integer.valueOf(csci.getMasterKeyVersion());
            }
            for (ClusterSmartcardInfo csci : cscList) {
                int thisKeyVersion = Integer.valueOf(csci.getMasterKeyVersion());
                if (thisKeyVersion != currentVersion - 1) continue;
                masterKeyGuid = csci.getMasterKeyGUID();
            }
        }
        stateMgr.setOldMasterKeyGUID(masterKeyGuid);
        if (masterKeyGuid == null) {
            String logMsg = "Query of old master key for " + clusterName + "failed.";
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (masterKeyGuid.equals(currentMasterKeyGuid)) {
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, "The detected old and new MasterKey GUID's are identical.");
            _Logger.warn((Object)ret.getDescription());
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
        }
        if (cluster.getLockState().equals((Object)ClusterLockEnum.None)) {
            _Logger.error((Object)"We should be locked at this point, doesn't seem so.");
        }
        stateMgr.setTotalActiveKeys(0);
        ArrayList<KeyInfo> wrapKeyList = ckmcBean.getTapeKeysWrappedByGUID(ctx, entityIndexWC, masterKeyGuid);
        int archivedKeys = wrapKeyList.size();
        stateMgr.setTotalArchivedKeys(archivedKeys);
        _Logger.debug((Object)("initial setup returning with count of " + archivedKeys + " wrap keys"));
        stateMgr.setState(MasterkeyRekeyStateEnum.Initializing);
        if (archivedKeys == 0 && !(sanityWrapKeyList = ckmcBean.getTapeKeysWrappedByGUID(ctx, entityIndexWC, currentMasterKeyGuid)).isEmpty()) {
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, "The KMC and Master Switch are in inconsistent states.  You must restart the masterkey rekey process.");
            _Logger.warn((Object)ret.getDescription());
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        return stateMgr;
    }

    @Override
    public MasterkeyRekeyInfo masterKeyRekey(SMEContext ctx, MasterkeyRekeyInfo stateMgr) {
        if (stateMgr == null || MasterkeyRekeyStateEnum.None.equals((Object)stateMgr.getState())) {
            stateMgr = new MasterkeyRekeyInfo();
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, "Failed to initialize object");
            _Logger.error((Object)ret.getDescription());
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setState(MasterkeyRekeyStateEnum.None);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        stateMgr.setErrorFlag(false);
        stateMgr.setErrorStatus(null);
        String clusterName = ctx.getCluster().getClusterName();
        String entityIndexWC = clusterName + ":%";
        String currentMasterKeyGuid = stateMgr.getNewMasterKeyGUID();
        String masterKeyGuid = stateMgr.getOldMasterKeyGUID();
        _Logger.debug((Object)("masterKeyRekey - entry for cluster " + clusterName + " rewrapping from old guid " + masterKeyGuid + " to new guid " + currentMasterKeyGuid));
        long startTime = System.currentTimeMillis();
        _Logger.debug((Object)("masterKeyRekey state: " + (Object)((Object)stateMgr.getState())));
        currentMasterKeyGuid = stateMgr.getNewMasterKeyGUID();
        if (currentMasterKeyGuid == null) {
            String logMsg = "Missing new master key, suggest retry";
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean == null) {
            String logMsg = "KMC server access failed for Cluster " + clusterName;
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (MasterkeyRekeyStateEnum.Initializing.equals((Object)stateMgr.getState())) {
            stateMgr.setState(MasterkeyRekeyStateEnum.Active);
        }
        if (MasterkeyRekeyStateEnum.Active.equals((Object)stateMgr.getState())) {
            OperationStatus rekeyStatus = this.rekeyVolumeGroups(ctx);
            if (!OperationStatusEnum.Success.equals(rekeyStatus.getStatus())) {
                _Logger.warn((Object)rekeyStatus.getDescription());
                stateMgr.getErrorStatus().add(rekeyStatus);
                stateMgr.setErrorFlag(true);
                return stateMgr;
            }
            _Logger.info((Object)"finished with active keys lets return");
            stateMgr.setState(MasterkeyRekeyStateEnum.ActiveComplete);
            return stateMgr;
        }
        if (MasterkeyRekeyStateEnum.ActiveComplete.equals((Object)stateMgr.getState())) {
            stateMgr.setState(MasterkeyRekeyStateEnum.Archived);
        }
        if (MasterkeyRekeyStateEnum.Archived.equals((Object)stateMgr.getState())) {
            OperationStatus cloneStatus = this.clusterBean.cloneVolumeGroupKeys(ctx, stateMgr.getOldMasterKeyGUID());
            if (!OperationStatusEnum.Success.equals(cloneStatus.getStatus())) {
                _Logger.warn((Object)cloneStatus.getDescription());
                stateMgr.getErrorStatus().add(cloneStatus);
                stateMgr.setErrorFlag(true);
                return stateMgr;
            }
            _Logger.info((Object)"finished with wrap keys lets return");
            stateMgr.setState(MasterkeyRekeyStateEnum.ArchivedComplete);
            return stateMgr;
        }
        OperationStatus ret = new OperationStatus();
        ret.set(OperationStatusEnum.Failure, "Unexpected state.");
        _Logger.warn((Object)ret.getDescription());
        stateMgr.getErrorStatus().add(ret);
        stateMgr.setErrorFlag(true);
        return stateMgr;
    }
}

