/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.message;

import com.cisco.dcbu.sme.common.SerialQualifierRangeInfo;
import com.cisco.dcbu.sme.common.SerialQualifierRegexInfo;
import com.cisco.dcbu.sme.common.SerialQualifierTypeEnum;
import com.cisco.dcbu.sme.common.SerialRangeInfo;
import com.cisco.dcbu.sme.common.TapeDeviceInfo;
import com.cisco.dcbu.sme.common.TapeDevicePathInfo;
import com.cisco.dcbu.sme.common.TapeGroupInfo;
import com.cisco.dcbu.sme.common.TapeVolumeGroupInfo;
import com.cisco.dcbu.sme.common.TapeVolumeInfo;
import com.cisco.dcbu.sme.message.SMEMessageBase;
import com.cisco.dcbu.sme.xml.SMELunPathUserConfig;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPath;
import com.cisco.dcbu.sme.xml.SMERange;
import com.cisco.dcbu.sme.xml.SMETableData;
import com.cisco.dcbu.sme.xml.SMETableEnum;
import com.cisco.dcbu.sme.xml.SMETapeBackupGroupIndex;
import com.cisco.dcbu.sme.xml.SMETapeBackupGroupObject;
import com.cisco.dcbu.sme.xml.SMETapeDeviceIndex;
import com.cisco.dcbu.sme.xml.SMETapeDeviceObject;
import com.cisco.dcbu.sme.xml.SMETapeDevicePathIndex;
import com.cisco.dcbu.sme.xml.SMETapeDevicePathObject;
import com.cisco.dcbu.sme.xml.SMETapeGroupGetReq;
import com.cisco.dcbu.sme.xml.SMETapeGroupSetReq;
import com.cisco.dcbu.sme.xml.SMETapeVolumeData;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupData;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupIndex;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupObject;
import com.cisco.dcbu.sme.xml.SMETapeVolumeIndex;
import com.cisco.dcbu.sme.xml.SMETapeVolumeObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class TapeGroupMessage
extends SMEMessageBase {
    public String prepareTapeGroupSetReq(TapeGroupInfo tapeGroupInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMETapeGroupSetReq tapeGroupSetReq = new SMETapeGroupSetReq();
        SMETapeBackupGroupObject object = new SMETapeBackupGroupObject();
        SMETapeBackupGroupIndex index = new SMETapeBackupGroupIndex();
        index.setCluster_Name(tapeGroupInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeGroupInfo.getTapeGroupName());
        object.setIndex(index);
        tapeGroupSetReq.setTape_BackupGroup(object);
        tableData.setTapeGroup_Set_Req(tapeGroupSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeDeviceSetReq(TapeDeviceInfo tapeGroupDeviceInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMETapeGroupSetReq tapeGroupSetReq = new SMETapeGroupSetReq();
        SMETapeDeviceObject object = new SMETapeDeviceObject();
        SMETapeDeviceIndex index = new SMETapeDeviceIndex();
        index.setCluster_Name(tapeGroupDeviceInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeGroupDeviceInfo.getTapeGroupName());
        index.setTape_Device_Name(tapeGroupDeviceInfo.getDeviceName());
        object.setIndex(index);
        tapeGroupSetReq.setTape_Device(object);
        tableData.setTapeGroup_Set_Req(tapeGroupSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " tapedevice: " + index.getTape_Device_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeVolumeGroupSetReq(TapeVolumeGroupInfo tapeVolumeGroupInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMETapeGroupSetReq tapeGroupSetReq = new SMETapeGroupSetReq();
        SMETapeVolumeGroupObject object = new SMETapeVolumeGroupObject();
        SMETapeVolumeGroupIndex index = new SMETapeVolumeGroupIndex();
        index.setCluster_Name(tapeVolumeGroupInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeVolumeGroupInfo.getTapeGroupName());
        index.setTape_VolumeGroup_Name(tapeVolumeGroupInfo.getVolumeGroupName());
        object.setIndex(index);
        if (opcode.equals((Object)SMEOpcodeEnum.UPDATE___TAPE___VOLUME___GROUP___BARCODE___MATCHING___RULE)) {
            SMETapeVolumeGroupData data = new SMETapeVolumeGroupData();
            if (tapeVolumeGroupInfo.getQualifier().getType() == SerialQualifierTypeEnum.Range) {
                SerialQualifierRangeInfo qualRange = (SerialQualifierRangeInfo)tapeVolumeGroupInfo.getQualifier();
                ArrayList<SerialRangeInfo> rangeInfoList = qualRange.getRangeList();
                List rangeList = data.getRange();
                for (int i = 0; i < rangeInfoList.size(); ++i) {
                    SerialRangeInfo ri = rangeInfoList.get(i);
                    SMERange r = new SMERange();
                    r.setStart(ri.getStart());
                    r.setEnd(ri.getEnd());
                    rangeList.add(r);
                }
            } else if (tapeVolumeGroupInfo.getQualifier().getType() == SerialQualifierTypeEnum.Regex) {
                SerialQualifierRegexInfo qualRegex = (SerialQualifierRegexInfo)tapeVolumeGroupInfo.getQualifier();
                data.setBarcode_Regex(qualRegex.getRegex());
            }
            object.setData(data);
        }
        tapeGroupSetReq.setTape_VolumeGroup(object);
        tableData.setTapeGroup_Set_Req(tapeGroupSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " volumegroup: " + index.getTape_VolumeGroup_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeVolumeSetReq(TapeVolumeInfo tapeVolumeInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMETapeGroupSetReq tapeGroupSetReq = new SMETapeGroupSetReq();
        SMETapeVolumeObject object = new SMETapeVolumeObject();
        SMETapeVolumeIndex index = new SMETapeVolumeIndex();
        index.setCluster_Name(tapeVolumeInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeVolumeInfo.getTapeGroupName());
        index.setTape_VolumeGroup_Name(tapeVolumeInfo.getVolumeGroupName());
        index.setBarcode(tapeVolumeInfo.getBarCode());
        object.setIndex(index);
        if (!opcode.equals((Object)SMEOpcodeEnum.DELETE___TAPE___VOLUME)) {
            SMETapeVolumeData data = new SMETapeVolumeData();
            object.setData(data);
        }
        tapeGroupSetReq.setTape_Volume(object);
        tableData.setTapeGroup_Set_Req(tapeGroupSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " volumegroup: " + index.getTape_VolumeGroup_Name() + " barcode: " + index.getBarcode()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeDevicePathSetReq(TapeDevicePathInfo tapePathInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMETapeGroupSetReq tapeGroupSetReq = new SMETapeGroupSetReq();
        SMETapeDevicePathObject object = new SMETapeDevicePathObject();
        SMETapeDevicePathIndex index = new SMETapeDevicePathIndex();
        index.setCluster_Name(tapePathInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapePathInfo.getTapeGroupName());
        index.setTape_Device_Name(tapePathInfo.getTapeDeviceName());
        SMELunPathUserConfig lunPath = new SMELunPathUserConfig();
        lunPath.setLun(tapePathInfo.getPath().getLunId());
        SMEPath path = new SMEPath();
        path.setInitiator(tapePathInfo.getPath().getInitiator());
        path.setTarget(tapePathInfo.getPath().getTarget());
        path.setFabric(tapePathInfo.getPath().getFabricName());
        path.setVSAN(Integer.valueOf(tapePathInfo.getPath().getVsanId()));
        lunPath.setPath(path);
        index.setPath(lunPath);
        object.setIndex(index);
        tapeGroupSetReq.setTape_Device_Path(object);
        tableData.setTapeGroup_Set_Req(tapeGroupSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " tapedevice: " + index.getTape_Device_Name() + " initiator: " + path.getInitiator() + " target: " + path.getTarget() + " lun: " + lunPath.getLun() + " fabric: " + path.getFabric() + " vsan: " + path.getVSAN()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeGroupGetReq(TapeGroupInfo tapeGroupInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, SMEOpcodeEnum.GET___TAPE___GROUP, count));
        SMETableData tableData = new SMETableData();
        SMETapeGroupGetReq tapeGroupGetReq = new SMETapeGroupGetReq();
        SMETapeBackupGroupIndex index = new SMETapeBackupGroupIndex();
        index.setCluster_Name(tapeGroupInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeGroupInfo.getTapeGroupName());
        tapeGroupGetReq.setTape_BackupGroup_Index(index);
        tableData.setTapeGroup_Get_Req(tapeGroupGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeDeviceGetReq(TapeDeviceInfo tapeGroupDeviceInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, SMEOpcodeEnum.GET___TAPE___DEVICE, count));
        SMETableData tableData = new SMETableData();
        SMETapeGroupGetReq tapeGroupGetReq = new SMETapeGroupGetReq();
        SMETapeDeviceIndex index = new SMETapeDeviceIndex();
        index.setCluster_Name(tapeGroupDeviceInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeGroupDeviceInfo.getTapeGroupName());
        index.setTape_Device_Name(tapeGroupDeviceInfo.getDeviceName());
        tapeGroupGetReq.setTape_Device_Index(index);
        tableData.setTapeGroup_Get_Req(tapeGroupGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " tapedevice: " + index.getTape_Device_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeDevicePathGetReq(TapeDevicePathInfo tapePathInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, SMEOpcodeEnum.GET___TAPE___PATH, count));
        SMETableData tableData = new SMETableData();
        SMETapeGroupGetReq tapeGroupGetReq = new SMETapeGroupGetReq();
        SMETapeDevicePathIndex index = new SMETapeDevicePathIndex();
        index.setCluster_Name(tapePathInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapePathInfo.getTapeGroupName());
        index.setTape_Device_Name(tapePathInfo.getTapeDeviceName());
        if (tapePathInfo.getPath() != null) {
            SMELunPathUserConfig lunPath = new SMELunPathUserConfig();
            lunPath.setLun(tapePathInfo.getPath().getLunId());
            SMEPath path = new SMEPath();
            path.setInitiator(tapePathInfo.getPath().getInitiator());
            path.setTarget(tapePathInfo.getPath().getTarget());
            path.setFabric(tapePathInfo.getPath().getFabricName());
            path.setVSAN(Integer.valueOf(tapePathInfo.getPath().getVsanId()));
            lunPath.setPath(path);
            index.setPath(lunPath);
        }
        tapeGroupGetReq.setTape_Device_Path_Index(index);
        tableData.setTapeGroup_Get_Req(tapeGroupGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " tapedevice: " + index.getTape_Device_Name()));
        if (index.getPath() != null) {
            _Logger.info((Object)(" initiator: " + index.getPath().getPath().getInitiator() + " target: " + index.getPath().getPath().getTarget() + " lun: " + index.getPath().getLun() + " fabric: " + index.getPath().getPath().getFabric() + " vsan: " + index.getPath().getPath().getVSAN()));
        }
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeVolumeGroupGetReq(TapeVolumeGroupInfo tapeVolumeGroupInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, SMEOpcodeEnum.GET___TAPE___VOLUME___GROUP, count));
        SMETableData tableData = new SMETableData();
        SMETapeGroupGetReq tapeGroupGetReq = new SMETapeGroupGetReq();
        SMETapeVolumeGroupIndex index = new SMETapeVolumeGroupIndex();
        index.setCluster_Name(tapeVolumeGroupInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeVolumeGroupInfo.getTapeGroupName());
        index.setTape_VolumeGroup_Name(tapeVolumeGroupInfo.getVolumeGroupName());
        tapeGroupGetReq.setTape_VolumeGroup_Index(index);
        tableData.setTapeGroup_Get_Req(tapeGroupGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " volumegroup: " + index.getTape_VolumeGroup_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTapeVolumeGetReq(TapeVolumeInfo tapeVolumeInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.TAPEGROUP___TABLE, SMEOpcodeEnum.GET___TAPE___VOLUME, count));
        SMETableData tableData = new SMETableData();
        SMETapeGroupGetReq tapeGroupGetReq = new SMETapeGroupGetReq();
        SMETapeVolumeIndex index = new SMETapeVolumeIndex();
        index.setCluster_Name(tapeVolumeInfo.getClusterName());
        index.setTape_BackupGroup_Name(tapeVolumeInfo.getTapeGroupName());
        index.setTape_VolumeGroup_Name(tapeVolumeInfo.getVolumeGroupName());
        index.setBarcode(tapeVolumeInfo.getBarCode());
        tapeGroupGetReq.setTape_Volume_Index(index);
        tableData.setTapeGroup_Get_Req(tapeGroupGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tapegroup: " + index.getTape_BackupGroup_Name() + " volumegroup: " + index.getTape_VolumeGroup_Name() + " barcode: " + index.getBarcode()));
        return this.buildSmeMessage(smeMessage);
    }

    public SMEMessage parseSMETapeGroupResponse(InputStream msg) {
        return this.parseSmeMessage(msg);
    }
}

