/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.smartcard;

import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.smartcard.SmartcardCluster;
import com.cisco.dcbu.sme.smartcard.SmartcardInfo;
import com.cisco.dcbu.sme.smartcard.SmartcardLogger;
import com.cisco.dcbu.sme.smartcard.SmartcardRSA;
import com.cisco.dcbu.sme.smartcard.SmartcardRecoveryShare;
import com.cisco.dcbu.sme.smartcard.SmartcardSlot;
import com.cisco.dcbu.sme.smartcard.SmartcardStatusEnum;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Data;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;

public class Smartcard {
    private ArrayList<SmartcardCluster> clusters;
    private SmartcardInfo smartcardInfo;
    private Session session;
    private SmartcardSlot smartcardSlot;
    private String user;
    private SmartcardRSA smartcardRSA = null;
    public static String SO_DEFAULT_PIN = "1234";
    public static String USER_DEFAULT_PIN = "1234";
    public static boolean USER = true;
    public static final String GLOBAL_LABEL = "GLOBAL";
    public static final String GLOBAL_RSA_KEY_LABEL = "GLOBAL_RSA";
    public static final String GLOBAL_PEER_RSA_KEY_LABEL = "PEER_RSA";
    public static final String CLUSTER_OBJECT_LABEL = "CLUSTER";
    public static final String RECOVERY_SHARE_OBJECT_LABEL = "RECOVERY_SHARE";
    private boolean cleanupCalled = false;

    public Session getSession() {
        return this.session;
    }

    public SmartcardSlot getSmartcardSlot() {
        return this.smartcardSlot;
    }

    public String getUser() {
        return this.user;
    }

    public SmartcardRSA getSmartcardRSA() {
        return this.smartcardRSA;
    }

    public void setSmartcardRSA(SmartcardRSA smartcardRSA) {
        this.smartcardRSA = smartcardRSA;
    }

    public SmartcardCluster getSmartcardCluster(String clusterName, String clusterID) {
        int size = this.clusters.size();
        for (int i = 0; i < size; ++i) {
            SmartcardCluster cluster = this.clusters.get(i);
            if (!cluster.getClusterName().equals(clusterName) || !cluster.getClusterID().equals(clusterID)) continue;
            return cluster;
        }
        return null;
    }

    public Smartcard(SmartcardSlot smartcardSlot, String user) throws Exception {
        this.smartcardSlot = smartcardSlot;
        this.user = user;
        try {
            Token token = smartcardSlot.getSlot().getToken();
            this.smartcardInfo = new SmartcardInfo(this);
            this.session = token.openSession(true, true, null, null);
            this.readLabel();
            this.clusters = new ArrayList();
        }
        catch (Exception e) {
            if (this.session != null) {
                this.disconnect();
            }
            SmartcardLogger.warn("Exception reading smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
            throw e;
        }
    }

    public SmartcardInfo getSmartcardinfo() {
        return this.smartcardInfo;
    }

    private void readLabel() throws Exception {
        this.session.findObjectsInit(null);
        iaik.pkcs.pkcs11.objects.Object[] objects = this.session.findObjects(1);
        while (objects.length > 0) {
            iaik.pkcs.pkcs11.objects.Object object = objects[0];
            if (object instanceof Data) {
                Data data = (Data)object;
                if (!data.getApplication().toString().equals(this.user)) {
                    objects = this.session.findObjects(1);
                    continue;
                }
                String label = data.getLabel().toString();
                if (label.equals(GLOBAL_LABEL)) {
                    this.smartcardInfo.restorePKCS11Object(this, data);
                }
            }
            objects = this.session.findObjects(1);
        }
        this.session.findObjectsFinal();
    }

    public void flushObjects() {
        boolean more = true;
        try {
            while (more) {
                this.session.findObjectsInit(null);
                iaik.pkcs.pkcs11.objects.Object[] objects = this.session.findObjects(1);
                this.session.findObjectsFinal();
                if (objects.length > 0) {
                    iaik.pkcs.pkcs11.objects.Object object = objects[0];
                    this.session.destroyObject(object);
                    continue;
                }
                more = false;
            }
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
        }
    }

    private void readPKCS11Objects(String reqLabel) {
        try {
            RSAPublicKey rsaPublicKey = null;
            RSAPrivateKey rsaPrivateKey = null;
            this.session.findObjectsInit(null);
            iaik.pkcs.pkcs11.objects.Object[] objects = this.session.findObjects(1);
            while (objects.length > 0) {
                iaik.pkcs.pkcs11.objects.Object object = objects[0];
                if (object instanceof Data) {
                    Data data = (Data)object;
                    if (!data.getApplication().toString().equals(this.user)) {
                        objects = this.session.findObjects(1);
                        continue;
                    }
                    String label = data.getLabel().toString();
                    if (label.equals(reqLabel) == Boolean.FALSE.booleanValue()) {
                        objects = this.session.findObjects(1);
                        continue;
                    }
                    if (label.equals(CLUSTER_OBJECT_LABEL)) {
                        SmartcardCluster cluster = SmartcardCluster.restorePKCS11Object(this, data);
                        this.clusters.add(cluster);
                    } else if (label.equals(RECOVERY_SHARE_OBJECT_LABEL)) {
                        SmartcardRecoveryShare rs = SmartcardRecoveryShare.restorePKCS11Object(this, data);
                        rs.getCluster().addRecoveryShare(rs, false);
                    } else if (!label.equals(GLOBAL_LABEL)) {
                        SmartcardLogger.warn("Unknown Object:::::::::");
                    }
                } else if (object instanceof RSAPublicKey) {
                    rsaPublicKey = (RSAPublicKey)object;
                } else if (object instanceof RSAPrivateKey) {
                    rsaPrivateKey = (RSAPrivateKey)object;
                } else {
                    SmartcardLogger.warn("Unknown Object:::::::::");
                }
                objects = this.session.findObjects(1);
            }
            this.session.findObjectsFinal();
            SmartcardLogger.info("Done with iteration of objects for " + reqLabel);
            if (rsaPublicKey != null && rsaPrivateKey != null && reqLabel == null) {
                this.smartcardRSA = new SmartcardRSA(rsaPublicKey, rsaPrivateKey);
            }
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception reading smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
        }
    }

    private void readPKCS11Objects() {
        this.readPKCS11Objects(null);
        this.readPKCS11Objects(CLUSTER_OBJECT_LABEL);
        this.readPKCS11Objects(RECOVERY_SHARE_OBJECT_LABEL);
    }

    public int numRecoveryShares() {
        int numRS = 0;
        try {
            this.session.findObjectsInit(null);
            iaik.pkcs.pkcs11.objects.Object[] objects = this.session.findObjects(1);
            while (objects.length > 0) {
                iaik.pkcs.pkcs11.objects.Object object = objects[0];
                if (object instanceof Data) {
                    Data data = (Data)object;
                    if (!data.getApplication().toString().equals(this.user)) {
                        objects = this.session.findObjects(1);
                        continue;
                    }
                    String label = data.getLabel().toString();
                    if (label.equals(RECOVERY_SHARE_OBJECT_LABEL)) {
                        ++numRS;
                    } else {
                        objects = this.session.findObjects(1);
                        continue;
                    }
                }
                objects = this.session.findObjects(1);
            }
            this.session.findObjectsFinal();
            SmartcardLogger.info("We found " + numRS + " objects of " + RECOVERY_SHARE_OBJECT_LABEL);
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception reading smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
        }
        return numRS;
    }

    public SmartcardStatusEnum login(String pin, boolean restore) {
        try {
            if (pin == null) {
                SmartcardLogger.warn("Null pin specified");
                return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
            }
            this.session.login(USER, pin.toCharArray());
        }
        catch (Exception e) {
            SmartcardLogger.debug(e.getMessage());
            if (e.getMessage().contains("CKR_USER_ALREADY_LOGGED_IN")) {
                try {
                    SmartcardLogger.info("Already logged in. Going to logout and try again");
                    this.session.logout();
                    this.session.login(USER, pin.toCharArray());
                }
                catch (Exception e2) {
                    SmartcardLogger.warn("Exception while login to smartcard:" + e.getMessage());
                    SmartcardLogger.stackTrace(e);
                    return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
                }
            }
            SmartcardLogger.warn("Exception while login to smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
            return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
        }
        SmartcardLogger.debug("Session login");
        if (restore) {
            this.readPKCS11Objects();
        }
        return SmartcardStatusEnum.SME_SC_STATUS_SUCCESS;
    }

    public SmartcardStatusEnum login(String pin) {
        return this.login(pin, true);
    }

    public void logout() {
        try {
            this.session.logout();
            SmartcardLogger.debug("Session logged off");
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception logging off smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
        }
    }

    public SmartcardStatusEnum updatePin(String oldpin, String newpin) {
        try {
            this.session.setPIN(oldpin.toCharArray(), newpin.toCharArray());
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception updating smartcard pin:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
            return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
        }
        SmartcardLogger.debug("Updated smartcard pin");
        return SmartcardStatusEnum.SME_SC_STATUS_SUCCESS;
    }

    public SmartcardCluster getCluster(String clusterName, String clusterID) {
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!this.clusters.get(i).getClusterName().equals(clusterName) || !this.clusters.get(i).getClusterID().equals(clusterID)) continue;
            return this.clusters.get(i);
        }
        SmartcardLogger.info("No cluster found by cluster name: " + clusterName);
        return null;
    }

    public SmartcardStatusEnum createCluster(SmartcardCluster cluster) {
        if (this.getCluster(cluster.getClusterName(), cluster.getClusterID()) != null) {
            SmartcardLogger.debug("Cluster " + cluster + "already exists");
            return SmartcardStatusEnum.SME_SC_OBJECT_ALREADY_EXISTS;
        }
        OperationStatus ret = cluster.addPKCS11Object();
        if (ret.getStatus() == OperationStatusEnum.Success) {
            this.clusters.add(cluster);
            SmartcardLogger.debug("Created cluster " + cluster);
            return SmartcardStatusEnum.SME_SC_STATUS_SUCCESS;
        }
        SmartcardLogger.warn("Failed to create cluster " + cluster + "Error: " + ret.getDescription());
        return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
    }

    public SmartcardStatusEnum deleteCluster(String clusterName, String clusterID) {
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!this.clusters.get(i).getClusterName().equals(clusterName) || !this.clusters.get(i).getClusterID().equals(clusterID)) continue;
            if (this.clusters.get(i).getCurrRecoveryShare() == null) {
                this.clusters.get(i).deletePKCS11Object();
                this.clusters.remove(i);
                SmartcardLogger.debug("Deleted cluster " + this.clusters.get(i));
                return SmartcardStatusEnum.SME_SC_STATUS_SUCCESS;
            }
            SmartcardLogger.warn("Failed to delete cluster " + this.clusters.get(i) + " Recovery share exists");
            return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
        }
        SmartcardLogger.info("Failed to delete cluster " + clusterName + "ID " + clusterID + " cluster does not exist");
        return SmartcardStatusEnum.SME_SC_OBJECT_DOES_NOT_EXISTS;
    }

    public void listClusters() {
        for (int i = 0; i < this.clusters.size(); ++i) {
            this.clusters.get(i).print("");
        }
    }

    public SmartcardStatusEnum addRecoveryShare(SmartcardCluster cluster, SmartcardRecoveryShare share) {
        if (this.getRecoveryShare(cluster, share.getMasterKeyVersion()) != null) {
            return SmartcardStatusEnum.SME_SC_OBJECT_ALREADY_EXISTS;
        }
        OperationStatus ret = cluster.addRecoveryShare(share, true);
        if (ret.getStatus() != OperationStatusEnum.Success) {
            return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
        }
        return SmartcardStatusEnum.SME_SC_STATUS_SUCCESS;
    }

    public SmartcardStatusEnum deleteRecoveryShare(SmartcardCluster cluster, String masterKeyVersion) {
        OperationStatus ret = cluster.deleteRecoveryShare(masterKeyVersion);
        if (ret.getStatus() != OperationStatusEnum.Success) {
            return SmartcardStatusEnum.SME_SC_STATUS_FAILURE;
        }
        return SmartcardStatusEnum.SME_SC_STATUS_SUCCESS;
    }

    public SmartcardRecoveryShare unwrapRecoveryShare(SmartcardRecoveryShare recoveryShare) throws Exception {
        byte[] encryptedKey = new byte[]{};
        if (recoveryShare.getShare() != null) {
            encryptedKey = Base64.decodeBase64((byte[])recoveryShare.getShare().getBytes());
        }
        String cryptoAlgo = recoveryShare.getCryptoAlgo();
        byte[] goodEncryptedKey = new byte[1024];
        System.arraycopy(encryptedKey, 0, goodEncryptedKey, 0, encryptedKey.length);
        byte[] origKey = null;
        if (cryptoAlgo == null) {
            SmartcardLogger.error("Crypto algo not set, copy the encrypted key data");
            origKey = goodEncryptedKey;
        }
        if (cryptoAlgo != null) {
            if (cryptoAlgo.compareTo("SME_MSG_ASYMMETRIC_CRYPTO_ALGO_RSA_BLOCK64") == 0 || cryptoAlgo.endsWith("BLOCK_64") || cryptoAlgo.endsWith("BLOCK64")) {
                SmartcardLogger.info("RSA block 64 algo set");
                byte[] tmp_origKey = new byte[1024];
                int input_length = encryptedKey.length;
                int input_offset = 0;
                int output_length = 0;
                int output_offset = 0;
                while (input_length > 0) {
                    int tmp_input_length = 0;
                    byte[] tmp_output_key = null;
                    tmp_input_length = (long)input_length > this.smartcardRSA.getRsaPublicKey().getModulusBits().getLongValue() / 8L ? this.smartcardRSA.getRsaPublicKey().getModulusBits().getLongValue().intValue() / 8 : input_length;
                    SmartcardLogger.debug("Input length: " + input_length + ", chunk: " + tmp_input_length);
                    byte[] tmp_input_key = new byte[tmp_input_length];
                    System.arraycopy(goodEncryptedKey, input_offset, tmp_input_key, 0, tmp_input_length);
                    tmp_output_key = this.smartcardRSA.unwrapKey(this, tmp_input_key);
                    if (tmp_output_key == null) {
                        throw new Exception("unwrapKey returned null");
                    }
                    if (tmp_output_key.length > 64) {
                        throw new Exception("unwrapKey returned invalid length: " + tmp_output_key.length);
                    }
                    SmartcardLogger.debug("Chunk: in_off: " + input_offset + " out_off: " + output_offset + " tmp_in: " + tmp_input_length + " tmp_out: " + tmp_output_key.length);
                    if (output_offset + tmp_output_key.length >= tmp_origKey.length) {
                        throw new Exception("Output key doesn't have sufficient space");
                    }
                    System.arraycopy(tmp_output_key, 0, tmp_origKey, output_offset, tmp_output_key.length);
                    input_length -= tmp_input_length;
                    input_offset += tmp_input_length;
                    output_length += tmp_output_key.length;
                    output_offset += tmp_output_key.length;
                }
                SmartcardLogger.info("Generated original key of length " + output_length);
                origKey = new byte[output_length];
                System.arraycopy(tmp_origKey, 0, origKey, 0, output_length);
            } else {
                SmartcardLogger.error("Invalid crypto algo: " + cryptoAlgo);
                throw new Exception("Invalid crypto algo: " + cryptoAlgo);
            }
        }
        String origShare = new String(Base64.encodeBase64((byte[])origKey));
        return new SmartcardRecoveryShare(recoveryShare.getCluster(), recoveryShare.getMasterKeyVersion(), recoveryShare.getShareVersion(), recoveryShare.getGuid(), origShare, recoveryShare.getHdrVersion(), recoveryShare.getCryptoAlgo(), recoveryShare.getDigestAlgo(), recoveryShare.getDigestData(), recoveryShare.getKeyDataLength());
    }

    public SmartcardRecoveryShare wrapRecoveryShare(SmartcardRecoveryShare recoveryShare, byte[] peerRSAPublicKey) {
        byte[] key = Base64.decodeBase64((byte[])recoveryShare.getShare().getBytes());
        byte[] wrappedKey = this.smartcardRSA.wrapKey(this, key, peerRSAPublicKey);
        String wrappedShare = new String(Base64.encodeBase64((byte[])wrappedKey));
        return new SmartcardRecoveryShare(recoveryShare.getCluster(), recoveryShare.getMasterKeyVersion(), recoveryShare.getShareVersion(), recoveryShare.getGuid(), wrappedShare, recoveryShare.getHdrVersion(), recoveryShare.getCryptoAlgo(), recoveryShare.getDigestAlgo(), recoveryShare.getDigestData(), recoveryShare.getKeyDataLength());
    }

    public SmartcardRecoveryShare getRecoveryShare(SmartcardCluster cluster, String masterKeyVersion) {
        return cluster.getRecoveryShare(masterKeyVersion);
    }

    public SmartcardRecoveryShare getRecoveryShareByGUID(String guid) {
        SmartcardRecoveryShare rs = null;
        for (int i = 0; i < this.clusters.size(); ++i) {
            SmartcardCluster cluster = this.clusters.get(i);
            if (cluster == null || (rs = cluster.getRecoveryShareByGuid(guid)) == null) continue;
            return rs;
        }
        SmartcardLogger.info("No recovery share found for guid: " + guid);
        return null;
    }

    public void finalize() {
        this.disconnect();
    }

    public void disconnect() {
        if (!this.cleanupCalled) {
            this.cleanupCalled = true;
            try {
                this.session.closeSession();
                SmartcardLogger.debug("Closing smartcard session");
            }
            catch (Exception e) {
                SmartcardLogger.warn("Exception closing smartcard:" + e.getMessage());
                SmartcardLogger.stackTrace(e);
            }
        } else {
            SmartcardLogger.debug("NOT Closing smartcard session");
        }
    }
}

