/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.smartcard;

import com.cisco.dcbu.sme.common.RecoveryScheme;
import com.cisco.dcbu.sme.smartcard.EraserThread;
import com.cisco.dcbu.sme.smartcard.Smartcard;
import com.cisco.dcbu.sme.smartcard.SmartcardCluster;
import com.cisco.dcbu.sme.smartcard.SmartcardLogger;
import com.cisco.dcbu.sme.smartcard.SmartcardRSA;
import com.cisco.dcbu.sme.smartcard.SmartcardRecoveryShare;
import com.cisco.dcbu.sme.smartcard.SmartcardSlot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;

public class SmartcardClient {
    public SmartcardSlot smartcardSlot = null;
    public Smartcard smartcard = null;
    static BufferedReader input_;

    static String readLine() {
        try {
            return input_.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    static String fileRead(String pathName) {
        FileInputStream dataInputStream = null;
        ByteArrayOutputStream bufferStream = null;
        try {
            int bytesRead;
            dataInputStream = new FileInputStream(pathName);
            bufferStream = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)dataInputStream).read(buffer)) >= 0) {
                bufferStream.write(buffer, 0, bytesRead);
            }
            ((InputStream)dataInputStream).close();
        }
        catch (Exception e) {
            SmartcardLogger.stackTrace(e);
            return null;
        }
        return bufferStream.toString();
    }

    static void fileWrite(String pathName, String data) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(pathName);
            fileOutputStream.write(data.getBytes());
            fileOutputStream.close();
        }
        catch (Exception e) {
            SmartcardLogger.stackTrace(e);
        }
    }

    static String nextToken(StringTokenizer st) throws Exception {
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        throw new Exception();
    }

    void processHelp() {
        System.out.println("usage:");
        System.out.println("list                      -- List all objects in the smartcard");
        System.out.println("initialize  <pin> <label> -- Initialize the smartcard");
        System.out.println("dumppubkey               -- Dump the public key of the smartcard");
        System.out.println("recovery-share import <clustername> <clusterid> <master key version> <share version> <guid> <share-file> <hdr-version> <crypto-algo> <digest-algo> <digest-data> <keydata-length>");
        System.out.println("      -- Import a recovery share. It should be wrapped with the smartcard public key");
        System.out.println("recovery-share export <clustername> <clusterid> <master key version> <pubkey file> <share file>");
        System.out.println("      -- Export the share wrapped with the public key in the file");
        System.out.println("recovery-share-clear import <clustername> <clusterid> <master key version> <share version> <guid> <share-file> <hdr-version> <crypto-algo> <digest-algo> <digest-data> <keydata-length>");
        System.out.println("      -- Import a recovery share in clear (no wrapping or base64 encoding required)");
        System.out.println("recovery-share-clear export <clustername> <clusterid> <master key version> <share file>");
        System.out.println("      -- Export the share in clear (no wrapping or base64 encoding required)");
        System.out.println("recovery-share remove <clustername> <clusterid> <master key version>");
        System.out.println("      -- Remove a recovery share.");
        System.out.println("cluster add <clustername> <clusterid> <recovery-scheme>");
        System.out.println("      -- Add a cluster to the smartcard");
        System.out.println("cluster remove <clustername> <clusterid>");
        System.out.println("      -- Remove a cluster from the smartcard");
        System.out.println("base642bin <infile> <outfile>");
        System.out.println("bin2base64 <infile> <outfile>");
        System.out.println("updatepin <oldpin> <newpin>");
        System.out.println("quit               -- Quit the shell");
    }

    void processList() {
        System.out.println("---------------------------------------------------------------------");
        System.out.println("                       Smartcard Details");
        System.out.println("---------------------------------------------------------------------");
        this.smartcard.getSmartcardinfo().print();
        System.out.println("Remaining Pin Attempts = " + this.smartcard.getSmartcardinfo().getPinAttemptsLeft());
        System.out.println("---------------------------------------------------------------------");
        System.out.println("                       Listing Clusters");
        System.out.println("---------------------------------------------------------------------");
        this.smartcard.listClusters();
    }

    void processInitialize(String pin, String label) {
        String user = this.smartcard.getUser();
        this.smartcard.logout();
        this.smartcard = null;
        this.smartcard = this.smartcardSlot.initializeSmartcard(user, pin, label);
        this.smartcard.login(pin);
    }

    void processRecoveryShareImport(String clusterName, String clusterID, String masterKeyVersion, String shareVersion, String guid, String shareFile, String hdrVersion, String cryptoAlgo, String digestAlgo, String digestData, String keyDataLength) {
        SmartcardCluster cluster = this.smartcard.getCluster(clusterName, clusterID);
        if (cluster == null) {
            System.out.println("Cluster object not found");
            return;
        }
        String share = SmartcardClient.fileRead(shareFile);
        if (share == null) {
            System.out.println("Unable to read the share file");
        }
        SmartcardRecoveryShare rs = new SmartcardRecoveryShare(cluster, masterKeyVersion, shareVersion, guid, share, hdrVersion, cryptoAlgo, digestAlgo, digestData, keyDataLength);
        try {
            SmartcardRecoveryShare rsUnwrapped = this.smartcard.unwrapRecoveryShare(rs);
            this.smartcard.addRecoveryShare(cluster, rsUnwrapped);
        }
        catch (Exception e) {
            System.out.println("Got exception");
            SmartcardLogger.stackTrace(e);
        }
    }

    void processRecoveryShareExport(String clusterName, String clusterID, String masterKeyVersion, String pubkeyFile, String shareFile) {
        SmartcardCluster cluster = this.smartcard.getCluster(clusterName, clusterID);
        if (cluster == null) {
            System.out.println("Cluster object not found");
            return;
        }
        System.out.println("Reading publickey file " + pubkeyFile);
        String publicKey = SmartcardClient.fileRead(pubkeyFile);
        byte[] publicKeySpec = SmartcardRSA.getPublicKeySpec(publicKey);
        SmartcardRecoveryShare rs = this.smartcard.getRecoveryShare(cluster, masterKeyVersion);
        SmartcardRecoveryShare rsWrapped = this.smartcard.wrapRecoveryShare(rs, publicKeySpec);
        System.out.println("Writing shareFile " + shareFile);
        SmartcardClient.fileWrite(shareFile, rsWrapped.getShare());
    }

    void processRecoveryShareRemove(String clusterName, String clusterID, String masterKeyVersion) {
        SmartcardCluster cluster = this.smartcard.getCluster(clusterName, clusterID);
        if (cluster == null) {
            System.out.println("Cluster object not found");
            return;
        }
        this.smartcard.deleteRecoveryShare(cluster, masterKeyVersion);
    }

    void processRecoveryShareClearImport(String clusterName, String clusterID, String masterKeyVersion, String shareVersion, String guid, String shareFile, String hdrVersion, String cryptoAlgo, String digestAlgo, String digestData, String keyDataLength) {
        SmartcardCluster cluster = this.smartcard.getCluster(clusterName, clusterID);
        if (cluster == null) {
            System.out.println("Cluster object not found");
            return;
        }
        String share = SmartcardClient.fileRead(shareFile);
        if (share == null) {
            System.out.println("Unable to read the share file");
        }
        SmartcardRecoveryShare rs = new SmartcardRecoveryShare(cluster, masterKeyVersion, shareVersion, guid, share, hdrVersion, cryptoAlgo, digestAlgo, digestData, keyDataLength);
        this.smartcard.addRecoveryShare(cluster, rs);
    }

    void processRecoveryShareClearExport(String clusterName, String clusterID, String masterKeyVersion, String shareFile) {
        SmartcardCluster cluster = this.smartcard.getCluster(clusterName, clusterID);
        if (cluster == null) {
            System.out.println("Cluster object not found");
            return;
        }
        SmartcardRecoveryShare rs = this.smartcard.getRecoveryShare(cluster, masterKeyVersion);
        System.out.println("Writing shareFile " + shareFile);
        SmartcardClient.fileWrite(shareFile, rs.getShare());
        try {
            System.out.println("Unwrap the share now: " + rs);
            SmartcardRecoveryShare unrs = this.smartcard.unwrapRecoveryShare(rs);
            System.out.println("Got unwrapped share: " + unrs);
        }
        catch (Exception e) {
            System.out.println("Got exception");
            SmartcardLogger.stackTrace(e);
        }
    }

    void processClusterAdd(String clusterName, String clusterID, String recoverySchemeString) {
        RecoveryScheme recoveryScheme = RecoveryScheme.parseRecoveryScheme(recoverySchemeString);
        SmartcardCluster cluster = new SmartcardCluster(this.smartcard, clusterName, clusterID, recoveryScheme);
        this.smartcard.createCluster(cluster);
    }

    void processClusterRemove(String clusterName, String clusterID) {
        this.smartcard.deleteCluster(clusterName, clusterID);
    }

    void processPubKeyDump() {
        String pubKeyEncoded = this.smartcard.getSmartcardRSA().getPublicKeyEncoded(true);
        System.out.println(pubKeyEncoded);
    }

    void processBin2Base64(String infile, String outfile) {
        String buf = SmartcardClient.fileRead(infile);
        byte[] bufEncoded = Base64.encodeBase64Chunked((byte[])buf.getBytes());
        SmartcardClient.fileWrite(outfile, new String(bufEncoded));
    }

    void processBase642Bin(String infile, String outfile) {
        String buf = SmartcardClient.fileRead(infile);
        byte[] bufDecoded = Base64.decodeBase64((byte[])buf.getBytes());
        SmartcardClient.fileWrite(outfile, new String(bufDecoded));
    }

    void processDummy() {
        byte[] publicKey = SmartcardRSA.getPublicKeySpec(this.smartcard.getSmartcardRSA().getPublicKeyEncoded(true));
        byte[] data = new byte[20];
        this.smartcard.getSmartcardRSA().wrapKey(this.smartcard, data, publicKey);
    }

    void processUpdatePin(String oldpin, String newpin) {
        this.smartcard.updatePin(oldpin, newpin);
    }

    void processAction(String command, StringTokenizer st) throws Exception {
        if (command.compareToIgnoreCase("list") == 0) {
            this.processList();
            return;
        }
        if (command.compareToIgnoreCase("updatePin") == 0) {
            String oldpin = SmartcardClient.nextToken(st);
            String newpin = SmartcardClient.nextToken(st);
            this.processUpdatePin(oldpin, newpin);
        } else if (command.compareToIgnoreCase("recovery-share") == 0 || command.compareToIgnoreCase("rs") == 0) {
            String action = SmartcardClient.nextToken(st);
            if (action.compareToIgnoreCase("import") == 0) {
                this.processRecoveryShareImport(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
            if (action.compareToIgnoreCase("export") == 0) {
                this.processRecoveryShareExport(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
            if (action.compareToIgnoreCase("remove") == 0) {
                this.processRecoveryShareRemove(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
        } else if (command.compareToIgnoreCase("recovery-share-clear") == 0 || command.compareToIgnoreCase("rs") == 0) {
            String action = SmartcardClient.nextToken(st);
            if (action.compareToIgnoreCase("import") == 0) {
                this.processRecoveryShareClearImport(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
            if (action.compareToIgnoreCase("export") == 0) {
                this.processRecoveryShareClearExport(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
        } else if (command.compareToIgnoreCase("cluster") == 0) {
            String action = SmartcardClient.nextToken(st);
            if (action.compareToIgnoreCase("add") == 0) {
                this.processClusterAdd(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
            if (action.compareToIgnoreCase("remove") == 0) {
                this.processClusterRemove(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
        } else {
            if (command.compareToIgnoreCase("initialize") == 0 || command.compareToIgnoreCase("init") == 0) {
                this.processInitialize(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
                return;
            }
            if (command.compareToIgnoreCase("dumppubkey") == 0) {
                this.processPubKeyDump();
                return;
            }
            if (command.compareToIgnoreCase("bin2base64") == 0) {
                this.processBin2Base64(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
            } else if (command.compareToIgnoreCase("base642bin") == 0) {
                this.processBase642Bin(SmartcardClient.nextToken(st), SmartcardClient.nextToken(st));
            } else if (command.compareToIgnoreCase("dummy") == 0) {
                this.processDummy();
            } else if (command.compareToIgnoreCase("quit") == 0) {
                this.smartcard.disconnect();
                this.smartcardSlot.disconnect();
                System.exit(1);
            }
        }
        this.processHelp();
    }

    void process() {
        BufferedReader _input = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String cmdargs = null;
            try {
                cmdargs = _input.readLine();
            }
            catch (Exception e) {
                SmartcardLogger.stackTrace(e);
            }
            StringTokenizer st = new StringTokenizer(cmdargs);
            try {
                String command = SmartcardClient.nextToken(st);
                this.processAction(command, st);
                continue;
            }
            catch (Exception e) {
                SmartcardLogger.stackTrace(e);
                System.out.println("Error: unable to parse input -- Please refer to usage");
                this.processHelp();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        SmartcardSlot smartcardSlot;
        if (args.length != 1) {
            System.out.println("usage: SmartcardClient <gclib.dll>");
            System.exit(1);
        }
        EraserThread et = new EraserThread("Password: ");
        Thread mask = new Thread(et);
        mask.start();
        String password = SmartcardClient.readLine();
        et.stopMasking();
        if (!password.equals("SMe")) {
            System.out.println("Invalid Password");
            System.exit(1);
        }
        ArrayList<Object> smartcardSlots = new ArrayList();
        try {
            SmartcardSlot.connect(args[0]);
        }
        catch (Exception ex) {
            System.out.println("failed to initialize PKCS11 module - Exiting");
            SmartcardLogger.stackTrace(ex);
        }
        try {
            smartcardSlots = SmartcardSlot.getAllSmartcardSlots();
        }
        catch (Exception ex) {
            SmartcardLogger.stackTrace(ex);
        }
        if (smartcardSlots.size() == 0) {
            System.out.println("No smartcard slots present - Exiting");
            return;
        }
        System.out.println("-----------------------------------------------------------------------");
        System.out.println("Slot    Manufacturer   Model                     SerialNumber");
        System.out.println("-----------------------------------------------------------------------");
        for (int i = 0; i < smartcardSlots.size(); ++i) {
            smartcardSlot = (SmartcardSlot)smartcardSlots.get(i);
            Token token = null;
            TokenInfo tokInfo = null;
            try {
                token = smartcardSlot.getSlot().getToken();
                tokInfo = token.getTokenInfo();
            }
            catch (Exception e) {
                SmartcardLogger.stackTrace(e);
            }
            if (token != null) {
                System.out.printf("%-7d %-14s %-25s %s\n", i, tokInfo.getManufacturerID().trim(), tokInfo.getModel(), tokInfo.getSerialNumber());
                continue;
            }
            System.out.printf("%-7d %-14s %-25s %s\n", i, "--", "--", "--");
        }
        int slotID = 0;
        if (smartcardSlots.size() > 1) {
            System.out.printf("Please enter the slot id: ", new Object[0]);
            slotID = Integer.parseInt(SmartcardClient.readLine());
        }
        smartcardSlot = (SmartcardSlot)smartcardSlots.get(slotID);
        SmartcardClient smartcardClient = new SmartcardClient(smartcardSlot);
        smartcardClient.processHelp();
        smartcardClient.process();
    }

    public SmartcardClient(SmartcardSlot smartcardSlot) {
        this.smartcardSlot = smartcardSlot;
        smartcardSlot.waitForSmartcardInserted();
        System.out.printf("Please enter the user-id: ", new Object[0]);
        String user = SmartcardClient.readLine();
        EraserThread et = new EraserThread("Please enter the PIN: ");
        Thread mask = new Thread(et);
        mask.start();
        String pin = SmartcardClient.readLine();
        et.stopMasking();
        this.smartcard = smartcardSlot.getSmartcard(user);
        this.smartcard.login(pin);
    }

    static {
        try {
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Exception e) {
            SmartcardLogger.stackTrace(e);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }
}

