/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.smartcard;

import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.smartcard.Smartcard;
import com.cisco.dcbu.sme.smartcard.SmartcardCluster;
import com.cisco.dcbu.sme.smartcard.SmartcardLogger;
import com.cisco.dcbu.sme.smartcard.SmartcardTLV;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Data;

public class SmartcardRecoveryShare {
    private SmartcardCluster cluster;
    private String masterKeyVersion;
    private String shareVersion;
    private String guid;
    private String share;
    private String hdrVersion;
    private String cryptoAlgo;
    private String digestAlgo;
    private String digestData;
    private String keyDataLength;
    private Data data;
    static final String TLV_TYPE_CLUSTER = "CLUSTER";
    static final String TLV_TYPE_CLUSTER_ID = "CLUSTER_ID";
    static final String TLV_TYPE_MK_VERSION = "MK_VERSION";
    static final String TLV_TYPE_SHARE_VERSION = "SHARE_VERSION";
    static final String TLV_TYPE_GUID = "GUID";
    static final String TLV_TYPE_SHARE = "SHARE";
    static final String TLV_TYPE_HDR_VERSION = "HDR_VERSION";
    static final String TLV_TYPE_CRYPTO_ALGO = "CRYPTO_ALGO";
    static final String TLV_TYPE_DIGEST_ALGO = "DIGEST_ALGO";
    static final String TLV_TYPE_DIGEST_DATA = "DIGEST_DATA";
    static final String TLV_TYPE_KEY_DATA_LENGTH = "KEY_DATA_LENGTH";

    public SmartcardCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(SmartcardCluster cluster) {
        this.cluster = cluster;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getMasterKeyVersion() {
        return this.masterKeyVersion;
    }

    public void setMasterKeyVersion(String masterKeyVersion) {
        this.masterKeyVersion = masterKeyVersion;
    }

    public String getShare() {
        return this.share;
    }

    public void setShare(String share) {
        this.share = share;
    }

    public String getShareVersion() {
        return this.shareVersion;
    }

    public void setShareVersion(String shareVersion) {
        this.shareVersion = shareVersion;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public String getHdrVersion() {
        return this.hdrVersion;
    }

    public void setHdrversion(String hdrVersion) {
        this.hdrVersion = hdrVersion;
    }

    public String getCryptoAlgo() {
        return this.cryptoAlgo;
    }

    public void setCryptoAlgo(String cryptoAlgo) {
        this.cryptoAlgo = cryptoAlgo;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    public void setDigestAlgo(String digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    public String getDigestData() {
        return this.digestData;
    }

    public void setDigestData(String digestData) {
        this.digestData = digestData;
    }

    public String getKeyDataLength() {
        return this.keyDataLength;
    }

    public void setKeyDataLength(String keyDataLength) {
        this.keyDataLength = keyDataLength;
    }

    public SmartcardRecoveryShare(SmartcardCluster cluster, String masterKeyVersion, String shareVersion, String guid, String share, String hdrVersion, String cryptoAlgo, String digestAlgo, String digestData, String keyDataLength) {
        this.cluster = cluster;
        this.masterKeyVersion = masterKeyVersion;
        this.shareVersion = shareVersion;
        this.guid = guid;
        this.share = share;
        this.hdrVersion = hdrVersion;
        this.cryptoAlgo = cryptoAlgo;
        this.digestAlgo = digestAlgo;
        this.digestData = digestData;
        this.keyDataLength = keyDataLength;
        this.data = null;
    }

    public void print(String tab) {
        SmartcardLogger.info(tab + "Master key version : " + this.masterKeyVersion);
        SmartcardLogger.debug(tab + "Share version : " + this.shareVersion);
        SmartcardLogger.info(tab + "GUID : " + this.guid);
        SmartcardLogger.debug(tab + "Share : Length " + this.share.length());
        SmartcardLogger.debug(tab + "HdrVersion " + this.hdrVersion);
        SmartcardLogger.debug(tab + "cryptoAlgo " + this.cryptoAlgo);
        SmartcardLogger.debug(tab + "digestAlgo " + this.digestAlgo);
        SmartcardLogger.debug(tab + "digestData " + this.digestData);
        SmartcardLogger.debug(tab + "keyDataLength " + this.keyDataLength);
    }

    public boolean equals(SmartcardRecoveryShare rs) {
        return this.getCluster().equals(rs.getCluster()) && this.getMasterKeyVersion().equals(rs.getMasterKeyVersion());
    }

    public int compareTo(SmartcardRecoveryShare rs) {
        int ret = this.getCluster().compareTo(rs.getCluster());
        if (ret == 0) {
            ret = this.getMasterKeyVersion().compareTo(rs.getMasterKeyVersion());
        }
        return ret;
    }

    public OperationStatus addPKCS11Object() {
        OperationStatus ret = new OperationStatus();
        try {
            Session session = this.cluster.getSmartcard().getSession();
            Data dataObjectTemplate = this.data;
            if (dataObjectTemplate == null) {
                dataObjectTemplate = new Data();
                dataObjectTemplate.getApplication().setCharArrayValue(this.cluster.getSmartcard().getUser().toCharArray());
                dataObjectTemplate.getLabel().setCharArrayValue("RECOVERY_SHARE".toCharArray());
                dataObjectTemplate.getToken().setBooleanValue(Boolean.TRUE);
                dataObjectTemplate.getPrivate().setBooleanValue(Boolean.TRUE);
            }
            dataObjectTemplate.getValue().setByteArrayValue(null);
            SmartcardTLV.addTLV(TLV_TYPE_CLUSTER, this.cluster.getClusterName(), dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_CLUSTER_ID, this.cluster.getClusterID(), dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_MK_VERSION, this.masterKeyVersion, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_SHARE_VERSION, this.shareVersion, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_GUID, this.guid, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_SHARE, this.share, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_HDR_VERSION, this.hdrVersion, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_CRYPTO_ALGO, this.cryptoAlgo, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_DIGEST_ALGO, this.digestAlgo, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_DIGEST_DATA, this.digestData, dataObjectTemplate.getValue());
            SmartcardTLV.addTLV(TLV_TYPE_KEY_DATA_LENGTH, this.keyDataLength, dataObjectTemplate.getValue());
            Data oldData = this.data;
            this.data = (Data)session.createObject(dataObjectTemplate);
            if (oldData != null) {
                session.destroyObject(oldData);
            }
            ret.setStatus(OperationStatusEnum.Success);
            SmartcardLogger.debug(" Recoveryshare strored from smartcard");
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception storing recoveryshare from smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
            ret.setStatus(OperationStatusEnum.Failure);
        }
        return ret;
    }

    public OperationStatus deletePKCS11Object() {
        OperationStatus ret = new OperationStatus();
        try {
            Session session = this.cluster.getSmartcard().getSession();
            session.destroyObject(this.data);
            ret.setStatus(OperationStatusEnum.Success);
            SmartcardLogger.debug(" Recoveryshare deleted from smartcard");
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception deleting recoveryshare from smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
            ret.setStatus(OperationStatusEnum.Failure);
        }
        return ret;
    }

    public static SmartcardRecoveryShare restorePKCS11Object(Smartcard smartcard, Data data) {
        String clusterName = SmartcardTLV.getTLV(TLV_TYPE_CLUSTER, data.getValue());
        String clusterID = SmartcardTLV.getTLV(TLV_TYPE_CLUSTER_ID, data.getValue());
        String masterKeyVersion = SmartcardTLV.getTLV(TLV_TYPE_MK_VERSION, data.getValue());
        String shareVersion = SmartcardTLV.getTLV(TLV_TYPE_SHARE_VERSION, data.getValue());
        String guid = SmartcardTLV.getTLV(TLV_TYPE_GUID, data.getValue());
        String share = SmartcardTLV.getTLV(TLV_TYPE_SHARE, data.getValue());
        String hdrVersion = SmartcardTLV.getTLV(TLV_TYPE_HDR_VERSION, data.getValue());
        String cryptoAlgo = SmartcardTLV.getTLV(TLV_TYPE_CRYPTO_ALGO, data.getValue());
        String digestAlgo = SmartcardTLV.getTLV(TLV_TYPE_DIGEST_ALGO, data.getValue());
        String digestData = SmartcardTLV.getTLV(TLV_TYPE_DIGEST_DATA, data.getValue());
        String keyDataLength = SmartcardTLV.getTLV(TLV_TYPE_KEY_DATA_LENGTH, data.getValue());
        SmartcardCluster cluster = smartcard.getSmartcardCluster(clusterName, clusterID);
        SmartcardRecoveryShare rs = new SmartcardRecoveryShare(cluster, masterKeyVersion, shareVersion, guid, share, hdrVersion, cryptoAlgo, digestAlgo, digestData, keyDataLength);
        rs.setData(data);
        return rs;
    }
}

