/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.util;

import com.cisco.dcbu.sme.util.Eraser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MigrateDB {
    private static Properties config = new Properties();
    private static final String[] tables = new String[]{"SME_SETTINGS", "SME_CLUSTER", "SME_CLUSTER_ATTRIBUTES", "SME_CLUSTER_SMARTCARD", "SME_TAPE_GROUP", "SME_TAPE_VOLUMEGROUP", "SME_KEY", "SME_ACCOUNTING_LOG", "SME_REPLICATION_REL", "SME_REPL_PENDING_KEY", "SME_REPL_ERROR_KEY", "QRTZ_JOB_DETAILS", "QRTZ_TRIGGERS", "QRTZ_JOB_LISTENERS", "QRTZ_TRIGGER_LISTENERS", "QRTZ_FIRED_TRIGGERS", "QRTZ_PAUSED_TRIGGER_GRPS", "QRTZ_SIMPLE_TRIGGERS", "QRTZ_CRON_TRIGGERS", "QRTZ_BLOB_TRIGGERS", "QRTZ_CALENDARS"};
    public static final String POSTGRES = "postgres";
    public static final String ORACLE = "oracle";
    public static final String OSQLDRIVER = "oracle.jdbc.OracleDriver";
    public static final String OSQLURL = "jdbc:oracle:thin:@localhost:1521:XE";
    public static final String PSQLDRIVER = "org.postgresql.Driver";
    private static Driver delegate;
    private static String srcDriver;
    private static String srcUrl;
    private static String srcUser;
    private static String srcPswd;
    private static String destDriver;
    private static String destUrl;
    private static String destUser;
    private static String destPswd;
    private static String srcDB;
    private static String destDB;
    private static Logger logger;
    static BufferedReader input_;

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception ex) {
                System.err.println("Unable to close connection: " + ex.getMessage());
            }
        }
    }

    private static Connection connect(String url, Properties info) throws SQLException {
        return delegate.connect(url, info);
    }

    public static void initDriver(String driver) throws Exception {
        delegate = (Driver)Class.forName(driver).newInstance();
        DriverManager.registerDriver(delegate);
    }

    public static Connection getConnection(String url, String driver, String user, String password) {
        Connection con = null;
        try {
            MigrateDB.initDriver(driver);
            DriverManager.setLoginTimeout(5);
            Properties info = new Properties();
            info.setProperty("user", user);
            info.setProperty("password", password);
            info.setProperty("loginTimeout", "20");
            con = MigrateDB.connect(url, info);
        }
        catch (ClassNotFoundException ce) {
            MigrateDB.log(Level.SEVERE, " Unable to connect to " + url + " Error: " + ce.getMessage(), true);
            MigrateDB.logStackTrace(ce.getStackTrace());
        }
        catch (SQLException sqle) {
            MigrateDB.log(Level.SEVERE, " Unable to connect to " + url + " Error: " + sqle.getMessage(), true);
            MigrateDB.logStackTrace(sqle.getStackTrace());
        }
        catch (IllegalAccessException iae) {
            MigrateDB.log(Level.SEVERE, " Unable to connect to " + url + " Error: " + iae.getMessage(), true);
            MigrateDB.logStackTrace(iae.getStackTrace());
        }
        catch (Exception ex) {
            MigrateDB.log(Level.SEVERE, " Unable to connect to " + url + " Error: " + ex.getMessage(), true);
            MigrateDB.logStackTrace(ex.getStackTrace());
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateTables() {
        Connection srcCon = MigrateDB.getConnection(srcUrl, srcDriver, srcUser, srcPswd);
        if (srcCon == null) {
            MigrateDB.log(Level.SEVERE, "Failed to connect to old database. No tables will be migrated.", true);
            return;
        }
        Connection destCon = MigrateDB.getConnection(destUrl, destDriver, destUser, destPswd);
        if (destCon == null) {
            MigrateDB.log(Level.SEVERE, "Failed to connect to new database. No tables will be migrated.", true);
            return;
        }
        try {
            for (String table : tables) {
                ResultSet mySet;
                ResultSet rs;
                Statement myStmt;
                Statement stmt;
                block79: {
                    stmt = null;
                    myStmt = null;
                    rs = null;
                    mySet = null;
                    MigrateDB.log(Level.INFO, "Migration Start for " + table, true);
                    String query = MigrateDB.constructSQL(srcUrl, srcDriver, srcUser, srcPswd, table);
                    stmt = srcCon.createStatement(1004, 1007);
                    try {
                        rs = stmt.executeQuery(query);
                    }
                    catch (Exception e) {
                        if (!e.getMessage().toUpperCase().contains("RELATION \"" + table + "\" DOES NOT EXIST")) break block79;
                        MigrateDB.log(Level.WARNING, "Table " + table + " doesnot exist in source database. Skipping", true);
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sqle) {
                            MigrateDB.logStackTrace(sqle.getStackTrace());
                        }
                        try {
                            if (myStmt != null) {
                                myStmt.close();
                            }
                        }
                        catch (SQLException sqle) {
                            MigrateDB.logStackTrace(sqle.getStackTrace());
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sqle) {
                            MigrateDB.logStackTrace(sqle.getStackTrace());
                        }
                        try {
                            if (mySet == null) continue;
                            mySet.close();
                        }
                        catch (SQLException sqle) {
                            MigrateDB.logStackTrace(sqle.getStackTrace());
                        }
                        continue;
                    }
                }
                try {
                    myStmt = destCon.createStatement(1005, 1008);
                    String toquery = MigrateDB.constructSQL(destUrl, destDriver, destUser, destPswd, table);
                    mySet = myStmt.executeQuery(toquery);
                    ResultSetMetaData myMeta = mySet.getMetaData();
                    int col = myMeta.getColumnCount();
                    Class<?> mySetClass = mySet.getClass();
                    boolean count = false;
                    while (rs.next()) {
                        ResultSetMetaData meta = rs.getMetaData();
                        if (col != meta.getColumnCount()) {
                            MigrateDB.log(Level.WARNING, meta.getTableName(1) + " schema are different", true);
                        }
                        mySet.moveToInsertRow();
                        try {
                            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                                int type = myMeta.getColumnType(i);
                                String colName = myMeta.getColumnName(i);
                                String className = myMeta.getColumnClassName(i);
                                if (!colName.equalsIgnoreCase(meta.getColumnName(i))) {
                                    MigrateDB.log(Level.WARNING, "Column Names are not the same for table " + table + ", skipping..", true);
                                    continue;
                                }
                                String cName = className.substring(className.lastIndexOf(46) + 1, className.length());
                                char c = Character.toUpperCase(cName.charAt(0));
                                if ((cName = c + cName.substring(1)).equals("[B") || cName.equals("Byte[]")) {
                                    byte[] values = rs.getBytes(colName);
                                    mySet.updateBytes(colName, values);
                                    continue;
                                }
                                if (cName.equals("Integer")) {
                                    cName = "Int";
                                } else if (cName.equalsIgnoreCase("TIMESTAMP")) {
                                    cName = "Timestamp";
                                }
                                Class[] arg = new Class[]{String.class};
                                Method meth = rs.getClass().getMethod("get" + cName, arg);
                                Object obj = meth.invoke((Object)rs, colName);
                                Class[] arg1 = new Class[]{String.class, MigrateDB.getPrimitiveClassName(className)};
                                Method method = mySetClass.getMethod("update" + cName, arg1);
                                method.invoke((Object)mySet, colName, obj);
                            }
                            mySet.insertRow();
                        }
                        catch (Throwable ex) {
                            MigrateDB.log(Level.WARNING, "Failed to insert record for table " + table + " Error: " + ex.getMessage(), false);
                            MigrateDB.logStackTrace(ex.getStackTrace());
                        }
                    }
                    destCon.commit();
                }
                catch (Throwable e) {
                    MigrateDB.log(Level.WARNING, "Failed to migrate record for table " + table + " Error: " + e.getMessage(), false);
                    MigrateDB.logStackTrace(e.getStackTrace());
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle) {
                        MigrateDB.logStackTrace(sqle.getStackTrace());
                    }
                    try {
                        if (myStmt != null) {
                            myStmt.close();
                        }
                    }
                    catch (SQLException sqle) {
                        MigrateDB.logStackTrace(sqle.getStackTrace());
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle) {
                        MigrateDB.logStackTrace(sqle.getStackTrace());
                    }
                    try {
                        if (mySet != null) {
                            mySet.close();
                        }
                    }
                    catch (SQLException sqle) {
                        MigrateDB.logStackTrace(sqle.getStackTrace());
                    }
                }
                MigrateDB.log(Level.INFO, "Migration Finished for " + table, true);
            }
        }
        catch (Exception e) {
            MigrateDB.logStackTrace(e.getStackTrace());
        }
        finally {
            try {
                if (srcCon != null) {
                    srcCon.close();
                }
            }
            catch (SQLException sqle) {
                MigrateDB.logStackTrace(sqle.getStackTrace());
            }
            try {
                if (destCon != null) {
                    destCon.close();
                }
            }
            catch (SQLException sqle) {
                MigrateDB.logStackTrace(sqle.getStackTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String constructSQL(String url, String driver, String user, String passwd, String table) throws SQLException {
        if (url.indexOf(ORACLE) > 0) {
            StringBuffer sql = new StringBuffer("SELECT ");
            Connection con = null;
            ResultSet columns = null;
            try {
                con = MigrateDB.getConnection(url, driver, user, passwd);
                DatabaseMetaData meta = con.getMetaData();
                columns = meta.getColumns(null, "%", table, "%");
                while (columns.next()) {
                    String col = columns.getString("COLUMN_NAME");
                    sql.append(table + "." + col + ",");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(" FROM " + table);
            }
            catch (Exception ex) {
            }
            finally {
                if (columns != null) {
                    columns.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            return sql.toString();
        }
        return "select * from " + table;
    }

    private static Class getPrimitiveClassName(String className) throws Exception {
        String clas = className.substring(className.lastIndexOf(46) + 1, className.length());
        if (clas.equals("Long")) {
            return Long.TYPE;
        }
        if (clas.equals("Integer")) {
            return Integer.TYPE;
        }
        if (clas.equals("Short")) {
            return Short.TYPE;
        }
        if (clas.equals("Double")) {
            return Double.TYPE;
        }
        if (clas.equals("Byte")) {
            return Byte.TYPE;
        }
        if (clas.equals("Float")) {
            return Float.TYPE;
        }
        if (clas.equals("[B")) {
            return Byte.TYPE;
        }
        if (clas.equals("Boolean")) {
            return Boolean.TYPE;
        }
        if (clas.equals("TIMESTAMP")) {
            return Timestamp.class;
        }
        return Class.forName(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadConfig() {
        String configFile = "smedbmigration.properties";
        File f = new File(configFile);
        if (f.exists()) {
            MigrateDB.log(Level.INFO, "File " + f.getAbsolutePath() + " found", false);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                config.load(fis);
                boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                MigrateDB.log(Level.WARNING, "Failed to read file " + f.getAbsolutePath(), true);
                MigrateDB.log(Level.WARNING, "Error: " + ex.getMessage(), false);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        MigrateDB.log(Level.WARNING, "File " + f.getAbsolutePath() + " not found", true);
        return false;
    }

    public static void readConfig() {
        String property = null;
        property = config.getProperty("src.db.url");
        if (property != null) {
            srcUrl = property;
        }
        if ((property = config.getProperty("src.db.type")) != null) {
            srcDB = property;
        }
        if ((property = config.getProperty("src.db.user")) != null) {
            srcUser = property;
        }
        if ((property = config.getProperty("dest.db.url")) != null) {
            destUrl = property;
        }
        if ((property = config.getProperty("dest.db.type")) != null) {
            destDB = property;
        }
        if ((property = config.getProperty("dest.db.user")) != null) {
            destUser = property;
        }
    }

    static String readLine() {
        try {
            return input_.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void getDBPasswords() {
        try {
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Exception e) {
            MigrateDB.logStackTrace(e.getStackTrace());
        }
        do {
            Eraser et1 = new Eraser("Please enter the passsword for user " + srcUser + " on source database " + srcUrl + " :");
            Thread mask1 = new Thread(et1);
            mask1.start();
            srcPswd = MigrateDB.readLine();
            et1.stopMasking();
        } while (srcPswd == null);
        System.out.println("");
        do {
            Eraser et2 = new Eraser("Please enter the passsword for user " + destUser + " on destination database " + destUrl + " :");
            Thread mask2 = new Thread(et2);
            mask2.start();
            destPswd = MigrateDB.readLine();
            et2.stopMasking();
        } while (destPswd == null);
    }

    public static void log(Level level, String msg, boolean console) {
        System.out.println("[" + level.toString() + "] " + msg);
    }

    public static void logStackTrace(StackTraceElement[] msg) {
        if (msg != null) {
            for (StackTraceElement m : msg) {
                System.out.println("                              " + m.toString());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (!MigrateDB.loadConfig()) {
            System.exit(1);
        }
        MigrateDB.readConfig();
        MigrateDB.getDBPasswords();
        if (srcDB.equalsIgnoreCase(POSTGRES)) {
            srcDriver = PSQLDRIVER;
        } else if (srcDB.equalsIgnoreCase(ORACLE)) {
            srcDriver = OSQLDRIVER;
        } else {
            MigrateDB.log(Level.WARNING, "Invalid source DB type: " + srcDB + " for database: " + srcUrl, true);
            return;
        }
        if (destDB.equalsIgnoreCase(POSTGRES)) {
            destDriver = PSQLDRIVER;
        } else if (destDB.equalsIgnoreCase(ORACLE)) {
            destDriver = OSQLDRIVER;
        } else {
            MigrateDB.log(Level.WARNING, "Invalid destination DB type: " + destDB + " for database: " + destUrl, true);
            return;
        }
        MigrateDB.log(Level.INFO, "Migrating database from " + srcUrl + " to " + destUrl, true);
        MigrateDB.migrateTables();
        MigrateDB.log(Level.INFO, "Migration complete", true);
    }

    static {
        srcDriver = null;
        srcUrl = null;
        srcUser = null;
        srcPswd = null;
        destDriver = null;
        destUrl = null;
        destUser = null;
        destPswd = null;
        srcDB = null;
        destDB = null;
        logger = null;
    }
}

