/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.xmltool;

import com.cisco.dcbu.sme.xmltool.Data;
import com.cisco.dcbu.sme.xmltool.IO;
import com.cisco.dcbu.sme.xmltool.SimpleType;
import com.cisco.dcbu.sme.xmltool.StructElement;

public class Struct {
    private String structName;
    private StructElement[] element = new StructElement[100];
    private int index = 0;
    private final String TAB = "     ";
    private boolean choice = false;
    private boolean shouldDefine = true;
    private boolean hidden = false;

    public StructElement[] getallElement() {
        return this.element;
    }

    public Struct setElement(StructElement element) {
        this.element[this.index++] = element;
        return this;
    }

    public String getStructName() {
        return this.structName;
    }

    public void setStructName(String structName) {
        this.structName = structName;
    }

    public void print() {
        System.out.println("StructName: " + this.getStructName() + " elements: " + this.index);
        for (int i = 0; i < this.index; ++i) {
            this.element[i].print();
        }
    }

    public void generateDefines(IO io, Data data) {
        for (int i = 0; i < this.index; ++i) {
            if (this.element[i].getDefineName().length() == 0) continue;
            io.writetofile("#define " + this.element[i].getDefineName() + "   " + this.element[i].getMaxOccurs());
        }
    }

    public void generateCStructuresPass1(IO io, Data data) {
        if (this.index != 0) {
            if (this.isChoice()) {
                io.writetofile("typedef union " + this.structName.toLowerCase() + "_ " + this.structName.toLowerCase() + ";");
            } else {
                io.writetofile("typedef struct " + this.structName.toLowerCase() + "_ " + this.structName.toLowerCase() + ";");
            }
        }
    }

    public void generateCStructuresPass2(IO io, Data data) {
        if (this.index != 0) {
            if (!this.shouldDefine) {
                return;
            }
            if (this.isChoice()) {
                io.writetofile("typedef enum " + this.structName.toLowerCase() + "_enum {");
                for (int i = 0; i < this.index; ++i) {
                    if (i < this.index - 1) {
                        io.writetofile("     " + this.structName.toUpperCase() + "__" + this.element[i].getName().toUpperCase() + " = " + (i + 1) + ",");
                        continue;
                    }
                    io.writetofile("     " + this.structName.toUpperCase() + "__" + this.element[i].getName().toUpperCase() + " = " + (i + 1));
                }
                io.writetofile("}" + this.structName.toLowerCase() + "_enum_t;");
                io.writetofile(" ");
            }
        }
    }

    public void generateCStructuresPass3(IO io, Data data) {
        if (this.index != 0) {
            for (int i = 0; i < this.index; ++i) {
                if (data.isSimpleType(this.element[i].getType()) || !data.getStructbyType(this.element[i].getType()).isChoice()) continue;
                io.writetofile("typedef struct " + this.element[i].getType().toLowerCase() + "_u_{ ");
                io.writetofile("     enum " + this.element[i].getType().toLowerCase() + "_enum " + "type;");
                this.element[i].generateCStructure(io, data, "");
                io.writetofile("}" + this.element[i].getType().toLowerCase() + "_u;");
                io.writetofile(" ");
            }
        }
    }

    public void generateCStructuresPass4(IO io, Data data) {
        if (this.index != 0) {
            for (int i = 0; i < this.index; ++i) {
                if (!this.element[i].isVariable()) continue;
                if (this.isChoice()) {
                    io.writetofile("#define GET_" + this.structName.toUpperCase() + "__" + this.element[i].getName().toUpperCase() + "(rootPtr, parentPtr, offset_id) ((char* )rootPtr +  parentPtr->" + this.element[i].getName().toLowerCase() + "_wrap._" + this.element[i].getName().toLowerCase() + "_offset" + "[offset_id])");
                } else {
                    io.writetofile("#define GET_" + this.structName.toUpperCase() + "__" + this.element[i].getName().toUpperCase() + "(rootPtr, parentPtr, offset_id) ((char* )rootPtr +  parentPtr->" + this.element[i].getName().toLowerCase() + "_wrap._" + this.element[i].getName().toLowerCase() + "_offset" + "[offset_id])");
                }
                io.writetofile(" ");
            }
        }
    }

    public void generateCStructuresPass5(IO io, Data data) {
        if (this.index != 0) {
            if (!this.shouldDefine) {
                return;
            }
            io.writetofile(" ");
            if (this.isChoice()) {
                io.writetofile("typedef union " + this.structName.toLowerCase() + "_{");
            } else {
                io.writetofile("typedef struct " + this.structName.toLowerCase() + "_{");
            }
            for (int i = 0; i < this.index; ++i) {
                if (!data.isSimpleType(this.element[i].getType())) {
                    System.out.println(this.structName + " " + this.element[i].getName() + " " + i);
                    if (data.getStructbyType(this.element[i].getType()).isChoice()) {
                        io.writetofile("     struct{");
                        io.writetofile("          enum " + this.element[i].getType().toLowerCase() + "_enum " + "type;");
                        this.element[i].generateCStructure(io, data, "     ");
                        io.writetofile("     }" + this.element[i].getType().toLowerCase() + "_u;");
                        continue;
                    }
                    this.element[i].generateCStructure(io, data, "");
                    continue;
                }
                this.element[i].generateCStructure(io, data, "");
            }
            io.writetofile("}" + this.getStructName().toLowerCase() + ";");
            io.writetofile(" ");
        }
    }

    public void generateCParseFunctions(IO io, Data data) {
        if (!this.shouldDefine) {
            return;
        }
        if (this.index != 0) {
            int i;
            io.writetofile(" ");
            io.writetofile("/* Method to parse " + this.structName + " node */");
            io.writetofile("uint parse" + this.structName.toLowerCase() + "(xmlDocPtr doc, xmlNodePtr cur" + ", void **current_offset_ptr" + ", " + this.structName.toLowerCase() + " *ptr" + (this.isChoice() ? ", enum " + this.structName.toLowerCase() + "_enum *type){" : "){"));
            io.writetofile(" ");
            io.writetofile("     xmlChar *temp = NULL;");
            io.writetofile("     uint error = 0;");
            io.writetofile(" ");
            for (i = 0; i < this.index; ++i) {
                if (!this.element[i].isVariable()) continue;
                io.writetofile("     " + this.element[i].getType().toLowerCase() + " " + this.element[i].getName().toLowerCase() + ";");
            }
            io.writetofile("     memset(ptr, 0, sizeof(" + this.structName.toLowerCase() + "));");
            io.writetofile(" ");
            io.writetofile("     cur = cur->xmlChildrenNode;");
            io.writetofile(" ");
            io.writetofile("     while (cur != NULL) {");
            for (i = 0; i < this.index; ++i) {
                this.element[i].generateCParseFunctions(io, data, this);
                if (this.element[i].getMaxOccurs() > 1) {
                    io.writetofile("               }");
                }
                io.writetofile("          }");
            }
            io.writetofile("          if(temp != NULL){");
            io.writetofile("               xmlFree(temp);");
            io.writetofile("               temp = NULL;");
            io.writetofile("          }");
            io.writetofile("          cur = cur->next;");
            io.writetofile("     }");
            io.writetofile("     return error;");
            io.writetofile("}");
        }
    }

    public void generateCBuildFunctions(IO io, Data data) {
        if (!this.shouldDefine) {
            return;
        }
        if (this.index != 0) {
            int i;
            io.writetofile(" ");
            io.writetofile("/* Method to build " + this.structName + " node */");
            io.writetofile(" ");
            io.writetofile("xmlNodePtr build" + this.structName.toLowerCase() + "(xmlNodePtr parent, void *rootPtr, " + this.structName.toLowerCase() + " *ptr" + (this.isChoice() ? ", uint memberid" : "") + "){");
            for (i = 0; i < this.index; ++i) {
                this.element[i].listNodePointers(io, data);
            }
            io.writetofile(" ");
            io.writetofile("     if(parent == NULL)");
            io.writetofile("          parent = xmlNewNode(NULL, BAD_CAST \"" + this.structName.split("_T$")[0] + "\");");
            io.writetofile(" ");
            if (this.isChoice()) {
                io.writetofile("     switch(memberid){");
            }
            for (i = 0; i < this.index; ++i) {
                if (this.isChoice()) {
                    io.writetofile("          case " + this.structName.toUpperCase() + "__" + this.element[i].getName().toUpperCase() + ": {");
                }
                this.element[i].generateCBuildFunctions(io, data, this.structName, this.isChoice() ? "          " : "", this);
                if (this.isChoice()) {
                    io.writetofile("               break;");
                    io.writetofile("          }");
                }
                io.writetofile(" ");
            }
            if (this.isChoice()) {
                io.writetofile("     }");
            }
            io.writetofile("     return parent;");
            io.writetofile("}");
        }
    }

    public void generateCParseFunctionsDefines(IO io, Data data) {
        if (!this.shouldDefine) {
            return;
        }
        if (this.index != 0) {
            io.writetofile(" ");
            io.writetofile("/* Method to parse " + this.structName + " node */");
            io.writetofile("uint parse" + this.structName.toLowerCase() + "(xmlDocPtr doc, xmlNodePtr cur" + ", void **current_offset_ptr" + ", " + this.structName.toLowerCase() + " *ptr" + (this.isChoice() ? ", enum " + this.structName.toLowerCase() + "_enum *type);" : ");"));
        }
    }

    public void generateCBuildFunctionsDefines(IO io, Data data) {
        if (!this.shouldDefine) {
            return;
        }
        if (this.index != 0) {
            io.writetofile(" ");
            io.writetofile("/* Method to build " + this.structName + " node */");
            io.writetofile(" ");
            io.writetofile("xmlNodePtr build" + this.structName.toLowerCase() + "(xmlNodePtr parent, void *rootPtr, " + this.structName.toLowerCase() + " *ptr" + (this.isChoice() ? ", uint memberid" : "") + ");");
        }
    }

    public boolean isChoice() {
        return this.choice;
    }

    public Struct setChoice(boolean choice) {
        this.choice = choice;
        return this;
    }

    public boolean isShouldDefine() {
        return this.shouldDefine;
    }

    public void setShouldDefine(boolean shouldDefine) {
        this.shouldDefine = shouldDefine;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void generateEndianConversion(IO io, Data data, boolean ntoh, boolean gen_header) {
        String suffix;
        if (!this.shouldDefine) {
            return;
        }
        String string = suffix = ntoh ? "_ntoh" : "_hton";
        if (this.isChoice()) {
            return;
        }
        io.writetofile("void " + this.structName.toLowerCase() + suffix + "( " + this.structName.toLowerCase() + " *" + this.structName.toLowerCase() + ")" + (gen_header ? ";\n" : ""));
        if (gen_header) {
            return;
        }
        io.writetofile("{");
        for (int i = 0; i < this.index; ++i) {
            SimpleType simpleType;
            String ele_type = this.element[i].getType().toLowerCase();
            String ele_name = this.element[i].getName().toLowerCase();
            String struct_name = this.structName.toLowerCase();
            Struct struct = data.getStructbyType(this.element[i].getType());
            if (struct != null && !struct.isChoice()) {
                int maxOccurs = this.element[i].getMaxOccurs();
                String tab = "     ";
                if (maxOccurs > 1) {
                    String cstr = struct_name + "->" + ele_name + "_wrap._" + ele_name;
                    io.writetofile(tab + cstr + "_count = " + (ntoh ? "ntohl(" : "htonl(") + cstr + "_count);");
                    io.writetofile(tab + "{");
                    tab = tab + "     ";
                    io.writetofile(tab + "int count;");
                    io.writetofile(tab + "for (count = 0; count < " + (this.element[i].getDefineName().length() > 0 ? this.element[i].getDefineName() : "" + maxOccurs) + "; count++) ");
                    tab = tab + "     ";
                    if (this.element[i].isVariable()) {
                        io.writetofile(tab + cstr + "_offset[count] = " + (ntoh ? "ntohl(" : "htonl(") + cstr + "_offset[count]);");
                    } else {
                        String sstr = struct_name + "->" + ele_name + "_wrap." + ele_name;
                        io.writetofile(tab + ele_type + suffix + "(&" + sstr + "[count]);");
                    }
                    io.writetofile("     }");
                } else {
                    io.writetofile(tab + ele_type + suffix + "(&" + struct_name + "->" + ele_name + ");");
                }
            }
            if ((simpleType = data.getSimpleTypeByName(this.element[i].getType())) == null || simpleType.EndianFunction(ntoh) == null) continue;
            if (!simpleType.isShouldDefine()) {
                io.writetofile("     " + simpleType.EndianFunction(ntoh) + "(&" + this.structName.toLowerCase() + "->" + this.element[i].getName().toLowerCase() + ");");
                continue;
            }
            io.writetofile("     " + this.structName.toLowerCase() + "->" + this.element[i].getName().toLowerCase() + " = " + simpleType.EndianFunction(ntoh) + "(" + this.structName.toLowerCase() + "->" + this.element[i].getName().toLowerCase() + ");");
        }
        io.writetofile("}\n");
    }
}

