/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.client.cim;

import com.cisco.dcbu.smis.client.CIMBase;
import com.cisco.dcbu.smis.client.cim.CIM_VoltageSensor;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public class VoltageSensor
extends CIMBase
implements CIM_VoltageSensor {
    private static final String mClassVersion = "2.8.0";
    private static final String[] mKeys = new String[]{"SystemCreationClassName", "SystemName", "CreationClassName", "DeviceID"};
    private static final String CPN_SENSORTYPE = "SensorType";
    private static final String CPN_BASEUNITS = "BaseUnits";
    private static final String CPN_UNITMODIFIER = "UnitModifier";
    private static final String CPN_RATEUNITS = "RateUnits";
    private static final String CPN_CURRENTREADING = "CurrentReading";
    private static final String CPN_NOMINALREADING = "NominalReading";
    private static final String CPN_NORMALMAX = "NormalMax";
    private static final String CPN_NORMALMIN = "NormalMin";
    private static final String CPN_MAXREADABLE = "MaxReadable";
    private static final String CPN_MINREADABLE = "MinReadable";
    private static final String CPN_RESOLUTION = "Resolution";
    private static final String CPN_TOLERANCE = "Tolerance";
    private static final String CPN_ACCURACY = "Accuracy";
    private static final String CPN_LOWERTHRESHOLDNONCRITICAL = "LowerThresholdNonCritical";
    private static final String CPN_UPPERTHRESHOLDNONCRITICAL = "UpperThresholdNonCritical";
    private static final String CPN_LOWERTHRESHOLDCRITICAL = "LowerThresholdCritical";
    private static final String CPN_UPPERTHRESHOLDCRITICAL = "UpperThresholdCritical";
    private static final String CPN_LOWERTHRESHOLDFATAL = "LowerThresholdFatal";
    private static final String CPN_UPPERTHRESHOLDFATAL = "UpperThresholdFatal";
    private static final String CPN_ISLINEAR = "IsLinear";
    private static final String CPN_HYSTERESIS = "Hysteresis";
    private static final String CPN_SUPPORTEDTHRESHOLDS = "SupportedThresholds";
    private static final String CPN_ENABLEDTHRESHOLDS = "EnabledThresholds";
    private static final String CPN_SETTABLETHRESHOLDS = "SettableThresholds";
    private static final String CPN_OTHERSENSORTYPEDESCRIPTION = "OtherSensorTypeDescription";
    private static final String CPN_POSSIBLESTATES = "PossibleStates";
    private static final String CPN_CURRENTSTATE = "CurrentState";
    private static final String CPN_POLLINGINTERVAL = "PollingInterval";
    private static final String CPN_SYSTEMCREATIONCLASSNAME = "SystemCreationClassName";
    private static final String CPN_SYSTEMNAME = "SystemName";
    private static final String CPN_CREATIONCLASSNAME = "CreationClassName";
    private static final String CPN_DEVICEID = "DeviceID";
    private static final String CPN_POWERMANAGEMENTSUPPORTED = "PowerManagementSupported";
    private static final String CPN_POWERMANAGEMENTCAPABILITIES = "PowerManagementCapabilities";
    private static final String CPN_AVAILABILITY = "Availability";
    private static final String CPN_STATUSINFO = "StatusInfo";
    private static final String CPN_LASTERRORCODE = "LastErrorCode";
    private static final String CPN_ERRORDESCRIPTION = "ErrorDescription";
    private static final String CPN_ERRORCLEARED = "ErrorCleared";
    private static final String CPN_OTHERIDENTIFYINGINFO = "OtherIdentifyingInfo";
    private static final String CPN_POWERONHOURS = "PowerOnHours";
    private static final String CPN_TOTALPOWERONHOURS = "TotalPowerOnHours";
    private static final String CPN_IDENTIFYINGDESCRIPTIONS = "IdentifyingDescriptions";
    private static final String CPN_ADDITIONALAVAILABILITY = "AdditionalAvailability";
    private static final String CPN_MAXQUIESCETIME = "MaxQuiesceTime";
    private static final String CPN_ENABLEDSTATE = "EnabledState";
    private static final String CPN_OTHERENABLEDSTATE = "OtherEnabledState";
    private static final String CPN_REQUESTEDSTATE = "RequestedState";
    private static final String CPN_ENABLEDDEFAULT = "EnabledDefault";
    private static final String CPN_TIMEOFLASTSTATECHANGE = "TimeOfLastStateChange";
    private static final String CPN_INSTALLDATE = "InstallDate";
    private static final String CPN_NAME = "Name";
    private static final String CPN_OPERATIONALSTATUS = "OperationalStatus";
    private static final String CPN_STATUSDESCRIPTIONS = "StatusDescriptions";
    private static final String CPN_STATUS = "Status";
    private static final String CPN_HEALTHSTATE = "HealthState";
    private static final String CPN_INSTANCEID = "InstanceID";
    private static final String CPN_CAPTION = "Caption";
    private static final String CPN_DESCRIPTION = "Description";
    private static final String CPN_ELEMENTNAME = "ElementName";

    public VoltageSensor(WBEMClient pWBEMClient, CIMInstance pCIMInstance) {
        super(pWBEMClient, pCIMInstance);
        if (pWBEMClient.toString().contains("WSManClient")) {
            this.typeConversion(pCIMInstance);
        } else {
            this.setCIMInstance(pCIMInstance);
        }
    }

    @Override
    public String getClassVersion() {
        return mClassVersion;
    }

    @Override
    public String[] getKeyPropertyNames() {
        return mKeys;
    }

    @Override
    public void setSensorType(UnsignedInteger16 pSensorType) throws IllegalArgumentException {
        if (pSensorType == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SENSORTYPE, CIMDataType.UINT16_T, pSensorType);
    }

    @Override
    public UnsignedInteger16 getSensorType() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_SENSORTYPE);
    }

    @Override
    public void setBaseUnits(UnsignedInteger16 pBaseUnits) throws IllegalArgumentException {
        if (pBaseUnits == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_BASEUNITS, CIMDataType.UINT16_T, pBaseUnits);
    }

    @Override
    public UnsignedInteger16 getBaseUnits() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_BASEUNITS);
    }

    @Override
    public void setUnitModifier(Integer pUnitModifier) throws IllegalArgumentException {
        if (pUnitModifier == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_UNITMODIFIER, CIMDataType.SINT32_T, pUnitModifier);
    }

    @Override
    public Integer getUnitModifier() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_UNITMODIFIER);
    }

    @Override
    public void setRateUnits(UnsignedInteger16 pRateUnits) throws IllegalArgumentException {
        if (pRateUnits == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RATEUNITS, CIMDataType.UINT16_T, pRateUnits);
    }

    @Override
    public UnsignedInteger16 getRateUnits() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_RATEUNITS);
    }

    @Override
    public void setCurrentReading(Integer pCurrentReading) throws IllegalArgumentException {
        if (pCurrentReading == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CURRENTREADING, CIMDataType.SINT32_T, pCurrentReading);
    }

    @Override
    public Integer getCurrentReading() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_CURRENTREADING);
    }

    @Override
    public void setNominalReading(Integer pNominalReading) throws IllegalArgumentException {
        if (pNominalReading == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NOMINALREADING, CIMDataType.SINT32_T, pNominalReading);
    }

    @Override
    public Integer getNominalReading() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_NOMINALREADING);
    }

    @Override
    public void setNormalMax(Integer pNormalMax) throws IllegalArgumentException {
        if (pNormalMax == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NORMALMAX, CIMDataType.SINT32_T, pNormalMax);
    }

    @Override
    public Integer getNormalMax() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_NORMALMAX);
    }

    @Override
    public void setNormalMin(Integer pNormalMin) throws IllegalArgumentException {
        if (pNormalMin == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NORMALMIN, CIMDataType.SINT32_T, pNormalMin);
    }

    @Override
    public Integer getNormalMin() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_NORMALMIN);
    }

    @Override
    public void setMaxReadable(Integer pMaxReadable) throws IllegalArgumentException {
        if (pMaxReadable == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MAXREADABLE, CIMDataType.SINT32_T, pMaxReadable);
    }

    @Override
    public Integer getMaxReadable() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_MAXREADABLE);
    }

    @Override
    public void setMinReadable(Integer pMinReadable) throws IllegalArgumentException {
        if (pMinReadable == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MINREADABLE, CIMDataType.SINT32_T, pMinReadable);
    }

    @Override
    public Integer getMinReadable() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_MINREADABLE);
    }

    @Override
    public void setResolution(UnsignedInteger32 pResolution) throws IllegalArgumentException {
        if (pResolution == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RESOLUTION, CIMDataType.UINT32_T, pResolution);
    }

    @Override
    public UnsignedInteger32 getResolution() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_RESOLUTION);
    }

    @Override
    public void setTolerance(Integer pTolerance) throws IllegalArgumentException {
        if (pTolerance == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TOLERANCE, CIMDataType.SINT32_T, pTolerance);
    }

    @Override
    public Integer getTolerance() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_TOLERANCE);
    }

    @Override
    public void setAccuracy(Integer pAccuracy) throws IllegalArgumentException {
        if (pAccuracy == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ACCURACY, CIMDataType.SINT32_T, pAccuracy);
    }

    @Override
    public Integer getAccuracy() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_ACCURACY);
    }

    @Override
    public void setLowerThresholdNonCritical(Integer pLowerThresholdNonCritical) throws IllegalArgumentException {
        if (pLowerThresholdNonCritical == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LOWERTHRESHOLDNONCRITICAL, CIMDataType.SINT32_T, pLowerThresholdNonCritical);
    }

    @Override
    public Integer getLowerThresholdNonCritical() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_LOWERTHRESHOLDNONCRITICAL);
    }

    @Override
    public void setUpperThresholdNonCritical(Integer pUpperThresholdNonCritical) throws IllegalArgumentException {
        if (pUpperThresholdNonCritical == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_UPPERTHRESHOLDNONCRITICAL, CIMDataType.SINT32_T, pUpperThresholdNonCritical);
    }

    @Override
    public Integer getUpperThresholdNonCritical() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_UPPERTHRESHOLDNONCRITICAL);
    }

    @Override
    public void setLowerThresholdCritical(Integer pLowerThresholdCritical) throws IllegalArgumentException {
        if (pLowerThresholdCritical == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LOWERTHRESHOLDCRITICAL, CIMDataType.SINT32_T, pLowerThresholdCritical);
    }

    @Override
    public Integer getLowerThresholdCritical() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_LOWERTHRESHOLDCRITICAL);
    }

    @Override
    public void setUpperThresholdCritical(Integer pUpperThresholdCritical) throws IllegalArgumentException {
        if (pUpperThresholdCritical == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_UPPERTHRESHOLDCRITICAL, CIMDataType.SINT32_T, pUpperThresholdCritical);
    }

    @Override
    public Integer getUpperThresholdCritical() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_UPPERTHRESHOLDCRITICAL);
    }

    @Override
    public void setLowerThresholdFatal(Integer pLowerThresholdFatal) throws IllegalArgumentException {
        if (pLowerThresholdFatal == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LOWERTHRESHOLDFATAL, CIMDataType.SINT32_T, pLowerThresholdFatal);
    }

    @Override
    public Integer getLowerThresholdFatal() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_LOWERTHRESHOLDFATAL);
    }

    @Override
    public void setUpperThresholdFatal(Integer pUpperThresholdFatal) throws IllegalArgumentException {
        if (pUpperThresholdFatal == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_UPPERTHRESHOLDFATAL, CIMDataType.SINT32_T, pUpperThresholdFatal);
    }

    @Override
    public Integer getUpperThresholdFatal() {
        return (Integer)this.mCimInstance.getPropertyValue(CPN_UPPERTHRESHOLDFATAL);
    }

    @Override
    public void setIsLinear(Boolean pIsLinear) throws IllegalArgumentException {
        if (pIsLinear == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ISLINEAR, CIMDataType.BOOLEAN_T, pIsLinear);
    }

    @Override
    public Boolean getIsLinear() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_ISLINEAR);
    }

    @Override
    public void setHysteresis(UnsignedInteger32 pHysteresis) throws IllegalArgumentException {
        if (pHysteresis == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_HYSTERESIS, CIMDataType.UINT32_T, pHysteresis);
    }

    @Override
    public UnsignedInteger32 getHysteresis() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_HYSTERESIS);
    }

    @Override
    public void setSupportedThresholds(UnsignedInteger16[] pSupportedThresholds) throws IllegalArgumentException {
        if (pSupportedThresholds == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SUPPORTEDTHRESHOLDS, CIMDataType.UINT16_ARRAY_T, pSupportedThresholds);
    }

    @Override
    public UnsignedInteger16[] getSupportedThresholds() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_SUPPORTEDTHRESHOLDS);
    }

    @Override
    public void setEnabledThresholds(UnsignedInteger16[] pEnabledThresholds) throws IllegalArgumentException {
        if (pEnabledThresholds == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDTHRESHOLDS, CIMDataType.UINT16_ARRAY_T, pEnabledThresholds);
    }

    @Override
    public UnsignedInteger16[] getEnabledThresholds() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_ENABLEDTHRESHOLDS);
    }

    @Override
    public void setSettableThresholds(UnsignedInteger16[] pSettableThresholds) throws IllegalArgumentException {
        if (pSettableThresholds == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SETTABLETHRESHOLDS, CIMDataType.UINT16_ARRAY_T, pSettableThresholds);
    }

    @Override
    public UnsignedInteger16[] getSettableThresholds() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_SETTABLETHRESHOLDS);
    }

    @Override
    public void setOtherSensorTypeDescription(String pOtherSensorTypeDescription) throws IllegalArgumentException {
        if (pOtherSensorTypeDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERSENSORTYPEDESCRIPTION, CIMDataType.STRING_T, pOtherSensorTypeDescription);
    }

    @Override
    public String getOtherSensorTypeDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_OTHERSENSORTYPEDESCRIPTION);
    }

    @Override
    public void setPossibleStates(String[] pPossibleStates) throws IllegalArgumentException {
        if (pPossibleStates == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POSSIBLESTATES, CIMDataType.STRING_ARRAY_T, pPossibleStates);
    }

    @Override
    public String[] getPossibleStates() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_POSSIBLESTATES);
    }

    @Override
    public void setCurrentState(String pCurrentState) throws IllegalArgumentException {
        if (pCurrentState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CURRENTSTATE, CIMDataType.STRING_T, pCurrentState);
    }

    @Override
    public String getCurrentState() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CURRENTSTATE);
    }

    @Override
    public void setPollingInterval(UnsignedInteger64 pPollingInterval) throws IllegalArgumentException {
        if (pPollingInterval == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POLLINGINTERVAL, CIMDataType.UINT64_T, pPollingInterval);
    }

    @Override
    public UnsignedInteger64 getPollingInterval() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_POLLINGINTERVAL);
    }

    @Override
    public void setSystemCreationClassName(String pSystemCreationClassName) throws IllegalArgumentException {
        if (pSystemCreationClassName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SYSTEMCREATIONCLASSNAME, CIMDataType.STRING_T, pSystemCreationClassName);
    }

    @Override
    public String getSystemCreationClassName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_SYSTEMCREATIONCLASSNAME);
    }

    @Override
    public void setSystemName(String pSystemName) throws IllegalArgumentException {
        if (pSystemName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SYSTEMNAME, CIMDataType.STRING_T, pSystemName);
    }

    @Override
    public String getSystemName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_SYSTEMNAME);
    }

    @Override
    public void setCreationClassName(String pCreationClassName) throws IllegalArgumentException {
        if (pCreationClassName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CREATIONCLASSNAME, CIMDataType.STRING_T, pCreationClassName);
    }

    @Override
    public String getCreationClassName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CREATIONCLASSNAME);
    }

    @Override
    public void setDeviceID(String pDeviceID) throws IllegalArgumentException {
        if (pDeviceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DEVICEID, CIMDataType.STRING_T, pDeviceID);
    }

    @Override
    public String getDeviceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DEVICEID);
    }

    @Override
    public void setPowerManagementSupported(Boolean pPowerManagementSupported) throws IllegalArgumentException {
        if (pPowerManagementSupported == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERMANAGEMENTSUPPORTED, CIMDataType.BOOLEAN_T, pPowerManagementSupported);
    }

    @Override
    public Boolean getPowerManagementSupported() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_POWERMANAGEMENTSUPPORTED);
    }

    @Override
    public void setPowerManagementCapabilities(UnsignedInteger16[] pPowerManagementCapabilities) throws IllegalArgumentException {
        if (pPowerManagementCapabilities == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERMANAGEMENTCAPABILITIES, CIMDataType.UINT16_ARRAY_T, pPowerManagementCapabilities);
    }

    @Override
    public UnsignedInteger16[] getPowerManagementCapabilities() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_POWERMANAGEMENTCAPABILITIES);
    }

    @Override
    public void setAvailability(UnsignedInteger16 pAvailability) throws IllegalArgumentException {
        if (pAvailability == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_AVAILABILITY, CIMDataType.UINT16_T, pAvailability);
    }

    @Override
    public UnsignedInteger16 getAvailability() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_AVAILABILITY);
    }

    @Override
    public void setStatusInfo(UnsignedInteger16 pStatusInfo) throws IllegalArgumentException {
        if (pStatusInfo == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUSINFO, CIMDataType.UINT16_T, pStatusInfo);
    }

    @Override
    public UnsignedInteger16 getStatusInfo() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_STATUSINFO);
    }

    @Override
    public void setLastErrorCode(UnsignedInteger32 pLastErrorCode) throws IllegalArgumentException {
        if (pLastErrorCode == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LASTERRORCODE, CIMDataType.UINT32_T, pLastErrorCode);
    }

    @Override
    public UnsignedInteger32 getLastErrorCode() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_LASTERRORCODE);
    }

    @Override
    public void setErrorDescription(String pErrorDescription) throws IllegalArgumentException {
        if (pErrorDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ERRORDESCRIPTION, CIMDataType.STRING_T, pErrorDescription);
    }

    @Override
    public String getErrorDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ERRORDESCRIPTION);
    }

    @Override
    public void setErrorCleared(Boolean pErrorCleared) throws IllegalArgumentException {
        if (pErrorCleared == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ERRORCLEARED, CIMDataType.BOOLEAN_T, pErrorCleared);
    }

    @Override
    public Boolean getErrorCleared() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_ERRORCLEARED);
    }

    @Override
    public void setOtherIdentifyingInfo(String[] pOtherIdentifyingInfo) throws IllegalArgumentException {
        if (pOtherIdentifyingInfo == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERIDENTIFYINGINFO, CIMDataType.STRING_ARRAY_T, pOtherIdentifyingInfo);
    }

    @Override
    public String[] getOtherIdentifyingInfo() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_OTHERIDENTIFYINGINFO);
    }

    @Override
    public void setPowerOnHours(UnsignedInteger64 pPowerOnHours) throws IllegalArgumentException {
        if (pPowerOnHours == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERONHOURS, CIMDataType.UINT64_T, pPowerOnHours);
    }

    @Override
    public UnsignedInteger64 getPowerOnHours() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_POWERONHOURS);
    }

    @Override
    public void setTotalPowerOnHours(UnsignedInteger64 pTotalPowerOnHours) throws IllegalArgumentException {
        if (pTotalPowerOnHours == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TOTALPOWERONHOURS, CIMDataType.UINT64_T, pTotalPowerOnHours);
    }

    @Override
    public UnsignedInteger64 getTotalPowerOnHours() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_TOTALPOWERONHOURS);
    }

    @Override
    public void setIdentifyingDescriptions(String[] pIdentifyingDescriptions) throws IllegalArgumentException {
        if (pIdentifyingDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_IDENTIFYINGDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pIdentifyingDescriptions);
    }

    @Override
    public String[] getIdentifyingDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_IDENTIFYINGDESCRIPTIONS);
    }

    @Override
    public void setAdditionalAvailability(UnsignedInteger16[] pAdditionalAvailability) throws IllegalArgumentException {
        if (pAdditionalAvailability == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ADDITIONALAVAILABILITY, CIMDataType.UINT16_ARRAY_T, pAdditionalAvailability);
    }

    @Override
    public UnsignedInteger16[] getAdditionalAvailability() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_ADDITIONALAVAILABILITY);
    }

    @Override
    public void setMaxQuiesceTime(UnsignedInteger64 pMaxQuiesceTime) throws IllegalArgumentException {
        if (pMaxQuiesceTime == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MAXQUIESCETIME, CIMDataType.UINT64_T, pMaxQuiesceTime);
    }

    @Override
    public UnsignedInteger64 getMaxQuiesceTime() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_MAXQUIESCETIME);
    }

    @Override
    public void setEnabledState(UnsignedInteger16 pEnabledState) throws IllegalArgumentException {
        if (pEnabledState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDSTATE, CIMDataType.UINT16_T, pEnabledState);
    }

    @Override
    public UnsignedInteger16 getEnabledState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ENABLEDSTATE);
    }

    @Override
    public void setOtherEnabledState(String pOtherEnabledState) throws IllegalArgumentException {
        if (pOtherEnabledState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERENABLEDSTATE, CIMDataType.STRING_T, pOtherEnabledState);
    }

    @Override
    public String getOtherEnabledState() {
        return (String)this.mCimInstance.getPropertyValue(CPN_OTHERENABLEDSTATE);
    }

    @Override
    public void setRequestedState(UnsignedInteger16 pRequestedState) throws IllegalArgumentException {
        if (pRequestedState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUESTEDSTATE, CIMDataType.UINT16_T, pRequestedState);
    }

    @Override
    public UnsignedInteger16 getRequestedState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_REQUESTEDSTATE);
    }

    @Override
    public void setEnabledDefault(UnsignedInteger16 pEnabledDefault) throws IllegalArgumentException {
        if (pEnabledDefault == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDDEFAULT, CIMDataType.UINT16_T, pEnabledDefault);
    }

    @Override
    public UnsignedInteger16 getEnabledDefault() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ENABLEDDEFAULT);
    }

    @Override
    public void setTimeOfLastStateChange(CIMDateTime pTimeOfLastStateChange) throws IllegalArgumentException {
        if (pTimeOfLastStateChange == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TIMEOFLASTSTATECHANGE, CIMDataType.DATETIME_T, pTimeOfLastStateChange);
    }

    @Override
    public CIMDateTime getTimeOfLastStateChange() {
        return (CIMDateTime)this.mCimInstance.getPropertyValue(CPN_TIMEOFLASTSTATECHANGE);
    }

    @Override
    public void setInstallDate(CIMDateTime pInstallDate) throws IllegalArgumentException {
        if (pInstallDate == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTALLDATE, CIMDataType.DATETIME_T, pInstallDate);
    }

    @Override
    public CIMDateTime getInstallDate() {
        return (CIMDateTime)this.mCimInstance.getPropertyValue(CPN_INSTALLDATE);
    }

    @Override
    public void setName(String pName) throws IllegalArgumentException {
        if (pName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NAME, CIMDataType.STRING_T, pName);
    }

    @Override
    public String getName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_NAME);
    }

    @Override
    public void setOperationalStatus(UnsignedInteger16[] pOperationalStatus) throws IllegalArgumentException {
        if (pOperationalStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OPERATIONALSTATUS, CIMDataType.UINT16_ARRAY_T, pOperationalStatus);
    }

    @Override
    public UnsignedInteger16[] getOperationalStatus() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_OPERATIONALSTATUS);
    }

    @Override
    public void setStatusDescriptions(String[] pStatusDescriptions) throws IllegalArgumentException {
        if (pStatusDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUSDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pStatusDescriptions);
    }

    @Override
    public String[] getStatusDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_STATUSDESCRIPTIONS);
    }

    @Override
    public void setStatus(String pStatus) throws IllegalArgumentException {
        if (pStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUS, CIMDataType.STRING_T, pStatus);
    }

    @Override
    public String getStatus() {
        return (String)this.mCimInstance.getPropertyValue(CPN_STATUS);
    }

    @Override
    public void setHealthState(UnsignedInteger16 pHealthState) throws IllegalArgumentException {
        if (pHealthState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_HEALTHSTATE, CIMDataType.UINT16_T, pHealthState);
    }

    @Override
    public UnsignedInteger16 getHealthState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_HEALTHSTATE);
    }

    @Override
    public void setInstanceID(String pInstanceID) throws IllegalArgumentException {
        if (pInstanceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTANCEID, CIMDataType.STRING_T, pInstanceID);
    }

    @Override
    public String getInstanceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_INSTANCEID);
    }

    @Override
    public void setCaption(String pCaption) throws IllegalArgumentException {
        if (pCaption == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CAPTION, CIMDataType.STRING_T, pCaption);
    }

    @Override
    public String getCaption() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CAPTION);
    }

    @Override
    public void setDescription(String pDescription) throws IllegalArgumentException {
        if (pDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DESCRIPTION, CIMDataType.STRING_T, pDescription);
    }

    @Override
    public String getDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DESCRIPTION);
    }

    @Override
    public void setElementName(String pElementName) throws IllegalArgumentException {
        if (pElementName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ELEMENTNAME, CIMDataType.STRING_T, pElementName);
    }

    @Override
    public String getElementName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ELEMENTNAME);
    }

    public void initialize(ProviderHandle pHandle) throws WBEMException {
    }

    private void typeConversion(CIMInstance pInstance) {
        CIMProperty[] propList = new CIMProperty[]{new CIMProperty(CPN_SENSORTYPE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_SENSORTYPE)), new CIMProperty(CPN_BASEUNITS, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_BASEUNITS)), new CIMProperty(CPN_UNITMODIFIER, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_UNITMODIFIER)), new CIMProperty(CPN_RATEUNITS, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_RATEUNITS)), new CIMProperty(CPN_CURRENTREADING, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_CURRENTREADING)), new CIMProperty(CPN_NOMINALREADING, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_NOMINALREADING)), new CIMProperty(CPN_NORMALMAX, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_NORMALMAX)), new CIMProperty(CPN_NORMALMIN, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_NORMALMIN)), new CIMProperty(CPN_MAXREADABLE, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_MAXREADABLE)), new CIMProperty(CPN_MINREADABLE, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_MINREADABLE)), new CIMProperty(CPN_RESOLUTION, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_RESOLUTION)), new CIMProperty(CPN_TOLERANCE, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_TOLERANCE)), new CIMProperty(CPN_ACCURACY, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_ACCURACY)), new CIMProperty(CPN_LOWERTHRESHOLDNONCRITICAL, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_LOWERTHRESHOLDNONCRITICAL)), new CIMProperty(CPN_UPPERTHRESHOLDNONCRITICAL, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_UPPERTHRESHOLDNONCRITICAL)), new CIMProperty(CPN_LOWERTHRESHOLDCRITICAL, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_LOWERTHRESHOLDCRITICAL)), new CIMProperty(CPN_UPPERTHRESHOLDCRITICAL, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_UPPERTHRESHOLDCRITICAL)), new CIMProperty(CPN_LOWERTHRESHOLDFATAL, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_LOWERTHRESHOLDFATAL)), new CIMProperty(CPN_UPPERTHRESHOLDFATAL, CIMDataType.SINT32_T, (Object)this.getIntegerValue(pInstance, CPN_UPPERTHRESHOLDFATAL)), new CIMProperty(CPN_ISLINEAR, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_ISLINEAR)), new CIMProperty(CPN_HYSTERESIS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_HYSTERESIS)), new CIMProperty(CPN_SUPPORTEDTHRESHOLDS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_SUPPORTEDTHRESHOLDS)), new CIMProperty(CPN_ENABLEDTHRESHOLDS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_ENABLEDTHRESHOLDS)), new CIMProperty(CPN_SETTABLETHRESHOLDS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_SETTABLETHRESHOLDS)), new CIMProperty(CPN_POLLINGINTERVAL, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_POLLINGINTERVAL)), new CIMProperty(CPN_POWERMANAGEMENTSUPPORTED, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_POWERMANAGEMENTSUPPORTED)), new CIMProperty(CPN_POWERMANAGEMENTCAPABILITIES, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_POWERMANAGEMENTCAPABILITIES)), new CIMProperty(CPN_AVAILABILITY, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_AVAILABILITY)), new CIMProperty(CPN_STATUSINFO, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_STATUSINFO)), new CIMProperty(CPN_LASTERRORCODE, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_LASTERRORCODE)), new CIMProperty(CPN_ERRORCLEARED, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_ERRORCLEARED)), new CIMProperty(CPN_POWERONHOURS, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_POWERONHOURS)), new CIMProperty(CPN_TOTALPOWERONHOURS, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_TOTALPOWERONHOURS)), new CIMProperty(CPN_ADDITIONALAVAILABILITY, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_ADDITIONALAVAILABILITY)), new CIMProperty(CPN_MAXQUIESCETIME, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_MAXQUIESCETIME)), new CIMProperty(CPN_ENABLEDSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ENABLEDSTATE)), new CIMProperty(CPN_REQUESTEDSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_REQUESTEDSTATE)), new CIMProperty(CPN_ENABLEDDEFAULT, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ENABLEDDEFAULT)), new CIMProperty(CPN_TIMEOFLASTSTATECHANGE, CIMDataType.DATETIME_T, (Object)this.getCIMDateTimeAbsoluteValue(pInstance, CPN_TIMEOFLASTSTATECHANGE)), new CIMProperty(CPN_INSTALLDATE, CIMDataType.DATETIME_T, (Object)this.getCIMDateTimeAbsoluteValue(pInstance, CPN_INSTALLDATE)), new CIMProperty(CPN_OPERATIONALSTATUS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_OPERATIONALSTATUS)), new CIMProperty(CPN_HEALTHSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_HEALTHSTATE))};
        CIMInstance tempInst = pInstance.deriveInstance(propList);
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty(CPN_SYSTEMCREATIONCLASSNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_SYSTEMCREATIONCLASSNAME)), new CIMProperty(CPN_SYSTEMNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_SYSTEMNAME)), new CIMProperty(CPN_CREATIONCLASSNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_CREATIONCLASSNAME)), new CIMProperty(CPN_DEVICEID, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_DEVICEID))};
        CIMObjectPath op = pInstance.getObjectPath();
        CIMObjectPath derivedOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyProps, op.getXmlSchemaName());
        this.setCIMInstance(tempInst.deriveInstance(derivedOP));
    }

    private UnsignedInteger16 getUnsignedInteger16Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16) {
                propertyValue = (UnsignedInteger16)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger16(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private Integer getIntegerValue(CIMInstance pInstance, String pPropName) {
        Integer propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof Integer) {
                propertyValue = (Integer)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new Integer(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger32 getUnsignedInteger32Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger32 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger32) {
                propertyValue = (UnsignedInteger32)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger32(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private Boolean getBooleanValue(CIMInstance pInstance, String pPropName) {
        Boolean propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof Boolean) {
                propertyValue = (Boolean)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new Boolean(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger16[] getUnsignedInteger16ArrValue(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16[] propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16[]) {
                propertyValue = (UnsignedInteger16[])property.getValue();
            } else {
                try {
                    if (property.getValue() instanceof String[]) {
                        String[] strValueArr = (String[])property.getValue();
                        if (strValueArr != null) {
                            propertyValue = new UnsignedInteger16[strValueArr.length];
                            for (int ndx = 0; ndx < propertyValue.length; ++ndx) {
                                propertyValue[ndx] = new UnsignedInteger16(strValueArr[ndx]);
                            }
                        }
                    } else {
                        String strValue = (String)property.getValue();
                        propertyValue = new UnsignedInteger16[]{new UnsignedInteger16(strValue)};
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger64 getUnsignedInteger64Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger64 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger64) {
                propertyValue = (UnsignedInteger64)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger64(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private String getStringValue(CIMInstance pInstance, String pPropName) {
        String propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            try {
                propertyValue = (String)property.getValue();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return propertyValue;
    }

    private CIMDateTimeAbsolute getCIMDateTimeAbsoluteValue(CIMInstance pInstance, String pPropName) {
        CIMDateTimeAbsolute propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof CIMDateTimeAbsolute) {
                propertyValue = (CIMDateTimeAbsolute)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new CIMDateTimeAbsolute(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    @Override
    public UnsignedInteger32 restoreDefaultThresholds() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RestoreDefaultThresholds", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 getNonLinearFactors(Integer pSensorReading, Integer pAccuracy, UnsignedInteger32 pResolution, Integer pTolerance, UnsignedInteger32 pHysteresis) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "GetNonLinearFactors", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 setPowerState(UnsignedInteger16 pPowerState, CIMDateTime pTime) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "SetPowerState", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 reset() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "Reset", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 enableDevice(Boolean pEnabled) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "EnableDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 onlineDevice(Boolean pOnline) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "OnlineDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 quiesceDevice(Boolean pQuiesce) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "QuiesceDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 saveProperties() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "SaveProperties", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 restoreProperties() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RestoreProperties", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 requestStateChange(UnsignedInteger16 pRequestedState, CIMObjectPath pJob, CIMDateTime pTimeoutPeriod) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RequestStateChange", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }
}

