/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.client;

import com.cisco.dcbu.smis.jaxws.ep.Inventory;
import com.cisco.dcbu.smis.jaxws.ep.Logon;
import com.cisco.dcbu.smis.jaxws.ep.Protocol;
import com.cisco.dcbu.smis.jaxws.ep.San;
import com.cisco.dcbu.smis.jaxws.ep.Statistics;
import com.cisco.dcbu.smis.jaxws.ep.ZoneManager;
import com.cisco.dcbu.smis.provider.client.ReferenceIf;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

class EjbReference
implements ReferenceIf {
    private static EjbReference _Instance = null;
    String _server;
    int _serverPort;
    boolean _useSSL;
    InitialContext _context;
    static LogLevel _logger = new LogLevel();

    static EjbReference getInstance(String server, int serverPort, boolean useSSL) throws RemoteException {
        if (_Instance == null || !EjbReference._Instance._server.equals(server) || EjbReference._Instance._serverPort != serverPort || EjbReference._Instance._useSSL != useSSL) {
            _Instance = new EjbReference(server, serverPort, useSSL);
        }
        return _Instance;
    }

    static EjbReference getNewInstance(String server, int serverPort, boolean useSSL) throws RemoteException {
        _Instance = new EjbReference(server, serverPort, useSSL);
        return _Instance;
    }

    private EjbReference(String server, int serverPort, boolean useSSL) throws RemoteException {
        this._server = server;
        this._serverPort = serverPort;
        this._useSSL = useSSL;
        this.initContext();
    }

    private void initContext() throws RemoteException {
        this._context = this.initContext(this._server);
    }

    private InitialContext initContext(String server) throws RemoteException {
        InitialContext ret = null;
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            String serverUrl = "jnp://" + server + ":" + this._serverPort;
            properties.put("java.naming.provider.url", serverUrl);
            ret = new InitialContext(properties);
            return ret;
        }
        catch (NamingException ex) {
            throw new RemoteException("can not get initial context from:" + this._server, ex);
        }
    }

    private String getProtocolString() {
        String ret = this._useSSL ? "ssl" : "remote";
        LogLevel.log(10000, "jndi lookup postfix:" + ret);
        return ret;
    }

    private Object getService(String serviceName) throws Exception {
        this.initContext();
        Object i = this._context.lookup(serviceName + this.getProtocolString());
        if (null == i) {
            throw new Exception("Failed to get " + serviceName + " Service");
        }
        return i;
    }

    @Override
    public Logon getLogon() throws Exception {
        return (Logon)this.getService("dcm/LogonWS/Bean");
    }

    @Override
    public San getSan(String token) throws Exception {
        return (San)this.getService("dcm/SanWS/Bean");
    }

    @Override
    public Inventory getInventory(String token) throws Exception {
        return (Inventory)this.getService("dcm/InventoryWS/Bean");
    }

    @Override
    public Protocol getProtocol(String token) throws Exception {
        return (Protocol)this.getService("dcm/ProtocolWS/Bean");
    }

    @Override
    public Statistics getStatistics(String token) throws Exception {
        return (Statistics)this.getService("dcm/StatisticsWS/Bean");
    }

    @Override
    public ZoneManager getZoneManager(String token) throws Exception {
        return (ZoneManager)this.getService("dcm/ZoneManagerWS/Bean");
    }
}

