/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.client;

import com.cisco.dcbu.smis.provider.client.EjbReference;
import com.cisco.dcbu.smis.provider.client.ReferenceIf;
import com.cisco.dcbu.smis.provider.client.TestReference;
import com.cisco.dcbu.smis.provider.client.WSReference;
import com.cisco.dcbu.smis.provider.common.Config;
import java.rmi.RemoteException;

public class ReferenceFactory {
    private static ReferenceIf _Instance = null;
    private static String _server;
    private static int _serverPort;
    private static int _httpPort;
    private static boolean _useSSL;

    public static ReferenceIf getInstance() throws RemoteException {
        Config config = Config.getInstance();
        return ReferenceFactory.getInstance(config.getFmAddr(), config.getFmPort(), config.getFmHttpPort(), config.getUseSSL());
    }

    public static ReferenceIf getInstance(String server, int serverPort, int httpPort, boolean useSSL) throws RemoteException {
        if (_Instance == null || _server != null && (!_server.equals(server) || _serverPort != serverPort || _httpPort != httpPort || _useSSL != useSSL)) {
            Config config = Config.getInstance();
            if (config.getFmProtocol().equalsIgnoreCase("WS")) {
                _Instance = WSReference.getInstance(server, httpPort, useSSL);
            } else if (config.getFmProtocol().equalsIgnoreCase("RMI")) {
                _Instance = EjbReference.getInstance(server, serverPort, useSSL);
            } else if (config.getFmProtocol().equalsIgnoreCase("TEST")) {
                _Instance = TestReference.getInstance(server, serverPort, useSSL);
            }
            _server = server;
            _serverPort = serverPort;
            _httpPort = httpPort;
            _useSSL = useSSL;
        }
        return _Instance;
    }

    public static ReferenceIf getNewInstance(String server, int serverPort, int httpPort, boolean useSSL) throws RemoteException {
        Config config = Config.getInstance();
        if (config.getFmProtocol().equalsIgnoreCase("WS")) {
            _Instance = WSReference.getInstance(server, httpPort, useSSL);
        } else if (config.getFmProtocol().equalsIgnoreCase("WS")) {
            _Instance = EjbReference.getInstance(server, serverPort, useSSL);
        }
        return _Instance;
    }
}

