/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.common;

import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class LogLevel {
    public static Logger _Logger = LogManager.getLogger((String)"SMIS.LogLevel");
    public static final int All = Integer.MIN_VALUE;
    public static final int OFF = Integer.MAX_VALUE;
    public static final int DEBUG = 10000;
    public static final int INFO = 20000;
    public static final int WARNING = 30000;
    public static final int ERROR = 40000;
    public static final int FATAL = 50000;
    public static final int TRACE = 5000;
    public static final int FINEST = 5000;
    public static final int FINER = 5000;
    public static final int FINE = 10000;
    public static final int CONFIG = 20000;
    public static final int SEVERE = 40000;
    public static String logConfFile;
    public static final String separator;
    public static String mdsRoot;
    public static String _Cache;
    public static String installDir;

    public static void log(int level, String message) {
        try {
            String wholeMsg = LogLevel.getSourceClass() + " " + LogLevel.getSourceMethod() + " " + message;
            switch (level) {
                case 10000: {
                    _Logger.debug((Object)wholeMsg);
                    break;
                }
                case 20000: {
                    _Logger.info((Object)wholeMsg);
                    break;
                }
                case 30000: {
                    _Logger.warn((Object)wholeMsg);
                    break;
                }
                case 40000: {
                    _Logger.error((Object)wholeMsg);
                    break;
                }
                case 50000: {
                    _Logger.fatal((Object)wholeMsg);
                    break;
                }
                default: {
                    _Logger.debug((Object)wholeMsg);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void log(int level, Throwable ex) {
        try {
            String wholeMsg = LogLevel.getSourceClass() + " " + LogLevel.getSourceMethod() + "EXCEPTION: " + ex;
            switch (level) {
                case 10000: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
                case 20000: {
                    _Logger.info((Object)wholeMsg, ex);
                    break;
                }
                case 30000: {
                    _Logger.warn((Object)wholeMsg, ex);
                    break;
                }
                case 40000: {
                    _Logger.error((Object)wholeMsg, ex);
                    break;
                }
                case 50000: {
                    _Logger.fatal((Object)wholeMsg, ex);
                    break;
                }
                default: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(int level, String message, Throwable ex) {
        try {
            String wholeMsg = LogLevel.getSourceClass() + " " + LogLevel.getSourceMethod() + " " + message;
            switch (level) {
                case 10000: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
                case 20000: {
                    _Logger.info((Object)wholeMsg, ex);
                    break;
                }
                case 30000: {
                    _Logger.warn((Object)wholeMsg, ex);
                    break;
                }
                case 40000: {
                    _Logger.error((Object)wholeMsg, ex);
                    break;
                }
                case 50000: {
                    _Logger.fatal((Object)wholeMsg, ex);
                    break;
                }
                default: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void log(String sMessage) {
        try {
            _Logger.info((Object)(LogLevel.getSourceClass() + " " + LogLevel.getSourceMethod() + " " + sMessage));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void info(String msg) {
        _Logger.info((Object)msg);
    }

    public static void warning(String msg) {
        _Logger.warn((Object)msg);
    }

    public static void fine(String msg) {
        _Logger.info((Object)msg);
    }

    private static String getSourceClass() {
        String str = "";
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] trace = t.getStackTrace();
        if (trace.length > 2) {
            str = trace[2].toString();
            if (str.lastIndexOf(40) != -1) {
                str = str.substring(0, str.lastIndexOf(40));
            }
            if (str.lastIndexOf(46) != -1) {
                str = str.substring(0, str.lastIndexOf(46));
            }
            return str;
        }
        return "";
    }

    private static String getSourceMethod() {
        String str = "";
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] trace = t.getStackTrace();
        if (trace.length > 2) {
            String str2 = str = trace[2].toString();
            if (str.lastIndexOf(46) != -1) {
                str = str.substring(str.lastIndexOf(46) + 1);
            }
            return str + "()";
        }
        return "";
    }

    static {
        separator = File.separator;
        mdsRoot = null;
        _Cache = null;
        installDir = null;
        logConfFile = System.getProperty("org.apache.log4j.file");
        if (logConfFile == null) {
            logConfFile = System.getProperty("mds.nmsRoot") + separator + "conf" + separator + "log4j_smis.xml";
        }
        if (logConfFile != null) {
            try {
                mdsRoot = System.getProperty("mds.nmsRoot");
                _Cache = System.getProperty("user.home");
                _Cache = _Cache + (_Cache.equals(separator) ? ".cisco_mds9000" : separator + ".cisco_mds9000");
                installDir = mdsRoot != null ? mdsRoot : _Cache;
                System.setProperty("log.dir", installDir + File.separator + "logs");
                DOMConfigurator.configure((String)logConfFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

