/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.sm.common.event.smis.EndPortChange;
import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.jaxws.ep.EndPort;
import com.cisco.dcbu.smis.jaxws.ep.San;
import com.cisco.dcbu.smis.jaxws.ep.Wwn;
import com.cisco.dcbu.smis.jaxws.ep.WwnKey;
import com.cisco.dcbu.smis.provider.client.ReferenceFactory;
import com.cisco.dcbu.smis.provider.client.ReferenceIf;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.common.SubscriptionTypeEnum;
import com.cisco.dcbu.smis.provider.helper.IndicationProviderHelper;
import com.cisco.dcbu.smis.provider.helper.MappingHelper;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class CISCO_PortAddedHelper
extends IndicationProviderHelper {
    private static final int NUM_KEYS = 1;
    private static final String CLS_PORTADDED = "CISCO_PortAdded";

    @Override
    public final String cimClassName() {
        return CLS_PORTADDED;
    }

    public final int numKeys() {
        return 1;
    }

    @Override
    public void deliverEvent(Object eventObj) {
        if (eventObj instanceof EndPortChange) {
            EndPortChange event = (EndPortChange)eventObj;
            try {
                CIMInstance inst = this.getInstance(event);
                this.deliverEvent(SubscriptionTypeEnum.PortAdded, inst);
            }
            catch (SMISException e) {
                String s = "Failed to deliver event: " + e.getMessage();
                LogLevel.log(30000, s, (Throwable)((Object)e));
            }
        } else {
            LogLevel.log(30000, "Invalid Event Type");
        }
    }

    @Override
    public CIMObjectPath getPath() throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] keyProps = new CIMProperty[]{};
            CIMObjectPath opNew = new CIMObjectPath("CIM_InstCreation", this._namespace, keyProps);
            return opNew;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    @Override
    public CIMInstance getInstance(Object obj) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            EndPortChange event = (EndPortChange)obj;
            ReferenceIf _rif = ReferenceFactory.getInstance();
            San san = _rif.getSan(this._token);
            EndPort eport = san.getEndPortByKey(new WwnKey(new Wwn(mappingHelper.stripLableOfWwn(event.getKey()))));
            String description = "EndPort event with ifName : " + event.getIfName();
            CIMObjectPath opNew = this.getPath();
            CIMProperty[] props = new CIMProperty[]{new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false, false, "CIM_InstCreation"), new CIMProperty("IndicationIdentifier", CIMDataType.STRING_T, (Object)Long.toString(CISCO_PortAddedHelper.getIndicationId()), false, false, "CIM_InstCreation"), new CIMProperty("SourceInstance", CIMDataType.OBJECT_T, (Object)this.getEndPortInstance(eport), false, false, "CIM_InstCreation"), new CIMProperty("SourceInstanceModelPath", CIMDataType.STRING_T, (Object)this.getEndPortPath(eport), true, false, "CIM_InstCreation"), new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(2), false, false, "CIM_InstCreation"), new CIMProperty("ProviderName", CIMDataType.STRING_T, (Object)"CISCO_PortAddedProvider", false, false, "CIM_AlertIndication"), new CIMProperty("Description", CIMDataType.STRING_T, (Object)description, false, false, "CIM_InstCreation")};
            CIMInstance newInst = new CIMInstance(opNew, props);
            return newInst;
        }
        catch (ClassCastException cce) {
            String s = "Error: Unknown object type: " + cce.getMessage();
            LogLevel.log(30000, s, cce);
            throw new SMISException(1, s, cce);
        }
        catch (SMISException se) {
            throw se;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }
}

