/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.sm.common.event.smis.ZoneSetChange;
import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.common.SubscriptionTypeEnum;
import com.cisco.dcbu.smis.provider.helper.IndicationProviderHelper;
import com.cisco.dcbu.smis.provider.helper.MappingHelper;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class CISCO_ZoneSetAlertHelper
extends IndicationProviderHelper {
    private static final int NUM_KEYS = 1;
    private static final String CLS_ZONESETALERT = "CISCO_ZoneSetAlert";

    @Override
    public final String cimClassName() {
        return CLS_ZONESETALERT;
    }

    public final int numKeys() {
        return 1;
    }

    @Override
    public void deliverEvent(Object eventObj) {
        if (eventObj instanceof ZoneSetChange) {
            ZoneSetChange event = (ZoneSetChange)eventObj;
            try {
                CIMInstance inst = this.getInstance(event);
                this.deliverEvent(SubscriptionTypeEnum.ZoneSetAlert, inst);
            }
            catch (SMISException e) {
                String s = "Failed to deliver event: " + e.getMessage();
                LogLevel.log(30000, s, (Throwable)((Object)e));
            }
        } else {
            LogLevel.log(30000, "Invalid Event Type");
        }
    }

    @Override
    public CIMObjectPath getPath() throws SMISException {
        try {
            CIMProperty[] keyProps = new CIMProperty[]{};
            CIMObjectPath opNew = new CIMObjectPath(CLS_ZONESETALERT, this._namespace, keyProps);
            return opNew;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    @Override
    public CIMInstance getInstance(Object obj) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            ZoneSetChange event = (ZoneSetChange)obj;
            String swWwn = MappingHelper.smisWwnFormat(event.getSwWwn());
            int vsanId = event.getVsanId();
            String fabric = event.getFabricName();
            String zoneSetName = event.getZoneSetName();
            int state = event.getState();
            String stateDesc = state == 0 ? " Activated " : " Deactivated ";
            String description = "Zoneset " + zoneSetName + stateDesc + "in Switch " + swWwn + " vsan " + vsanId + " in Fabric " + fabric;
            CIMObjectPath opNew = this.getPath();
            CIMProperty[] props = new CIMProperty[]{new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false, false, "CISCO_AlertIndication"), new CIMProperty("IndicationIdentifier", CIMDataType.STRING_T, (Object)Long.toString(CISCO_ZoneSetAlertHelper.getIndicationId()), false, false, "CISCO_AlertIndication"), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)swWwn, false, false, "CIM_AlertIndication"), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", false, false, "CIM_AlertIndication"), new CIMProperty("AlertingElementFormat", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(2), false, false, "CIM_AlertIndication"), new CIMProperty("AlertingAdminDomain", CIMDataType.STRING_T, (Object)fabric, false, false, "CISCO_AlertIndication"), new CIMProperty("AlertingManagedElement", CIMDataType.STRING_T, (Object)this.getPhysicalComputerSystemObjectPath(swWwn), true, false, "CIM_AlertIndication"), new CIMProperty("AlertType", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(6), false, false, "CISCO_AlertIndication"), new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(4), false, false, "CISCO_AlertIndication"), new CIMProperty("OtherAlertType", CIMDataType.STRING_T, (Object)"Zone Alert", false, false, "CISCO_AlertIndication"), new CIMProperty("ProbableCause", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(1), true, false, "CISCO_AlertIndication"), new CIMProperty("DebugLevel", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(5), false, false, "CISCO_AlertIndication"), new CIMProperty("ProviderName", CIMDataType.STRING_T, (Object)"CISCO_ZoneSetAlertProvider", false, false, "CIM_AlertIndication"), new CIMProperty("Description", CIMDataType.STRING_T, (Object)description, false, false, "CISCO_AlertIndication"), new CIMProperty("VsanId", CIMDataType.UINT32_T, (Object)mappingHelper.intToUnsignedInteger32(vsanId), false, false, CLS_ZONESETALERT), new CIMProperty("ZoneSetName", CIMDataType.STRING_T, (Object)zoneSetName, false, false, CLS_ZONESETALERT)};
            CIMInstance newInst = new CIMInstance(opNew, props);
            return newInst;
        }
        catch (ClassCastException cce) {
            String s = "Error: Unknown object type: " + cce.getMessage();
            LogLevel.log(30000, s, cce);
            throw new SMISException(1, s, cce);
        }
        catch (SMISException se) {
            throw se;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }
}

