/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.provider.common.Config;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import java.util.ArrayList;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;

public abstract class ProviderHelper {
    static LogLevel _logger = new LogLevel();
    public String DELIMITER = Config.getInstance().getDelimiter();
    protected String _token;
    protected String _namespace = "cimv2";

    public abstract String cimClassName();

    public abstract CIMDataType cimRefType();

    public abstract ArrayList<CIMObjectPath> getAllNames() throws SMISException;

    public abstract ArrayList<CIMInstance> getAllInstances() throws SMISException;

    public abstract CIMInstance getInstance(CIMObjectPath var1) throws SMISException;

    public abstract CIMObjectPath getObjectPath(Object var1) throws SMISException;

    public abstract void getAssociatedNames(Object var1, ArrayList<CIMObjectPath> var2) throws SMISException;

    public abstract void getAssociatedObjects(Object var1, ArrayList<CIMInstance> var2) throws SMISException;

    public ArrayList<CIMObjectPath> getAssociatedNames(Object obj) throws SMISException {
        ArrayList<CIMObjectPath> ret = new ArrayList<CIMObjectPath>();
        this.getAssociatedNames(obj, ret);
        return ret;
    }

    public ArrayList<CIMInstance> getAssociatedObjects(Object obj) throws SMISException {
        ArrayList<CIMInstance> ret = new ArrayList<CIMInstance>();
        this.getAssociatedObjects(obj, ret);
        return ret;
    }

    protected void checkObjPath(CIMObjectPath op, int numKeys) throws SMISException {
        if (op == null) {
            throw new SMISException(4, "CIMObjectPath is null");
        }
        if (op.getKeys() == null || op.getKeys().length != numKeys) {
            String s = "Incorrect number of keys in CIMObjectPath: " + op.toString();
            LogLevel.log(30000, s);
            throw new SMISException(4, s);
        }
    }

    public abstract Object[] getAllDomainObjects() throws SMISException;

    public abstract Object getDomainObject(CIMObjectPath var1) throws SMISException;

    public void setToken(String tok) {
        this._token = tok;
    }

    public void setNamespace(String ns) {
        this._namespace = ns;
    }
}

