/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.jaxws.ep.Fabric;
import com.cisco.dcbu.smis.jaxws.ep.FabricKey;
import com.cisco.dcbu.smis.jaxws.ep.San;
import com.cisco.dcbu.smis.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.smis.jaxws.ep.SanServiceException;
import com.cisco.dcbu.smis.jaxws.ep.WwnKey;
import com.cisco.dcbu.smis.jaxws.ep._switch;
import com.cisco.dcbu.smis.provider.client.ReferenceFactory;
import com.cisco.dcbu.smis.provider.client.ReferenceIf;
import com.cisco.dcbu.smis.provider.common.CIMItemList;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.helper.ProviderHelper;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class SwitchProviderHelper
extends ProviderHelper {
    protected Fabric[] getAllFabrics() throws SMISException {
        ArrayList<Fabric> licfabrics = null;
        try {
            LogLevel.log(20000, "Getting all Fabrics ...");
            ReferenceIf _rif = ReferenceFactory.getInstance();
            San san = _rif.getSan(this._token);
            licfabrics = new ArrayList<Fabric>();
            Fabric[] fabrics = san.getFabrics();
            if (fabrics != null) {
                for (int i = 0; i < fabrics.length; ++i) {
                    if (!fabrics[i].isLicensed()) continue;
                    licfabrics.add(fabrics[i]);
                }
            }
            if (licfabrics.size() == 0) {
                String s = "No Fabrics found";
                LogLevel.log(30000, s);
                throw new SMISException(6, s);
            }
            LogLevel.log(20000, "Got: " + fabrics.length + " fabrics and " + fabrics.length + " licensed fabrics");
        }
        catch (SMISException se) {
            throw se;
        }
        catch (SanNotFoundException e) {
            LogLevel.log(30000, e.getMessage(), (Throwable)((Object)e));
        }
        catch (SanServiceException se) {
            throw new SMISException(1, "Error retrieving fabrics. Reason: " + se.getMessage1());
        }
        catch (Exception e) {
            String s = "Error retrieving fabrics. Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            throw new SMISException(1, s, e);
        }
        return licfabrics.toArray(new Fabric[0]);
    }

    protected _switch getPhysicalSwitch(WwnKey wwnKey) throws SMISException {
        _switch sw = null;
        try {
            ReferenceIf _rif = ReferenceFactory.getInstance();
            San san = _rif.getSan(this._token);
            sw = san.getSwitchByKey(wwnKey);
            if (sw == null) {
                String s = "Unable to find Switch " + wwnKey.getWwn().getValue();
                LogLevel.log(30000, s);
                throw new SMISException(6, s);
            }
        }
        catch (SanNotFoundException e) {
            String s = "Unable to find Switch " + wwnKey.getWwn().getValue();
            LogLevel.log(30000, s);
        }
        catch (SanServiceException se) {
            throw new SMISException(1, "Error retrieving switch :" + wwnKey.getWwn().getValue() + ". Reason: " + se.getMessage1());
        }
        catch (Exception e) {
            String s = "Error retrieving Switch : " + wwnKey.getWwn().getValue() + ". Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            throw new SMISException(1, s, e);
        }
        return sw;
    }

    protected void getAllPhysicalSwitches(CIMItemList<_switch> list) throws SMISException {
        _switch[] switches;
        for (_switch sw : switches = this.getAllPhysicalSwitches()) {
            list.add(sw);
        }
    }

    protected _switch[] getAllPhysicalSwitches() throws SMISException {
        ArrayList<_switch> switches = new ArrayList<_switch>();
        Fabric[] fabrics = this.getAllFabrics();
        if (fabrics != null && fabrics.length > 0) {
            for (Fabric f : fabrics) {
                try {
                    _switch[] sws = this.getAllPhysicalSwitchesForFabric(f.getFabricKey());
                    if (sws == null || sws.length <= 0) continue;
                    switches.addAll(Arrays.asList(sws));
                }
                catch (Exception e) {
                    LogLevel.log(30000, "Not able to get Switches in the Fabric with fabric key : " + f.getFabricKey().toString() + " due to " + e.getMessage(), e);
                }
            }
        }
        if (switches.size() == 0) {
            String s = "No Switches found";
            LogLevel.log(30000, s);
            throw new SMISException(6, s);
        }
        return switches.toArray(new _switch[0]);
    }

    protected _switch[] getAllPhysicalSwitchesForFabric(FabricKey fk) throws SMISException {
        _switch[] switches = null;
        try {
            ReferenceIf _rif = ReferenceFactory.getInstance();
            San san = _rif.getSan(this._token);
            switches = san.getSwitchesByFabric(fk);
            if (switches == null || switches.length == 0) {
                String s = "No Switches found in fabric " + fk.getName();
                LogLevel.log(30000, s);
                throw new SMISException(6, s);
            }
            LogLevel.log(20000, "Found: " + switches.length + " Switch instances in fabric " + fk.getName());
        }
        catch (SanNotFoundException se) {
            String s = "Error retrieving switches in fabric " + fk.getName() + ". Reason: " + se.getMessage();
            LogLevel.log(30000, s);
        }
        catch (SanServiceException se) {
            throw new SMISException(1, "Error retrieving switchs in fabric :" + fk.getName() + ". Reason: " + se.getMessage1());
        }
        catch (Exception e) {
            String s = "Error retrieving switches in fabric " + fk.getName() + ". Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            throw new SMISException(1, s, e);
        }
        return switches;
    }

    protected int ifIndex2Card(int ifIndex) {
        int type = this.getType(ifIndex);
        if (type == 10 || type == 4 || type == 5) {
            return -1;
        }
        if (type == 31 || type == 30) {
            return ifIndex >> 12 & 0xF;
        }
        return ifIndex >> 19 & 0x1F;
    }

    protected int ifIndex2Port(int ifIndex) {
        int type = this.getType(ifIndex);
        if (type == 31 || type == 30) {
            return ifIndex >> 6 & 0x3F;
        }
        return ifIndex >> 12 & 0x7F;
    }

    public int getType(int ifIndex) {
        return ifIndex >> 24;
    }

    protected int getPortnumberFromIfIndex(int ifIndex) {
        if (this.ifIndex2Card(ifIndex) > -1) {
            return (this.ifIndex2Card(ifIndex) + 1) * 100 + (this.ifIndex2Port(ifIndex) + 1);
        }
        return 0;
    }
}

