/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.test.util;

import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.test.cimparser.CimXmlResponseInfo;
import com.cisco.dcbu.smis.test.exceptions.ExpectedOutputPopulatorException;
import com.cisco.dcbu.smis.test.util.TestConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;

public class ExpectedOutputPopulator {
    public static final String EI = "_EI_";
    public static final String GI = "_GI_";
    public static final String NI = "_NI_";
    public static final String ANI = "_ANI_";
    public static final String AEI = "_AEI_";
    public static final String AGI = "_AGI_";
    public static final String AN = "_AN_AC";
    public static final String A = "_A_AC";
    public static final String ASSOCIATION = "_ASSOCIATION";
    static LogLevel trace = new LogLevel();
    static HashMap<String, List<CIMInstance>> outputResultMap_GI = new HashMap();
    static HashMap<String, List<CIMObjectPath>> outputResultMap_NI = new HashMap();
    static HashMap<String, List<CIMInstance>> outputResultMap_EI = new HashMap();
    static HashMap<String, List<CIMInstance>> outputResultMap_AGI = new HashMap();
    static HashMap<String, List<CIMObjectPath>> outputResultMap_ANI = new HashMap();
    static HashMap<String, List<CIMInstance>> outputResultMap_AEI = new HashMap();
    static HashMap<String, List<CIMObjectPath>> outputResultMap_AN = new HashMap();
    static HashMap<String, List<CIMInstance>> outputResultMap_A = new HashMap();
    static HashMap<String, List<String>> outputResultMap_Association = new HashMap();

    public static Boolean populate() throws ExpectedOutputPopulatorException {
        LogLevel.log(20000, "-------Entered-------");
        Map<String, List<String>> cimClasses2Operations = TestConfiguration.getCimClasses2Operations();
        Set<String> keys = cimClasses2Operations.keySet();
        String[] cimClassesArr = keys.toArray(new String[0]);
        try {
            for (String cimClass : cimClassesArr) {
                System.out.println("=====Populating for the CIM class ====== " + cimClass);
                String xmlResponsePath = TestConfiguration.getXMLResponsePath() + cimClass + File.separator;
                List<String> fileNames = TestConfiguration.getListOfFileNames(xmlResponsePath, ".xml");
                if (fileNames == null || fileNames.size() <= 0) {
                    throw new ExpectedOutputPopulatorException("No response files for the CIM class ==> " + cimClass);
                }
                for (String key : fileNames) {
                    List<CIMObjectPath> orgres;
                    CimXmlResponseInfo xmlRespInfo;
                    if (key.contains(AN) || key.contains(A)) {
                        for (String assocfile : fileNames) {
                            if (!assocfile.contains(ASSOCIATION)) continue;
                            CimXmlResponseInfo xmlRespInfo2 = new CimXmlResponseInfo(assocfile, cimClass);
                            List<String> associationName = xmlRespInfo2.getAssociationClassList();
                            outputResultMap_Association.put(cimClass, associationName);
                        }
                        if (outputResultMap_Association.size() == 0) {
                            String error = "Associtaion List for Class " + cimClass + "noy provided";
                            throw new ExpectedOutputPopulatorException(error);
                        }
                    }
                    if (key.contains(ANI)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMObjectPathForAssociationClass();
                        outputResultMap_ANI.put(key, orgres);
                        continue;
                    }
                    if (key.contains(AEI)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMInstancesForAssociationClass();
                        outputResultMap_AEI.put(key, orgres);
                        continue;
                    }
                    if (key.contains(AGI)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMInstancesForAssociationClass();
                        outputResultMap_AGI.put(key, orgres);
                        continue;
                    }
                    if (key.contains(EI)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMInstances();
                        outputResultMap_EI.put(key, orgres);
                        continue;
                    }
                    if (key.contains(GI)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMInstances();
                        outputResultMap_GI.put(key, orgres);
                        continue;
                    }
                    if (key.contains(NI)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMObjectPath();
                        outputResultMap_NI.put(key, orgres);
                        continue;
                    }
                    if (key.contains(AN)) {
                        xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                        orgres = xmlRespInfo.getCIMObjectPath();
                        outputResultMap_AN.put(key, orgres);
                        continue;
                    }
                    if (!key.contains(A)) continue;
                    xmlRespInfo = new CimXmlResponseInfo(key, cimClass);
                    orgres = xmlRespInfo.getCIMInstances();
                    outputResultMap_A.put(key, orgres);
                }
            }
        }
        catch (Exception e) {
            LogLevel.log(20000, "exception in ExpectedOutputPopulator :: populator ");
            throw new ExpectedOutputPopulatorException(e);
        }
        LogLevel.log(20000, "-------Exit-------");
        return true;
    }

    public static List<CIMInstance> getCIMInstanceListFromExpOuput(String fileName) throws ExpectedOutputPopulatorException {
        LogLevel.log(20000, "-------Entered-------");
        List<Object> cimInstanceList = new ArrayList();
        if (fileName.contains(EI)) {
            cimInstanceList = outputResultMap_EI.get(fileName);
        } else if (fileName.contains(GI)) {
            cimInstanceList = outputResultMap_GI.get(fileName);
        } else if (fileName.contains(AGI)) {
            cimInstanceList = outputResultMap_AGI.get(fileName);
        } else if (fileName.contains(AEI)) {
            cimInstanceList = outputResultMap_AEI.get(fileName);
        } else if (fileName.contains(A)) {
            cimInstanceList = outputResultMap_A.get(fileName);
        } else {
            throw new ExpectedOutputPopulatorException("The supplied file name doesnot have either EI or GI key");
        }
        LogLevel.log(20000, "-------Exit-------");
        return cimInstanceList;
    }

    public static List<CIMObjectPath> getCIMObjectPathFromExpOuput(String fileName) throws ExpectedOutputPopulatorException {
        LogLevel.log(20000, "-------Entered-------");
        List<Object> copList = new ArrayList();
        if (fileName.contains(NI)) {
            copList = outputResultMap_NI.get(fileName);
        } else if (fileName.contains(ANI)) {
            copList = outputResultMap_ANI.get(fileName);
        } else if (fileName.contains(AN)) {
            copList = outputResultMap_AN.get(fileName);
        } else {
            throw new ExpectedOutputPopulatorException("The supplied file name doesnot have NI");
        }
        LogLevel.log(20000, "-------Exit-------");
        return copList;
    }

    public static List<String> getAssociationListForClass(String className) throws ExpectedOutputPopulatorException {
        LogLevel.log(20000, "-------Entered getAssociationListForClass-------");
        List<Object> assocNameList = new ArrayList();
        if (className != null && !className.equals("")) {
            assocNameList = outputResultMap_Association.get(className);
            if (assocNameList != null && assocNameList.size() != 0) {
                return assocNameList;
            }
            throw new ExpectedOutputPopulatorException("Association list not supplied for className" + className);
        }
        throw new ExpectedOutputPopulatorException("The supplied classname is wrong");
    }

    public static void main(String[] args) {
        System.out.println("in main");
        ExpectedOutputPopulator obj = new ExpectedOutputPopulator();
    }
}

