/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.test.util;

import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.test.util.CimXmlFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TestConfiguration {
    static LogLevel trace = new LogLevel();
    public static final String XML_EXTENSION = ".xml";
    private static Map<String, List<String>> cimClasses2Operations = new HashMap<String, List<String>>();
    private static final String SEPARATOR_TAG = "#########################################################\r\n";
    private static final String CIM_CLASS = "CIM CLASS           :";
    private static final String LINE_BREAK = "\r\n";
    private static final String REQUEST_FILE_NAME = "REQUEST FILE NAME   :";
    private static final String RESULT = "RESULT              :";
    private static final String SEPARATOR = "\\";
    private static final String GENERIC_FILE_SEPARATOR = File.separator;
    private static final Boolean TRUE = true;
    private static final String PASSED = "PASSED";
    private static final String FAILED = "FAILED";
    private static final String confFilePath = "com\\cisco\\dcbu\\smis\\test\\configuration\\TestDriver.conf";
    private static final String CIM_XML_REQUEST_RESPONSE_ZIP_FILE = "com\\cisco\\dcbu\\smis\\test\\configuration\\testcases.zip";
    static Properties propertiesFile = new Properties();

    public static void main(String[] args) throws IOException {
        TestConfiguration.unZipCimXmlRequestResponse();
    }

    public static String getXMLRequestPath() {
        String XMLRequestPath = propertiesFile.getProperty("XML_REQUEST_PATH");
        return TestConfiguration.makeGeneric(XMLRequestPath);
    }

    public static String getParserRulesPath() {
        String ParserRulesPath = propertiesFile.getProperty("PARSER_RULES_PATH");
        return TestConfiguration.makeGeneric(ParserRulesPath);
    }

    public static String getXMLResponsePath() {
        String XMLResponsePath = propertiesFile.getProperty("XML_RESPONSE_PATH");
        return TestConfiguration.makeGeneric(XMLResponsePath);
    }

    public static String getTestCasesPath() {
        String testCasesPath = propertiesFile.getProperty("TESTCASES_PATH");
        return TestConfiguration.makeGeneric(testCasesPath);
    }

    public static String getReportPath() {
        String reportPath = propertiesFile.getProperty("REPORT_PATH");
        return TestConfiguration.makeGeneric(reportPath);
    }

    public static Boolean isReportGeneration() {
        String reportGenerationStatus = propertiesFile.getProperty("REPORT_GENARATION");
        Boolean isReportGeneration = Boolean.parseBoolean(reportGenerationStatus);
        return isReportGeneration;
    }

    public static String getNameSpace() {
        String NameSpace = propertiesFile.getProperty("NAMESPACE");
        return NameSpace;
    }

    private static void populateCimClasses2OperationsList() {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(TestConfiguration.getTestCasesPath()));
            while ((str = in.readLine()) != null) {
                if (str.startsWith("#")) continue;
                String[] cimClass2Operations = str.split("=");
                String cimClass = cimClass2Operations[0];
                String operType = cimClass2Operations[1];
                String[] opTypes = operType.split(" ");
                cimClasses2Operations.put(cimClass, Arrays.asList(opTypes));
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Map<String, List<String>> getCimClasses2Operations() {
        return cimClasses2Operations;
    }

    private static String makeGeneric(String filePath) {
        String genericFilePath = filePath.replace(SEPARATOR, GENERIC_FILE_SEPARATOR);
        return genericFilePath;
    }

    public static void unZipCimXmlRequestResponse() throws IOException {
        try {
            ZipEntry entry;
            int BUFFER = 1024;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(CIM_XML_REQUEST_RESPONSE_ZIP_FILE);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                int i = 0;
                if (entry.isDirectory()) {
                    if (entry.getName().contains("request") || entry.getName().contains("response")) {
                        new File(entry.getName()).mkdir();
                        ++i;
                    }
                    if (i <= true) continue;
                    new File(entry.getName()).mkdir();
                    continue;
                }
                System.out.println("Extracting = : " + entry.getName());
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(entry.getName());
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = zis.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> getListOfFileNames(String dirName, String operType, String fileExtn) {
        File[] listOfFiles;
        ArrayList<String> fileNames = new ArrayList<String>();
        File response = new File(dirName);
        CimXmlFilter filter = new CimXmlFilter(operType, fileExtn);
        for (File f : listOfFiles = response.listFiles(filter)) {
            if (!f.isFile()) continue;
            fileNames.add(f.getName());
        }
        return fileNames;
    }

    public static List<String> getListOfFileNames(String dirName, String fileExtn) {
        return TestConfiguration.getListOfFileNames(dirName, null, fileExtn);
    }

    public static void writeTestResultReport(String cimclass, String oper, Boolean result) {
        try {
            LogLevel.log(20000, "-------Entered-------");
            File f = new File(TestConfiguration.getReportPath());
            FileWriter fw = new FileWriter(f, (boolean)TRUE);
            if (f.exists()) {
                fw.write(SEPARATOR_TAG);
                fw.write(CIM_CLASS);
                fw.write(cimclass);
                fw.write(LINE_BREAK);
                fw.write(REQUEST_FILE_NAME);
                fw.write(oper);
                fw.write(LINE_BREAK);
                fw.write(RESULT);
                if (result.equals(TRUE)) {
                    fw.write(PASSED);
                } else {
                    fw.write(FAILED);
                }
                fw.write(LINE_BREAK);
                fw.write(SEPARATOR_TAG);
                fw.write(LINE_BREAK);
                fw.close();
            } else {
                LogLevel.log(30000, "File does not exist" + TestConfiguration.getReportPath());
            }
        }
        catch (IOException ioe) {
            LogLevel.log(30000, "EXCEPTION CAUGHT:" + ioe);
        }
        LogLevel.log(20000, "-------Exit-------");
    }

    static {
        try {
            propertiesFile.load(new FileInputStream(confFilePath));
            TestConfiguration.populateCimClasses2OperationsList();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

