/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.test.util;

import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.test.exceptions.VerificationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;

public class Verification {
    public static final int INT_VALUE = 1;
    public static final int STRING_VALUE = 2;
    public static final int BOOLEAN_VALUE = 3;
    public static final int DATEANDTIME_VALUE = 4;
    static LogLevel trace = new LogLevel();

    public Boolean verifyCIMInstance(List<CIMInstance> cimInsProvList, List<CIMInstance> cimInsExptdList, String fileName) throws VerificationException {
        LogLevel.log(20000, "-------Entered-------");
        if (cimInsProvList.size() != cimInsExptdList.size()) {
            LogLevel.log(20000, "The verification failed : The size of both lists are NOT same\n");
            return false;
        }
        LogLevel.log(20000, "The Prov list size::\n" + cimInsProvList.size());
        LogLevel.log(20000, "The Expt list size::\n" + cimInsExptdList.size());
        for (CIMInstance provciminst : cimInsProvList) {
            try {
                if (this.findProvInsInExptdList(provciminst, cimInsExptdList, fileName).booleanValue()) continue;
                LogLevel.log(20000, "The verification failed :The CIM intance NOT present in cimInsExptdList ::\n" + provciminst.getObjectPath().toString());
                return false;
            }
            catch (VerificationException e) {
                e.printStackTrace();
                throw new VerificationException(e);
            }
        }
        LogLevel.log(20000, "The verification passed\n");
        LogLevel.log(20000, "-------Exit-------");
        return true;
    }

    private Boolean findProvInsInExptdList(CIMInstance provInst, List<CIMInstance> instList, String fileName) throws VerificationException {
        LogLevel.log(20000, "-------Entered-------");
        for (CIMInstance exptInst : instList) {
            try {
                if (!this.isCIMInsMatching(provInst, exptInst, fileName).booleanValue()) continue;
                LogLevel.log(20000, "The prov intance found in Expt List\n");
                return true;
            }
            catch (VerificationException e) {
                e.printStackTrace();
                throw new VerificationException(e);
            }
        }
        LogLevel.log(20000, "The prov intance NOT found in Expt List\n");
        LogLevel.log(20000, "-------Exit-------");
        return false;
    }

    private Boolean isCIMInsMatching(CIMInstance provins, CIMInstance exptins, String fileName) throws VerificationException {
        CIMProperty[] provProplist;
        LogLevel.log(20000, "-------Entered-------");
        if (fileName.contains("AEI")) {
            LogLevel.log(20000, "checking for COPS in association of EI");
            String expobj = exptins.getObjectPath().toString();
            expobj = expobj.replaceFirst("\"", "").replace("\\", "").replace("\"\"", "\"").replace("\"/", "/");
            String provObj = provins.getObjectPath().toString();
            if (!provObj.equals(expobj)) {
                LogLevel.log(20000, "The COP NOT Matching for associations\n");
                LogLevel.log(20000, "The COP of Prov associations is" + provObj + "\n");
                LogLevel.log(20000, "The COP of Expt associations is" + expobj + "\n");
                return false;
            }
        } else {
            LogLevel.log(20000, "checking for COPS in providers of EI");
            if (!provins.equals((Object)exptins)) {
                LogLevel.log(20000, "The COP NOT Matching\n");
                LogLevel.log(20000, "The COP of Prov is " + provins.getObjectPath().toString() + "\n");
                LogLevel.log(20000, "The COP of Expt is " + exptins.getObjectPath().toString() + "\n");
                return false;
            }
        }
        int provSz = provins.getPropertyCount();
        int exptSz = exptins.getPropertyCount();
        LogLevel.log(20000, "The size of Prov property list " + provSz);
        LogLevel.log(20000, "The size of Expt property list " + exptSz);
        if (provSz != exptSz) {
            LogLevel.log(20000, "The size of property lists NOT Matching\n");
            return false;
        }
        block4: for (CIMProperty provProp : provProplist = provins.getProperties()) {
            CIMProperty exptProp = exptins.getProperty(provProp.getName());
            if (exptProp == null) {
                LogLevel.log(20000, "The  Expt property Name :: " + exptProp + " is null");
                throw new VerificationException("The  Expt property Name :: " + exptProp + " is null");
            }
            CIMDataType provType = provProp.getDataType();
            CIMDataType exptType = exptProp.getDataType();
            LogLevel.log(20000, "First time Prov property value ::" + provProp.getName() + " datatype " + provType);
            LogLevel.log(20000, "First time Expt property value ::" + exptProp.getName() + " datatype " + exptType);
            if (exptType.isArray()) {
                LogLevel.log(20000, "property!!!! is an array" + provProp.getName());
            }
            if (!fileName.contains("AEI") && !provType.equals((Object)exptType)) {
                LogLevel.log(20000, "the property TYPE of CIM property NOT equal\n");
                throw new VerificationException("The property Type NOT equal\nprovType is ::" + provType + "exptType is ::" + exptType);
            }
            Object Provval = provProp.getValue();
            Object exptval = exptProp.getValue();
            LogLevel.log(20000, "First time Prov property value ::" + Provval);
            LogLevel.log(20000, "First time Expt property value ::" + exptval);
            if (Provval == null && exptval == null) {
                LogLevel.log(20000, "both the property values are null\n");
                continue;
            }
            if (Provval == null || exptval == null) {
                LogLevel.log(20000, "one of the property value is null\n");
                LogLevel.log(20000, "Prov property value ::" + Provval);
                LogLevel.log(20000, "Expt property value ::" + exptval);
                throw new VerificationException("One of the property Value is null\nProvval is ::" + Provval + "exptval is ::" + exptval);
            }
            boolean arrayType = false;
            arrayType = this.checkCIMDataTypeForArray(provType);
            int typ = this.checkCIMDataType(provType);
            switch (typ) {
                case 1: {
                    if (arrayType) {
                        if (Arrays.equals((UnsignedInteger16[])Provval, (UnsignedInteger16[])exptval)) continue block4;
                        LogLevel.log(20000, "the property value of CIM Property arrays for int!!!!!!! are not equal\n");
                        return false;
                    }
                    if (Provval.equals(exptval)) continue block4;
                    LogLevel.log(20000, "the property value of CIM Property NOT equal\n");
                    LogLevel.log(20000, "Prov property value ::" + Provval);
                    LogLevel.log(20000, "Expt property value ::" + exptval);
                    return false;
                }
                case 2: {
                    if (arrayType) {
                        if (Arrays.equals((String[])Provval, (String[])exptval)) continue block4;
                        LogLevel.log(20000, "the property value of CIM Property arrays for string!!!!!!! are not equal\n");
                        return false;
                    }
                    String ProvvalStr = (String)Provval;
                    String exptvalStr = (String)exptval;
                    if (ProvvalStr.equalsIgnoreCase(exptvalStr)) continue block4;
                    LogLevel.log(20000, "the property value of CIM Property NOT equal\n");
                    LogLevel.log(20000, "Prov property value ::" + Provval);
                    LogLevel.log(20000, "Expt property value ::" + exptval);
                    return false;
                }
            }
        }
        LogLevel.log(20000, "-------Exit-------");
        return true;
    }

    public Boolean verifyCIMInstanceForGI(CIMInstance provcimInst, CIMInstance ExptcimInst, String fileName) throws VerificationException {
        Boolean result;
        LogLevel.log(20000, "-------Entered-------");
        try {
            result = this.tempisCIMInsMatching(provcimInst, ExptcimInst, fileName);
            LogLevel.log(20000, "the CIM Instance for GI verification is over\n");
        }
        catch (VerificationException e) {
            throw new VerificationException(e);
        }
        LogLevel.log(20000, "-------Exit-------");
        return result;
    }

    private Boolean tempisCIMInsMatching(CIMInstance provins, CIMInstance exptins, String fileName) throws VerificationException {
        CIMProperty[] provProplist;
        LogLevel.log(20000, "-------Entered-------");
        int provSz = provins.getPropertyCount();
        int exptSz = exptins.getPropertyCount();
        LogLevel.log(20000, "The size of Prov property list " + provSz);
        LogLevel.log(20000, "The size of Prov property list " + exptSz);
        if (provSz != exptSz) {
            LogLevel.log(20000, "The size of property lists NOT Matching\n");
            return false;
        }
        block4: for (CIMProperty provProp : provProplist = provins.getProperties()) {
            CIMProperty exptProp = exptins.getProperty(provProp.getName());
            if (exptProp == null) {
                LogLevel.log(20000, "The  Expt property Name :: " + exptProp + " is null");
                throw new VerificationException("The  Expt property Name :: " + exptProp + " is null");
            }
            CIMDataType provType = provProp.getDataType();
            CIMDataType exptType = exptProp.getDataType();
            if (exptType.isArray()) {
                LogLevel.log(20000, "property is an array" + provProp.getName());
            }
            LogLevel.log(20000, "First time Prov property value ::" + provProp.getName());
            LogLevel.log(20000, "First time Expt property value ::" + exptProp.getName());
            LogLevel.log(20000, "First time Prov property value ::" + provType);
            LogLevel.log(20000, "First time Expt property value ::" + exptType);
            if (!fileName.contains("AGI") && !provType.equals((Object)exptType)) {
                LogLevel.log(20000, "the property TYPE of CIM property NOT equal\n");
                throw new VerificationException("The property Type NOT equal\nprovType is ::" + provType + "exptType is ::" + exptType);
            }
            Object Provval = provProp.getValue();
            Object exptval = exptProp.getValue();
            LogLevel.log(20000, "First time Prov property value ::" + Provval);
            LogLevel.log(20000, "First time Expt property value ::" + exptval);
            if (Provval == null && exptval == null) {
                LogLevel.log(20000, "both the property values are null\n");
                continue;
            }
            if (Provval == null || exptval == null) {
                LogLevel.log(20000, "one of the property value is null\n");
                LogLevel.log(20000, "Prov property value ::" + Provval);
                LogLevel.log(20000, "Expt property value ::" + exptval);
                throw new VerificationException("One of the property Value is null\nProvval is ::" + Provval + "exptval is ::" + exptval);
            }
            boolean arrayType = false;
            arrayType = this.checkCIMDataTypeForArray(provType);
            int typ = this.checkCIMDataType(provType);
            switch (typ) {
                case 1: {
                    if (arrayType) {
                        if (Arrays.equals((UnsignedInteger16[])Provval, (UnsignedInteger16[])exptval)) continue block4;
                        LogLevel.log(20000, "the property value of CIM Property arrays for int are not equal\n");
                        return false;
                    }
                    if (Provval.equals(exptval)) continue block4;
                    LogLevel.log(20000, "the property value of CIM Property NOT equal\n");
                    LogLevel.log(20000, "Prov property value ::" + Provval);
                    LogLevel.log(20000, "Expt property value ::" + exptval);
                    return false;
                }
                case 2: {
                    if (arrayType) {
                        if (Arrays.equals((String[])Provval, (String[])exptval)) continue block4;
                        LogLevel.log(20000, "the property value of CIM Property arrays for string are not equal\n");
                        return false;
                    }
                    String ProvvalStr = (String)Provval;
                    String exptvalStr = (String)exptval;
                    if (ProvvalStr.equalsIgnoreCase(exptvalStr)) continue block4;
                    LogLevel.log(20000, "the property value of CIM Property NOT equal\n");
                    LogLevel.log(20000, "Prov property value ::" + Provval);
                    LogLevel.log(20000, "Expt property value ::" + exptval);
                    return false;
                }
            }
        }
        LogLevel.log(20000, "-------Exit-------");
        return true;
    }

    private boolean checkCIMDataTypeForArray(CIMDataType dataType) {
        return dataType.isArray();
    }

    private int checkCIMDataType(CIMDataType dataType) {
        int value = 0;
        switch (dataType.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                value = 1;
                break;
            }
            case 8: {
                value = 2;
                break;
            }
            case 9: {
                value = 3;
                break;
            }
            case 12: {
                value = 4;
            }
        }
        return value;
    }

    public Boolean verifyCIMObjectPath(List<CIMObjectPath> cimInsProvList, List<CIMObjectPath> cimExptdList, String fileName) {
        LogLevel.log(20000, "-------Entered-------");
        Boolean result = false;
        String expobj = null;
        ArrayList<String> cimobjpathExptdList = new ArrayList<String>();
        ArrayList<String> cimobjpathProvList = new ArrayList<String>();
        LogLevel.log(20000, "entered the Verification::verifyCIMObjectPath ");
        LogLevel.log(20000, "the obj path of provider " + cimInsProvList);
        LogLevel.log(20000, "the obj path of expected " + cimExptdList);
        LogLevel.log(20000, "size of cimobjpathProvtdList " + cimInsProvList.size());
        LogLevel.log(20000, "the size of cimobjpathExptdList" + cimExptdList.size());
        if (cimInsProvList.size() == cimExptdList.size()) {
            LogLevel.log(20000, "the size of both lists are same\n");
            if (fileName.contains("ANI")) {
                LogLevel.log(20000, "verifying for NI in association");
                for (CIMObjectPath expObjpath : cimExptdList) {
                    expobj = expObjpath.toString();
                    expobj = expobj.replaceFirst("\"", "").replace("\\", "").replace("\"\"", "\"").replace("\"/", "/");
                    LogLevel.log(20000, "!!!!!! stringobj " + expobj);
                    cimobjpathExptdList.add(expobj);
                }
                for (CIMObjectPath provObjpath : cimInsProvList) {
                    cimobjpathProvList.add(provObjpath.toString());
                }
                return this.verifyCIMObjectpathForAssociation(cimobjpathExptdList, cimobjpathProvList);
            }
            for (CIMObjectPath provObjpath : cimInsProvList) {
                if (cimExptdList.contains(provObjpath)) continue;
                LogLevel.log(20000, "the  CIMObjectPath  NOT Present in Expted List, provpath is ::\n" + provObjpath);
                LogLevel.log(20000, " Verification::verifyCIMObjectPath result is - " + result);
                LogLevel.log(20000, "-------Exit-------");
                return result;
            }
            result = true;
            LogLevel.log(20000, " Verification::verifyCIMObjectPath result is - " + result);
            LogLevel.log(20000, "-------Exit-------");
            return result;
        }
        LogLevel.log(20000, "the size of both lists are NOT same\n");
        LogLevel.log(20000, " Verification::verifyCIMObjectPath result is - " + result);
        LogLevel.log(20000, "-------Exit-------");
        return result;
    }

    boolean verifyCIMObjectpathForAssociation(List<String> expectedList, List<String> providerList) {
        boolean result = false;
        for (String provObjpath : providerList) {
            if (expectedList.contains(provObjpath)) continue;
            LogLevel.log(20000, "the  CIMObjectPath  NOT Present in Expted List, provpath is ::\n" + provObjpath);
            LogLevel.log(20000, " Verification::verifyCIMObjectPath result is - " + result);
            LogLevel.log(20000, "-------Exit-------");
            return result;
        }
        result = true;
        LogLevel.log(20000, " Verification::verifyCIMObjectPath result is - " + result);
        LogLevel.log(20000, "-------Exit-------");
        return result;
    }

    public ArrayList<CIMObjectPath> CreateMockCIMObjectPath(String nameSpace, int number, int value) {
        String objectName = "cisco_admindomain";
        ArrayList<CIMObjectPath> retArr = new ArrayList<CIMObjectPath>();
        for (int i = 0; i < number; ++i) {
            CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)("CISCO_AdminDomain" + value), true, false, "CIM_System"), new CIMProperty("Name", CIMDataType.SINT32_T, (Object)"20:00:00:0d:ec:20:d8:00", true, false, "CIM_System")};
            ++value;
            CIMObjectPath ObjectPath = new CIMObjectPath(objectName, nameSpace, keyProps);
            retArr.add(ObjectPath);
        }
        LogLevel.log(20000, "-------Exit-------");
        return retArr;
    }

    public ArrayList<CIMInstance> CreateMockCIMInstance(String nameSpace, int number, int value, int info) {
        String objectName = "cisco_admindomain";
        ArrayList<CIMInstance> retArr = new ArrayList<CIMInstance>();
        for (int i = 0; i < number; ++i) {
            CIMInstance ciminst;
            CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)("wipro" + value), true, false, "CIM_System"), new CIMProperty("Name", CIMDataType.SINT32_T, (Object)2001000, true, false, "CIM_System")};
            CIMProperty[] keyProps1 = new CIMProperty[]{new CIMProperty("ElementName", CIMDataType.STRING_ARRAY_T, (Object)("{fabric9}" + value), true, false, "CIM_ManagedElement"), new CIMProperty("Name", CIMDataType.SINT32_T, (Object)2001000, true, false, "CIM_System"), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)("wipro" + value), true, false, "CIM_System")};
            CIMObjectPath ObjectPath = null;
            if (info == 0) {
                ObjectPath = new CIMObjectPath(objectName, nameSpace, keyProps);
                ciminst = new CIMInstance(ObjectPath, keyProps1);
            } else {
                CIMProperty[] keyProps2 = new CIMProperty[]{new CIMProperty("ElementName", CIMDataType.STRING_ARRAY_T, (Object)("{fabric9}" + value), true, false, "CIM_ManagedElement"), new CIMProperty("Name", CIMDataType.SINT32_T, (Object)2001000, true, false, "CIM_System"), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)("wipro" + value), true, false, "CIM_System")};
                CIMProperty[] keyProps3 = new CIMProperty[]{new CIMProperty("Name", CIMDataType.SINT32_T, (Object)2001000, true, false, "CIM_System"), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)("wipro" + value), true, false, "CIM_System")};
                ObjectPath = new CIMObjectPath(objectName, nameSpace, keyProps3);
                ciminst = new CIMInstance(ObjectPath, keyProps2);
            }
            ++value;
            retArr.add(ciminst);
        }
        return retArr;
    }

    public static void main(String[] args) {
    }
}

