/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.db;

import com.cisco.dcbu.jaxws.san.wo.SMISHostDO;
import com.cisco.dcbu.jaxws.san.wo.SMISNavItemDO;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HostHelper {
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    private static final String insertSql = "INSERT INTO SMIS_HOST (ID, SYSTEM_DB_ID, HOST_NWWN, HOST_NAME, LAST_UPDATED) VALUES (?,?,?,?,?)";
    private static final String updateSql = "UPDATE SMIS_HOST SET SYSTEM_DB_ID=?, HOST_NWWN=?, HOST_NAME=?, LAST_UPDATED=?  WHERE ID=?";
    private static final String checkSql = "SELECT ID FROM SMIS_HOST WHERE SYSTEM_DB_ID=? AND HOST_NAME=?";
    private static final String getNavListSql = "SELECT ID, HOST_NAME FROM SMIS_HOST WHERE SYSTEM_DB_ID=? ORDER BY HOST_NAME ASC";
    private static final String getSql = "SELECT HOST_NWWN, HOST_NAME, LAST_UPDATED FROM SMIS_HOST WHERE ID=? ORDER BY HOST_NAME ASC";
    private static final String getListSql = "SELECT ID, HOST_NWWN, HOST_NAME, LAST_UPDATED FROM SMIS_HOST WHERE SYSTEM_DB_ID=? ORDER BY HOST_NAME ASC";
    private static final String getListLengthSql = "SELECT COUNT(ID) FROM SMIS_HOST WHERE SYSTEM_DB_ID=?";
    private static final String getTimeListSql = "SELECT ID, HOST_NAME, LAST_UPDATED FROM SMIS_HOST WHERE SYSTEM_DB_ID=? ORDER BY HOST_NAME ASC";
    private static final String cleanupSql = "DELETE FROM SMIS_HOST WHERE ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(Connection con, StorageSystem storageSystem) throws SQLException {
        if (con == null || storageSystem == null) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(insertSql);
            updateStat = con.prepareStatement(updateSql);
            Iterator<Host> iter = storageSystem.get_hosts().iterator();
            long now = System.currentTimeMillis();
            while (iter.hasNext()) {
                Host obj = iter.next();
                long sysId = storageSystem.getDBID();
                if (obj.getDBID() == 0L) {
                    checkStat = con.prepareStatement(checkSql);
                    HostHelper.setupCheckExistenceStatement(sysId, obj, checkStat);
                    SMISHelper.checkPreexistRecord(obj, checkStat);
                }
                if (obj.getDBID() == 0L) {
                    obj.setDBID(Sequence.getSequence().getPK());
                    HostHelper.setupInsertStatement(sysId, obj, insertStat);
                    insertStat.addBatch();
                } else if (obj.isModified() || obj.isPresent()) {
                    obj.setLastUpdateTime(now);
                    HostHelper.setupUpdateStatement(sysId, obj, updateStat);
                    if (updateStat.executeUpdate() < 1) {
                        obj.setDBID(Sequence.getSequence().getPK());
                        HostHelper.setupInsertStatement(sysId, obj, insertStat);
                        insertStat.addBatch();
                    }
                }
                obj.setFlushed(true);
            }
            insertStat.executeBatch();
            for (Host obj : storageSystem.get_hosts()) {
                if (!obj.get_strgHwids().isEmpty()) continue;
                obj.clearModified();
                obj.setPresent(false);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public static void setupInsertStatement(long systemDbId, Host obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, obj.getDBID());
        stat.setLong(i++, systemDbId);
        stat.setString(i++, obj.getNwwn());
        stat.setString(i++, obj.get_pKey()._name);
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public static void setupUpdateStatement(long systemDbId, Host obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        Timestamp now = new Timestamp(obj.getLastUpdateTime());
        stat.setLong(i++, systemDbId);
        stat.setString(i++, obj.getNwwn());
        stat.setString(i++, obj.get_pKey()._name);
        stat.setTimestamp(i++, now);
        stat.setLong(i++, obj.getDBID());
    }

    public static void setupCheckExistenceStatement(long systemDbId, Host obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, systemDbId);
        stat.setString(2, obj.get_pKey()._name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISNavItemDO[] getNavList(Connection con, long dbid) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISNavItemDO> ssl = new ArrayList<SMISNavItemDO>();
        try {
            getStat = con.prepareStatement(getNavListSql);
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                SMISNavItemDO obj = new SMISNavItemDO();
                obj.setDbid(rs.getLong(i++));
                obj.setLabel(rs.getString(i++));
                ssl.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Host list for system " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl.toArray(new SMISNavItemDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISHostDO get(Connection con, long dbid, Timestamp time) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        SMISHostDO obj = null;
        try {
            getStat = con.prepareStatement(getSql);
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                obj = new SMISHostDO();
                obj.setDbId(dbid);
                obj.setNwwn(rs.getString(i++));
                obj.setName(rs.getString(i++));
                Timestamp t = rs.getTimestamp(i++);
                obj.setLastSeen(t.toString());
                if (t.after(time)) {
                    obj.setPresent(true);
                    continue;
                }
                obj.setPresent(false);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Host with id " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISHostDO[] getList(Connection con, long dbid, Timestamp time) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISHostDO> ssl = new ArrayList<SMISHostDO>();
        try {
            getStat = con.prepareStatement(getListSql);
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                SMISHostDO obj = new SMISHostDO();
                obj.setDbId(rs.getLong(i++));
                obj.setNwwn(rs.getString(i++));
                obj.setName(rs.getString(i++));
                Timestamp t = rs.getTimestamp(i++);
                obj.setLastSeen(t.toString());
                if (t.after(time)) {
                    obj.setPresent(true);
                } else {
                    obj.setPresent(false);
                }
                ssl.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Host list for system " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl.toArray(new SMISHostDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getListLength(Connection con, long dbid) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        int count = 0;
        try {
            getStat = con.prepareStatement(getListLengthSql);
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Host list length for system " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDbId(long dbid, String name, Connection con) throws SQLException {
        PreparedStatement stat = con.prepareStatement(checkSql);
        stat.setLong(1, dbid);
        stat.setString(2, name);
        ResultSet rs = null;
        try {
            rs = stat.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(Connection con, StorageSystem sys, Timestamp expired) {
        PreparedStatement getStat = null;
        PreparedStatement cleanStat = null;
        ResultSet rs = null;
        try {
            getStat = con.prepareStatement(getTimeListSql);
            getStat.setLong(1, sys.getDBID());
            cleanStat = con.prepareStatement(cleanupSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                long dbid = rs.getLong(1);
                String name = rs.getString(2);
                Timestamp ts = rs.getTimestamp(3);
                if (ts.getTime() >= expired.getTime()) continue;
                _Logger.info((Object)("Host " + name + " has timestamp " + ts + " cleaning out."));
                cleanStat.setLong(1, dbid);
                cleanStat.addBatch();
            }
            cleanStat.executeBatch();
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception during cleanup for system " + sys.getDBID()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                DbUtil.close(cleanStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
            DbUtil.close(cleanStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        DbUtil.close(cleanStat);
    }
}

