/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.db;

import com.cisco.dcbu.jaxws.san.wo.SMISHostLunMappingDO;
import com.cisco.dcbu.jaxws.san.wo.SMISHostPortDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import com.cisco.dcbu.storage.db.HostPortHelper;
import com.cisco.dcbu.storage.db.LunHelper;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HostLunMapHelper {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    private static final String insertSql = "INSERT INTO SMIS_HOST_LUN_MAP (ID, SYSTEM_DB_ID, HOST_PORT_DB_ID, LUN_DB_ID, HOST_LUN_ID, READABLE_HOST_NAME, TARGET_PWWN, LUN_ID, ADAPTER_NAME, LUN_ACCESS, ACCESS_PRIV_GRANTED, LAST_UPDATED) VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?)";
    private static final String updateSql = "UPDATE SMIS_HOST_LUN_MAP SET SYSTEM_DB_ID=?, HOST_PORT_DB_ID=?, LUN_DB_ID=?, HOST_LUN_ID=?, READABLE_HOST_NAME=?, TARGET_PWWN=?, LUN_ID=?, ADAPTER_NAME=?, LUN_ACCESS=?, ACCESS_PRIV_GRANTED=?, LAST_UPDATED=?  WHERE ID=?";
    private static final String checkSql = "SELECT ID FROM SMIS_HOST_LUN_MAP WHERE SYSTEM_DB_ID=? AND HOST_PORT_DB_ID=? AND TARGET_PWWN=? AND LUN_DB_ID=?";
    private static final String getListByLUNSql = "SELECT SMIS_HOST_LUN_MAP.ID, SMIS_HOST.HOST_NAME, SMIS_HOST_LUN_MAP.READABLE_HOST_NAME, SMIS_HOST_PORT.HOST_PWWN, SMIS_HOST_LUN_MAP.TARGET_PWWN, SMIS_HOST_LUN_MAP.LUN_ID, SMIS_HOST_LUN_MAP.HOST_LUN_ID, SMIS_HOST_LUN_MAP.LUN_ACCESS, SMIS_HOST_LUN_MAP.ACCESS_PRIV_GRANTED, SMIS_HOST_LUN_MAP.ADAPTER_NAME, SMIS_HOST_LUN_MAP.LAST_UPDATED FROM SMIS_HOST, SMIS_HOST_PORT, SMIS_HOST_LUN_MAP WHERE SMIS_HOST_LUN_MAP.SYSTEM_DB_ID=? AND SMIS_HOST_LUN_MAP.LUN_DB_ID=? AND SMIS_HOST_LUN_MAP.HOST_PORT_DB_ID=SMIS_HOST_PORT.ID AND SMIS_HOST_PORT.HOST_DB_ID=SMIS_HOST.ID  ORDER BY SMIS_HOST.HOST_NAME ASC";
    private static final String getListByHostSql = "SELECT SMIS_HOST_LUN_MAP.ID, SMIS_HOST.HOST_NAME, SMIS_HOST_LUN_MAP.READABLE_HOST_NAME, SMIS_HOST_PORT.HOST_PWWN, SMIS_HOST_LUN_MAP.TARGET_PWWN, SMIS_HOST_LUN_MAP.LUN_ID, SMIS_HOST_LUN_MAP.HOST_LUN_ID, SMIS_HOST_LUN_MAP.LUN_ACCESS, SMIS_HOST_LUN_MAP.ACCESS_PRIV_GRANTED, SMIS_HOST_LUN_MAP.ADAPTER_NAME, SMIS_HOST_LUN_MAP.LAST_UPDATED FROM SMIS_HOST, SMIS_HOST_PORT, SMIS_HOST_LUN_MAP WHERE SMIS_HOST_LUN_MAP.SYSTEM_DB_ID=? AND SMIS_HOST_PORT.HOST_DB_ID=? AND SMIS_HOST_LUN_MAP.HOST_PORT_DB_ID=SMIS_HOST_PORT.ID AND SMIS_HOST_PORT.HOST_DB_ID=SMIS_HOST.ID ORDER BY SMIS_HOST.HOST_NAME ASC";
    private static final String getListByStorageSql = "SELECT SMIS_HOST_LUN_MAP.ID, SMIS_HOST.HOST_NAME, SMIS_HOST_LUN_MAP.READABLE_HOST_NAME, SMIS_HOST_PORT.HOST_PWWN, SMIS_HOST_LUN_MAP.TARGET_PWWN, SMIS_HOST_LUN_MAP.LUN_ID, SMIS_HOST_LUN_MAP.HOST_LUN_ID, SMIS_HOST_LUN_MAP.LUN_ACCESS, SMIS_HOST_LUN_MAP.ACCESS_PRIV_GRANTED, SMIS_HOST_LUN_MAP.ADAPTER_NAME, SMIS_HOST_LUN_MAP.LAST_UPDATED FROM SMIS_HOST, SMIS_HOST_PORT, SMIS_HOST_LUN_MAP WHERE SMIS_HOST_LUN_MAP.SYSTEM_DB_ID=? AND SMIS_HOST_LUN_MAP.TARGET_PWWN=? AND SMIS_HOST_LUN_MAP.HOST_PORT_DB_ID=SMIS_HOST_PORT.ID AND SMIS_HOST_PORT.HOST_DB_ID=SMIS_HOST.ID  ORDER BY SMIS_HOST.HOST_NAME ASC";
    private static final String getTimeListSql = "SELECT ID, HOST_LUN_ID, LAST_UPDATED FROM SMIS_HOST_LUN_MAP WHERE SYSTEM_DB_ID=?";
    private static final String cleanupSql = "DELETE FROM SMIS_HOST_LUN_MAP WHERE ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(Connection con, StorageSystem storageSystem) throws SQLException {
        if (con == null || storageSystem == null) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(insertSql);
            updateStat = con.prepareStatement(updateSql);
            for (Host host : storageSystem.get_hosts()) {
                SMISHostPortDO[] hostPortList;
                for (SMISHostPortDO hostPort : hostPortList = HostPortHelper.getList(con, storageSystem.getDBID(), host.getDBID(), null)) {
                    String hostWwn = hostPort.getHostWwn();
                    if (host.get_hostLunMap(hostWwn) == null) continue;
                    for (HostLunMapping obj : host.get_hostLunMap(hostWwn)) {
                        long systemDbId = storageSystem.getDBID();
                        Lun lun = storageSystem.get_lun(obj.get_lunId(), null);
                        long lunDbId = 0L;
                        if (lun != null) {
                            lunDbId = lun.getDBID();
                        } else {
                            lunDbId = LunHelper.getDbId(systemDbId, obj.get_lunId(), con);
                            _Logger.warn((Object)("Cache lookup failed for lun " + obj.get_lunId()));
                        }
                        long hportDbId = hostPort.getDbId();
                        if (hportDbId == 0L) {
                            _Logger.debug((Object)"HPort Lookup failed bailing on this one");
                            _Logger.debug((Object)("HML lists host as " + obj.get_hostName()));
                            _Logger.debug((Object)("HML lists lunID as " + obj.get_lunId()));
                            _Logger.debug((Object)("HML lists wwn as " + hostWwn));
                            continue;
                        }
                        if (lunDbId == 0L) {
                            _Logger.debug((Object)"Lun Lookup failed bailing on this one");
                            _Logger.debug((Object)("HML lists host as " + obj.get_hostName()));
                            _Logger.debug((Object)("HML lists lunID as " + obj.get_lunId()));
                            _Logger.debug((Object)("HML lists wwn as " + hostWwn));
                            continue;
                        }
                        if (obj.getDBID() == 0L) {
                            checkStat = con.prepareStatement(checkSql);
                            HostLunMapHelper.setupCheckExistenceStatement(systemDbId, hportDbId, lunDbId, obj, checkStat);
                            SMISHelper.checkPreexistRecord(obj, checkStat);
                        }
                        if (obj.getDBID() == 0L) {
                            obj.setDBID(Sequence.getSequence().getPK());
                            HostLunMapHelper.setupInsertStatement(systemDbId, hportDbId, lunDbId, obj, insertStat);
                            insertStat.addBatch();
                        } else if (obj.isModified() || obj.isPresent()) {
                            HostLunMapHelper.setupUpdateStatement(systemDbId, hportDbId, lunDbId, obj, updateStat);
                            if (updateStat.executeUpdate() < 1) {
                                obj.setDBID(Sequence.getSequence().getPK());
                                HostLunMapHelper.setupInsertStatement(systemDbId, hportDbId, lunDbId, obj, insertStat);
                                insertStat.addBatch();
                            }
                        }
                        obj.setFlushed(true);
                    }
                }
            }
            insertStat.executeBatch();
            for (Host host : storageSystem.get_hosts()) {
                for (String hostWwn : host.get_strgHwids()) {
                    if (host.get_hostLunMap(hostWwn) == null) continue;
                    for (HostLunMapping obj : host.get_hostLunMap(hostWwn)) {
                        obj.clearModified();
                        obj.setPresent(false);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public static void setupInsertStatement(long systemDbId, long hostportDbId, long lunDbId, HostLunMapping obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, obj.getDBID());
        stat.setLong(i++, systemDbId);
        stat.setLong(i++, hostportDbId);
        stat.setLong(i++, lunDbId);
        stat.setString(i++, obj.get_hostLunId());
        stat.setString(i++, obj.get_readableHost());
        stat.setString(i++, obj.get_targetWwn());
        stat.setString(i++, obj.get_lunId());
        stat.setString(i++, obj.get_adapterName());
        stat.setInt(i++, obj.get_lunAccess());
        stat.setBoolean(i++, obj.is_accessPrivGranted());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public static void setupUpdateStatement(long systemDbId, long hostportDbId, long lunDbId, HostLunMapping obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, systemDbId);
        stat.setLong(i++, hostportDbId);
        stat.setLong(i++, lunDbId);
        stat.setString(i++, obj.get_hostLunId());
        stat.setString(i++, obj.get_readableHost());
        stat.setString(i++, obj.get_targetWwn());
        stat.setString(i++, obj.get_lunId());
        stat.setString(i++, obj.get_adapterName());
        stat.setInt(i++, obj.get_lunAccess());
        stat.setBoolean(i++, obj.is_accessPrivGranted());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, obj.getDBID());
    }

    public static void setupCheckExistenceStatement(long systemDbId, long hostportDbId, long lunDbId, HostLunMapping obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, systemDbId);
        stat.setLong(2, hostportDbId);
        stat.setString(3, obj.get_targetWwn());
        stat.setLong(4, lunDbId);
    }

    public static SMISHostLunMappingDO[] getListByLun(Connection con, long systemDbId, long lunDbId, Timestamp time) {
        return HostLunMapHelper.getList(con, systemDbId, lunDbId, time, getListByLUNSql);
    }

    private static ArrayList<ZoneBase> getZones(EndPortImpl hImpl, EndPortImpl tImpl) {
        ArrayList<ZoneBase> zonedList = new ArrayList<ZoneBase>();
        FabricImpl fabricImpl = SanManager.getInstance().findFabric(hImpl.getFabricPK());
        String hostAlias = hImpl.getDeviceAlias();
        String targetAlias = tImpl.getDeviceAlias();
        for (short j : hImpl.getVsanMembership()) {
            VsanImpl[] vsanList;
            FabricBase fabricBase = fabricImpl.getFabricBase(hImpl.getVsanMembership());
            if (fabricBase == null || (vsanList = fabricImpl.findVsan(j)) == null) continue;
            for (VsanImpl vsanImpl : vsanList) {
                ZoneBase[] zoneList = vsanImpl.getEnforcedZones();
                if (zoneList == null) continue;
                block2: for (ZoneBase zone : zoneList) {
                    boolean zoneHasHost = false;
                    boolean zoneHasTarget = false;
                    Array memberList = zone.getMembers();
                    if (memberList == null) continue;
                    for (int k = 0; k < memberList.size(); ++k) {
                        ZoneMemberBase zmb = (ZoneMemberBase)memberList.elementAt(k);
                        if (zmb.getType() == 1) {
                            Wwn memWwn = HostLunMapHelper.getZoneMemberWwn(zmb, (VsanBase)vsanImpl.getBaseObject(), fabricBase);
                            if (memWwn == null) continue;
                            if (memWwn.equals(hImpl.getBase().getPortWwn())) {
                                zoneHasHost = true;
                            } else if (memWwn.equals(tImpl.getBase().getPortWwn())) {
                                zoneHasTarget = true;
                            }
                        } else if (zmb.getType() == 10) {
                            String deviceAlias = new String(zmb.getId());
                            if (hostAlias != null && hostAlias.equals(deviceAlias)) {
                                zoneHasHost = true;
                            } else if (targetAlias != null && targetAlias.equals(deviceAlias)) {
                                zoneHasTarget = true;
                            }
                        }
                        if (!zoneHasHost || !zoneHasTarget) continue;
                        zonedList.add(zone);
                        continue block2;
                    }
                }
            }
        }
        ZoneBase[] ivrZoneList = fabricImpl.getIvrEnforcedZones();
        if (ivrZoneList != null && ivrZoneList.length > 0) {
            block4: for (ZoneBase zone : ivrZoneList) {
                boolean zoneHasHost = false;
                boolean zoneHasTarget = false;
                Array memberList = zone.getMembers();
                if (memberList == null) continue;
                for (int k = 0; k < memberList.size(); ++k) {
                    Wwn memWwn;
                    if (zoneHasHost && zoneHasTarget) {
                        zonedList.add(zone);
                        continue block4;
                    }
                    ZoneMemberBase zmb = (ZoneMemberBase)memberList.elementAt(k);
                    String deviceAlias = new String(zmb.getId());
                    for (short hvsan : hImpl.getVsanMembership()) {
                        if (hvsan != zmb.getIvrVsanId()) continue;
                        if (zmb.getType() == 1) {
                            memWwn = new Wwn(zmb.getId());
                            if (memWwn == null || !hImpl.getBase().getPortWwn().equals(memWwn)) continue;
                            zoneHasHost = true;
                            break;
                        }
                        if (zmb.getType() != 10 || hostAlias == null || !hostAlias.equals(deviceAlias)) continue;
                        zoneHasHost = true;
                    }
                    for (short tvsan : tImpl.getVsanMembership()) {
                        if (tvsan != zmb.getIvrVsanId()) continue;
                        if (zmb.getType() == 1) {
                            memWwn = new Wwn(zmb.getId());
                            if (memWwn == null || !tImpl.getBase().getPortWwn().equals(memWwn)) continue;
                            zoneHasTarget = true;
                            break;
                        }
                        if (zmb.getType() != 10 || targetAlias == null || !targetAlias.equals(deviceAlias)) continue;
                        zoneHasTarget = true;
                    }
                    if (!zoneHasHost || !zoneHasTarget) continue;
                    zonedList.add(zone);
                    continue block4;
                }
            }
        }
        return zonedList;
    }

    private static Wwn getZoneMemberWwn(ZoneMemberBase mem, VsanBase vsan, FabricBase fa) {
        switch (mem.getType()) {
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                EndPortBase epb = ZoneService.getEndPort(mem.getType(), mem.getId(), vsan, fa);
                if (epb == null) break;
                Wwn epbWwn = epb.getPortWwn();
                return epbWwn;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList endportList = ZoneService.getAttachedEndPorts(fa, mem.getType(), mem.getId(), vsan);
                if (endportList == null) break;
                for (int i = 0; i < endportList.size(); ++i) {
                    EndPortBase epb = (EndPortBase)endportList.get(i);
                    if (epb == null) continue;
                    Wwn epbWwn = epb.getPortWwn();
                    return epbWwn;
                }
                break;
            }
        }
        return null;
    }

    public static SMISHostLunMappingDO[] getListByHost(Connection con, long systemDbId, long hostDbId, Timestamp time) {
        return HostLunMapHelper.getList(con, systemDbId, hostDbId, time, getListByHostSql);
    }

    /*
     * Exception decompiling
     */
    public static SMISHostLunMappingDO[] getList(Connection con, long systemDbId, long parentDbId, Timestamp time, String getSql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static SMISHostLunMappingDO[] getListByStoragePort(Connection con, long systemDbId, String storagewwn, Timestamp time) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(Connection con, StorageSystem sys, Timestamp expired) {
        PreparedStatement getStat = null;
        PreparedStatement cleanStat = null;
        ResultSet rs = null;
        try {
            getStat = con.prepareStatement(getTimeListSql);
            getStat.setLong(1, sys.getDBID());
            cleanStat = con.prepareStatement(cleanupSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                long dbid = rs.getLong(1);
                String name = rs.getString(2);
                Timestamp ts = rs.getTimestamp(3);
                if (ts.getTime() >= expired.getTime()) continue;
                _Logger.info((Object)("HostLunMap w/ hostLunId " + name + " has timestamp " + ts + " cleaning out."));
                cleanStat.setLong(1, dbid);
                cleanStat.addBatch();
            }
            cleanStat.executeBatch();
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception during cleanup for system " + sys.getDBID()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                DbUtil.close(cleanStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
            DbUtil.close(cleanStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        DbUtil.close(cleanStat);
    }
}

