/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.db;

import com.cisco.dcbu.jaxws.san.wo.SMISNavItemDO;
import com.cisco.dcbu.jaxws.san.wo.SMISPortDO;
import com.cisco.dcbu.jaxws.san.wo.SMISPortRowDO;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.MappingUtility;
import com.cisco.dcbu.storage.model.StoragePort;
import com.cisco.dcbu.storage.model.StorageProcessor;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class StoragePortHelper {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    private static final String insertSql = "INSERT INTO SMIS_STORAGE_PORT (ID, SYSTEM_DB_ID, PROCESSOR_DB_ID, PORT_NAME, PORT_NUMBER, PORT_TYPE,NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS,LAST_UPDATED) VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    private static final String updateSql = "UPDATE SMIS_STORAGE_PORT SET SYSTEM_DB_ID=?, PROCESSOR_DB_ID=?, PORT_NAME=?, PORT_NUMBER=?, PORT_TYPE=?,NETWORK_ADDRESS=?, PERM_ADDRESS=?, PORT_DESCRIPTION=?, SPEED=?, PORT_USAGE=?, STATUS=?, LAST_UPDATED=?  WHERE ID=?";
    private static final String checkSql = "SELECT ID FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? AND PORT_NAME=?";
    private static final String getNavListSql = "SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? ORDER BY PORT_NAME ASC";
    private static final String getSql = "SELECT PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE ID=?";
    private static final String getListSql = "SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? ORDER BY PORT_NAME ASC";
    private static final String getListLengthSql = "SELECT COUNT(ID) FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=?";
    private static final String getListByProcessorSql = "SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? AND PROCESSOR_DB_ID=? ORDER BY PORT_NAME ASC";
    private static final String getTimeListSql = "SELECT ID, PORT_NAME, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? ORDER BY PORT_NAME ASC";
    private static final String cleanupSql = "DELETE FROM SMIS_STORAGE_PORT WHERE ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(Connection con, StorageSystem storageSystem) throws SQLException {
        if (con == null || storageSystem == null) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(insertSql);
            updateStat = con.prepareStatement(updateSql);
            for (StoragePort storagePort : storageSystem.get_ports()) {
                long systemDbId = storageSystem.getDBID();
                long processorId = 0L;
                for (StorageProcessor p : storageSystem.get_strgprocs()) {
                    if (p.get_port(storagePort.get_pKey()._name) == null) continue;
                    processorId = p.getDBID();
                    break;
                }
                if (storagePort.getDBID() == 0L) {
                    checkStat = con.prepareStatement(checkSql);
                    StoragePortHelper.setupCheckExistenceStatement(systemDbId, storagePort, checkStat);
                    SMISHelper.checkPreexistRecord(storagePort, checkStat);
                }
                if (storagePort.getDBID() == 0L) {
                    storagePort.setDBID(Sequence.getSequence().getPK());
                    StoragePortHelper.setupInsertStatement(systemDbId, processorId, storagePort, insertStat);
                    insertStat.addBatch();
                } else if (storagePort.isModified() || storagePort.isPresent()) {
                    StoragePortHelper.setupUpdateStatement(systemDbId, processorId, storagePort, updateStat);
                    if (updateStat.executeUpdate() < 1) {
                        storagePort.setDBID(Sequence.getSequence().getPK());
                        StoragePortHelper.setupInsertStatement(systemDbId, processorId, storagePort, insertStat);
                        insertStat.addBatch();
                    }
                }
                storagePort.setFlushed(true);
            }
            insertStat.executeBatch();
            for (StoragePort storagePort : storageSystem.get_ports()) {
                storagePort.clearModified();
                storagePort.setPresent(false);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public static void setupInsertStatement(long systemDbId, long processorId, StoragePort obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, obj.getDBID());
        stat.setLong(i++, systemDbId);
        stat.setLong(i++, processorId);
        stat.setString(i++, obj.get_pKey()._name);
        stat.setInt(i++, obj.get_portNumber());
        stat.setInt(i++, obj.get_portType());
        stat.setString(i++, obj.get_networkAddress());
        stat.setString(i++, obj.get_permAddress());
        stat.setString(i++, Arrays.toString(obj.get_portDesc()));
        stat.setLong(i++, obj.get_speed());
        stat.setLong(i++, obj.get_usage());
        stat.setString(i++, obj.getStatusAsString());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public static void setupUpdateStatement(long systemDbId, long processorId, StoragePort obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, systemDbId);
        stat.setLong(i++, processorId);
        stat.setString(i++, obj.get_pKey()._name);
        stat.setInt(i++, obj.get_portNumber());
        stat.setInt(i++, obj.get_portType());
        stat.setString(i++, obj.get_networkAddress());
        stat.setString(i++, obj.get_permAddress());
        stat.setString(i++, Arrays.toString(obj.get_portDesc()));
        stat.setLong(i++, obj.get_speed());
        stat.setLong(i++, obj.get_usage());
        stat.setString(i++, obj.getStatusAsString());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, obj.getDBID());
    }

    public static void setupCheckExistenceStatement(long systemDbId, StoragePort obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, systemDbId);
        stat.setString(2, obj.get_pKey()._name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISNavItemDO[] getNavList(Connection con, long dbid) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISNavItemDO> ssl = new ArrayList<SMISNavItemDO>();
        try {
            getStat = con.prepareStatement("SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? ORDER BY PORT_NAME ASC");
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                SMISNavItemDO obj = new SMISNavItemDO();
                obj.setDbid(rs.getLong(i++));
                obj.setLabel(rs.getString(i++));
                ssl.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Port list for storage system with id " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl.toArray(new SMISNavItemDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISPortDO get(Connection con, long dbid, Timestamp time) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        SMISPortDO obj = null;
        try {
            getStat = con.prepareStatement(getSql);
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                obj = new SMISPortDO();
                obj.setDbId(dbid);
                obj.setName(rs.getString(i++));
                obj.setPortNumber(rs.getInt(i++));
                obj.setPortType(MappingUtility.getPortType(rs.getInt(i++)));
                obj.setNetworkAddress(rs.getString(i++));
                obj.setPermAddress(rs.getString(i++));
                obj.setPortDesc(rs.getString(i++));
                obj.setSpeed(rs.getLong(i++));
                obj.setUsage(MappingUtility.mapUsageRestriction((int)rs.getLong(i++)));
                obj.setStatus(rs.getString(i++));
                Timestamp t = rs.getTimestamp(i++);
                obj.setLastSeen(t.toString());
                if (t.after(time)) {
                    obj.setPresent(true);
                    continue;
                }
                obj.setPresent(false);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Port with id " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISPortRowDO[] getList(Connection con, long dbid, Timestamp time) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISPortRowDO> ssl = new ArrayList<SMISPortRowDO>();
        try {
            getStat = con.prepareStatement("SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PERM_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED FROM SMIS_STORAGE_PORT WHERE SYSTEM_DB_ID=? ORDER BY PORT_NAME ASC");
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                SMISPortRowDO obj = new SMISPortRowDO();
                obj.setDbId(rs.getLong(i++));
                obj.setName(rs.getString(i++));
                obj.setPortNumber(rs.getInt(i++));
                obj.setPortType(MappingUtility.getPortType(rs.getInt(i++)));
                obj.setNetworkAddress(rs.getString(i++));
                obj.setPermAddress(rs.getString(i++));
                obj.setPortDesc(rs.getString(i++));
                obj.setSpeed(rs.getLong(i++));
                obj.setUsage(MappingUtility.mapUsageRestriction((int)rs.getLong(i++)));
                obj.setStatus(rs.getString(i++));
                Timestamp t = rs.getTimestamp(i++);
                obj.setLastSeen(t.toString());
                if (t.after(time)) {
                    obj.setPresent(true);
                } else {
                    obj.setPresent(false);
                }
                ssl.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Port list for storage system with id " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl.toArray(new SMISPortRowDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getListLength(Connection con, long dbid) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        int count = 0;
        try {
            getStat = con.prepareStatement(getListLengthSql);
            getStat.setLong(1, dbid);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Port list length for storage system with id " + dbid), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISPortRowDO[] getListByProcessor(Connection con, long dbid, long processorDbId, Timestamp time) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISPortRowDO> ssl = new ArrayList<SMISPortRowDO>();
        try {
            getStat = con.prepareStatement(getListByProcessorSql);
            getStat.setLong(1, dbid);
            getStat.setLong(2, processorDbId);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                SMISPortRowDO obj = new SMISPortRowDO();
                obj.setDbId(rs.getLong(i++));
                obj.setName(rs.getString(i++));
                obj.setPortNumber(rs.getInt(i++));
                obj.setPortType(MappingUtility.getPortType(rs.getInt(i++)));
                obj.setNetworkAddress(rs.getString(i++));
                obj.setPermAddress(rs.getString(i++));
                obj.setPortDesc(rs.getString(i++));
                obj.setSpeed(rs.getLong(i++));
                obj.setUsage(MappingUtility.mapUsageRestriction((int)rs.getLong(i++)));
                obj.setStatus(rs.getString(i++));
                Timestamp t = rs.getTimestamp(i++);
                obj.setLastSeen(t.toString());
                if (t.after(time)) {
                    obj.setPresent(true);
                } else {
                    obj.setPresent(false);
                }
                ssl.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting Port list by processor for storage system with id " + dbid + " and processor id " + processorDbId), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl.toArray(new SMISPortRowDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(Connection con, StorageSystem sys, Timestamp expired) {
        PreparedStatement getStat = null;
        PreparedStatement cleanStat = null;
        ResultSet rs = null;
        try {
            getStat = con.prepareStatement(getTimeListSql);
            getStat.setLong(1, sys.getDBID());
            cleanStat = con.prepareStatement(cleanupSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                long dbid = rs.getLong(1);
                String name = rs.getString(2);
                Timestamp ts = rs.getTimestamp(3);
                if (ts.getTime() >= expired.getTime()) continue;
                _Logger.info((Object)("StoragePort " + name + " has timestamp " + ts + " cleaning out."));
                cleanStat.setLong(1, dbid);
                cleanStat.addBatch();
            }
            cleanStat.executeBatch();
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception during cleanup for system " + sys.getDBID()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                DbUtil.close(cleanStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
            DbUtil.close(cleanStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        DbUtil.close(cleanStat);
    }
}

