/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.storage.model.Provider;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class CIMDiscoveryHandler {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    WBEMClient _wbclient = null;
    Provider _provider = null;

    protected void setProvider(Provider provider) {
        this._provider = provider;
        this._wbclient = this.createClientObject(this._provider);
    }

    protected CloseableIterator<CIMObjectPath> getAssociator(String resultClass, CIMObjectPath cimop) throws IOException {
        CloseableIterator an = null;
        try {
            an = this._wbclient.associatorNames(cimop, null, resultClass, null, null);
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to get association instances of " + resultClass + " Error: " + e.toString()));
        }
        return an;
    }

    protected CIMObjectPath[] getAssociatorNew(String resultClass, CIMObjectPath cimop) {
        ArrayList<Object> a = new ArrayList<Object>();
        try {
            CloseableIterator assos = this._wbclient.associatorNames(cimop, null, resultClass, null, null);
            while (assos != null && assos.hasNext()) {
                a.add(assos.next());
            }
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to get association instances of " + resultClass + " Error: " + e.toString()));
        }
        return a.toArray(new CIMObjectPath[0]);
    }

    protected CloseableIterator<CIMInstance> getAssociatorInstances(String resultClass, CIMObjectPath cimop) {
        return this.getAssociatorInstances(resultClass, cimop, null);
    }

    protected CloseableIterator<CIMInstance> getAssociatorInstances(String resultClass, CIMObjectPath cimop, String[] propertyList) {
        CloseableIterator a = null;
        try {
            a = this._wbclient.associatorInstances(cimop, null, resultClass, null, null, false, propertyList);
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to get association instances of " + resultClass + " Error: " + e.toString()));
        }
        return a;
    }

    protected CIMInstance[] getAssociatorInstancesNew(String resultClass, CIMObjectPath cimop, String[] propertyList) {
        ArrayList<Object> a = new ArrayList<Object>();
        CloseableIterator<CIMInstance> insts = this.getAssociatorInstances(resultClass, cimop, null);
        while (insts != null && insts.hasNext()) {
            a.add(insts.next());
        }
        return a.toArray(new CIMInstance[0]);
    }

    protected CIMInstance getInstance(CIMObjectPath cimop) {
        CIMInstance a = null;
        try {
            a = this._wbclient.getInstance(cimop, false, false, null);
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to get references instances of " + cimop + " Error: " + e.toString()));
        }
        return a;
    }

    protected CloseableIterator<CIMInstance> getReferenceInstances(String resultClass, CIMObjectPath cimop) {
        return this.getReferenceInstances(resultClass, cimop, null);
    }

    protected CloseableIterator<CIMInstance> getReferenceInstances(String resultClass, CIMObjectPath cimop, String[] propertyList) {
        CloseableIterator a = null;
        try {
            a = this._wbclient.referenceInstances(cimop, resultClass, null, false, propertyList);
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to get references instances of " + resultClass + " Error: " + e.toString()));
        }
        return a;
    }

    protected void discoverCimInstance(String className) {
        CloseableIterator<CIMInstance> ei = this.enumerateInstances(className, this._provider.getNs(), null);
        if (ei == null) {
            return;
        }
        if (ei.hasNext()) {
            while (ei.hasNext()) {
                _Logger.debug(ei.next());
            }
        }
    }

    protected void discoverCimCop(String className) {
        CIMObjectPath cop = new CIMObjectPath(className, this._provider.getNs());
        CloseableIterator ei = null;
        try {
            ei = this._wbclient.enumerateInstanceNames(cop);
            if (ei == null) {
                return;
            }
            while (ei.hasNext()) {
                _Logger.debug(ei.next());
            }
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to enumerate instances of " + className + " Error: " + e.getMessage()));
        }
    }

    protected CloseableIterator<CIMInstance> enumerateInstances(String className, String namespace, List<String> propertyList) {
        CloseableIterator ei = null;
        CIMObjectPath cop = new CIMObjectPath(className, namespace);
        String[] props = null;
        if (propertyList != null) {
            props = propertyList.toArray(new String[propertyList.size()]);
        }
        try {
            ei = this._wbclient.enumerateInstances(cop, false, true, false, props);
        }
        catch (WBEMException e) {
            _Logger.warn((Object)(" Failed to enumerate instances of " + className + " Error: " + e.toString()));
        }
        return ei;
    }

    protected WBEMClient createClientObject(Provider provider) {
        WBEMClient clientObj = null;
        String host = provider.isSecure() ? "https://" + provider.getUrl() + ":" + provider.getPort() + "/" : "http://" + provider.getUrl() + ":" + provider.getPort() + "/";
        try {
            CIMObjectPath cns = new CIMObjectPath(host);
            UserPrincipal up = new UserPrincipal(provider.getUsername());
            PasswordCredential pc = new PasswordCredential(provider.getPassword());
            Subject s = new Subject();
            s.getPrincipals().add((Principal)up);
            s.getPrivateCredentials().add(pc);
            clientObj = WBEMClientFactory.getClient((String)"CIM-XML");
            String tracecim = System.getProperty("storage.cim.trace", "false");
            if (tracecim.equalsIgnoreCase("true")) {
                String logdir = ClientCache.getLogsDir();
                if (logdir == null) {
                    logdir = new File(".").getCanonicalPath();
                }
                clientObj.setProperty("javax.wbem.debug", "1");
                clientObj.setProperty("javax.wbem.client.log.file.enabled", "1");
                clientObj.setProperty("javax.wbem.client.log.console.enabled", "1");
                clientObj.setProperty("javax.wbem.client.log.filename", provider.getUrl() + "_%g.log");
                clientObj.setProperty("javax.wbem.client.log.dir", logdir + "/");
                _Logger.info((Object)("CIM trace File set to:" + logdir + "/" + provider.getUrl() + "_%g.log"));
            }
            clientObj.initialize(cns, s, null);
        }
        catch (WBEMException e) {
            if (e.getID() == 2) {
                _Logger.warn((Object)"Access Denied: Please check the principal/credentials.");
            }
            _Logger.warn((Object)(" Failed to connect to cimom at " + host + " Error: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            _Logger.warn((Object)(" Failed to connect to cimom at " + host + " Error: " + e.getMessage()));
            return null;
        }
        return clientObj;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public String validateClient() throws Exception {
        String result;
        block13: {
            result = null;
            if (this._wbclient != null) {
                CIMObjectPath cop = new CIMObjectPath("CIM_SoftwareIdentity", this._provider.getInteropns());
                try {
                    CloseableIterator ei = this._wbclient.enumerateInstanceNames(cop);
                    if (ei != null) {
                        if (this._provider.getVendor().equals("other")) {
                            return null;
                        }
                        while (ei.hasNext()) {
                            CIMObjectPath op = (CIMObjectPath)ei.next();
                            if (op.toString().contains("ONTAP")) {
                                if (this._provider.getVendor().equals("netapp")) continue;
                                return "Invalid Vendor type, detected Netapp provider.  Please check your parameters and try again.";
                            }
                            if (op.toString().contains("EMC")) {
                                if (this._provider.getVendor().equals("emc")) continue;
                                return "Invalid Vendor type, detected EMC provider.  Please check your parameters and try again.";
                            }
                            if (op.toString().contains("HITACHI")) {
                                if (this._provider.getVendor().equals("hds")) continue;
                                return "Invalid Vendor type, detected HDS provider.  Please check your parameters and try again.";
                            }
                            if (!op.toString().contains("CISCO")) continue;
                            return "Invalid provider, detected Cisco Systems.  Please check your parameters and try again.";
                        }
                        return null;
                    }
                    _Logger.warn((Object)(" Failed to connect to cimom at " + this._provider.getUrl()));
                    result = "Failed to connect to provider";
                }
                catch (WBEMException e) {
                    if (e.getID() == 2) {
                        _Logger.warn((Object)"Access Denied: Please check the principal/credentials.");
                        result = "Access Denied: Please check the credentials";
                        break block13;
                    }
                    if (e.getID() == 3) {
                        _Logger.warn((Object)"Invalid Namespace: Please check the provider configuration.");
                        result = "Invalid Namespace: Please check the provider configuration";
                        break block13;
                    }
                    _Logger.warn((Object)"Connection failed: Please check the provider configuration.");
                    result = "Connection failed: Please check the provider configuration";
                }
                catch (Exception e) {
                    _Logger.warn((Object)(" Failed to connect to cimom at " + this._provider.getUrl() + " Error: " + e.toString()));
                    result = "Failed to connect to provider";
                }
            } else {
                _Logger.warn((Object)(" Failed to connect to cimom at " + this._provider.getUrl()));
                result = "Failed to connect to provider";
            }
        }
        return result;
    }

    protected long getPropertyUint64(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return ((UnsignedInteger64)inst.getPropertyValue(property)).longValue();
        }
        return -1L;
    }

    protected long getPropertyUint32(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return ((UnsignedInteger32)inst.getPropertyValue(property)).longValue();
        }
        return -1L;
    }

    protected int getPropertyUint16(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return ((UnsignedInteger16)inst.getPropertyValue(property)).intValue();
        }
        return -1;
    }

    protected int getPropertyUint8(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return ((UnsignedInteger8)inst.getPropertyValue(property)).intValue();
        }
        return -1;
    }

    protected String getPropertyString(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return (String)inst.getPropertyValue(property);
        }
        return "";
    }

    protected String[] getPropertyStringArray(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return (String[])inst.getPropertyValue(property);
        }
        return new String[0];
    }

    protected UnsignedInteger16[] getPropertyUint16Array(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return (UnsignedInteger16[])inst.getPropertyValue(property);
        }
        return new UnsignedInteger16[0];
    }

    protected Boolean getPropertyBoolean(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return (Boolean)inst.getPropertyValue(property);
        }
        return false;
    }

    protected CIMObjectPath getPropertyObjectPath(CIMInstance inst, String property) {
        if (inst != null && inst.getProperty(property) != null) {
            return (CIMObjectPath)inst.getPropertyValue(property);
        }
        return null;
    }

    public static enum InterconnectType {
        SATA(4, "SATA"),
        ATA(3, "ATA"),
        SAS(5, "SAS"),
        FC(6, "FC"),
        SOP(7, "SOP"),
        OTHER(1, "OTHER"),
        NOTAPPLICABLE(2, "NOTAPPLICABLE"),
        UNKNOWN(0, "UNKNOWN");

        int value;
        String description;

        private InterconnectType(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static InterconnectType valueOf(int val) {
            InterconnectType[] types;
            for (InterconnectType e : types = InterconnectType.values()) {
                if (e.value != val) continue;
                return e;
            }
            return UNKNOWN;
        }
    }
}

