/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.smis.client.cim.BlockStorageStatisticalData;
import com.cisco.dcbu.smis.client.cim.PhysicalPackage;
import com.cisco.dcbu.smis.client.cim.SoftwareIdentity;
import com.cisco.dcbu.storage.discovery.CIMDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.PropertyList;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.DiskLun;
import com.cisco.dcbu.storage.model.DiskPool;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Pool;
import com.cisco.dcbu.storage.model.StorageProcessor;
import com.cisco.dcbu.storage.model.StorageStatistics;
import com.cisco.dcbu.storage.model.StorageSystem;
import com.cisco.dcbu.storage.model.StorageSystemStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger64;
import javax.wbem.CloseableIterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EMCDiscoveryHandler
extends StorageDiscoveryHandler {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    public static String VOLUMEVIEW = "VolumeView";
    public static String DISKDRIVEVIEW = "DiskDriveView";
    public static String MASKINGMAPPINGVIEW = "MaskingMappingView";
    public static String EXPOSEDVIEW = "ExposedView";

    @Override
    public void discover(ArrayList<StorageSystem> strgSystems) {
        ArrayList<CIMInstance> regProfs = this.fetchRegisteredArrayProfiles();
        if (regProfs.size() > 0) {
            ArrayList<CIMInstance> comSysInsts = this.fetchTopLevelComputerSystem(regProfs);
            for (CIMInstance comSysInst : comSysInsts) {
                StorageSystem strgSystem = this.fetchComputerSystemPhysical(comSysInst);
                if (strgSystem == null || strgSystem.get_vendor() == null || strgSystem.get_pKey()._name == null || strgSystem.get_serialNumber() == null) continue;
                int index = strgSystems.indexOf(strgSystem);
                if (index >= 0) {
                    StorageSystem oldStrgSystem = strgSystems.get(index);
                    oldStrgSystem.update(strgSystem.get_nwwns(), strgSystem.get_storageType(), strgSystem.get_vendor(), strgSystem.get_version(), strgSystem.get_model(), strgSystem.get_partNumber(), strgSystem.get_serialNumber());
                    strgSystem = oldStrgSystem;
                } else {
                    strgSystem.set_provider(this._provider);
                    strgSystems.add(strgSystem);
                }
                String strgProcClassName = "CIM_ComputerSystem";
                String compSysClassName = null;
                if (strgSystem.get_storageSystemClassName().equalsIgnoreCase("Clar_StorageSystem")) {
                    strgProcClassName = "Clar_StorageProcessorSystem";
                } else if (strgSystem.get_storageSystemClassName().equalsIgnoreCase("Symm_StorageSystem")) {
                    strgProcClassName = "Symm_StorageProcessorSystem";
                    compSysClassName = "Symm_ComponentSystem";
                }
                this.fetchStorageProcessor(comSysInst, strgSystem, strgProcClassName);
                Map<CIMObjectPath, Pool> strgPools = this.fetchStoragePools(comSysInst, strgSystem);
                this.fetchVolume(comSysInst, strgSystem, strgPools);
                this.fetchComponentSystem(comSysInst, strgSystem, strgPools, compSysClassName);
            }
        }
    }

    @Override
    public void perfCollection(StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> statsColInsts = this.getAssociatorInstances("CIM_StatisticsCollection", strgSystem.get_objPath());
        StorageStatistics storageStat = null;
        if (statsColInsts != null && statsColInsts.hasNext()) {
            _Logger.debug((Object)"** Statistics Info **");
            HashMap<Integer, StorageSystemStatistics> hs = new HashMap<Integer, StorageSystemStatistics>();
            CIMInstance statsColInst = (CIMInstance)statsColInsts.next();
            if (statsColInst != null) {
                CloseableIterator<CIMInstance> statsInsts = this.getAssociatorInstances("CIM_BlockStorageStatisticalData", statsColInst.getObjectPath());
                while (statsInsts != null && statsInsts.hasNext()) {
                    CIMInstance statsInst = (CIMInstance)statsInsts.next();
                    BlockStorageStatisticalData stat = new BlockStorageStatisticalData(this._wbclient, statsInst);
                    _Logger.debug((Object)(stat.getElementName() + " " + stat.getElementType()));
                    switch (stat.getElementType().intValue()) {
                        case 2: {
                            storageStat = this.fetchArrayStats(statsInst);
                            break;
                        }
                        case 3: {
                            storageStat = this.fetchAdapterStats(statsInst);
                            break;
                        }
                        case 6: {
                            storageStat = this.fetchPortStats(statsInst);
                            break;
                        }
                        case 8: {
                            storageStat = this.fetchVolumeStats(statsInst);
                            break;
                        }
                        case 10: {
                            storageStat = this.fetchDiskStats(statsInst);
                            break;
                        }
                        default: {
                            storageStat = null;
                        }
                    }
                    if (storageStat == null) continue;
                    StorageSystemStatistics sss = (StorageSystemStatistics)hs.get(new Integer(stat.getElementType().intValue()));
                    if (sss == null) {
                        sss = new StorageSystemStatistics(stat.getElementName(), stat.getElementType().intValue());
                        hs.put(new Integer(stat.getElementType().intValue()), sss);
                    }
                    sss.add_strgstat(storageStat);
                }
                if (!hs.isEmpty()) {
                    strgSystem.getStatsList().addAll(hs.values());
                }
            }
        }
    }

    private void fetchStorageProcessor(CIMInstance comSysInst, StorageSystem strgSystem, String strProcClassName) {
        CloseableIterator<CIMInstance> strgprocsysInsts = this.getAssociatorInstances(strProcClassName, comSysInst.getObjectPath());
        while (strgprocsysInsts != null && strgprocsysInsts.hasNext()) {
            CIMInstance strgprocsysInst = (CIMInstance)strgprocsysInsts.next();
            String elementName = this.getPropertyString(strgprocsysInst, "ElementName");
            String accessInfo = null;
            CloseableIterator<CIMInstance> remsrvaccessptInsts = this.getAssociatorInstances("CIM_RemoteServiceAccessPoint", strgprocsysInst.getObjectPath());
            if (remsrvaccessptInsts != null && remsrvaccessptInsts.hasNext()) {
                accessInfo = this.getPropertyString((CIMInstance)remsrvaccessptInsts.next(), "AccessInfo");
            } else {
                _Logger.warn((Object)("Failed to get CIM_RemoteServiceAccessPoint for " + elementName));
            }
            long[] status = this.unit16arrayTolongarray(this.getPropertyUint16Array(strgprocsysInst, "OperationalStatus"));
            long adapterNumber = this.getPropertyUint32(strgprocsysInst, "EMCAdapterNumber");
            long numPorts = this.getPropertyUint32(strgprocsysInst, "NumPorts");
            long memSize = this.getPropertyUint32(strgprocsysInst, "MemorySize");
            String serialNumber = this.getPropertyString(strgprocsysInst, "EMCSerialNumber");
            long slotNumber = this.getPropertyUint32(strgprocsysInst, "EMCSlotNumber");
            long readCache = this.getPropertyUint32(strgprocsysInst, "EMCReadCacheSize");
            long writeCache = this.getPropertyUint32(strgprocsysInst, "EMCWriteCacheSize");
            String[] roles = this.getPropertyStringArray(strgprocsysInst, "Roles");
            StorageProcessor strgproc = strgSystem.get_strgproc(elementName);
            if (strgproc == null) {
                strgproc = new StorageProcessor(elementName, adapterNumber, numPorts, memSize, serialNumber, slotNumber, readCache, writeCache, status, accessInfo, roles);
                strgSystem.add_strgproc(strgproc);
            } else {
                strgproc.update(adapterNumber, numPorts, memSize, serialNumber, slotNumber, readCache, writeCache, status, accessInfo, roles);
            }
            this.fetchComputerSystemPorts(strgprocsysInst, strgproc, strgSystem);
        }
    }

    private void fetchComponentSystem(CIMInstance comSysInst, StorageSystem strgSystem, Map<CIMObjectPath, Pool> strgPools, String compSysClassName) {
        if (compSysClassName == null) {
            String name = this.getPropertyString(comSysInst, "Name");
            ComponentSystem comp = strgSystem.get_comp(name);
            if (comp == null) {
                comp = new ComponentSystem(name);
                comp.set_objPath(comSysInst.getObjectPath());
                strgSystem.add_comp(comp);
            } else {
                comp.update();
            }
            this.fetchDiskDrive(comSysInst, comp, strgPools, strgSystem);
        } else {
            CIMInstance[] compsysInsts;
            for (CIMInstance compsysInst : compsysInsts = this.getAssociatorInstancesNew(compSysClassName, comSysInst.getObjectPath(), null)) {
                String name = this.getPropertyString(compsysInst, "Name");
                ComponentSystem comp = strgSystem.get_comp(name);
                if (comp == null) {
                    comp = new ComponentSystem(name);
                    comp.set_objPath(compsysInst.getObjectPath());
                    strgSystem.add_comp(comp);
                } else {
                    comp.update();
                }
                this.fetchDiskDrive(compsysInst, comp, strgPools, strgSystem);
            }
        }
    }

    private void fetchDiskDrive(CIMInstance comSysInst, ComponentSystem comp, Map<CIMObjectPath, Pool> strgPools, StorageSystem strgSystem) {
        CIMInstance[] diskDrvInsts;
        for (CIMInstance diskDrvInst : diskDrvInsts = this.getAssociatorInstancesNew("CIM_DiskDrive", comSysInst.getObjectPath(), null)) {
            Pool pool;
            CIMObjectPath poolObj;
            int len$;
            CIMObjectPath[] arr$;
            CIMObjectPath[] poolObjs;
            int i$;
            String driveType = CIMDiscoveryHandler.InterconnectType.valueOf(this.getPropertyUint16(diskDrvInst, "InterconnectType")).getDescription();
            String diskName = this.getPropertyString(diskDrvInst, "Name");
            Disk disk = comp.get_disk(diskName);
            if (disk == null) {
                SoftwareIdentity swIdent;
                disk = new Disk(diskName, driveType, -1L, -1L, -1L, -1, "", null, null, null, "", "", "", "", "", -1L, -1L);
                PhysicalPackage phyPackage = this.fetchPhyscialPackage(diskDrvInst.getObjectPath());
                if (phyPackage != null) {
                    disk.set_manufacturer(phyPackage.getManufacturer());
                    disk.set_model(phyPackage.getModel());
                    disk.set_serialNumber(phyPackage.getSerialNumber());
                    disk.set_partNumber(phyPackage.getPartNumber());
                }
                if ((swIdent = this.fetchSoftwareIdentity(diskDrvInst.getObjectPath())) != null) {
                    disk.set_firmwareRev(swIdent.getVersionString());
                }
                comp.add_disk(disk);
            } else {
                disk.setPresent(true);
            }
            disk.set_status(this.unit16arrayTolongarray(this.getPropertyUint16Array(diskDrvInst, "OperationalStatus")));
            disk.set_state(this.getPropertyUint16(diskDrvInst, "HealthState"));
            long actualBlocks = this.getPropertyUint64(diskDrvInst, "EMCNumberOfBlocks");
            long freeBlocks = this.getPropertyUint64(diskDrvInst, "EMCFreeBlocks");
            long defaultBlockSize = this.getPropertyUint64(diskDrvInst, "DefaultBlockSize");
            disk.set_rawCapacity(actualBlocks * defaultBlockSize);
            if (actualBlocks >= freeBlocks) {
                disk.set_userCapacity(freeBlocks * defaultBlockSize);
                disk.set_userSectors(actualBlocks - freeBlocks);
            }
            disk.set_currSpeed(this.getPropertyUint32(diskDrvInst, "RPM"));
            disk.set_maxSpeed(this.getPropertyUint32(diskDrvInst, "RPM"));
            ArrayList<DiskPool> poolList = new ArrayList<DiskPool>();
            if (strgSystem.get_storageSystemClassName().equalsIgnoreCase("Clar_StorageSystem")) {
                i$ = 0;
                poolObjs = this.getAssociatorNew("EMC_UnifiedStoragePool", diskDrvInst.getObjectPath());
                arr$ = poolObjs;
                len$ = arr$.length;
                if (i$ < len$) {
                    poolObj = arr$[i$];
                    pool = strgPools.get(poolObj);
                    poolList.add(new DiskPool(pool.get_pKey()._name));
                    disk.set_raidType(pool.get_raidType());
                }
                arr$ = poolObjs;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    poolObj = arr$[i$];
                    pool = strgPools.get(poolObj);
                    if (pool == null) continue;
                    pool.add_diskType(driveType);
                }
            }
            if ((i$ = 0) < (len$ = (arr$ = (poolObjs = this.getAssociatorNew("EMC_DeviceStoragePool", diskDrvInst.getObjectPath()))).length)) {
                poolObj = arr$[i$];
                pool = strgPools.get(poolObj);
                poolList.add(new DiskPool(pool.get_pKey()._name));
                disk.set_raidType(pool.get_raidType());
            }
            arr$ = poolObjs;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                poolObj = arr$[i$];
                pool = strgPools.get(poolObj);
                if (pool == null) continue;
                pool.add_diskType(driveType);
            }
            disk.set_pools(poolList.toArray(new DiskPool[0]));
            CIMInstance[] volInsts = this.getAssociatorInstancesNew("CIM_Storagevolume", diskDrvInst.getObjectPath(), PropertyList.EMCStorageVolumeProperties);
            ArrayList<DiskLun> lunList = new ArrayList<DiskLun>();
            for (CIMInstance volInst : volInsts) {
                String lunName = this.getPropertyString(volInst, "ElementName");
                String lunId = this.getPropertyString(volInst, "DeviceID");
                Lun lun = strgSystem.get_lun(lunId, lunName);
                if (lun != null) {
                    lun.set_diskType(driveType);
                }
                DiskLun pk = new DiskLun(lunId, lunName);
                lunList.add(pk);
            }
            disk.set_luns(lunList.toArray(new DiskLun[0]));
        }
    }

    private Map<CIMObjectPath, Pool> fetchStoragePools(CIMInstance comSysInst, StorageSystem strgSystem) {
        HashMap<CIMObjectPath, Pool> pools = new HashMap<CIMObjectPath, Pool>();
        ArrayList<CIMInstance> strgPoolInsts = new ArrayList<CIMInstance>();
        if (strgSystem.get_storageSystemClassName().equalsIgnoreCase("Clar_StorageSystem")) {
            CIMInstance[] unifiedStrgPoolInsts = this.getAssociatorInstancesNew("Clar_UnifiedStoragePool", comSysInst.getObjectPath(), null);
            CIMInstance[] globalStrgPoolInsts = this.getAssociatorInstancesNew("Clar_SnapStoragePool", comSysInst.getObjectPath(), null);
            CIMInstance[] deviceStrgPoolInsts = this.getAssociatorInstancesNew("Clar_DeviceStoragePool", comSysInst.getObjectPath(), null);
            strgPoolInsts.addAll(Arrays.asList(unifiedStrgPoolInsts));
            strgPoolInsts.addAll(Arrays.asList(globalStrgPoolInsts));
            strgPoolInsts.addAll(Arrays.asList(deviceStrgPoolInsts));
        } else if (strgSystem.get_storageSystemClassName().equalsIgnoreCase("Symm_StorageSystem")) {
            CIMInstance[] deviceStrgPoolInsts_symm = this.getAssociatorInstancesNew("Symm_DeviceStoragePool", comSysInst.getObjectPath(), null);
            CIMInstance[] globalStrgPoolInsts_symm = this.getAssociatorInstancesNew("Symm_SnapStoragePool", comSysInst.getObjectPath(), null);
            strgPoolInsts.addAll(Arrays.asList(globalStrgPoolInsts_symm));
            strgPoolInsts.addAll(Arrays.asList(deviceStrgPoolInsts_symm));
        }
        for (CIMInstance strgPoolInst : strgPoolInsts) {
            long[] status = this.unit16arrayTolongarray(this.getPropertyUint16Array(strgPoolInst, "OperationalStatus"));
            String poolName = (String)strgPoolInst.getPropertyValue("PoolId");
            long rawCapacity = this.getPropertyUint64(strgPoolInst, "EMCTotalRawCapacity");
            long totalManagedSpace = this.getPropertyUint64(strgPoolInst, "TotalManagedSpace");
            long remainingManagedSpace = this.getPropertyUint64(strgPoolInst, "RemainingManagedSpace");
            long remainingRawCapacity = this.getPropertyUint64(strgPoolInst, "EMCRemainingRawCapacity");
            long subscribedCapacity = this.getPropertyUint64(strgPoolInst, "EMCSubscribedCapacity");
            int percentSubscribed = this.getPropertyUint16(strgPoolInst, "EMCPercentSubscribed");
            String raidLevel = null;
            Pool pool = strgSystem.get_pool(poolName);
            if (pool == null) {
                pool = new Pool(poolName, rawCapacity, totalManagedSpace, remainingManagedSpace, remainingRawCapacity, subscribedCapacity, percentSubscribed, status, raidLevel, null);
                strgSystem.add_pool(pool);
            } else {
                pool.update(rawCapacity, totalManagedSpace, remainingManagedSpace, remainingRawCapacity, subscribedCapacity, percentSubscribed, status, raidLevel, null);
            }
            pools.put(strgPoolInst.getObjectPath(), pool);
        }
        return pools;
    }

    private void fetchVolume(CIMInstance comSysInst, StorageSystem strgSystem, Map<CIMObjectPath, Pool> strgPools) {
        CloseableIterator<CIMInstance> volInsts = this.getAssociatorInstances("CIM_StorageVolume", comSysInst.getObjectPath(), PropertyList.EMCStorageVolumeProperties);
        while (volInsts != null && volInsts.hasNext()) {
            CIMInstance volInst = (CIMInstance)volInsts.next();
            long[] status = this.unit16arrayTolongarray(this.getPropertyUint16Array(volInst, "OperationalStatus"));
            String lunName = this.getPropertyString(volInst, "ElementName");
            String lunId = this.getPropertyString(volInst, "DeviceID");
            String wwn = this.getPropertyString(volInst, "EMCWWN");
            long blockSize = this.getPropertyUint64(volInst, "BlockSize");
            long numberOfBlocks = this.getPropertyUint64(volInst, "NumberOfBlocks");
            String raidLevel = this.getPropertyString(volInst, "EMCRaidLevel");
            String currOwner = this.getPropertyString(volInst, "EMCCurrentOwningStorageProcessor");
            String defaultOwner = this.getPropertyString(volInst, "EMCDefaultOwningStorageProcessor");
            StringBuilder poolName = new StringBuilder();
            CloseableIterator<CIMInstance> afSPlInsts = this.getReferenceInstances("CIM_AllocatedFromStoragePool", volInst.getObjectPath());
            while (afSPlInsts != null && afSPlInsts.hasNext()) {
                Lun lun;
                CIMInstance afSPlInst = (CIMInstance)afSPlInsts.next();
                long spaceConsumed = ((UnsignedInteger64)afSPlInst.getPropertyValue("SpaceConsumed")).longValue();
                CIMObjectPath poolObj = (CIMObjectPath)afSPlInst.getPropertyValue("Antecedent");
                String[] diskType = null;
                long remainingManagedSpace = 0L;
                Pool pool = strgPools.get(poolObj);
                if (pool != null) {
                    poolName.append(pool.get_pKey()._name);
                    pool.set_raidType(raidLevel);
                    remainingManagedSpace = pool.get_remainingManagedSpace();
                    diskType = pool.get_diskType();
                }
                if ((lun = strgSystem.get_lun(lunId, lunName)) == null) {
                    lun = new Lun(lunName, lunId, wwn, poolName.toString(), blockSize * numberOfBlocks, -1L, spaceConsumed, status, raidLevel, diskType, currOwner, defaultOwner);
                    strgSystem.add_lun(lun);
                } else {
                    lun.update(wwn, poolName.toString(), blockSize * numberOfBlocks, -1L, spaceConsumed, status, raidLevel, diskType, currOwner, defaultOwner);
                }
                this.fetchExposedView(volInst, strgSystem);
                this.fetchMaskingMappingView(volInst, lun, strgSystem);
            }
        }
    }

    private void fetchExposedView(CIMInstance strgVolInst, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> expViewInsts = this.getReferenceInstances("SNIA_ExposedView", strgVolInst.getObjectPath(), PropertyList.EMCExposedViewProperties);
        while (expViewInsts != null && expViewInsts.hasNext()) {
            CIMInstance expViewInst = (CIMInstance)expViewInsts.next();
            String protoEndPtWWN = this.getPropertyString(expViewInst, "PEPName");
            String strgProcName = this.getPropertyString(expViewInst, "SPCElementName");
            strgSystem.add_storageAdapter(protoEndPtWWN, strgProcName);
        }
    }

    private void fetchMaskingMappingView(CIMInstance strgVolInst, Lun lun, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> maskmapViewInsts = this.getReferenceInstances("SNIA_MaskingMappingView", strgVolInst.getObjectPath(), PropertyList.EMCMaskingViewProperties);
        while (maskmapViewInsts != null && maskmapViewInsts.hasNext()) {
            CIMInstance maskmapViewInst = (CIMInstance)maskmapViewInsts.next();
            CIMObjectPath strgHWIDOP = this.getPropertyObjectPath(maskmapViewInst, "StorageHardwareID");
            String protoEndPtWWN = this.getPropertyString(maskmapViewInst, "SPEPName");
            String strgHWID = this.getPropertyString(maskmapViewInst, "SHIDStorageID");
            String initID = this.getPropertyString(maskmapViewInst, "EMCSPCInitiatorID");
            String nwwn = "";
            nwwn = initID.length() > 16 ? initID.substring(0, 16) : initID;
            boolean accessGranted = this.getPropertyBoolean(maskmapViewInst, "APPrivilegeGranted");
            String strgLun = this.getPropertyString(maskmapViewInst, "LDDeviceID");
            String mappedLun = this.getPropertyString(maskmapViewInst, "PCFUDeviceNumber");
            int lunAccess = this.getPropertyUint16(maskmapViewInst, "PCFUDeviceAccess");
            String initAlias = this.getPropertyString(maskmapViewInst, "EMCSPCInitiatorAlias");
            if (initAlias == null) {
                initAlias = initID;
            }
            HostLunMapping hostLunMap = new HostLunMapping(strgHWID, initID, initAlias, protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
            lun.add_hostLunMap(hostLunMap);
            Host host = strgSystem.get_host(initAlias);
            if (host == null) {
                host = new Host(initAlias);
                host.setNwwn(nwwn);
                strgSystem.add_host(host);
            }
            host.add_strgHwid(strgHWID, strgHWIDOP);
            host.add_hostLunMap(hostLunMap);
        }
    }
}

