/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.smis.client.cim.AuthorizedPrivilege;
import com.cisco.dcbu.smis.client.cim.BlockStorageStatisticalData;
import com.cisco.dcbu.smis.client.cim.Collection;
import com.cisco.dcbu.smis.client.cim.DiskDrive;
import com.cisco.dcbu.smis.client.cim.PhysicalPackage;
import com.cisco.dcbu.smis.client.cim.ProtocolControllerForUnit;
import com.cisco.dcbu.smis.client.cim.SoftwareIdentity;
import com.cisco.dcbu.smis.client.cim.StorageExtent;
import com.cisco.dcbu.smis.client.cim.StorageHardwareID;
import com.cisco.dcbu.smis.client.cim.StoragePool;
import com.cisco.dcbu.smis.client.cim.StorageVolume;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Pool;
import com.cisco.dcbu.storage.model.StorageStatistics;
import com.cisco.dcbu.storage.model.StorageSystem;
import com.cisco.dcbu.storage.model.StorageSystemStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class OtherDiscoveryHandler
extends StorageDiscoveryHandler {
    private static boolean debug = true;
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");

    @Override
    public void discover(ArrayList<StorageSystem> strgSystems) {
        ArrayList<CIMInstance> regProfs = this.fetchRegisteredArrayProfiles();
        if (regProfs.size() > 0) {
            ArrayList<CIMInstance> comSysInsts = this.fetchTopLevelComputerSystem(regProfs);
            for (CIMInstance comSysInst : comSysInsts) {
                StorageSystem strgSystem = this.fetchComputerSystemPhysical(comSysInst);
                if (strgSystem == null || strgSystem.get_vendor() == null || strgSystem.get_pKey()._name == null || strgSystem.get_serialNumber() == null) continue;
                int index = strgSystems.indexOf(strgSystem);
                if (index >= 0) {
                    StorageSystem oldStrgSystem = strgSystems.get(index);
                    oldStrgSystem.update(strgSystem.get_nwwns(), strgSystem.get_storageType(), strgSystem.get_vendor(), strgSystem.get_version(), strgSystem.get_model(), strgSystem.get_partNumber(), strgSystem.get_serialNumber());
                    strgSystem = oldStrgSystem;
                } else {
                    strgSystem.set_provider(this._provider);
                    strgSystems.add(strgSystem);
                }
                this.fetchStoragePools(comSysInst, strgSystem);
                this.fetchComputerSystemPorts(comSysInst, null, strgSystem);
                this.fetchDiskDrive(comSysInst, strgSystem);
                CloseableIterator<CIMInstance> strgHWIDMSInsts = this.getAssociatorInstances("CIM_StorageHardwareIDManagementService", comSysInst.getObjectPath());
                if (strgHWIDMSInsts == null) continue;
                String collClassName = this.getStorageHardwareIdCollection(strgHWIDMSInsts);
                if (collClassName == null) {
                    this.fetchLun(comSysInst, strgSystem, true);
                    continue;
                }
                this.fetchLun(comSysInst, strgSystem, false);
                this.fetchHostandMap(comSysInst, strgSystem, collClassName);
            }
        }
    }

    private String getStorageHardwareIdCollection(CloseableIterator<CIMInstance> strgHWIDMSInsts) {
        CloseableIterator<CIMInstance> strgHWIDCollInsts;
        CloseableIterator<CIMInstance> strgHWIDInsts;
        String collClassName = null;
        if (strgHWIDMSInsts.hasNext() && (strgHWIDInsts = this.getAssociatorInstances("CIM_StorageHardwareID", ((CIMInstance)strgHWIDMSInsts.next()).getObjectPath())).hasNext() && (strgHWIDCollInsts = this.getAssociatorInstances("CIM_SystemSpecificCollection", ((CIMInstance)strgHWIDInsts.next()).getObjectPath())).hasNext()) {
            collClassName = ((CIMInstance)strgHWIDCollInsts.next()).getClassName();
        }
        return collClassName;
    }

    @Override
    public void perfCollection(StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> statsColInsts = this.getAssociatorInstances("CIM_StatisticsCollection", strgSystem.get_objPath());
        StorageStatistics storageStat = null;
        if (statsColInsts != null && statsColInsts.hasNext()) {
            HashMap<Integer, StorageSystemStatistics> hs = new HashMap<Integer, StorageSystemStatistics>();
            CIMInstance statsColInst = (CIMInstance)statsColInsts.next();
            if (statsColInst != null) {
                CloseableIterator<CIMInstance> statsInsts = this.getAssociatorInstances("CIM_BlockStorageStatisticalData", statsColInst.getObjectPath());
                while (statsInsts != null && statsInsts.hasNext()) {
                    CIMInstance statsInst = (CIMInstance)statsInsts.next();
                    BlockStorageStatisticalData stat = new BlockStorageStatisticalData(this._wbclient, statsInst);
                    switch (stat.getElementType().intValue()) {
                        case 2: {
                            storageStat = this.fetchArrayStats(statsInst);
                            break;
                        }
                        case 3: {
                            storageStat = this.fetchAdapterStats(statsInst);
                            break;
                        }
                        case 6: {
                            storageStat = this.fetchPortStats(statsInst);
                            break;
                        }
                        case 8: {
                            storageStat = this.fetchVolumeStats(statsInst);
                            break;
                        }
                        case 10: {
                            storageStat = this.fetchDiskStats(statsInst);
                            break;
                        }
                        default: {
                            storageStat = null;
                        }
                    }
                    if (storageStat == null) continue;
                    StorageSystemStatistics sss = (StorageSystemStatistics)hs.get(new Integer(stat.getElementType().intValue()));
                    if (sss == null) {
                        sss = new StorageSystemStatistics(stat.getElementName(), stat.getElementType().intValue());
                        hs.put(new Integer(stat.getElementType().intValue()), sss);
                    }
                    sss.add_strgstat(storageStat);
                }
                if (!hs.isEmpty()) {
                    strgSystem.getStatsList().addAll(hs.values());
                }
            }
        }
    }

    private void fetchDiskDrive(CIMInstance comSysInst, StorageSystem strgSystem) {
        ComponentSystem comp = strgSystem.get_comp(strgSystem.get_pKey()._name);
        if (comp == null) {
            comp = new ComponentSystem(strgSystem.get_pKey()._name);
            strgSystem.add_comp(comp);
        } else {
            comp.update();
        }
        CloseableIterator<CIMInstance> diskDrvInsts = this.getAssociatorInstances("CIM_DiskDrive", comSysInst.getObjectPath());
        while (diskDrvInsts != null && diskDrvInsts.hasNext()) {
            CIMInstance diskDrvInst = (CIMInstance)diskDrvInsts.next();
            DiskDrive diskDrive = new DiskDrive(this._wbclient, diskDrvInst);
            long rawCapacity = -1L;
            long userCapacity = -1L;
            long speed = -1L;
            CloseableIterator<CIMInstance> diskPhyPkgInsts = this.getAssociatorInstances("CIM_PhysicalPackage", diskDrvInst.getObjectPath());
            if (diskPhyPkgInsts == null || !diskPhyPkgInsts.hasNext()) {
                _Logger.warn((Object)("Error: Failed to get CIM_PhysicalPackage for " + diskDrive.getName()));
                return;
            }
            CIMInstance diskPhyPkgInst = (CIMInstance)diskPhyPkgInsts.next();
            PhysicalPackage diskPhyPkg = new PhysicalPackage(this._wbclient, diskPhyPkgInst);
            CloseableIterator<CIMInstance> softwareIdInsts = this.getAssociatorInstances("CIM_SoftwareIdentity", diskDrvInst.getObjectPath());
            if (softwareIdInsts == null || !softwareIdInsts.hasNext()) {
                _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + diskDrive.getName()));
                return;
            }
            CIMInstance softwareIdInst = (CIMInstance)softwareIdInsts.next();
            SoftwareIdentity swId = new SoftwareIdentity(this._wbclient, softwareIdInst);
            CloseableIterator<CIMInstance> diskExtInsts = this.getAssociatorInstances("CIM_StorageExtent", diskDrvInst.getObjectPath());
            CIMInstance diskExtInst = null;
            if (diskExtInsts != null && diskExtInsts.hasNext()) {
                diskExtInst = (CIMInstance)diskExtInsts.next();
                StorageExtent diskExtent = new StorageExtent(this._wbclient, diskExtInst);
                rawCapacity = diskExtent.getNumberOfBlocks().longValue() * diskExtent.getBlockSize().longValue();
                userCapacity = diskExtent.getConsumableBlocks().longValue() * diskExtent.getBlockSize().longValue();
                if (strgSystem.get_vendor().equalsIgnoreCase("IBM")) {
                    speed = ((UnsignedInteger32)diskDrvInst.getPropertyValue("DDMSpeed")).intValue();
                } else if (diskExtInst.getPropertyValue("DiskRPM") != null) {
                    speed = ((UnsignedInteger16)diskExtInst.getPropertyValue("DiskRPM")).intValue();
                }
            } else {
                _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + diskDrive.getName()));
                return;
            }
            UnsignedInteger16[] uint16 = diskDrive.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            Disk disk = comp.get_disk(diskDrive.getName());
            if (disk == null) {
                disk = new Disk(diskDrive.getName(), diskDrive.getCaption(), rawCapacity, userCapacity, -1L, diskDrive.getHealthState().intValue(), null, null, status, null, diskPhyPkg.getManufacturer(), diskPhyPkg.getModel(), diskPhyPkg.getSerialNumber(), "", swId.getVersionString(), speed, speed);
                comp.add_disk(disk);
                continue;
            }
            disk.update(diskDrive.getCaption(), rawCapacity, userCapacity, -1L, diskDrive.getHealthState().intValue(), null, null, status, null, diskPhyPkg.getManufacturer(), diskPhyPkg.getModel(), diskPhyPkg.getSerialNumber(), "", swId.getVersionString(), speed, speed);
        }
    }

    private void fetchLun(CIMInstance comSysInst, StorageSystem strgSystem, boolean doMap) {
        CloseableIterator<CIMInstance> strgVolInsts = this.getAssociatorInstances("CIM_StorageVolume", comSysInst.getObjectPath());
        while (strgVolInsts != null && strgVolInsts.hasNext()) {
            CIMInstance strgVolInst = (CIMInstance)strgVolInsts.next();
            StorageVolume strgVol = new StorageVolume(this._wbclient, strgVolInst);
            String wwn = null;
            if (strgVol.getOtherIdentifyingInfo() != null) {
                wwn = strgVol.getOtherIdentifyingInfo()[0];
            }
            UnsignedInteger16[] uint16 = strgVol.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
            if (lun == null) {
                lun = new Lun(strgVol.getElementName(), strgVol.getDeviceID(), wwn, "", strgVol.getBlockSize().longValue() * strgVol.getNumberOfBlocks().longValue(), -1L, strgVol.getBlockSize().longValue() * strgVol.getConsumableBlocks().longValue(), status, "", null, "", "");
                strgSystem.add_lun(lun);
            } else {
                lun.update(wwn, "", strgVol.getBlockSize().longValue() * strgVol.getNumberOfBlocks().longValue(), -1L, strgVol.getBlockSize().longValue() * strgVol.getConsumableBlocks().longValue(), status, "", null, "", "");
            }
            if (!doMap) continue;
            this.fetchHostandMap(strgVolInst, strgVol, strgSystem);
        }
    }

    private void fetchHostandMap(CIMInstance comSysInst, StorageSystem strgSystem, String collClassName) {
        CloseableIterator<CIMInstance> strgHWIDColInsts = this.getAssociatorInstances(collClassName, comSysInst.getObjectPath());
        while (strgHWIDColInsts != null && strgHWIDColInsts.hasNext()) {
            CIMInstance strgHWIDColInst = (CIMInstance)strgHWIDColInsts.next();
            Collection strgHWIDCol = new Collection(this._wbclient, strgHWIDColInst);
            String hostName = strgHWIDCol.getElementName();
            if (hostName == null) continue;
            Host host = strgSystem.get_host(hostName);
            if (host == null) {
                host = new Host(hostName);
                host.setNwwn("");
                strgSystem.add_host(host);
            }
            CloseableIterator<CIMInstance> strgHWIDInsts = this.getAssociatorInstances("CIM_StorageHardwareID", strgHWIDColInst.getObjectPath());
            while (strgHWIDInsts != null && strgHWIDInsts.hasNext()) {
                CIMInstance strgHWIDInst = (CIMInstance)strgHWIDInsts.next();
                StorageHardwareID strgHWID = new StorageHardwareID(this._wbclient, strgHWIDInst);
                host.add_strgHwid(strgHWID.getStorageID(), strgHWIDInst.getObjectPath());
                CloseableIterator<CIMInstance> privInsts = this.getAssociatorInstances("CIM_Privilege", strgHWIDInst.getObjectPath());
                if (privInsts == null || !privInsts.hasNext()) continue;
                CIMInstance privInst = (CIMInstance)privInsts.next();
                AuthorizedPrivilege authpriv = new AuthorizedPrivilege(this._wbclient, privInst);
                CloseableIterator<CIMInstance> pcInsts = this.getAssociatorInstances("CIM_ProtocolController", privInst.getObjectPath());
                if (pcInsts == null || !pcInsts.hasNext()) continue;
                CIMInstance pcInst = (CIMInstance)pcInsts.next();
                ArrayList<String> scsiPEPwwns = new ArrayList<String>();
                CloseableIterator<CIMInstance> fcPortInsts = this.getAssociatorInstances("CIM_FCPort", pcInst.getObjectPath());
                while (fcPortInsts != null && fcPortInsts.hasNext()) {
                    CIMInstance fcPortInst = (CIMInstance)fcPortInsts.next();
                    scsiPEPwwns.add((String)fcPortInst.getPropertyValue("PermanentAddress"));
                }
                ArrayList<String> devices = new ArrayList<String>();
                CloseableIterator<CIMInstance> pc4UInsts = this.getReferenceInstances("CIM_ProtocolControllerForUnit", pcInst.getObjectPath());
                while (pc4UInsts != null && pc4UInsts.hasNext()) {
                    CIMInstance pc4UInst = (CIMInstance)pc4UInsts.next();
                    ProtocolControllerForUnit pc4U = new ProtocolControllerForUnit(this._wbclient, pc4UInst);
                    if (devices.contains(pc4U.getDeviceNumber())) continue;
                    devices.add(pc4U.getDeviceNumber());
                    CIMObjectPath strgHWIDOP = strgHWIDInst.getObjectPath();
                    CIMInstance strgVolInst = this.getInstance(pc4U.getDependent());
                    if (strgVolInst == null) continue;
                    StorageVolume strgVol = new StorageVolume(this._wbclient, strgVolInst);
                    int strgHWIDType = strgHWID.getIDType().intValue();
                    boolean accessGranted = authpriv.getPrivilegeGranted();
                    String strgLun = strgVol.getDeviceID();
                    String mappedLun = pc4U.getDeviceNumber();
                    int lunAccess = pc4U.getDeviceAccess().intValue();
                    for (String protoEndPtWWN : scsiPEPwwns) {
                        HostLunMapping hostLunMap = new HostLunMapping(strgHWID.getStorageID(), hostName, "", protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
                        Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                        if (lun != null) {
                            lun.add_hostLunMap(hostLunMap);
                        }
                        host.add_hostLunMap(hostLunMap);
                    }
                }
            }
        }
    }

    private void fetchHostandMap(CIMInstance strgVolInst, StorageVolume strgVol, StorageSystem strgSystem) {
        ArrayList<String> devices = new ArrayList<String>();
        CloseableIterator<CIMInstance> pc4UInsts = this.getReferenceInstances("CIM_ProtocolControllerForUnit", strgVolInst.getObjectPath());
        while (pc4UInsts != null && pc4UInsts.hasNext()) {
            CIMInstance pc4UInst = (CIMInstance)pc4UInsts.next();
            ProtocolControllerForUnit pc4U = new ProtocolControllerForUnit(this._wbclient, pc4UInst);
            if (devices.contains(pc4U.getDeviceNumber())) continue;
            devices.add(pc4U.getDeviceNumber());
            CIMInstance pcInst = null;
            if (strgSystem.get_vendor().equalsIgnoreCase("IBM")) {
                String pc4u = "//" + this._provider.getUrl() + pc4U.getAntecedent().toString();
                CIMObjectPath cimop = new CIMObjectPath(pc4u);
                pcInst = this.getInstance(cimop);
            } else {
                pcInst = this.getInstance(pc4U.getAntecedent());
            }
            if (pcInst == null) continue;
            ArrayList<String> scsiPEPwwns = new ArrayList<String>();
            CloseableIterator<CIMInstance> fcPortInsts = this.getAssociatorInstances("CIM_FCPort", pcInst.getObjectPath());
            while (fcPortInsts != null && fcPortInsts.hasNext()) {
                CIMInstance fcPortInst = (CIMInstance)fcPortInsts.next();
                scsiPEPwwns.add((String)fcPortInst.getPropertyValue("PermanentAddress"));
            }
            CloseableIterator<CIMInstance> privInsts = this.getAssociatorInstances("CIM_Privilege", pcInst.getObjectPath());
            if (privInsts == null || !privInsts.hasNext()) continue;
            CIMInstance privInst = (CIMInstance)privInsts.next();
            AuthorizedPrivilege authpriv = new AuthorizedPrivilege(this._wbclient, privInst);
            CloseableIterator<CIMInstance> strgHWIDInsts = this.getAssociatorInstances("CIM_StorageHardwareID", privInst.getObjectPath());
            while (strgHWIDInsts != null && strgHWIDInsts.hasNext()) {
                Host host;
                CIMInstance strgHWIDInst = (CIMInstance)strgHWIDInsts.next();
                StorageHardwareID strgHWID = new StorageHardwareID(this._wbclient, strgHWIDInst);
                String hostName = strgHWID.getElementName();
                if (hostName != null && (host = strgSystem.get_host(hostName)) == null) {
                    host = new Host(hostName);
                    host.setNwwn("");
                    strgSystem.add_host(host);
                    host.add_strgHwid(strgHWID.getStorageID(), strgHWIDInst.getObjectPath());
                }
                boolean accessGranted = authpriv.getPrivilegeGranted();
                String strgLun = strgVol.getDeviceID();
                String mappedLun = pc4U.getDeviceNumber();
                int lunAccess = pc4U.getDeviceAccess().intValue();
                for (String protoEndPtWWN : scsiPEPwwns) {
                    HostLunMapping hostLunMap = new HostLunMapping(strgHWID.getStorageID(), hostName, "", protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
                    Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                    lun.add_hostLunMap(hostLunMap);
                    Host host2 = strgSystem.get_host(hostName);
                    if (host2 == null) continue;
                    host2.add_hostLunMap(hostLunMap);
                }
            }
        }
    }

    private void fetchStoragePools(CIMInstance comSysInst, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> strgPoolInsts = this.getAssociatorInstances("CIM_StoragePool", comSysInst.getObjectPath());
        while (strgPoolInsts != null && strgPoolInsts.hasNext()) {
            long usedSpace;
            CIMInstance strgPoolInst = (CIMInstance)strgPoolInsts.next();
            StoragePool strgPool = new StoragePool(this._wbclient, strgPoolInst);
            long rawcapacity = -1L;
            String extendstripe = "";
            long totalManagedSpace = strgPool.getTotalManagedSpace().longValue();
            long remainingManagedSpace = strgPool.getRemainingManagedSpace().longValue();
            int per_sub = 0;
            if (totalManagedSpace > 0L && (usedSpace = totalManagedSpace - remainingManagedSpace) > 0L) {
                per_sub = (int)(usedSpace * 100L / totalManagedSpace);
            }
            UnsignedInteger16[] uint16 = strgPool.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            Pool pool = strgSystem.get_pool(strgPool.getElementName());
            if (pool == null) {
                pool = new Pool(strgPool.getElementName(), rawcapacity, totalManagedSpace, remainingManagedSpace, -1L, -1L, per_sub, status, extendstripe, null);
                strgSystem.add_pool(pool);
                continue;
            }
            pool.update(rawcapacity, totalManagedSpace, remainingManagedSpace, -1L, -1L, per_sub, status, extendstripe, null);
        }
    }

    public void run() {
    }
}

