/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Pool;
import com.cisco.dcbu.storage.model.StoragePort;
import com.cisco.dcbu.storage.model.StorageProcessor;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.cim.CIMObjectPath;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TESTDiscoveryHandler
extends StorageDiscoveryHandler {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    private static final String storageSystemListSql = "SELECT ID, SYSTEM_NAME, STORAGE_TYPE, VENDOR, VERSION, MODEL, SERIAL_NUMBER, PART_NUMBER FROM TEST_STORAGE_SYSTEM";
    private static final String getComponentListSql = "SELECT ID, SYSTEM_COMPONENT_NAME FROM TEST_SYSTEM_COMPONENT WHERE SYSTEM_DB_ID=?";
    private static final String diskListSql = "SELECT TEST_DISK.ID, TEST_DISK.DISK_NAME, TEST_DISK.DRIVE_TYPE, TEST_DISK.RAW_CAPACITY,TEST_DISK.USER_CAPACITY, TEST_DISK.USER_SECTORS, TEST_DISK.STATE, TEST_DISK.RAID_TYPE, TEST_DISK.STORAGE_POOL,TEST_DISK.STATUS, TEST_DISK.MANUFACTURER, TEST_DISK.MODEL, TEST_DISK.SERIAL_NUMBER, TEST_DISK.PART_NUMBER, TEST_DISK.FIRMWARE_REV, TEST_DISK.CURRENT_SPEED, TEST_DISK.MAX_SPEED, TEST_DISK.PRESENT FROM TEST_DISK WHERE TEST_DISK.SYSTEM_COMPONENT_DB_ID=? ORDER BY DISK_NAME ASC";
    private static final String poolListSql = "SELECT ID, POOL_NAME, RAW_CAPACITY, TOTAL_MANAGED,REMAINING_MANAGED, REMAINING_RAW_CAPACITY, SUBSCRIBED_CAPACITY, PERCENT_SUBSCRIBED, STATUS,RAID_TYPE, DISK_TYPE, PRESENT FROM TEST_POOL WHERE SYSTEM_DB_ID=? ORDER BY POOL_NAME ASC";
    private static final String getHostListSql = "SELECT ID, HOST_NWWN, HOST_NAME, PRESENT FROM TEST_HOST WHERE SYSTEM_DB_ID=? ORDER BY HOST_NAME ASC";
    private static final String lunListSql = "SELECT ID, LUN_NAME, LUN_ID, WWN, POOL_NAME, TOTAL_MANAGED_SPACE, REMAINING_MANAGED_SPACE, CONSUMED_CAPACITY, STATUS, RAID_TYPE, DISK_TYPE, CURRENT_OWNER, DEFAULT_OWNER, LAST_UPDATED, PRESENT FROM TEST_STORAGE_LUN WHERE SYSTEM_DB_ID=? ORDER BY LUN_NAME ASC";
    private static final String getListByLUNSql = "SELECT TEST_HOST_LUN_MAP.ID, TEST_HOST.HOST_NAME, TEST_HOST_LUN_MAP.READABLE_HOST_NAME, TEST_HOST_PORT.HOST_PWWN, TEST_HOST_LUN_MAP.TARGET_PWWN, TEST_HOST_LUN_MAP.LUN_ID, TEST_HOST_LUN_MAP.HOST_LUN_ID, TEST_HOST_LUN_MAP.LUN_ACCESS, TEST_HOST_LUN_MAP.ACCESS_PRIV_GRANTED, TEST_HOST_LUN_MAP.ADAPTER_NAME, TEST_HOST_LUN_MAP.LAST_UPDATED, TEST_HOST_LUN_MAP.PRESENT FROM TEST_HOST, TEST_HOST_PORT, TEST_HOST_LUN_MAP WHERE TEST_HOST_LUN_MAP.SYSTEM_DB_ID=? AND TEST_HOST_LUN_MAP.LUN_DB_ID=? AND TEST_HOST_LUN_MAP.HOST_PORT_DB_ID=TEST_HOST_PORT.ID AND TEST_HOST_PORT.HOST_DB_ID=TEST_HOST.ID  ORDER BY TEST_HOST.HOST_NAME ASC";
    private static final String getListByHostSql = "SELECT TEST_HOST_LUN_MAP.ID, TEST_HOST.HOST_NAME, TEST_HOST_LUN_MAP.READABLE_HOST_NAME, TEST_HOST_PORT.HOST_PWWN, TEST_HOST_LUN_MAP.TARGET_PWWN, TEST_HOST_LUN_MAP.LUN_ID, TEST_HOST_LUN_MAP.HOST_LUN_ID, TEST_HOST_LUN_MAP.LUN_ACCESS, TEST_HOST_LUN_MAP.ACCESS_PRIV_GRANTED, TEST_HOST_LUN_MAP.ADAPTER_NAME, TEST_HOST_LUN_MAP.LAST_UPDATED, TEST_HOST_LUN_MAP.PRESENT FROM TEST_HOST, TEST_HOST_PORT, TEST_HOST_LUN_MAP WHERE TEST_HOST_LUN_MAP.SYSTEM_DB_ID=? AND TEST_HOST_PORT.HOST_DB_ID=? AND TEST_HOST_LUN_MAP.HOST_PORT_DB_ID=TEST_HOST_PORT.ID AND TEST_HOST_PORT.HOST_DB_ID=TEST_HOST.ID ORDER BY TEST_HOST.HOST_NAME ASC";
    private static final String processorListSql = "SELECT ID, PROCESSOR_NAME, PROCESSOR_NUMBER, NUM_PORTS, MEM_SIZE, SERIAL_NUMBER, SLOT_NUMBER, READ_CACHE, WRITE_CACHE, STATUS, IP_ADDRESS,FRONT_END_ADAPTER, BACK_END_ADAPTER, SRDF_ADAPTER, LAST_UPDATED, PRESENT FROM TEST_STORAGE_PROCESSOR WHERE SYSTEM_DB_ID=? ORDER BY PROCESSOR_NAME ASC";
    private static final String portListSql = "SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED, PRESENT FROM TEST_STORAGE_PORT WHERE SYSTEM_DB_ID=? ORDER BY PORT_NAME ASC";
    private static final String getListByProcessorSql = "SELECT ID, PORT_NAME, PORT_NUMBER, PORT_TYPE, NETWORK_ADDRESS, PORT_DESCRIPTION, SPEED, PORT_USAGE, STATUS, LAST_UPDATED, PRESENT FROM TEST_STORAGE_PORT WHERE SYSTEM_DB_ID=? AND PROCESSOR_DB_ID=? ORDER BY PORT_NAME ASC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discover(ArrayList<StorageSystem> strgSystems) {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            ArrayList<StorageSystem> systemList = TESTDiscoveryHandler.getSystemList(con);
            for (StorageSystem strgSystem : systemList) {
                ArrayList<StoragePort> portList;
                if (strgSystem == null) continue;
                long testSystemDbId = strgSystem.getDBID();
                int index = strgSystems.indexOf(strgSystem);
                if (index >= 0) {
                    StorageSystem oldStrgSystem = strgSystems.get(index);
                    _Logger.error((Object)"Before discovery");
                    for (StoragePort wtfPort : oldStrgSystem.get_ports()) {
                        _Logger.error((Object)(oldStrgSystem.get_pKey()._name + " Port: " + wtfPort.get_pKey()._name + " modified: " + wtfPort.isModified() + "  present: " + wtfPort.isPresent()));
                    }
                    oldStrgSystem.update(strgSystem.get_nwwns(), strgSystem.get_storageType(), strgSystem.get_vendor(), strgSystem.get_version(), strgSystem.get_model(), strgSystem.get_partNumber(), strgSystem.get_serialNumber());
                    strgSystem = oldStrgSystem;
                } else {
                    strgSystem.set_provider(this._provider);
                    strgSystems.add(strgSystem);
                }
                strgSystem.setDBID(0L);
                ArrayList<ComponentSystem> componentList = TESTDiscoveryHandler.getComponentList(con, testSystemDbId);
                for (ComponentSystem comp : componentList) {
                    ComponentSystem cacheComp = strgSystem.get_comp(comp.get_pKey()._name);
                    ArrayList<Disk> diskList = TESTDiscoveryHandler.getDiskList(con, comp.getDBID());
                    if (cacheComp == null) {
                        comp.setDBID(0L);
                        strgSystem.add_comp(comp);
                        cacheComp = comp;
                    }
                    for (Disk d : diskList) {
                        if (!d.isPresent()) {
                            _Logger.error((Object)("Skipping !present disk " + d.get_pKey()._name));
                            continue;
                        }
                        Disk old = cacheComp.get_disk(d.get_pKey()._name);
                        if (old != null) {
                            old.update(d.get_driveType(), d.get_rawCapacity(), d.get_userCapacity(), d.get_userSectors(), d.get_state(), d.get_raidType(), d.get_pools(), d.get_status(), d.get_luns(), d.get_manufacturer(), d.get_model(), d.get_serialNumber(), d.get_partNumber(), d.get_firmwareRev(), d.get_currSpeed(), d.get_maxSpeed());
                            continue;
                        }
                        d.setDBID(0L);
                        cacheComp.add_disk(d);
                    }
                }
                ArrayList<Pool> poolList = TESTDiscoveryHandler.getPoolList(con, testSystemDbId);
                for (Pool p : poolList) {
                    if (!p.isPresent()) {
                        _Logger.error((Object)("Skipping !present pool " + p.get_pKey()._name));
                        continue;
                    }
                    Pool cachePool = strgSystem.get_pool(p.get_pKey()._name);
                    if (cachePool != null) {
                        cachePool.update(p.get_rawCapacity(), p.get_totalManagedSpace(), p.get_remainingManagedSpace(), p.get_remainingRawCapacity(), p.get_subscribedCapacity(), p.get_percentSubscribed(), p.get_status(), p.get_raidType(), p.get_diskType());
                        continue;
                    }
                    p.setDBID(0L);
                    strgSystem.add_pool(p);
                }
                ArrayList<StorageProcessor> processorList = TESTDiscoveryHandler.getProcessorList(con, testSystemDbId);
                for (StorageProcessor p : processorList) {
                    if (!p.isPresent()) {
                        _Logger.error((Object)("Skipping !present processor " + p.get_pKey()._name));
                        continue;
                    }
                    portList = TESTDiscoveryHandler.getPortListByProcessor(con, testSystemDbId, p.getDBID());
                    StorageProcessor processorCache = strgSystem.get_strgproc(p.get_pKey()._name);
                    if (processorCache != null) {
                        _Logger.error((Object)("processor in cache " + p.get_pKey()._name));
                        processorCache.update(p.get_adapterNumber(), p.get_numPorts(), p.get_memsize(), p.get_serialNumber(), p.get_slotNumber(), p.get_readCache(), p.get_writeCache(), p.get_status(), p.get_ipaddress(), p.get_roles());
                    } else {
                        _Logger.error((Object)("processor not in cache " + p.get_pKey()._name));
                        p.setDBID(0L);
                        strgSystem.add_strgproc(p);
                        processorCache = p;
                    }
                    for (StoragePort sp : portList) {
                        if (!sp.isPresent()) {
                            _Logger.error((Object)("Skipping !present port " + sp.get_pKey()._name));
                            continue;
                        }
                        if (strgSystem.get_port(sp.get_pKey()._name) == null) {
                            sp.setDBID(0L);
                        }
                        strgSystem.add_port(sp);
                        processorCache.add_port(sp);
                    }
                }
                ArrayList<Lun> lunList = TESTDiscoveryHandler.getLunList(con, testSystemDbId);
                for (Lun l : lunList) {
                    if (!l.isPresent()) {
                        _Logger.error((Object)("Skipping !present lun " + l.get_pKey().get_lunName()));
                        continue;
                    }
                    Lun lunCache = strgSystem.get_lun(l.get_pKey().get_lunId(), l.get_pKey().get_lunName());
                    if (lunCache != null) {
                        lunCache.update(l.get_wwn(), l.get_storagePoolName(), l.get_totalManagedSpace(), l.get_remainingManagedSpace(), l.get_consumedCapacity(), l.get_status(), l.get_raidType(), l.get_diskType(), l.get_currentOwner(), l.get_defaultOwner());
                        continue;
                    }
                    l.setDBID(0L);
                    strgSystem.add_lun(l);
                    lunCache = l;
                }
                ArrayList<Host> hostList = this.getHostList(con, testSystemDbId);
                for (Host h : hostList) {
                    if (!h.isPresent()) {
                        _Logger.error((Object)("Skipping !present host " + h.get_pKey()._name));
                        continue;
                    }
                    ArrayList<HostLunMapping> hlmList = TESTDiscoveryHandler.getListByHost(con, testSystemDbId, h.getDBID());
                    Host hostCache = strgSystem.get_host(h.get_pKey()._name);
                    if (hostCache != null) {
                        hostCache.update();
                    } else {
                        h.setDBID(0L);
                        strgSystem.add_host(h);
                        hostCache = h;
                    }
                    for (HostLunMapping hlm : hlmList) {
                        if (!hlm.isPresent()) continue;
                        if (hostCache.get_hostLunMap(hlm.get_hostWwn()) == null) {
                            hlm.setDBID(0L);
                        }
                        hostCache.add_hostLunMap(hlm);
                    }
                }
                portList = TESTDiscoveryHandler.getPortList(con, testSystemDbId);
                for (StoragePort sp : portList) {
                    if (!sp.isPresent()) {
                        _Logger.error((Object)("Skipping !present port " + sp.get_pKey()._name));
                        continue;
                    }
                    if (strgSystem.get_port(sp.get_pKey()._name) == null) {
                        sp.setDBID(0L);
                    }
                    strgSystem.add_port(sp);
                }
                _Logger.error((Object)"After discovery");
                for (StoragePort wtfPort : strgSystem.get_ports()) {
                    _Logger.error((Object)(strgSystem.get_pKey()._name + " Port: " + wtfPort.get_pKey()._name + " modified: " + wtfPort.isModified() + "  present: " + wtfPort.isPresent()));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbUtil.close(con);
        }
    }

    @Override
    public void perfCollection(StorageSystem strgSystem) {
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<StorageSystem> getSystemList(Connection con) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<StorageSystem> ssl = new ArrayList<StorageSystem>();
        try {
            getStat = con.prepareStatement(storageSystemListSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                long dbId = rs.getLong(1);
                String Name2 = rs.getString(2);
                String StorageType = rs.getString(3);
                String Vendor = rs.getString(4);
                String Version2 = rs.getString(5);
                String Model = rs.getString(6);
                String SerialNumber = rs.getString(7);
                String PartNumber = rs.getString(8);
                long[] nwwns = new long[]{0L, 1L};
                String[] storageType = new String[]{};
                if (StorageType.length() > 3) {
                    StorageType = StorageType.substring(1, StorageType.length() - 1);
                    storageType = StorageType.split(", ");
                }
                StorageSystem ssd = new StorageSystem(Name2, nwwns, storageType, Vendor, Version2, Model, PartNumber, SerialNumber);
                ssd.setDBID(dbId);
                ssl.add(ssd);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ComponentSystem> getComponentList(Connection con, long systemDbId) {
        ArrayList<ComponentSystem> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<ComponentSystem>();
            try {
                getStat = con.prepareStatement(getComponentListSql);
                getStat.setLong(1, systemDbId);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    ComponentSystem obj = new ComponentSystem(rs.getString(2));
                    long dbId = rs.getLong(1);
                    obj.setDBID(dbId);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Disk> getDiskList(Connection con, long dbid) {
        ArrayList<Disk> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<Disk>();
            try {
                getStat = con.prepareStatement(diskListSql);
                getStat.setLong(1, dbid);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    int i = 1;
                    long DbId = rs.getLong(i++);
                    String DiskName = rs.getString(i++);
                    String DriveType = rs.getString(i++);
                    long RawCapacity = rs.getLong(i++);
                    long UserCapacity = rs.getLong(i++);
                    long UserSectors = rs.getLong(i++);
                    int n = ++i;
                    String RaidType = rs.getString(n);
                    int n2 = ++i;
                    String StoragePoolName = rs.getString(n2);
                    int n3 = ++i;
                    String Status2 = rs.getString(n3);
                    int n4 = ++i;
                    String Manufacturer = rs.getString(n4);
                    int n5 = ++i;
                    String Model = rs.getString(n5);
                    int n6 = ++i;
                    String SerialNumber = rs.getString(n6);
                    int n7 = ++i;
                    String PartNumber = rs.getString(n7);
                    int n8 = ++i;
                    String FirmwareRev = rs.getString(n8);
                    int n9 = ++i;
                    long CurrSpeed = rs.getLong(n9);
                    int n10 = ++i;
                    long MaxSpeed = rs.getLong(n10);
                    int n11 = ++i;
                    ++i;
                    boolean present = rs.getBoolean(n11);
                    long[] status = new long[]{};
                    Disk obj = new Disk(DiskName, DriveType, RawCapacity, UserCapacity, UserSectors, 5, RaidType, null, status, null, Manufacturer, Model, SerialNumber, PartNumber, FirmwareRev, CurrSpeed, MaxSpeed);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Pool> getPoolList(Connection con, long systemDbId) {
        ArrayList<Pool> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<Pool>();
            try {
                getStat = con.prepareStatement(poolListSql);
                getStat.setLong(1, systemDbId);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    int i = 1;
                    long DbId = rs.getLong(i++);
                    String Name2 = rs.getString(i++);
                    long RawCapacity = rs.getLong(i++);
                    long TotalManagedSpace = rs.getLong(i++);
                    long RemainingManagedSpace = rs.getLong(i++);
                    long RemainingRawCapacity = rs.getLong(i++);
                    long SubscribedCapacity = rs.getLong(i++);
                    int PercentSubscribed = rs.getInt(i++);
                    String Status2 = rs.getString(i++);
                    String RaidType = rs.getString(i++);
                    String DiskType = rs.getString(i++);
                    boolean present = rs.getBoolean(i++);
                    long[] _status = new long[]{};
                    String[] _diskType = new String[]{};
                    Pool obj = new Pool(Name2, RawCapacity, TotalManagedSpace, RemainingManagedSpace, RemainingRawCapacity, SubscribedCapacity, PercentSubscribed, _status, RaidType, _diskType);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<Host> getHostList(Connection con, long dbid) {
        ArrayList<Host> ssl;
        block8: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<Host>();
            try {
                getStat = con.prepareStatement(getHostListSql);
                getStat.setLong(1, dbid);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    long DbId = rs.getLong(1);
                    String hwwns = rs.getString(2);
                    String[] hwwnList = new String[]{};
                    if (hwwns.length() > 3) {
                        hwwns = hwwns.substring(1, hwwns.length() - 1);
                        hwwnList = hwwns.split(", ");
                    }
                    Host obj = new Host(rs.getString(3));
                    for (String hwwn : hwwnList) {
                        obj.add_strgHwid(hwwn, new CIMObjectPath("tESt"));
                    }
                    boolean present = rs.getBoolean(4);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Lun> getLunList(Connection con, long poolDbId) {
        ArrayList<Lun> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<Lun>();
            try {
                getStat = con.prepareStatement(lunListSql);
                getStat.setLong(1, poolDbId);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    int i = 1;
                    long DbId = rs.getLong(i++);
                    String LunName = rs.getString(i++);
                    String LunId = rs.getString(i++);
                    String Wwn2 = rs.getString(i++);
                    String StoragePoolName = rs.getString(i++);
                    long TotalManagedSpace = rs.getLong(i++);
                    long RemainingManagedSpace = rs.getLong(i++);
                    long ConsumedCapacity = rs.getLong(i++);
                    String Status2 = rs.getString(i++);
                    String RaidType = rs.getString(i++);
                    String DiskType = rs.getString(i++);
                    String CurrentOwner = rs.getString(i++);
                    String DefaultOwner = rs.getString(i++);
                    String LastSeen = rs.getTimestamp(i++).toString();
                    boolean present = rs.getBoolean(i++);
                    long[] _status = new long[]{};
                    String[] _diskType = new String[]{};
                    Lun obj = new Lun(LunName, LunId, Wwn2, StoragePoolName, TotalManagedSpace, RemainingManagedSpace, ConsumedCapacity, _status, RaidType, _diskType, CurrentOwner, DefaultOwner);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<HostLunMapping> getListByLun(Connection con, long systemDbId, long lunDbId) {
        ArrayList<HostLunMapping> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<HostLunMapping>();
            try {
                getStat = con.prepareStatement(getListByLUNSql);
                getStat.setLong(1, systemDbId);
                getStat.setLong(2, lunDbId);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    int i = 1;
                    long DbId = rs.getLong(i++);
                    String HostName = rs.getString(i++);
                    String ReadableHost = rs.getString(i++);
                    String HostWwn = rs.getString(i++);
                    String TargetWwn = rs.getString(i++);
                    String LunId = rs.getString(i++);
                    String HostLunId = rs.getString(i++);
                    int LunAccess = rs.getInt(i++);
                    boolean AccessPrivGranted = rs.getBoolean(i++);
                    String AdapterName = rs.getString(i++);
                    String LastSeen = rs.getTimestamp(i++).toString();
                    boolean present = rs.getBoolean(i++);
                    HostLunMapping obj = new HostLunMapping(HostWwn, HostName, ReadableHost, TargetWwn, AdapterName, LunId, HostLunId, LunAccess, AccessPrivGranted);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<HostLunMapping> getListByHost(Connection con, long systemDbId, long hostDbId) {
        ArrayList<HostLunMapping> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<HostLunMapping>();
            try {
                getStat = con.prepareStatement(getListByHostSql);
                getStat.setLong(1, systemDbId);
                getStat.setLong(2, hostDbId);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    int i = 1;
                    long DbId = rs.getLong(i++);
                    String HostName = rs.getString(i++);
                    String ReadableHost = rs.getString(i++);
                    String HostWwn = rs.getString(i++);
                    String TargetWwn = rs.getString(i++);
                    String LunId = rs.getString(i++);
                    String HostLunId = rs.getString(i++);
                    int LunAccess = rs.getInt(i++);
                    boolean AccessPrivGranted = rs.getBoolean(i++);
                    String AdapterName = rs.getString(i++);
                    String LastSeen = rs.getTimestamp(i++).toString();
                    boolean present = rs.getBoolean(i++);
                    HostLunMapping obj = new HostLunMapping(HostWwn, HostName, ReadableHost, TargetWwn, AdapterName, LunId, HostLunId, LunAccess, AccessPrivGranted);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<StorageProcessor> getProcessorList(Connection con, long dbid) {
        ArrayList<StorageProcessor> ssl;
        block7: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<StorageProcessor>();
            try {
                getStat = con.prepareStatement(processorListSql);
                getStat.setLong(1, dbid);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    int i = 1;
                    long DbId = rs.getLong(i++);
                    String Name2 = rs.getString(i++);
                    long AdapterNumber = rs.getLong(i++);
                    long NumPorts = rs.getLong(i++);
                    long Memsize = rs.getLong(i++);
                    String SerialNumber = rs.getString(i++);
                    long SlotNumber = rs.getLong(i++);
                    long ReadCache = rs.getLong(i++);
                    long WriteCache = rs.getLong(i++);
                    String Status2 = rs.getString(i++);
                    String Ipaddress = rs.getString(i++);
                    boolean FrontEndAdapter = rs.getBoolean(i++);
                    boolean BackendEndAdapter = rs.getBoolean(i++);
                    boolean SrdfAdapter = rs.getBoolean(i++);
                    Timestamp t = rs.getTimestamp(i++);
                    boolean present = rs.getBoolean(i++);
                    String LastSeen = "";
                    if (t != null) {
                        LastSeen = t.toString();
                    }
                    long[] _status = new long[]{};
                    String[] roles = new String[]{};
                    StorageProcessor obj = new StorageProcessor(Name2, AdapterNumber, NumPorts, Memsize, SerialNumber, SlotNumber, ReadCache, WriteCache, _status, Ipaddress, roles);
                    obj.setDBID(DbId);
                    obj.set_backendEndAdapter(BackendEndAdapter);
                    obj.set_frontEndAdapter(FrontEndAdapter);
                    obj.set_srdfAdapter(SrdfAdapter);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<StoragePort> getPortList(Connection con, long dbid) {
        ArrayList<StoragePort> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<StoragePort>();
            try {
                getStat = con.prepareStatement(portListSql);
                getStat.setLong(1, dbid);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    long DbId = rs.getLong(1);
                    String Name2 = rs.getString(2);
                    int PortNumber = rs.getInt(3);
                    int PortType2 = rs.getInt(4);
                    String NetworkAddress = rs.getString(5);
                    String PortDesc = rs.getString(6);
                    long Speed = rs.getLong(7);
                    long Usage = rs.getLong(8);
                    String Status2 = rs.getString(9);
                    String LastSeen = rs.getTimestamp(10).toString();
                    boolean present = rs.getBoolean(11);
                    String[] _portDesc = new String[]{};
                    long[] _status = new long[]{};
                    StoragePort obj = new StoragePort(new NameKey(Name2), PortNumber, PortType2, NetworkAddress, "", _portDesc, Speed, (int)Usage, _status);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<StoragePort> getPortListByProcessor(Connection con, long dbid, long processorDbId) {
        ArrayList<StoragePort> ssl;
        block6: {
            PreparedStatement getStat = null;
            ResultSet rs = null;
            ssl = new ArrayList<StoragePort>();
            try {
                getStat = con.prepareStatement(getListByProcessorSql);
                getStat.setLong(1, dbid);
                getStat.setLong(2, processorDbId);
                rs = SQLLoader.execute(getStat);
                while (rs.next()) {
                    long DbId = rs.getLong(1);
                    String Name2 = rs.getString(2);
                    int PortNumber = rs.getInt(3);
                    int PortType2 = rs.getInt(4);
                    String NetworkAddress = rs.getString(5);
                    String PortDesc = rs.getString(6);
                    long Speed = rs.getLong(7);
                    long Usage = rs.getLong(8);
                    String Status2 = rs.getString(9);
                    String LastSeen = rs.getTimestamp(10).toString();
                    boolean present = rs.getBoolean(11);
                    String[] _portDesc = new String[]{};
                    long[] _status = new long[]{};
                    StoragePort obj = new StoragePort(new NameKey(Name2), PortNumber, PortType2, NetworkAddress, "", _portDesc, Speed, (int)Usage, _status);
                    obj.setDBID(DbId);
                    obj.setPresent(present);
                    ssl.add(obj);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            DbUtil.close(getStat);
        }
        return ssl;
    }
}

