/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.model.Disk;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import javax.cim.CIMObjectPath;

public class ComponentSystem
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base;
    private NameKey _pKey;
    private CIMObjectPath _objPath = null;
    private ConcurrentHashMap<NameKey, Disk> _diskByPK = new ConcurrentHashMap();

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Comp-Name=").append(this._pKey._name == null ? "" : this._pKey._name).append("\n").append(this.dumpDisk(level + 1));
        return sb.toString();
    }

    public String dumpDisk(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Disks: ").append(this._diskByPK.size());
        for (Disk disk : this._diskByPK.values()) {
            sb.append(disk.dump(level));
        }
        return sb.toString();
    }

    public ComponentSystem() {
        this._base = new SMISBaseModelObject();
    }

    public ComponentSystem(String _storageName) {
        this();
        this._pKey = new NameKey(_storageName);
        this._base.setModified(true);
    }

    public void update() {
        this._base.setPresent(true);
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public Collection<Disk> get_disks() {
        return this._diskByPK.values();
    }

    public void add_disk(Disk _disk) {
        if (!this._diskByPK.contains(_disk)) {
            this._base.setModified(true);
            this._diskByPK.put(_disk.get_pKey(), _disk);
        }
    }

    public Disk get_disk(String diskName) {
        return this._diskByPK.get(new NameKey(diskName));
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return null;
    }

    public NameKey get_pKey() {
        return this._pKey;
    }

    public void set_pKey(NameKey _pKey) {
        if (!this._pKey.equals(_pKey)) {
            this._pKey = _pKey;
            this._base.setModified(true);
        }
    }

    public CIMObjectPath get_objPath() {
        return this._objPath;
    }

    public void set_objPath(CIMObjectPath _objPath) {
        this._objPath = _objPath;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ComponentSystem)) {
            return false;
        }
        ComponentSystem p = (ComponentSystem)o;
        if (this._pKey != null && this._pKey.equals(p._pKey)) {
            return true;
        }
        return this._pKey == null && p._pKey == null;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof ComponentSystem)) {
            throw new ClassCastException();
        }
        ComponentSystem p = (ComponentSystem)arg0;
        if (this._pKey != null) {
            return this._pKey.compareTo(p._pKey);
        }
        if (p._pKey != null) {
            return p._pKey.hashCode();
        }
        return 0;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof ComponentSystem)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof ComponentSystem)) {
            throw new ClassCastException();
        }
        ComponentSystem p0 = (ComponentSystem)arg0;
        ComponentSystem p1 = (ComponentSystem)arg1;
        if (p1._pKey != null) {
            return p1._pKey.compareTo(p0._pKey);
        }
        if (p0._pKey != null) {
            return p0._pKey.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        if (this._pKey != null) {
            return this._pKey.hashCode();
        }
        return 0;
    }
}

