/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.smis.client.cim.BlockStorageStatisticalData;
import com.cisco.dcbu.storage.model.StorageStatistics;
import java.util.Date;

public class DiskStatistics
extends StorageStatistics {
    protected long currentPWRSavingLogTimeStamp = -1L;
    protected long kbSeeked = -1L;
    protected long queueArrivals = -1L;
    protected long queueLength = -1L;
    protected long spinningCounter = -1L;
    protected long spinUPS = -1L;
    protected long standbyCounter = -1L;
    protected long readHits = -1L;
    protected long readMisses = -1L;
    protected long writeHits = -1L;
    protected long writeMisses = -1L;

    public DiskStatistics() {
    }

    public DiskStatistics(BlockStorageStatisticalData arryStat) {
        this.instanceID = arryStat.getInstanceID();
        if (arryStat.getStatisticTime() != null) {
            this.statisticTime = this.tryFormat(arryStat.getStatisticTime().getDateTimeString(), "yyyyMMddHHmmss");
        }
        if (arryStat.getElementType() != null) {
            this.elementType = arryStat.getElementType().intValue();
        }
        if (arryStat.getTotalIOs() != null) {
            this.totalIOs = arryStat.getTotalIOs().longValue();
        }
        if (arryStat.getKBytesTransferred() != null) {
            this.kBytesTransferred = arryStat.getKBytesTransferred().longValue();
        }
        if (arryStat.getIOTimeCounter() != null) {
            this.iOTimeCounter = arryStat.getIOTimeCounter().longValue();
        }
        if (arryStat.getReadIOs() != null) {
            this.readIOs = arryStat.getReadIOs().longValue();
        }
        if (arryStat.getKBytesRead() != null) {
            this.kBytesRead = arryStat.getKBytesRead().longValue();
        }
        if (arryStat.getWriteIOs() != null) {
            this.writeIOs = arryStat.getWriteIOs().longValue();
        }
        if (arryStat.getKBytesWritten() != null) {
            this.kBytesWritten = arryStat.getKBytesWritten().longValue();
        }
        if (arryStat.getIdleTimeCounter() != null) {
            this.idleTimeCounter = arryStat.getIdleTimeCounter().longValue();
        }
        this.elementName = arryStat.getElementName();
    }

    public DiskStatistics(String instanceID, Date statisticTime, int elementType, long totalIOs, long bytesTransferred, long timeCounter, long readIOs, long bytesRead, long writeIOs, long bytesWritten, long idleTimeCounter, String elementName, Date startStatisticTime, long currentPWRSavingLogTimeStamp, long seeked, long queueArrivals, long queueLength, long spinningCounter, long spinUPS, long standbyCounter, long readHits, long readMisses, long writeHits, long writeMisses) {
        this.instanceID = instanceID;
        this.elementType = elementType;
        this.totalIOs = totalIOs;
        this.kBytesTransferred = bytesTransferred;
        this.iOTimeCounter = timeCounter;
        this.readIOs = readIOs;
        this.kBytesRead = bytesRead;
        this.writeIOs = writeIOs;
        this.kBytesWritten = bytesWritten;
        this.idleTimeCounter = idleTimeCounter;
        this.elementName = elementName;
        this.currentPWRSavingLogTimeStamp = currentPWRSavingLogTimeStamp;
        this.kbSeeked = seeked;
        this.queueArrivals = queueArrivals;
        this.queueLength = queueLength;
        this.spinningCounter = spinningCounter;
        this.spinUPS = spinUPS;
        this.standbyCounter = standbyCounter;
        this.readHits = readHits;
        this.readMisses = readMisses;
        this.writeHits = writeHits;
        this.writeMisses = writeMisses;
    }

    public DiskStatistics(String instanceID, Date statisticTime, int elementType, long totalIOs, long bytesTransferred, long readIOs, long bytesRead, long writeIOs, long bytesWritten, long idleTimeCounter, String elementName, Date startStatisticTime) {
        this.instanceID = instanceID;
        this.elementType = elementType;
        this.totalIOs = totalIOs;
        this.kBytesTransferred = bytesTransferred;
        this.readIOs = readIOs;
        this.kBytesRead = bytesRead;
        this.writeIOs = writeIOs;
        this.kBytesWritten = bytesWritten;
        this.idleTimeCounter = idleTimeCounter;
        this.elementName = elementName;
    }

    @Override
    public void dump() {
        System.out.println("Disk Statistics for:");
        super.dump();
        System.out.println("currentPWRSavingLogTimeStamp " + this.currentPWRSavingLogTimeStamp);
        System.out.println("kbSeeked " + this.kbSeeked);
        System.out.println("queueArrivals " + this.queueArrivals);
        System.out.println("queueLength " + this.queueLength);
        System.out.println("spinningCounter " + this.spinningCounter);
        System.out.println("spinUPS " + this.spinUPS);
        System.out.println("standbyCounter " + this.standbyCounter);
        System.out.println("readMisses " + this.readMisses);
        System.out.println("writeHits " + this.writeHits);
        System.out.println("writeMisses " + this.writeMisses);
        System.out.println("----------------------------------");
    }

    public long getCurrentPWRSavingLogTimeStamp() {
        return this.currentPWRSavingLogTimeStamp;
    }

    public void setCurrentPWRSavingLogTimeStamp(long currentPWRSavingLogTimeStamp) {
        this.currentPWRSavingLogTimeStamp = currentPWRSavingLogTimeStamp;
    }

    public long getKbSeeked() {
        return this.kbSeeked;
    }

    public void setKbSeeked(long kbSeeked) {
        this.kbSeeked = kbSeeked;
    }

    public long getQueueArrivals() {
        return this.queueArrivals;
    }

    public void setQueueArrivals(long queueArrivals) {
        this.queueArrivals = queueArrivals;
    }

    public long getQueueLength() {
        return this.queueLength;
    }

    public void setQueueLength(long queueLength) {
        this.queueLength = queueLength;
    }

    public long getSpinningCounter() {
        return this.spinningCounter;
    }

    public void setSpinningCounter(long spinningCounter) {
        this.spinningCounter = spinningCounter;
    }

    public long getSpinUPS() {
        return this.spinUPS;
    }

    public void setSpinUPS(long spinUPS) {
        this.spinUPS = spinUPS;
    }

    public long getStandbyCounter() {
        return this.standbyCounter;
    }

    public void setStandbyCounter(long standbyCounter) {
        this.standbyCounter = standbyCounter;
    }

    public long getReadHits() {
        return this.readHits;
    }

    public void setReadHits(long readHits) {
        this.readHits = readHits;
    }

    public long getReadMisses() {
        return this.readMisses;
    }

    public void setReadMisses(long readMisses) {
        this.readMisses = readMisses;
    }

    public long getWriteHits() {
        return this.writeHits;
    }

    public void setWriteHits(long writeHits) {
        this.writeHits = writeHits;
    }

    public long getWriteMisses() {
        return this.writeMisses;
    }

    public void setWriteMisses(long writeMisses) {
        this.writeMisses = writeMisses;
    }
}

