/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Comparator;

public class HostLunMapping
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base = new SMISBaseModelObject();
    private String _hostWwn = "";
    private String _hostName = "";
    private String _readableHost = "";
    private String _targetWwn = "";
    private String _lunId;
    private String _hostLunId;
    private int _lunAccess;
    private boolean _accessPrivGranted = false;
    private String _adapterName;

    public HostLunMapping(String _hostWwn, String _hostName, String _readableHost, String _targetWwn, String _adapterName, String _lunId, String _hostLunId, int _lunAccess, boolean _accessPrivGranted) {
        this();
        this._hostWwn = _hostWwn;
        this._hostName = _hostName;
        this._readableHost = _readableHost;
        this._targetWwn = _targetWwn;
        this._adapterName = _adapterName;
        this._lunId = _lunId;
        this._hostLunId = _hostLunId;
        this._lunAccess = _lunAccess;
        this._accessPrivGranted = _accessPrivGranted;
        this._base.setModified(true);
    }

    public HostLunMapping() {
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Host-Name=").append(this._hostName == null ? "" : this._hostName).append(", Host-pwwn=").append(this._hostWwn == null ? "" : this._hostWwn).append(", Readable-HostName=").append(this._readableHost == null ? "" : this._readableHost).append(", Storage-pwwn=").append(this._targetWwn == null ? "" : this._targetWwn).append(", Adapter-Name=").append(this._adapterName == null ? "" : this._adapterName).append(", LUN-ID=").append(this._lunId == null ? "" : this._lunId).append(", Host-LUN-ID=").append(this._hostLunId == null ? "" : this._hostLunId).append(", LUN-Access=").append(this._lunAccess).append(", Access-Priv-Granted=").append(this._accessPrivGranted);
        return sb.toString();
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public void update(String adapter, int lunAccess, boolean accessPrivGranted) {
        this.set_lunAccess(lunAccess);
        this.set_adapterName(adapter);
        this.set_accessPrivGranted(accessPrivGranted);
        this._base.setPresent(true);
    }

    public String get_hostName() {
        return this._hostName;
    }

    public String get_readableHost() {
        return this._readableHost;
    }

    public void set_readableHost(String _readableHost) {
        this._readableHost = _readableHost;
    }

    public void set_hostName(String _hostName) {
        if (!SMISHelper.equals(this._hostName, _hostName)) {
            this._hostName = _hostName;
            this._base.setModified(true);
        }
    }

    public String get_lunId() {
        return this._lunId;
    }

    public void set_lunId(String _lunId) {
        if (!SMISHelper.equals(this._lunId, _lunId)) {
            this._lunId = _lunId;
            this._base.setModified(true);
        }
    }

    public String get_hostLunId() {
        return this._hostLunId;
    }

    public void set_hostLunId(String _hostLunId) {
        if (!SMISHelper.equals(this._hostLunId, _hostLunId)) {
            this._hostLunId = _hostLunId;
            this._base.setModified(true);
        }
    }

    public static byte[] valueOf(long inm) {
        byte[] b = new byte[]{(byte)(inm >> 56 & 0xFFL), (byte)(inm >> 48 & 0xFFL), (byte)(inm >> 40 & 0xFFL), (byte)(inm >> 32 & 0xFFL), (byte)(inm >> 24 & 0xFFL), (byte)(inm >> 16 & 0xFFL), (byte)(inm >> 8 & 0xFFL), (byte)(inm & 0xFFL)};
        return b;
    }

    public String get_hostWwn() {
        return this._hostWwn;
    }

    public void set_hostWwn(String _hostWwn) {
        if (!SMISHelper.equals(this._hostWwn, _hostWwn)) {
            this._hostWwn = _hostWwn;
            this._base.setModified(true);
        }
    }

    public String get_targetWwn() {
        return this._targetWwn;
    }

    public void set_targetWwn(String _targetWwn) {
        if (!SMISHelper.equals(this._targetWwn, _targetWwn)) {
            this._targetWwn = _targetWwn;
            this._base.setModified(true);
        }
    }

    public int get_lunAccess() {
        return this._lunAccess;
    }

    public void set_lunAccess(int _lunAccess) {
        if (this._lunAccess != _lunAccess) {
            this._lunAccess = _lunAccess;
            this._base.setModified(true);
        }
    }

    public boolean is_accessPrivGranted() {
        return this._accessPrivGranted;
    }

    public void set_accessPrivGranted(boolean _accessPrivGranted) {
        if (this._accessPrivGranted != _accessPrivGranted) {
            this._accessPrivGranted = _accessPrivGranted;
            this._base.setModified(true);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return null;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof HostLunMapping)) {
            throw new ClassCastException();
        }
        HostLunMapping p = (HostLunMapping)arg0;
        if (p != null) {
            if (p.hashCode() > this.hashCode()) {
                return p.hashCode() - this.hashCode();
            }
            return this.hashCode() - p.hashCode();
        }
        return this.hashCode();
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof HostLunMapping)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof HostLunMapping)) {
            throw new ClassCastException();
        }
        HostLunMapping p0 = (HostLunMapping)arg0;
        HostLunMapping p1 = (HostLunMapping)arg1;
        if (p0 != null) {
            if (p0.hashCode() > p1.hashCode()) {
                return p0.hashCode() - p1.hashCode();
            }
            return this.hashCode() - p1.hashCode();
        }
        return p1.hashCode();
    }

    public int hashCode() {
        String[] strings = new String[]{this._hostWwn, this._targetWwn, this._hostName, this._lunId};
        int prime = 31;
        int result = 1;
        for (String s : strings) {
            result = result * 31 + s.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof HostLunMapping) {
            HostLunMapping obj = (HostLunMapping)o;
            if (obj._hostWwn != null && obj._hostWwn.equals(this._hostWwn) && obj._targetWwn != null && obj._targetWwn.equals(this._targetWwn) && obj._hostName.equals(this._hostName) && obj._lunId.equals(this._lunId)) {
                return true;
            }
        }
        return false;
    }

    public String get_adapterName() {
        return this._adapterName;
    }

    public void set_adapterName(String _adapterName) {
        if (!SMISHelper.equals(this._adapterName, _adapterName)) {
            this._adapterName = _adapterName;
            this._base.setModified(true);
        }
    }

    public String toString() {
        return "HostLunMapping [_hostWwn=" + this._hostWwn + ", _targetWwn=" + this._targetWwn + ", _lunId=" + this._lunId + ", _hostLunId=" + this._hostLunId + "]";
    }
}

