/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.common.type.LunPK;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.MappingUtility;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.model.HostLunMapping;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import javax.cim.CIMObjectPath;

public class Lun
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base = new SMISBaseModelObject();
    private LunPK _pKey;
    private String _wwn = "";
    private String _storagePoolName = "";
    private long _totalManagedSpace;
    private long _remainingManagedSpace;
    private long _consumedCapacity;
    private long[] _status;
    private String _raidType = "";
    private ArrayList<String> _diskType;
    private String _currentOwner = "";
    private String _defaultOwner = "";
    private CIMObjectPath _objPath = null;
    private ConcurrentHashMap<String, ArrayList<HostLunMapping>> _hostLunMappingByHostWwm;

    public Lun() {
    }

    public Lun(String _lunName, String _lunId, String _wwn, String _storagePoolName, long _totalManagedSpace, long _remainingManagedSpace, long _consumedCapacity, long[] _status, String _raidType, String[] _diskType, String _currentOwner, String _defaultOwner) {
        this();
        this._pKey = new LunPK(_lunId, _lunName);
        this._wwn = _wwn;
        this._storagePoolName = _storagePoolName;
        this._totalManagedSpace = _totalManagedSpace;
        this._remainingManagedSpace = _remainingManagedSpace;
        this._consumedCapacity = _consumedCapacity;
        this._status = _status;
        this._raidType = _raidType;
        this._diskType = _diskType != null ? new ArrayList<String>(Arrays.asList(_diskType)) : new ArrayList();
        this._currentOwner = _currentOwner;
        this._defaultOwner = _defaultOwner;
        this._hostLunMappingByHostWwm = new ConcurrentHashMap();
        this._base.setModified(true);
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(StorageImpl.LIL[level]).append("Lun-Name=").append(this._pKey.get_lunName() == null ? "" : this._pKey.get_lunName()).append(", LUN-Id=").append(this._pKey.get_lunId() == null ? "" : this._pKey.get_lunId()).append(", Strg-Pool-Name=").append(this._storagePoolName == null ? "" : this._storagePoolName).append(", UID=").append(this._wwn == null ? "" : this._wwn).append(", Disk-Type=").append(Arrays.toString(this._diskType.toArray())).append(", User-Capacity=").append(this.mapCapacity(this._totalManagedSpace) == null ? "" : this.mapCapacity(this._totalManagedSpace)).append(", Avail-Capacity=").append(this.mapCapacity(this._remainingManagedSpace) == null ? "" : this.mapCapacity(this._remainingManagedSpace)).append(", Comsumed-Capacity=").append(this.mapCapacity(this._consumedCapacity) == null ? "" : this.mapCapacity(this._consumedCapacity)).append(", Status=").append(Arrays.toString(this._status)).append(", Raid_type=").append(this._raidType == null ? "" : this._raidType).append(", Curr-owner=").append(this._currentOwner == null ? "" : this._currentOwner).append(", Default-owner=").append(this._defaultOwner == null ? "" : this._defaultOwner).append("\n").append(this.dumpHostLunMap(level + 1));
        return sb.toString();
    }

    public String dumpHostLunMap(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Host LUN Map: ").append(this._hostLunMappingByHostWwm.size());
        for (ArrayList<HostLunMapping> hostlunmaps : this._hostLunMappingByHostWwm.values()) {
            for (HostLunMapping hostlunmap : hostlunmaps) {
                sb.append(hostlunmap.dump(level));
            }
        }
        return sb.toString();
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public void update(String _wwn, String _storagePoolName, long _totalManagedSpace, long _remainingManagedSpace, long _consumedCapacity, long[] _status, String _raidType, String[] _diskType, String _currentOwner, String _defaultOwner) {
        this.set_wwn(_wwn);
        this.set_storagePoolName(_storagePoolName);
        this.set_totalManagedSpace(_totalManagedSpace);
        this.set_remainingManagedSpace(_remainingManagedSpace);
        this.set_consumedCapacity(_consumedCapacity);
        this.set_status(_status);
        this.set_raidType(_raidType);
        this.set_diskType(_diskType);
        this.set_currentOwner(_currentOwner);
        this.set_defaultOwner(_defaultOwner);
        this._base.setPresent(true);
    }

    public String get_wwn() {
        return this._wwn;
    }

    public void set_wwn(String _wwn) {
        if (!SMISHelper.equals(this._wwn, _wwn)) {
            this._wwn = _wwn;
            this._base.setModified(true);
        }
    }

    public String get_storagePoolName() {
        return this._storagePoolName;
    }

    public void set_storagePoolName(String _storagePoolName) {
        if (!SMISHelper.equals(this._storagePoolName, _storagePoolName)) {
            this._storagePoolName = _storagePoolName;
            this._base.setModified(true);
        }
    }

    public long get_consumedCapacity() {
        return this._consumedCapacity;
    }

    public void set_consumedCapacity(long _consumedCapacity) {
        if (this._consumedCapacity != _consumedCapacity) {
            this._consumedCapacity = _consumedCapacity;
            this._base.setModified(true);
        }
    }

    public String get_currentOwner() {
        return this._currentOwner;
    }

    public void set_currentOwner(String _currentOwner) {
        if (!SMISHelper.equals(this._currentOwner, _currentOwner)) {
            this._currentOwner = _currentOwner;
            this._base.setModified(true);
        }
    }

    public String get_defaultOwner() {
        return this._defaultOwner;
    }

    public void set_defaultOwner(String _defaultOwner) {
        if (!SMISHelper.equals(this._defaultOwner, _defaultOwner)) {
            this._defaultOwner = _defaultOwner;
            this._base.setModified(true);
        }
    }

    public long get_totalManagedSpace() {
        return this._totalManagedSpace;
    }

    public void set_totalManagedSpace(long _totalManagedSpace) {
        if (this._totalManagedSpace != _totalManagedSpace) {
            this._totalManagedSpace = _totalManagedSpace;
            this._base.setModified(true);
        }
    }

    public long get_remainingManagedSpace() {
        return this._remainingManagedSpace;
    }

    public void set_remainingManagedSpace(long _remainingManagedSpace) {
        if (this._remainingManagedSpace != _remainingManagedSpace) {
            this._remainingManagedSpace = _remainingManagedSpace;
            this._base.setModified(true);
        }
    }

    public long[] get_status() {
        return this._status;
    }

    public void set_status(long[] _status) {
        if (!Arrays.equals(this._status, _status)) {
            this._status = _status;
            this._base.setModified(true);
        }
    }

    public String getStatusAsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (long status : this._status) {
            String str = MappingUtility.getStatusMapping((int)status, true);
            if (str.length() == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public String get_raidType() {
        return this._raidType;
    }

    public void set_raidType(String _raidType) {
        if (!SMISHelper.equals(this._raidType, _raidType)) {
            this._raidType = _raidType;
            this._base.setModified(true);
        }
    }

    public String[] get_diskType() {
        return this._diskType.toArray(new String[0]);
    }

    public void set_diskType(String[] _diskType) {
        if (_diskType != null && !Arrays.equals(this._diskType.toArray(new String[0]), _diskType)) {
            this._diskType = new ArrayList<String>(Arrays.asList(_diskType));
            this._base.setModified(true);
        }
    }

    public void set_diskType(String _diskType) {
        for (String dt : this._diskType) {
            if (!dt.equalsIgnoreCase(_diskType)) continue;
            return;
        }
        this._diskType.add(_diskType);
        this._base.setModified(true);
    }

    public String getDiskTypeAsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (this._diskType != null) {
            for (String distType : this._diskType) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(distType);
            }
        }
        return sb.toString();
    }

    public Collection<HostLunMapping> get_hostLunMaps() {
        ArrayList<HostLunMapping> maps = new ArrayList<HostLunMapping>();
        for (ArrayList<HostLunMapping> hostmaps : this._hostLunMappingByHostWwm.values()) {
            maps.addAll(hostmaps);
        }
        return maps;
    }

    public void add_hostLunMap(HostLunMapping _hostLunMap) {
        ArrayList<HostLunMapping> maps = this.get_hostLunMap(_hostLunMap.get_hostWwn());
        if (maps == null) {
            maps = new ArrayList();
            this._hostLunMappingByHostWwm.put(_hostLunMap.get_hostWwn(), maps);
        }
        if (!maps.contains(_hostLunMap)) {
            maps.add(_hostLunMap);
            this._base.setModified(true);
        } else {
            int index = maps.indexOf(_hostLunMap);
            HostLunMapping oldHLM = maps.get(index);
            oldHLM.update(_hostLunMap.get_adapterName(), _hostLunMap.get_lunAccess(), _hostLunMap.is_accessPrivGranted());
        }
    }

    public ArrayList<HostLunMapping> get_hostLunMap(String wwn) {
        return this._hostLunMappingByHostWwm.get(wwn);
    }

    public static byte[] valueOf(long inm) {
        byte[] b = new byte[]{(byte)(inm >> 56 & 0xFFL), (byte)(inm >> 48 & 0xFFL), (byte)(inm >> 40 & 0xFFL), (byte)(inm >> 32 & 0xFFL), (byte)(inm >> 24 & 0xFFL), (byte)(inm >> 16 & 0xFFL), (byte)(inm >> 8 & 0xFFL), (byte)(inm & 0xFFL)};
        return b;
    }

    private String mapCapacity(long bytes) {
        if (bytes < 0L) {
            return "N/A";
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        long kbytes = bytes / 1024L;
        if (kbytes < 1024L) {
            return kbytes + " KB";
        }
        long mbytes = kbytes / 1024L;
        if (mbytes < 1024L) {
            return mbytes + " MB";
        }
        long gbytes = mbytes / 1024L;
        return gbytes + " GB";
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return "SMIS_STORAGE_LUN";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Lun)) {
            return false;
        }
        Lun p = (Lun)o;
        if (this._pKey != null && this._pKey.equals(p._pKey)) {
            return true;
        }
        return this._pKey == null && p._pKey == null;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof Lun)) {
            throw new ClassCastException();
        }
        Lun p = (Lun)arg0;
        if (this._pKey != null) {
            return this._pKey.compareTo(p._pKey);
        }
        if (p._pKey != null) {
            return p._pKey.hashCode();
        }
        return 0;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof Lun)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof Lun)) {
            throw new ClassCastException();
        }
        Lun p0 = (Lun)arg0;
        Lun p1 = (Lun)arg1;
        if (p1._pKey != null) {
            return p1._pKey.compareTo(p0._pKey);
        }
        if (p0._pKey != null) {
            return p0._pKey.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        if (this._pKey != null) {
            return this._pKey.hashCode();
        }
        return 0;
    }

    public LunPK get_pKey() {
        return this._pKey;
    }

    public void set_pKey(LunPK _pKey) {
        if (!SMISHelper.equals(this._pKey, _pKey)) {
            this._pKey = _pKey;
            this._base.setModified(true);
        }
    }

    public CIMObjectPath get_objPath() {
        return this._objPath;
    }

    public void set_objPath(CIMObjectPath _objPath) {
        this._objPath = _objPath;
    }

    public String toString() {
        return "Lun [_pKey=" + this._pKey + "]";
    }
}

