/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.MappingUtility;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.cim.CIMObjectPath;

public class Pool
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base = new SMISBaseModelObject();
    private NameKey _pKey;
    private long _rawCapacity;
    private long _totalManagedSpace;
    private long _remainingManagedSpace;
    private long _remainingRawCapacity;
    private long _subscribedCapacity;
    private int _percentSubscribed;
    private long[] _status;
    private String _raidType = "";
    private ArrayList<String> _diskType;
    private CIMObjectPath _objPath = null;

    public Pool() {
    }

    public Pool(String _poolName, long _rawCapacity, long _totalManagedSpace, long _remainingManagedSpace, long _remainingRawCapacity, long _subscribedCapacity, int _percentSubscribed, long[] _status, String _raidType, String[] _diskType) {
        this();
        this._pKey = new NameKey(_poolName);
        this._rawCapacity = _rawCapacity;
        this._totalManagedSpace = _totalManagedSpace;
        this._remainingManagedSpace = _remainingManagedSpace;
        this._remainingRawCapacity = _remainingRawCapacity;
        this._subscribedCapacity = _subscribedCapacity;
        this._percentSubscribed = _percentSubscribed;
        this._status = _status;
        this._raidType = _raidType;
        this._diskType = _diskType != null ? new ArrayList<String>(Arrays.asList(_diskType)) : new ArrayList();
        this._base.setModified(true);
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Pool/Aggrr-Name=").append(this._pKey._name == null ? "" : this._pKey._name).append(", Raw-Capacity=").append(this._rawCapacity).append(", User-Capacity=").append(this._totalManagedSpace).append(", Free-Capacity=").append(this._remainingManagedSpace).append(", Free-Raw_Capacity=").append(this._remainingRawCapacity).append(", Sub-Capacity=").append(this._subscribedCapacity).append(", Percent-Sub=").append(this._percentSubscribed).append(", Raid-Type=").append(this._raidType == null ? "" : this._raidType).append(", Disk-Type=").append(Arrays.toString(this._diskType.toArray())).append(", Status=").append(Arrays.toString(this._status));
        return sb.toString();
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public void update(long rawCapacity, long totalManagedSpace, long remainingManagedSpace, long remainingRawCapacity, long subscribedCapacity, int percentSubscribed, long[] status, String raidType, String[] diskType) {
        this.set_rawCapacity(rawCapacity);
        this.set_totalManagedSpace(totalManagedSpace);
        this.set_remainingManagedSpace(remainingManagedSpace);
        this.set_remainingRawCapacity(remainingRawCapacity);
        this.set_subscribedCapacity(subscribedCapacity);
        this.set_percentSubscribed(percentSubscribed);
        this.set_status(status);
        this.set_raidType(raidType);
        this.set_diskType(diskType);
        this._base.setPresent(true);
    }

    public long get_remainingRawCapacity() {
        return this._remainingRawCapacity;
    }

    public void set_remainingRawCapacity(long _remainingRawCapacity) {
        if (this._remainingRawCapacity != _remainingRawCapacity) {
            this._remainingRawCapacity = _remainingRawCapacity;
            this._base.setModified(true);
        }
    }

    public long get_rawCapacity() {
        return this._rawCapacity;
    }

    public void set_rawCapacity(long _rawCapacity) {
        if (this._rawCapacity != _rawCapacity) {
            this._rawCapacity = _rawCapacity;
            this._base.setModified(true);
        }
    }

    public long get_totalManagedSpace() {
        return this._totalManagedSpace;
    }

    public void set_totalManagedSpace(long _totalManagedSpace) {
        if (this._totalManagedSpace != _totalManagedSpace) {
            this._totalManagedSpace = _totalManagedSpace;
            this._base.setModified(true);
        }
    }

    public long get_remainingManagedSpace() {
        return this._remainingManagedSpace;
    }

    public void set_remainingManagedSpace(long _remainingManagedSpace) {
        if (this._remainingManagedSpace != _remainingManagedSpace) {
            this._remainingManagedSpace = _remainingManagedSpace;
            this._base.setModified(true);
        }
    }

    public long get_subscribedCapacity() {
        return this._subscribedCapacity;
    }

    public void set_subscribedCapacity(long _subscribedCapacity) {
        if (this._subscribedCapacity != _subscribedCapacity) {
            this._subscribedCapacity = _subscribedCapacity;
            this._base.setModified(true);
        }
    }

    public int get_percentSubscribed() {
        return this._percentSubscribed;
    }

    public void set_percentSubscribed(int _percentSubscribed) {
        if (this._percentSubscribed != _percentSubscribed) {
            this._percentSubscribed = _percentSubscribed;
            this._base.setModified(true);
        }
    }

    public long[] get_status() {
        return this._status;
    }

    public void set_status(long[] _status) {
        if (!Arrays.equals(this._status, _status)) {
            this._status = _status;
            this._base.setModified(true);
        }
    }

    public String getStatusAsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (long status : this._status) {
            String str = MappingUtility.getStatusMapping((int)status, false);
            if (str.length() == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public String[] get_diskType() {
        return this._diskType.toArray(new String[0]);
    }

    public void set_diskType(String[] _diskType) {
        if (_diskType != null && !Arrays.equals(this._diskType.toArray(new String[0]), _diskType)) {
            this._diskType = new ArrayList<String>(Arrays.asList(_diskType));
            this._base.setModified(true);
        }
    }

    public void add_diskType(String _diskType) {
        for (String dt : this._diskType) {
            if (!dt.equalsIgnoreCase(_diskType)) continue;
            return;
        }
        this._diskType.add(_diskType);
        this._base.setModified(true);
    }

    public String getDiskTypeAsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String distType : this._diskType) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(distType);
        }
        return sb.toString();
    }

    public String get_raidType() {
        return this._raidType;
    }

    public void set_raidType(String _raidType) {
        if (!SMISHelper.equals(this._raidType, _raidType)) {
            this._raidType = _raidType;
            this._base.setModified(true);
        }
    }

    public static byte[] valueOf(long inm) {
        byte[] b = new byte[]{(byte)(inm >> 56 & 0xFFL), (byte)(inm >> 48 & 0xFFL), (byte)(inm >> 40 & 0xFFL), (byte)(inm >> 32 & 0xFFL), (byte)(inm >> 24 & 0xFFL), (byte)(inm >> 16 & 0xFFL), (byte)(inm >> 8 & 0xFFL), (byte)(inm & 0xFFL)};
        return b;
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Pool)) {
            return false;
        }
        Pool p = (Pool)o;
        if (this._pKey != null && this._pKey.equals(p._pKey)) {
            return true;
        }
        return this._pKey == null && p._pKey == null;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof Pool)) {
            throw new ClassCastException();
        }
        Pool p = (Pool)arg0;
        if (this._pKey != null) {
            return this._pKey.compareTo(p._pKey);
        }
        if (p._pKey != null) {
            return p._pKey.hashCode();
        }
        return 0;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof Pool)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof Pool)) {
            throw new ClassCastException();
        }
        Pool p0 = (Pool)arg0;
        Pool p1 = (Pool)arg1;
        if (p1._pKey != null) {
            return p1._pKey.compareTo(p0._pKey);
        }
        if (p0._pKey != null) {
            return p0._pKey.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        if (this._pKey != null) {
            return this._pKey.hashCode();
        }
        return 0;
    }

    public NameKey get_pKey() {
        return this._pKey;
    }

    public void set_pKey(NameKey _pKey) {
        if (!SMISHelper.equals(this._pKey, _pKey)) {
            this._pKey = _pKey;
            this._base.setModified(true);
        }
    }

    public CIMObjectPath get_objPath() {
        return this._objPath;
    }

    public void set_objPath(CIMObjectPath _objPath) {
        this._objPath = _objPath;
    }

    public String toString() {
        return "Pool [_pKey=" + this._pKey + "]";
    }
}

