/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCounter;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpNsap;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOpaque;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.Sort;
import com.cisco.dcbu.lib.util.SortIf;
import com.cisco.dcbu.tools.OidRegisterIf;
import com.cisco.dcbu.tools.SnmpWalk;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class Agent
extends Thread {
    private static final int MAX_VBL = 270;
    public static final int NOT_FOUND = -1;
    private static final int INITIAL_LEN = 1000;
    private static final int BUF_SIZE = 8000;
    private static final int[] PREFIX = new int[]{1, 3, 6, 1};
    private static final int[] SYS_UP_TIME = new int[]{1, 3, 6, 1, 2, 1, 1, 3, 0};
    public static final long START_TIME = System.currentTimeMillis();
    public static int _RandomLoss;
    public static int _RandomDelay;
    public static boolean _Trace;
    private static boolean _NeedSort;
    private static String _RegClassName;
    private static int _Timeout;
    private Array _oidRegister;
    private Array _oidRegisterParty;
    private int _lineNo;
    Array _keys;
    Array _values;
    private String _read;
    private String _write;
    public DatagramSocket _sock;
    private DatagramPacket _response;
    private byte[] _inBuf = new byte[8000];
    private SnmpOutputStream _outBuf = new SnmpOutputStream(8000);
    private int _reqId;
    private boolean _continue = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.err.println("usage: [-trace] [-port <port>] [-loss <0..100%>] [-delay <msecs>] [-reg <regClass>] [-sort] [-rd <cmty>] [-wr <cmty] [-mib <file>] [-timeout <msecs>] [-mibwalk peer] [-reg <class>] {[<dataFile>] | [-map <file>]}");
            System.exit(1);
        }
        int port = 161;
        String rdCmty = "public";
        String wrCmty = "public";
        try {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].charAt(0) == '-') {
                    if (argv[i].equals("-map")) {
                        Agent.startAgents(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-trace")) {
                        _Trace = true;
                        continue;
                    }
                    if (argv[i].equals("-port")) {
                        port = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-loss")) {
                        _RandomLoss = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-delay")) {
                        _RandomDelay = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (argv[i].equals("-mib")) {
                        String mib = argv[++i];
                        DataInputStream is = new DataInputStream(new BufferedInputStream(Agent.class.getResourceAsStream(mib)));
                        MibNode.load(is);
                        is.close();
                        continue;
                    }
                    if (argv[i].equals("-reg")) {
                        _RegClassName = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-sort")) {
                        _NeedSort = true;
                        continue;
                    }
                    if (argv[i].equals("-rd")) {
                        rdCmty = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-wr")) {
                        wrCmty = argv[++i];
                        continue;
                    }
                    if (argv[i].equals("-timeout")) {
                        _Timeout = Integer.parseInt(argv[++i]);
                        continue;
                    }
                    if (!argv[i].equals("-mibwalk")) continue;
                    String peer = argv[++i];
                    SnmpWalk.walk(peer, port, peer + ".otv", rdCmty, _Timeout, 1);
                    System.exit(0);
                    continue;
                }
                new Agent(InetAddress.getLocalHost().getHostAddress(), port, argv[i], rdCmty, wrCmty);
                if (_RegClassName != null) continue;
                MibNode.clear();
                System.gc();
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            String string = argv[0];
            synchronized (string) {
                try {
                    argv[0].wait(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void startAgents(String mapFile) throws Exception {
        Array data = Agent.parseMapFile(mapFile);
        for (int i = 0; i < data.size(); ++i) {
            String[] param = (String[])data.elementAt(i);
            new Agent(param[0], Integer.parseInt(param[1]), param[2], param[3], param[4]);
        }
    }

    static Array parseMapFile(String mapFile) throws IOException {
        String tempBuff;
        Array<String[]> data = new Array<String[]>();
        BufferedReader is = new BufferedReader(new FileReader(mapFile));
        int _lineNo = 0;
        int _cntComment = 0;
        int _cntNotDiscovered = 0;
        System.out.println("Parsing entries of " + mapFile + "file");
        System.out.println("Ignoring blank lines and comments...");
        while ((tempBuff = is.readLine()) != null) {
            String mainBuff = tempBuff.trim();
            ++_lineNo;
            if (mainBuff.equals("") || mainBuff.charAt(0) == '#') {
                ++_cntComment;
                continue;
            }
            if (mainBuff.split(" ").length != 5) {
                ++_cntNotDiscovered;
                System.out.println("Warning: Ignoring Entry at Line " + _lineNo + ",Entry is not in the required format ");
                continue;
            }
            String[] row = new String[5];
            int p1 = 0;
            int p2 = 0;
            for (int i = 0; i < 4; ++i) {
                p2 = mainBuff.indexOf(32, p1);
                row[i] = mainBuff.substring(p1, p2);
                p1 = p2 + 1;
            }
            row[4] = mainBuff.substring(p1);
            data.addElement(row);
        }
        if (_cntNotDiscovered == 0) {
            System.out.println("End of parsing: all entries are in the required format");
        } else {
            System.out.println("End of parsing:" + _cntNotDiscovered + " entries which are not in the required format \n<IpAddress> <PortNumber> <OTVfilename> <readComm> <writeComm> are ignored");
        }
        is.close();
        return data;
    }

    public void oidRegister(int[] oid, OidRegisterIf party) {
        if (this._oidRegister == null) {
            this._oidRegister = new Array();
            this._oidRegisterParty = new Array();
        }
        this._oidRegister.addElement(oid);
        this._oidRegisterParty.addElement(party);
    }

    public Agent(String host, int port, String otvFile, String read, String write) {
        try {
            this.readFile(otvFile);
            this._sock = new DatagramSocket(port, InetAddress.getByName(host));
            this.start();
            this.setName(host);
            this._read = read;
            this._write = write;
            if (_RegClassName != null) {
                ((OidRegisterIf)Class.forName(_RegClassName).newInstance()).init(this);
            }
            System.out.println(otvFile + " listening on " + host + ":" + port);
        }
        catch (Exception ex) {
            System.err.println(host + ": " + ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        DatagramPacket packet = new DatagramPacket(this._inBuf, this._inBuf.length);
        this._response = new DatagramPacket(this._outBuf._buf, 0, 0);
        SnmpInputStream in = new SnmpInputStream(this._inBuf);
        SnmpPDU pdu = new SnmpPDU(new VarBindList());
        while (this._continue) {
            pdu.getVariables().clear();
            packet.setLength(this._inBuf.length);
            try {
                this._sock.receive(packet);
                pdu.setPort(packet.getPort());
                pdu.setAddress(packet.getAddress());
                in.setMax(packet.getLength());
                pdu.decode(in);
                if (pdu.getVersion() != 3 && (pdu.getCommand() != -93 ? !pdu.getCommunity().equals(this._read) : !pdu.getCommunity().equals(this._write))) continue;
                if (_RandomDelay > 0) {
                    Agent.sleep((int)(Math.random() * (double)_RandomDelay));
                }
                this.respond(pdu);
            }
            catch (SnmpException ex) {
                System.err.println("bad packet from " + packet.getAddress() + ", " + packet.getPort() + ": " + ex.getMessage());
            }
            catch (Exception ex) {
                System.err.println("receiver: " + ex);
            }
        }
    }

    void terminate() {
        this._continue = false;
        if (this._sock != null) {
            this._sock.close();
            this._sock = null;
        }
        this._values = null;
        this._keys = null;
    }

    private void respond(SnmpPDU pdu) throws SnmpException {
        if (_Trace) {
            System.out.println(pdu);
        }
        block0 : switch (pdu.getCommand()) {
            case -96: {
                int s = pdu.getVariables().size();
                for (int i = 0; i < s; ++i) {
                    SnmpVarBind vb = pdu.getVariables().getVb(i);
                    int k = this.findKey(vb.getOid().getValue());
                    if (k == -1) {
                        vb.setVar(new SnmpNull(-127));
                        continue;
                    }
                    vb.setVar(this.getValue(k));
                }
                break;
            }
            case -95: {
                int s = pdu.getVariables().size();
                for (int i = 0; i < s; ++i) {
                    SnmpVarBind vb = pdu.getVariables().getVb(i);
                    int k = this.findNextKey(vb.getOid().getValue());
                    if (k < this._keys.size()) {
                        vb = new SnmpVarBind(new SnmpOID(PREFIX, (int[])this._keys.elementAt(k)), this.getValue(k));
                        pdu.getVariables().set(i, vb);
                        continue;
                    }
                    vb.setVar(new SnmpNull(-126));
                }
                break;
            }
            case -91: {
                int size = pdu.getVariables().size() - pdu.getNonRptr();
                VarBindList vbl = new VarBindList(size * pdu.getMaxRptr() + pdu.getNonRptr());
                for (int i = 0; i < pdu.getNonRptr(); ++i) {
                    SnmpOID var = pdu.getVariables().getVb(i).getOid();
                    int k = this.findNextKey(var.getValue());
                    if (k < this._values.size()) {
                        vbl.set(i, new SnmpVarBind(new SnmpOID(PREFIX, (int[])this._keys.elementAt(k)), this.getValue(k)));
                        continue;
                    }
                    vbl.set(i, new SnmpVarBind(var, new SnmpNull(21)));
                }
                int maxRptr = pdu.getMaxRptr();
                if (maxRptr > 270) {
                    maxRptr = 270;
                }
                int vblSize = size + pdu.getNonRptr();
                for (int i = pdu.getNonRptr(); i < vblSize; ++i) {
                    SnmpOID var = pdu.getVariables().getVb(i).getOid();
                    int k = this.findNextKey(var.getValue());
                    int max = k + maxRptr;
                    int j = 0;
                    while (k < max) {
                        int vblIndex = j * size + i;
                        if (k < this._values.size()) {
                            vbl.set(vblIndex, new SnmpVarBind(new SnmpOID(PREFIX, (int[])this._keys.elementAt(k)), this.getValue(k)));
                        } else {
                            vbl.set(vblIndex, new SnmpVarBind(var, new SnmpNull(2)));
                        }
                        ++k;
                        ++j;
                    }
                }
                pdu.setMaxRptr(0);
                pdu.setNonRptr(0);
                pdu.setVariables(vbl);
                break;
            }
            case -93: {
                int[] regOid;
                int j;
                SnmpVarBind vb;
                int i;
                int s;
                if (this._oidRegister != null) {
                    s = pdu.getVariables().size();
                    block11: for (i = 0; i < s; ++i) {
                        vb = pdu.getVariables().getVb(i);
                        for (j = 0; j < this._oidRegister.size(); ++j) {
                            regOid = (int[])this._oidRegister.elementAt(j);
                            if (!vb.getOid().startsWith(regOid)) continue;
                            ((OidRegisterIf)this._oidRegisterParty.elementAt(j)).oidRegisterCallback(this, pdu.getVariables(), i, pdu.getAddress());
                            continue block11;
                        }
                    }
                }
                s = pdu.getVariables().size();
                for (i = 0; i < s; ++i) {
                    vb = pdu.getVariables().getVb(i);
                    if (this._oidRegister != null) {
                        for (j = 0; j < this._oidRegister.size(); ++j) {
                            regOid = (int[])this._oidRegister.elementAt(j);
                            if (vb.getOid().startsWith(regOid)) break;
                        }
                    }
                    pdu.setError(this.processSetReq(vb));
                    if (pdu.getError() == 0) continue;
                    pdu.setErrorIndex(i + 1);
                    break block0;
                }
                break;
            }
            default: {
                throw new SnmpException("Unsupported command: " + pdu.getCommand());
            }
        }
        if (_RandomLoss > 0 && Math.random() * 100.0 <= (double)_RandomLoss) {
            if (_Trace) {
                System.out.println("random loss: " + pdu);
            }
            return;
        }
        pdu.setCommand((byte)-94);
        this.reply(pdu);
        if (_Trace) {
            System.out.println(pdu);
        }
    }

    private void reply(SnmpPDU pdu) throws SnmpException {
        this._outBuf.reset();
        try {
            pdu.encode(this._outBuf);
            this._response.setAddress(pdu.getAddress());
            this._response.setPort(pdu.getPort());
            this._response.setLength(this._outBuf._pos);
            this._sock.send(this._response);
        }
        catch (IOException ex) {
            throw new SnmpException("send PDU: " + ex.getMessage());
        }
    }

    private int processSetReq(SnmpVarBind vb) {
        int result;
        int[] oid = vb.getOid().getValue();
        int hi = this._keys.size();
        int lo = 0;
        int mid = (hi - lo) / 2 + lo;
        while (hi > lo && (result = Agent.equals((int[])this._keys.elementAt(mid), oid)) != 0) {
            if (result < 0) {
                hi = mid;
            } else {
                lo = mid + 1;
            }
            mid = (hi - lo) / 2 + lo;
        }
        if (hi <= lo) {
            int[] key = new int[oid.length - 4];
            System.arraycopy(oid, 4, key, 0, key.length);
            this._keys.insertElementAt(key, mid);
            this._values.insertElementAt(vb.getVar(), mid);
        } else if (vb.getVar().getClass() == this._values.elementAt(mid).getClass()) {
            this._values.setElementAt(vb.getVar(), mid);
        } else {
            vb.setVar(new SnmpNull(7));
            return 7;
        }
        return 0;
    }

    public void sendTrap(InetAddress address, VarBindList vbl) {
        SnmpVarBind time = new SnmpVarBind(new SnmpOID(SYS_UP_TIME), new SnmpTimeticks((System.currentTimeMillis() - START_TIME) / 10L));
        vbl.add(0, time);
        this.sendPDU((byte)-89, address, vbl, "public", 162);
    }

    private void sendPDU(byte op, InetAddress address, VarBindList vbl, String community, int port) {
        try {
            this._outBuf.reset();
            SnmpPDU pdu = new SnmpPDU(op);
            pdu.setVersion(1);
            pdu.setReqid(++this._reqId);
            pdu.setAddress(address);
            pdu.setCommunity(community);
            pdu.setVariables(vbl);
            if (_Trace) {
                System.out.println(pdu);
            }
            pdu.encode(this._outBuf);
            this._sock.send(new DatagramPacket(this._outBuf._buf, this._outBuf._pos, address, port));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex);
        }
    }

    private void readFile(String inFile) throws FileNotFoundException, IOException, NumberFormatException, SnmpException {
        String buf;
        BufferedReader is = new BufferedReader(new FileReader(inFile));
        this._keys = new Array(1000);
        this._values = new Array(1000);
        MibNode node = null;
        String lastMibDescr = null;
        while ((buf = is.readLine()) != null) {
            ++this._lineNo;
            if (buf.trim().equals("") || buf.charAt(0) == '#') continue;
            if (!Agent.checkOtvFileFormat(buf)) {
                System.err.println("Warning: At " + inFile + ", line " + this._lineNo + " : Not in <ObjectID Type Value> format. Ignoring line!!");
                continue;
            }
            try {
                int pos = buf.indexOf(32);
                if (Character.isDigit(buf.charAt(0))) {
                    this._keys.addElement(SnmpOID.stringToOid(buf.substring(8, pos)));
                } else {
                    if (Character.isUpperCase(buf.charAt(0))) continue;
                    int indexOffset = buf.indexOf(46);
                    String mibDescr = buf.substring(0, indexOffset);
                    if (lastMibDescr == null || !mibDescr.equals(lastMibDescr)) {
                        node = MibNode.get(mibDescr);
                        if (node == null) continue;
                        lastMibDescr = mibDescr;
                    }
                    int[] varOid = SnmpOID.stringToOid(buf.substring(indexOffset + 1, pos));
                    int nodeLen = node.getOid().length - PREFIX.length;
                    int[] oid = new int[nodeLen + varOid.length];
                    System.arraycopy(node.getOid(), PREFIX.length, oid, 0, nodeLen);
                    System.arraycopy(varOid, 0, oid, nodeLen, varOid.length);
                    this._keys.addElement(oid);
                }
                int pos1 = buf.indexOf(32, ++pos);
                int type = Integer.parseInt(pos1 < 0 ? buf.substring(pos) : buf.substring(pos, pos1));
                SnmpVar v = this.buildVar(type, ++pos1 >= buf.length() ? null : buf.substring(pos1));
                if (v.getType() == 4) {
                    ((SnmpString)v)._value = null;
                }
                this._values.addElement(v);
            }
            catch (Exception ex) {
                System.err.println("error at " + inFile + ", line " + this._lineNo + ": " + ex);
            }
        }
        is.close();
        this._lineNo = 0;
        if (_NeedSort) {
            Sort.quickSort(new OidSortModel(), 0, this._keys.size() - 1);
        }
    }

    private static boolean checkOtvFileFormat(String file_entry) {
        char[] digit = file_entry.toCharArray();
        int nbSpaces = 0;
        for (int i = 0; i < digit.length; ++i) {
            if (digit[i] != ' ') continue;
            ++nbSpaces;
        }
        return nbSpaces >= 2;
    }

    public void insertRow(int[][] oids, SnmpVar[] values) {
        for (int i = 0; i < oids.length; ++i) {
            int pos = this.findNextKey(oids[i]);
            int[] oid = new int[oids[i].length - PREFIX.length];
            System.arraycopy(oids[i], PREFIX.length, oid, 0, oid.length);
            this._keys.insertElementAt(oid, pos);
            this._values.insertElementAt(values[i], pos);
            if (!_Trace) continue;
            System.out.println("Adding " + SnmpOID.toString(oid) + "=" + values[i]);
        }
    }

    public boolean deleteRow(int[][] oids) {
        for (int i = 0; i < oids.length; ++i) {
            int pos = this.findKey(oids[i]);
            if (pos == -1) continue;
            this._keys.removeElementAt(pos);
            this._values.removeElementAt(pos);
            return true;
        }
        return false;
    }

    private SnmpVar buildVar(int type, String s) throws SnmpException, NumberFormatException {
        switch (type) {
            case 2: {
                return new SnmpInt(s);
            }
            case 4: {
                if (s == null) {
                    return new SnmpString(new byte[0]);
                }
                if (s.charAt(0) == '\"') {
                    return new SnmpString(s.substring(1).getBytes());
                }
                try {
                    return new SnmpString(s);
                }
                catch (NumberFormatException ex) {
                    return new SnmpString(s.getBytes());
                }
            }
            case 5: {
                return new SnmpNull();
            }
            case 6: {
                return new SnmpOID(SnmpOID.stringToOid(s));
            }
            case 64: {
                if (s.equals("null")) {
                    return new SnmpIpAddress("0.0.0.0");
                }
                return new SnmpIpAddress(s);
            }
            case 65: {
                return new SnmpCounter(Long.parseLong(s));
            }
            case 66: {
                return new SnmpGauge(Long.parseLong(s));
            }
            case 67: {
                return new SnmpTimeticks(Long.parseLong(s));
            }
            case 68: {
                return new SnmpOpaque(s);
            }
            case 69: {
                return new SnmpNsap(s);
            }
            case 70: {
                if (s.startsWith("0x")) {
                    try {
                        return new SnmpCounter64(Long.parseLong(s.substring(2), 16));
                    }
                    catch (NumberFormatException ex) {
                        return new SnmpCounter64(new BigInteger(s.substring(2), 16));
                    }
                }
                try {
                    return new SnmpCounter64(Long.parseLong(s));
                }
                catch (NumberFormatException ex) {
                    return new SnmpCounter64(new BigInteger(s));
                }
            }
        }
        throw new SnmpException("Unsupported type: " + Integer.toHexString(type));
    }

    public SnmpVar getValue(int key) {
        SnmpVar v = (SnmpVar)this._values.elementAt(key);
        if (v.getType() == 67 && Agent.equals((int[])this._keys.elementAt(key), SYS_UP_TIME) == 0) {
            ((SnmpTimeticks)this._values.elementAt(key)).setValue((System.currentTimeMillis() - START_TIME) / 10L);
        }
        return v;
    }

    public void setValue(SnmpVar value, int key) {
        this._values.setElementAt(value, key);
    }

    public int findKey(int[] key) {
        int hi = this._keys.size();
        int lo = 0;
        while (hi > lo) {
            int mid = (hi - lo) / 2 + lo;
            int result = Agent.equals((int[])this._keys.elementAt(mid), key);
            if (result == 0) {
                return mid;
            }
            if (result < 0) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public int findNextKey(int[] key) {
        int result;
        int hi = this._keys.size();
        int lo = 0;
        int mid = 0;
        while (hi > lo && (result = Agent.equals((int[])this._keys.elementAt(mid = (hi - lo) / 2 + lo), key)) != 0) {
            if (result < 0) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        if (hi == lo) {
            return lo;
        }
        return mid + 1;
    }

    public static int equals(int[] first, int[] second) {
        int i = 0;
        for (int j = PREFIX.length; i < first.length && j < second.length; ++i, ++j) {
            if (first[i] < second[j]) {
                return 1;
            }
            if (first[i] <= second[j]) continue;
            return -1;
        }
        if (first.length == second.length - PREFIX.length) {
            return 0;
        }
        return -1;
    }

    static {
        _Timeout = 5000;
    }

    class OidSortModel
    implements SortIf {
        OidSortModel() {
        }

        @Override
        public Object elementAt(int index) {
            return Agent.this._keys.elementAt(index);
        }

        @Override
        public void swap(int i, int j) {
            this.swapIt(Agent.this._keys, i, j);
            this.swapIt(Agent.this._values, i, j);
        }

        void swapIt(Array data, int i, int j) {
            Object t = data.elementAt(i);
            data.setElementAt(data.elementAt(j), i);
            data.setElementAt(t, j);
        }

        @Override
        public void set(int index, Object o) {
        }

        @Override
        public boolean lt(Object first, Object second) {
            return MibNode.equals((int[])first, (int[])second) == 1;
        }
    }
}

