/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.tools.CdpIsl;
import com.cisco.dcbu.tools.CdpNode;
import com.cisco.dcbu.tools.IfIndexToNameEtc;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Cdp
implements SnmpCallbackIf {
    static final int CACHE_ADDRESS = 0;
    static final int CACHE_DEVICEID = 1;
    static final int CACHE_DEVICEPORT = 2;
    static final int CACHE_PLATFORM = 3;
    static final int CACHE_NATIVEVLAN = 4;
    static final int CACHE_CAPABILITIES = 5;
    static final int CACHE_VTPDOMAIN = 6;
    static final String[] CACHE_VARS = new String[]{"cdpCacheAddress", "cdpCacheDeviceId", "cdpCacheDevicePort", "cdpCachePlatform", "cdpCacheNativeVLAN", "cdpCacheCapabilities", "cdpCacheVTPMgmtDomain"};
    static final String[] SYSTEM_VARS = new String[]{"cdpGlobalDeviceId", "sysDescr", "sysServices", "entPhysicalDescr"};
    static int[] _IfDescrOid;
    static int[] _IfNameOid;
    static int[] _IfSpeedOid;
    static int[] _IfNameDescrOid;
    static int[] _PagpGroupIfIndex;
    static VarBindList _CacheVbl;
    static HashMap _NodeByDeviceId;
    static HashMap _NodesByIpAddr;
    static HashMap _Isls;
    static String _Community;
    static SnmpSession _Session;
    private final SyncedInt _numOutstanding;

    public static void main(String[] args) {
        try {
            DataInputStream is = new DataInputStream(new BufferedInputStream(ClassLoader.getSystemResourceAsStream(args[0])));
            MibNode.load(is);
            _Session = SnmpSession.getInstance();
            _Session.open();
            SnmpSession.setTrace(false);
            _Community = args[2];
            new Cdp(args[1]);
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cdp(String seed) throws SnmpException, UnknownHostException {
        _CacheVbl = new VarBindList();
        for (int i = 0; i < CACHE_VARS.length; ++i) {
            _CacheVbl.add(MibNode.get(CACHE_VARS[i]).getOid());
        }
        _IfNameOid = MibNode.get("ifName").getOid();
        _IfDescrOid = MibNode.get("ifDescr").getOid();
        _IfSpeedOid = MibNode.get("ifSpeed").getOid();
        SnmpPeer peer = new SnmpPeer(InetAddress.getByName(seed), _Community, _Community, _Session);
        SnmpPeer.addPeer(peer);
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get(SYSTEM_VARS[0]).getOid(), 0);
        vbl.add(MibNode.get(SYSTEM_VARS[1]).getOid(), 0);
        vbl.add(MibNode.get(SYSTEM_VARS[2]).getOid(), 0);
        vbl.add(MibNode.get(SYSTEM_VARS[3]).getOid(), 1);
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        SnmpPDU resp = peer.send(pdu);
        vbl = resp.getVariables();
        CdpNode local = new CdpNode(vbl.stringValue(0), vbl.stringValue(3), this.convertSysServiceToCdpCap(vbl.intValue(2)));
        local._version = vbl.stringValue(1);
        local._peer = peer;
        _NodeByDeviceId.put(local._deviceId, local);
        _NodesByIpAddr.put(resp.getAddress(), local);
        this._numOutstanding = new SyncedInt(0);
        this._numOutstanding.increment();
        new SnmpFetch().getBulk(peer, _CacheVbl, (SnmpCallbackIf)this);
        try {
            SyncedInt syncedInt = this._numOutstanding;
            synchronized (syncedInt) {
                this._numOutstanding.wait(60000L);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ArrayList nodes = new ArrayList(_NodeByDeviceId.values());
        Collections.sort(nodes);
        System.out.println(nodes.size() + " nodes");
        for (int i = 0; i < nodes.size(); ++i) {
            System.out.println(nodes.get(i));
        }
        ArrayList isls = new ArrayList(_Isls.values());
        Collections.sort(isls);
        System.out.println(isls.size() + " isls");
        for (int i = 0; i < isls.size(); ++i) {
            System.out.println(isls.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        CdpNode local = (CdpNode)_NodesByIpAddr.get(pdu.getAddress());
        VarBindList vbl = pdu.getVariables();
        if (local == null) {
            System.err.println(pdu.getAddress() + " unknown");
        } else if (timedOut) {
            System.err.println(pdu.getAddress() + " timedOut");
            if (local != null) {
                local._isManagable = false;
            }
        } else if (vbl.size() > 0) {
            local._isManagable = true;
            try {
                if (!SnmpOID.startsWith(_IfNameDescrOid, vbl.getVb(0).getOid().getValue())) {
                    local._cacheVbl = vbl;
                    VarBindList ifVbl = new VarBindList();
                    ifVbl.add(MibNode.get(SYSTEM_VARS[1]).getOid(), 0);
                    int[] ifNameOid = this.getNameOid(local);
                    for (int i = 0; i < vbl.size(); i += CACHE_VARS.length) {
                        int[] oid = vbl.getVb(i).getOid().getValue();
                        int ifIndex = oid[oid.length - 2];
                        ifVbl.add(ifNameOid, ifIndex);
                        ifVbl.add(_PagpGroupIfIndex, ifIndex);
                        ifVbl.add(_IfSpeedOid, ifIndex);
                    }
                    new SnmpFetch().get(local._peer, ifVbl, this);
                    this._numOutstanding.increment();
                } else {
                    local._version = vbl.stringValue(0);
                    IfIndexToNameEtc[] ifNameMap = new IfIndexToNameEtc[(vbl.size() - 1) / 3];
                    int i = 1;
                    int j = 0;
                    while (i < vbl.size()) {
                        int[] oid = vbl.getVb(i).getOid().getValue();
                        String ifName = vbl.stringValue(i);
                        int ifIndex = oid[oid.length - 1];
                        int pagpGroupIfIndex = vbl.intValue(i + 1);
                        long ifSpeed = vbl.longValue(i + 2);
                        ifNameMap[j] = new IfIndexToNameEtc(ifIndex, ifName, pagpGroupIfIndex, ifSpeed);
                        i += 3;
                        ++j;
                    }
                    this.processCache(local, ifNameMap, local._cacheVbl);
                    local._cacheVbl = null;
                }
            }
            catch (Exception ex) {
                System.err.println(ex + " " + pdu);
                ex.printStackTrace();
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() == 0) {
            SyncedInt syncedInt = this._numOutstanding;
            synchronized (syncedInt) {
                this._numOutstanding.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCache(CdpNode local, IfIndexToNameEtc[] ifNameMap, VarBindList cacheVbl) throws Exception {
        int i = 0;
        int j = 0;
        while (i < cacheVbl.size()) {
            SnmpInetAddress ipAddr = new SnmpInetAddress(cacheVbl.byteValue(i));
            String deviceId = cacheVbl.stringValue(i + 1);
            CdpNode remote = (CdpNode)_NodeByDeviceId.get(deviceId);
            if (remote == null) {
                HashMap hashMap = _NodeByDeviceId;
                synchronized (hashMap) {
                    remote = new CdpNode(deviceId, cacheVbl.stringValue(i + 3), cacheVbl.byteValue(i + 5));
                    _NodeByDeviceId.put(deviceId, remote);
                }
            }
            if (remote._peer == null && !ipAddr.isNull() && this.queryNode(remote)) {
                remote._peer = new SnmpPeer(InetAddress.getByName(ipAddr.toString()), _Community, _Community, _Session);
                SnmpPeer.addPeer(remote._peer);
                _NodesByIpAddr.put(remote._peer.getAddress(), remote);
                new SnmpFetch().getBulk(remote._peer, _CacheVbl, (SnmpCallbackIf)this);
                this._numOutstanding.increment();
            }
            int ifIndex = ifNameMap[j]._ifIndex;
            CdpIsl newIsl = new CdpIsl(local, ifNameMap[j]._ifName, remote, cacheVbl.stringValue(i + 2), cacheVbl.intValue(i + 4), cacheVbl.stringValue(i + 6), ifNameMap[j]._ifSpeed);
            CdpIsl isl = (CdpIsl)_Isls.get(newIsl);
            if (isl == null) {
                HashMap hashMap = _Isls;
                synchronized (hashMap) {
                    _Isls.put(newIsl, newIsl);
                }
                isl = newIsl;
            }
            isl.setIfIndex(local, ifIndex, ifNameMap[j]._pagpGroupIfIndex);
            i += CACHE_VARS.length;
            ++j;
        }
    }

    private boolean queryNode(CdpNode node) {
        return !node._platform.startsWith("Cisco IP Phone");
    }

    private int[] getNameOid(CdpNode node) {
        if (node._platform.startsWith("isco", 1)) {
            return _IfDescrOid;
        }
        return _IfNameOid;
    }

    private String lookupIfIndex(int ifIndex, IfIndexToNameEtc[] ifNameMap) {
        for (int i = 0; i < ifNameMap.length; ++i) {
            if (ifIndex != ifNameMap[i]._ifIndex) continue;
            return ifNameMap[i]._ifName;
        }
        return Integer.toString(ifIndex);
    }

    private byte[] convertSysServiceToCdpCap(int sysServices) {
        return new byte[0];
    }

    static {
        _IfNameDescrOid = new int[]{1, 3, 6, 1, 2, 1};
        _PagpGroupIfIndex = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 98, 1, 1, 1, 1, 8};
        _NodeByDeviceId = new HashMap();
        _NodesByIpAddr = new HashMap();
        _Isls = new HashMap();
    }
}

