/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.tools.CdpNode;
import java.util.Comparator;

class CdpIsl
implements Comparator,
Comparable {
    CdpNode _node1;
    String _ifName1;
    int _ifIndex1;
    int _pagpGroupIfIndex1;
    CdpNode _node2;
    String _ifName2;
    int _ifIndex2;
    int _pagpGroupIfIndex2;
    int _nativeVlan;
    long _ifSpeed;
    String _vtpDomain;

    public CdpIsl(CdpNode node1, String ifName1, CdpNode node2, String ifName2, int nativeVlan, String vtpDomain, long ifSpeed) {
        if (node1._deviceId.compareTo(node2._deviceId) > 0) {
            this._node1 = node2;
            this._ifName1 = ifName2;
            this._node2 = node1;
            this._ifName2 = ifName1;
        } else {
            this._node1 = node1;
            this._ifName1 = ifName1;
            this._node2 = node2;
            this._ifName2 = ifName2;
        }
        this._nativeVlan = nativeVlan;
        this._vtpDomain = vtpDomain;
        this._ifSpeed = ifSpeed;
    }

    public void setIfIndex(CdpNode node, int ifIndex, int pagpGroupIfIndex) {
        if (node == this._node1) {
            this._ifIndex1 = ifIndex;
            this._pagpGroupIfIndex1 = pagpGroupIfIndex;
        } else {
            this._ifIndex2 = ifIndex;
            this._pagpGroupIfIndex2 = pagpGroupIfIndex;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._node1._deviceId + " " + this._ifName1);
        if (this._pagpGroupIfIndex1 > 0 && this._pagpGroupIfIndex1 != this._ifIndex1) {
            sb.append(" PC " + this._pagpGroupIfIndex1);
        }
        sb.append(" <-> " + this._node2._deviceId + " " + this._ifName2);
        if (this._pagpGroupIfIndex2 > 0 && this._pagpGroupIfIndex2 != this._ifIndex2) {
            sb.append(" PC " + this._pagpGroupIfIndex2);
        }
        if (this._nativeVlan != 0) {
            sb.append(", VLAN" + this._nativeVlan);
        }
        if (this._vtpDomain.length() > 0) {
            sb.append(", VTP " + this._vtpDomain);
        }
        sb.append(" " + MibVariableFormat.speedBasic(this._ifSpeed));
        return sb.toString();
    }

    public int hashCode() {
        return this._node1.hashCode() ^ this._ifName1.hashCode() ^ this._node2.hashCode() ^ this._ifName2.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CdpIsl)) {
            return false;
        }
        CdpIsl isl = (CdpIsl)obj;
        return this._node1 == isl._node1 && this._node2 == isl._node2 && this._ifName1.equals(isl._ifName1) && this._ifName2.equals(isl._ifName2);
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        CdpIsl isl1 = (CdpIsl)o1;
        CdpIsl isl2 = (CdpIsl)o2;
        return isl1._node1._deviceId.compareTo(isl2._node1._deviceId);
    }
}

