/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.tools.AddDialog;
import com.cisco.dcbu.tools.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class LearnDialog
extends JDialog
implements ActionListener,
SnmpCallbackIf {
    static final int MAXRPTR = 60;
    static final String[] _Labels = new String[]{"Device Address:", "Port:", "Agent File:", "Read Community:", "Timeout:", "Retries:", "Start Walk:", "End Walk:"};
    static final String[] _Defaults = new String[]{"127.0.0.1", "161", "walk.otv", "public", "5", "1", "0", "endOfMib"};
    final String[] _Buttons = new String[]{"Start", "Stop", "Close"};
    static SnmpPeer _Peer;
    JTextField[] _values;
    JButton[] _buttons;
    AddDialog _addDialog;
    JCheckBox _translate;
    JCheckBox _version;
    JCheckBox _skip;
    boolean _isTranslate;
    JLabel _status;
    PrintStream _os;
    boolean _isStopped;
    int[] _endWalk;
    byte _op;

    public LearnDialog(JFrame parent, AddDialog addDialog) {
        super((Frame)parent, parent.getTitle() + " - Learn From Device");
        this._addDialog = addDialog;
        this._values = new JTextField[_Labels.length];
        for (int i = 0; i < _Labels.length; ++i) {
            this._values[i] = new JTextField(_Defaults[i]);
        }
        this._values[2].setColumns(20);
        JPanel fields = DialogUtil.buildPanel(DialogUtil.buildLabels(_Labels), this._values);
        JButton browse = new JButton("...");
        browse.addActionListener(this);
        browse.setMargin(DialogUtil.getInsets());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        fields.add((Component)browse, gbc);
        this._translate = new JCheckBox("Translate OID to MIB descriptor", true);
        gbc.gridx = 1;
        gbc.gridy = _Labels.length + 1;
        gbc.anchor = 17;
        fields.add((Component)this._translate, gbc);
        ++gbc.gridy;
        this._version = new JCheckBox("Use GET-BULK for speed (V2c only)", false);
        fields.add((Component)this._version, gbc);
        ++gbc.gridy;
        this._skip = new JCheckBox("Don't stop on timeout; skip oid", false);
        fields.add((Component)this._skip, gbc);
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", fields);
        this._status = new JLabel(" ");
        this._status.setBackground(Color.white);
        p.add("South", this._status);
        this._buttons = DialogUtil.buildButtons(this._Buttons, (ActionListener)this);
        this._buttons[1].setEnabled(false);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, (AbstractButton[])this._buttons);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = ((JButton)e.getSource()).getText();
        if (s.equals(this._Buttons[0])) {
            this._isStopped = false;
            this._buttons[0].setEnabled(false);
            this._buttons[1].setEnabled(true);
            this._isTranslate = this._translate.isSelected();
            this._status.setText(" ");
            try {
                this.walk(this._values[0].getText(), Integer.parseInt(this._values[1].getText()), this._values[2].getText(), this._values[3].getText(), Integer.parseInt(this._values[4].getText()), Integer.parseInt(this._values[5].getText()), this._values[6].getText(), this._values[7].getText(), this._version.isSelected());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            }
        } else if (s.equals(this._Buttons[1])) {
            this._isStopped = true;
            this._status.setText("Stop pending...");
        } else if (s.equals("...")) {
            String fName = Simulator.getFileName((JFrame)this.getParent(), "*.otv");
            if (fName != null) {
                this._values[2].setText(fName);
            }
        } else {
            this.setVisible(false);
        }
    }

    void walk(String peer, int port, String outFile, String community, int timeout, int retries, String startWalk, String endWalk, boolean v2c) throws SocketException, SnmpException, UnknownHostException, IOException {
        if (_Peer == null) {
            SnmpSession session = SnmpSession.getInstance();
            session.open();
            _Peer = new SnmpPeer(null);
            _Peer.setSession(session);
        }
        this._os = new PrintStream(new FileOutputStream(outFile));
        this._os.println("# <OID> <TYPE> <VALUE>");
        this._os.println("# <TYPE>: integer(1), string(4), objectId(6), ipAddress(64), counter(65), gauge(66), unsigned32(66), timeTicks(67)");
        _Peer.setAddress(InetAddress.getByName(peer));
        _Peer.setPort(port);
        _Peer.setReadCommunity(community);
        _Peer.setTimeout(timeout * 1000);
        _Peer.setRetries(retries);
        this._endWalk = (int[])(endWalk.equals(_Defaults[7]) ? null : SnmpOID.stringToOid(endWalk));
        SnmpPDU pdu = new SnmpPDU(new VarBindList(1));
        pdu.setAddress(InetAddress.getByName(peer));
        if (v2c) {
            this._op = (byte)-91;
            pdu.setMaxRptr(60);
        } else {
            this._op = (byte)-95;
        }
        pdu.setCommand(this._op);
        pdu.addNull(new SnmpOID(SnmpOID.stringToOid(startWalk)));
        _Peer.send(pdu, this);
    }

    void endWalk(String reason) {
        this._os.println("#" + reason);
        this._os.close();
        this._isStopped = true;
        this._buttons[0].setEnabled(true);
        this._buttons[1].setEnabled(false);
        this._status.setText(reason);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (this._isStopped) {
            this.endWalk("stopped");
            return;
        }
        SnmpVarBind vb = null;
        if (timedOut) {
            if (!this._skip.isSelected()) {
                this.endWalk("timeout");
                return;
            }
            vb = pdu.getVariables().getVb(0);
            String s = new String("# timeout, skip: " + vb.getOid());
            this._status.setText(s);
            this._os.println(s);
            int[] oid = vb.getOid().getValue();
            int n = oid.length - 1;
            oid[n] = oid[n] + 1;
        } else {
            if (this._op == -95) {
                vb = pdu.getVariables().getVb(0);
                if (vb.getError() == 21) {
                    return;
                }
                if (pdu.getError() != 0 || this._endWalk != null && vb.getOid().startsWith(this._endWalk)) {
                    this.endWalk("done");
                    return;
                }
                this.dumpVb(vb, true);
            } else {
                int numVb = pdu.getVariables().size();
                for (int i = 0; i < numVb && (vb = pdu.getVariables().getVb(i)).getError() == 0; ++i) {
                    this.dumpVb(vb, i + 1 == numVb);
                }
                if (numVb < 60) {
                    this.endWalk("done");
                    return;
                }
                pdu.getVariables().removeRange(0, numVb - 1);
                pdu.setMaxRptr(60);
            }
            vb.setVar(null);
        }
        pdu.setReqid(0);
        pdu.setCommand(this._op);
        try {
            _Peer.send(pdu, this);
            return;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    void dumpVb(SnmpVarBind vb, boolean updateStatus) {
        StringBuffer sb = new StringBuffer(80);
        if (Simulator._UseMib && this._isTranslate) {
            sb.append(MibNode.oidToName(vb.getOid().getValue()));
        } else {
            sb.append(vb.getOid());
        }
        if (updateStatus) {
            this._status.setText(sb.toString());
        }
        sb.append(' ');
        sb.append(vb.getVar().getType());
        sb.append(' ');
        if (vb.getVar().getType() == 67) {
            sb.append(((SnmpTimeticks)vb.getVar()).getValue());
        } else {
            sb.append(vb.getVar());
        }
        this._os.println(sb.toString());
    }
}

