/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class MemoryTest {
    private static final Runtime s_runtime = Runtime.getRuntime();

    public static void main(String[] args) throws Exception {
        MemoryTest.runGC();
        MemoryTest.usedMemory();
        long heap1 = 0L;
        MibNode.load("mib.dat");
        HashMap alias = new HashMap();
        MemoryTest.load(alias, "alias.properties");
        MemoryTest.runGC();
        long heap2 = MemoryTest.usedMemory();
        System.out.println("'before' heap: " + heap1 + ", 'after' heap: " + heap2);
    }

    private static void runGC() throws Exception {
        for (int r = 0; r < 4; ++r) {
            MemoryTest._runGC();
        }
    }

    private static void _runGC() throws Exception {
        long usedMem1 = MemoryTest.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.currentThread();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = MemoryTest.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }

    public static void load(HashMap p, String fName) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(fName));){
            MemoryTest.load(p, br);
        }
    }

    public static void load(HashMap p, BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            p.put(line.substring(0, equals).intern(), line.substring(equals + 1).intern());
        }
    }
}

