/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.MibTC;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.Sort;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.tools.OidSortModel;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class MibParse {
    static int _LineNo;
    static Hashtable _NodeHash;
    static Hashtable _TcHash;
    static Hashtable _TcUsed;
    static String _CurrentFile;
    static Array _Keys;

    public static void main(String[] argv) {
        if (argv.length < 2) {
            System.err.println("usage: <x.out> [<y.out>] <z.dat>");
            System.exit(1);
        }
        try {
            _CurrentFile = argv[0];
            MibParse.parseFile(argv[0], true);
            FileOutputStream fos = null;
            if (argv.length == 3) {
                _LineNo = 0;
                _CurrentFile = argv[1];
                MibParse.parseFile(argv[1], false);
                fos = new FileOutputStream(argv[2]);
            } else {
                fos = new FileOutputStream(argv[1]);
            }
            DataOutputStream out = new DataOutputStream(fos);
            MibParse.checkTcHash();
            Sort.quickSort(new OidSortModel(_Keys, _NodeHash), 0, _Keys.size() - 1);
            out.writeInt(3);
            out.writeInt(_TcHash.size());
            out.writeInt(MibParse.calcHash(_TcHash.size()));
            Enumeration en = _TcHash.elements();
            while (en.hasMoreElements()) {
                MibTC tc = (MibTC)en.nextElement();
                out.writeUTF(tc._label);
                MibNode.writeEnums(out, tc._enums);
            }
            out.writeInt(_Keys.size());
            out.writeInt(MibParse.calcHash(_Keys.size()));
            for (int i = 0; i < _Keys.size(); ++i) {
                out.writeUTF((String)_Keys.elementAt(i));
                MibNode n = (MibNode)_NodeHash.get(_Keys.elementAt(i));
                n.write(out);
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            System.err.println(_CurrentFile + ", line " + _LineNo + ": " + ex);
            ex.printStackTrace();
        }
    }

    static void checkTcHash() {
        for (Object n : _NodeHash.values()) {
            String tc = ((MibNode)n).getTCLabel();
            if (tc == null || _TcUsed.get(tc) != null) continue;
            _TcUsed.put(tc, tc);
        }
        for (Object n : _TcHash.keySet()) {
            if (_TcUsed.get(n) != null) continue;
            System.out.println((String)n + " TC unused; removed");
            _TcHash.remove(_TcHash.get(n));
        }
    }

    static void parseFile(String inFile, boolean saveKeys) throws FileNotFoundException, IOException {
        String buf;
        BufferedReader is = new BufferedReader(new FileReader(inFile));
        while ((buf = is.readLine()) != null) {
            String[] str;
            ++_LineNo;
            if (buf.charAt(0) == '#' || (str = StringUtil.tokenize(buf, " ")) == null) continue;
            if (str[0].charAt(0) == 'T') {
                byte type = Byte.parseByte(str[2]);
                if (type == 56 || type == 71) {
                    type = 66;
                }
                _TcHash.put(str[1], new MibTC(str[1], type, MibParse.parseEnums(str, 3)));
                continue;
            }
            if (str[0].charAt(0) == 'N') {
                boolean isIndex;
                int[] oid = null;
                if (saveKeys) {
                    String[] oids = StringUtil.tokenize(str[2], ".");
                    oid = new int[oids.length];
                    for (int i = 0; i < oid.length; ++i) {
                        oid[i] = Integer.valueOf(oids[i]);
                    }
                    _Keys.addElement(str[1]);
                } else {
                    MibNode n = (MibNode)_NodeHash.get(str[1]);
                    oid = n.getOid();
                }
                int offset = saveKeys ? 1 : 0;
                byte access = MibParse.getAccess(str[3 + offset]);
                MibTC tc = (MibTC)_TcHash.get(str[8 + offset]);
                String tcLabel = null;
                byte typ = Byte.parseByte(str[2 + offset]);
                if (tc != null) {
                    typ = tc._type;
                    tcLabel = tc._label;
                }
                if (typ == 56 || typ == 71) {
                    typ = 66;
                }
                boolean bl = isIndex = str[4 + offset].charAt(0) == 't';
                if (isIndex) {
                    access = (byte)(access + 16);
                }
                short lo = Integer.valueOf(str[5 + offset]).shortValue();
                int hi = Integer.valueOf(str[6 + offset]);
                int defVal = Integer.valueOf(str[7 + offset]);
                MibEnum[] enums = MibParse.parseEnums(str, 9 + offset);
                MibNode node = new MibNode(oid, typ, access, lo, hi, defVal, tcLabel, enums);
                _NodeHash.put(str[1], node);
                continue;
            }
            throw new IOException("Unknown element");
        }
        is.close();
    }

    static MibEnum[] parseEnums(String[] str, int pos) {
        int numEnums = (str.length - pos) / 2;
        if (numEnums == 0) {
            return null;
        }
        MibEnum[] enums = new MibEnum[numEnums];
        for (int i = 0; i < numEnums; ++i) {
            enums[i] = new MibEnum(str[pos++], Integer.valueOf(str[pos++]));
        }
        return enums;
    }

    static byte getAccess(String access) {
        switch (access.charAt(1)) {
            case 'o': {
                if (access.charAt(0) == 'r') {
                    return 1;
                }
                return 3;
            }
            case 'w': {
                return 2;
            }
            case 'a': {
                return 4;
            }
            case 'c': {
                return 5;
            }
            case 'x': {
                return 6;
            }
        }
        return 0;
    }

    static void replaceErrorEnums(MibEnum[] enums, String fName) {
        try {
            Properties errors = new Properties();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(fName));
            errors.load(is);
            is.close();
            for (int i = 0; i < enums.length; ++i) {
                String msg = (String)errors.get(Integer.toString(enums[i].getValue()));
                if (msg == null) continue;
                enums[i].setLabel(msg);
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    static int calcHash(int size) {
        if ((size = (int)((double)size * 1.3)) > 2879) {
            return size;
        }
        if (size > 1439) {
            return 2879;
        }
        if (size > 719) {
            return 1439;
        }
        if (size > 359) {
            return 719;
        }
        if (size > 179) {
            return 359;
        }
        if (size > 89) {
            return 179;
        }
        return 89;
    }

    static {
        _NodeHash = new Hashtable();
        _TcHash = new Hashtable();
        _TcUsed = new Hashtable();
        _Keys = new Array();
    }
}

