/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ProxyStub {
    static final int TYPE1_IFINDEX = 0x1000000;
    static final int CHANNEL_IFINDEX = 0x4000000;
    static PrintStream _Out;
    static int[] _ScalarIndex;
    static final int[] _CardTypes;
    static int _numCards;
    static HashMap _Methods;
    static String[] _System;
    static String[] _SnmpStats;
    static String[] _If;
    static String[] _IfX;
    static String[] _Ent;
    static String[] _CefcModule;
    static String[] _EntPower;
    static String[] _EntFan;
    static String[] _EntSensorThreshold;
    static String[] _PortChannel;
    static String[] _CcCopy;
    static String[] _CImage;
    static String[] _IpStat;
    static String[] _IcmpStat;
    static String[] _Domain;
    static String[] _DomainArea;
    static String[] _DomainDB;
    static String[] _DomainCache;
    static String[] _Vsan;
    static String[] _VsanIf;
    static String[] _FcIf;
    static String[] _FcFlogi;
    static String[] _FcCap;
    static String[] _FcELP;
    static String[] _FcStat;
    static String[] _FcC2Stat;
    static String[] _FcC3Stat;
    static String[] _FcCfStat;
    static String[] _FcName;
    static String[] _FcNameStat;
    static String[] _Fspf;
    static String[] _FspfIf;
    static String[] _FspfLsr;
    static String[] _FspfLink;
    static String[] _ZoneSet;
    static String[] _Zone;
    static String[] _ZoneAlias;
    static String[] _ZoneMember;
    static String[] _ZoneScalar;
    static String[] _ZoneStats;
    static String[] _TcpConn;
    static String[] _Tcp;
    static String[] _Vrrp;
    static String[] _VrrpScalars;
    static String[] _SysModule;
    static String[] _SysScalars;
    static String[] _SysRadius;
    static String[] _SysLog;
    static String[] _SysLogSeverity;
    static String[] _FcRouteEntry;
    static String[] _FcRouteScalar;
    static String[] _WwnM;
    static String[] _CallHome;
    static String[] _CallHomeProfile;
    static String[] _CallHomeEmail;
    static final int ENT_CHASSIS = 1;
    static final int ENT_BACKPLANE = 21;
    static final int ENT_CARD1 = 22;
    static final int ENT_CARD13 = 34;
    static final int ENT_PS1 = 38;
    static final int ENT_PS2 = 39;
    static final int ENT_FAN = 40;
    static MibEnum[] _Severity;
    static String[] _SwitchWwn;
    static String[] _HBAWwn;
    static String[] _DiskWwn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            _Out = new PrintStream(new FileOutputStream(argv[0]));
            MibNode.load("com/cisco/dcbu/dmdb/andiamo/mib.dat");
            ProxyStub.build(argv.length > 1 ? Integer.parseInt(argv[1]) : 9);
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
            String string = argv[0];
            synchronized (string) {
                try {
                    argv[0].wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static void build(int numCards) {
        int j;
        int i;
        int i2;
        int j2;
        int i3;
        int c;
        int i4;
        int i5;
        _numCards = numCards;
        Method[] methods = ProxyStub.class.getDeclaredMethods();
        for (int i6 = 0; i6 < methods.length; ++i6) {
            if (methods[i6].getReturnType() != String.class) continue;
            _Methods.put(methods[i6].getName(), methods[i6]);
        }
        int[] singleIndex = new int[1];
        ProxyStub.createScalars(_System);
        ProxyStub.createScalars(_SnmpStats);
        int[][] cmtyIndex = new int[][]{{112, 117, 98, 108, 105, 99}, {112, 114, 105, 118, 97, 116, 101}, {115, 101, 99, 114, 101, 116}};
        String[] cmtyName = new String[]{"basic", "operator", "admin"};
        for (i5 = 0; i5 < cmtyName.length; ++i5) {
            String oid = SnmpOID.toString(cmtyIndex[i5]);
            _Out.println("snmpCommunitySecurityName." + oid + " 4 " + cmtyName[i5]);
            _Out.println("usmUserSecurityName." + oid + " 4 " + cmtyName[i5]);
        }
        singleIndex[0] = 1;
        ProxyStub.createTable(_Ent, singleIndex);
        singleIndex[0] = 21;
        ProxyStub.createTable(_Ent, singleIndex);
        singleIndex[0] = 40;
        ProxyStub.createTable(_Ent, singleIndex);
        ProxyStub.createTable(_EntFan, singleIndex);
        for (i5 = 38; i5 <= 39; ++i5) {
            singleIndex[0] = i5;
            ProxyStub.createTable(_Ent, singleIndex);
            ProxyStub.createTable(_EntPower, singleIndex);
            int[] sensor = new int[2];
            sensor[0] = i5;
            int j3 = 1;
            while (j3 <= 2) {
                sensor[1] = j3++;
                ProxyStub.createTable(_EntSensorThreshold, sensor);
            }
        }
        i5 = 22;
        while (i5 < 22 + numCards) {
            singleIndex[0] = i5++;
            ProxyStub.createTable(_Ent, singleIndex);
            ProxyStub.createTable(_CefcModule, singleIndex);
        }
        _Out.println("entLastChangeTime.0 67 0");
        ProxyStub.createIfTable(_If);
        ProxyStub.createScalars(_IpStat);
        ProxyStub.createScalars(_IcmpStat);
        ProxyStub.createIfTable(_IfX);
        int[] tcpConnIndex = new int[10];
        tcpConnIndex[5] = 10;
        tcpConnIndex[0] = 10;
        for (i4 = 0; i4 < 10; ++i4) {
            tcpConnIndex[3] = tcpConnIndex[8] = i4;
            tcpConnIndex[4] = 100 + i4;
            tcpConnIndex[9] = 1000 + i4;
            ProxyStub.createTable(_TcpConn, tcpConnIndex);
        }
        ProxyStub.createScalars(_Tcp);
        _Out.println("ipForwarding.0 2 1");
        singleIndex[0] = 1;
        ProxyStub.createTable(_PortChannel, singleIndex);
        i4 = 1;
        while (i4 <= 2) {
            singleIndex[0] = i4++;
            ProxyStub.createTable(_CcCopy, singleIndex);
        }
        i4 = 1;
        while (i4 <= 2) {
            singleIndex[0] = i4++;
            ProxyStub.createTable(_CImage, singleIndex);
        }
        _Out.println("cffFcFeElementName.0 4 01:00:00:05:30:00:00:01");
        ProxyStub.createIfTable(_FcIf);
        int[] fcLogi = new int[2];
        fcLogi[1] = 1;
        int[] fspf = new int[2];
        fspf[0] = 1;
        int supSlot = 4;
        if (_numCards == 6) {
            supSlot = 2;
        } else if (_numCards == 13) {
            supSlot = 6;
        } else if (_numCards == 2) {
            supSlot = -1;
        }
        for (c = 0; c < supSlot; ++c) {
            for (i3 = 3; i3 < 8; ++i3) {
                fcLogi[0] = 0x1000000 + (c << 19) + (i3 << 12);
                ProxyStub.createTable(_FcFlogi, fcLogi);
            }
            for (i3 = 0; i3 < 3; ++i3) {
                singleIndex[0] = 0x1000000 + (c << 19) + (i3 << 12);
                ProxyStub.createTable(_FcELP, singleIndex);
            }
            for (i3 = 0; i3 < 3; ++i3) {
                fspf[1] = 0x1000000 + (c << 19) + (i3 << 12);
                ProxyStub.createTable(_FspfIf, fspf);
            }
        }
        for (c = supSlot + 2; c < _numCards; ++c) {
            for (i3 = 3; i3 < 8; ++i3) {
                fcLogi[0] = 0x1000000 + (c << 19) + (i3 << 12);
                ProxyStub.createTable(_FcFlogi, fcLogi);
            }
            for (i3 = 0; i3 < 3; ++i3) {
                singleIndex[0] = 0x1000000 + (c << 19) + (i3 << 12);
                ProxyStub.createTable(_FcELP, singleIndex);
            }
            for (i3 = 0; i3 < 3; ++i3) {
                fspf[1] = 0x1000000 + (c << 19) + (i3 << 12);
                ProxyStub.createTable(_FspfIf, fspf);
            }
        }
        ProxyStub.createIfTable(_FcCap);
        ProxyStub.createIfTable(_FcStat);
        ProxyStub.createIfTable(_FcC2Stat);
        ProxyStub.createIfTable(_FcC3Stat);
        ProxyStub.createIfTable(_FcCfStat);
        _Out.println("vsanNumber.0 2 1");
        singleIndex[0] = 1;
        ProxyStub.createTable(_Vsan, singleIndex);
        ProxyStub.createIfTable(_VsanIf);
        singleIndex[0] = 1;
        ProxyStub.createTable(_Domain, singleIndex);
        int[] domainArea = new int[2];
        domainArea[0] = 1;
        i3 = 1;
        while (i3 <= 2) {
            domainArea[1] = i3++;
            ProxyStub.createTable(_DomainArea, domainArea);
        }
        i3 = 1;
        while (i3 < 10) {
            domainArea[1] = i3++;
            ProxyStub.createTable(_DomainDB, domainArea);
        }
        _Out.println("dmMaxFcIdCacheSize.0 2 0");
        int[] domainCache = new int[9];
        domainCache[0] = 1;
        int i7 = 1;
        while (i7 < 10) {
            domainCache[1] = i7++;
            ProxyStub.createTable(_DomainCache, domainCache);
        }
        _Out.println("dmReConfFabricChangeNotifyEnable.0 2 1");
        singleIndex[0] = 1;
        ProxyStub.createTable(_Fspf, singleIndex);
        int[] fspfLsr = new int[3];
        fspfLsr[0] = 1;
        fspfLsr[2] = 1;
        int i8 = 1;
        while (i8 <= 3) {
            fspfLsr[1] = i8++;
            ProxyStub.createTable(_FspfLsr, fspfLsr);
        }
        int[] fspfLink = new int[4];
        fspfLink[0] = 1;
        fspfLink[2] = 1;
        for (int i9 = 1; i9 <= 3; ++i9) {
            fspfLink[1] = i9;
            int j4 = 1;
            while (j4 <= 2) {
                fspfLink[3] = j4++;
                ProxyStub.createTable(_FspfLink, fspfLink);
            }
        }
        _Out.println("fspfNbrStateChangeNotifyEnable.0 2 1");
        int[] fcName = new int[4];
        int fcCount = 0;
        fcName[0] = 1;
        fcName[1] = 1;
        for (j2 = 1; j2 <= 4; ++j2) {
            fcName[2] = j2;
            i2 = 4;
            while (i2 <= 8) {
                fcName[3] = i2++;
                ProxyStub.createTable(_FcName, fcName);
                ++fcCount;
            }
        }
        for (j2 = 7; j2 <= 9; ++j2) {
            fcName[2] = j2;
            i2 = 4;
            while (i2 <= 8) {
                fcName[3] = i2++;
                ProxyStub.createTable(_FcName, fcName);
                ++fcCount;
            }
        }
        _Out.println("fcNameServerNumRows.0 2 " + fcCount);
        _Out.println("fcNameServerProxyPortName.1 4 00:00:00:00:00:00:00:00");
        _Out.println("fcNameServerTableLastChange.0 2 0");
        singleIndex[0] = 1;
        ProxyStub.createTable(_FcNameStat, singleIndex);
        _Out.println("zoneSetNumber.0 2 2");
        int[] zoneset = new int[2];
        zoneset[0] = 1;
        i2 = 1;
        while (i2 <= 2) {
            zoneset[1] = i2++;
            ProxyStub.createTable(_ZoneSet, zoneset);
        }
        singleIndex[0] = 1;
        _Out.println("zoneNumber.0 2 6");
        i2 = 1;
        while (i2 <= 6) {
            zoneset[1] = i2++;
            ProxyStub.createTable(_Zone, zoneset);
        }
        _Out.println("zoneAliasNumber.0 2 2");
        i2 = 1;
        while (i2 <= 2) {
            zoneset[1] = i2++;
            ProxyStub.createTable(_ZoneAlias, zoneset);
        }
        _Out.println("zoneMemberNumber.0 2 22");
        int[] zoneMember = new int[4];
        zoneMember[0] = 1;
        zoneMember[1] = 1;
        int zoneIndex = 1;
        for (i = 1; i <= 6; ++i) {
            zoneMember[2] = i;
            for (j = 1; j <= 2; ++j) {
                zoneMember[3] = zoneIndex++;
                ProxyStub.createTable(_ZoneMember, zoneMember);
            }
        }
        zoneMember[1] = 2;
        zoneIndex = 1;
        for (i = 1; i <= 2; ++i) {
            zoneMember[2] = i;
            for (j = 1; j <= 5; ++j) {
                zoneMember[3] = zoneIndex++;
                ProxyStub.createTable(_ZoneMember, zoneMember);
            }
        }
        ProxyStub.createScalars(_ZoneScalar);
        singleIndex[0] = 1;
        ProxyStub.createTable(_ZoneStats, singleIndex);
        int[] vrrp = new int[2];
        vrrp[0] = 17362944;
        int i10 = 1;
        while (i10 < 5) {
            vrrp[1] = i10++;
            ProxyStub.createTable(_Vrrp, vrrp);
        }
        ProxyStub.createScalars(_VrrpScalars);
        _Severity = MibNode.get("syslogMessageFacility").getEnums();
        for (i10 = 0; i10 < _Severity.length; ++i10) {
            singleIndex[0] = _Severity[i10].getValue();
            ProxyStub.createTable(_SysLogSeverity, singleIndex);
        }
        ProxyStub.createScalars(_SysScalars);
        int[] sysModuleIndex = new int[2];
        sysModuleIndex[0] = 1;
        for (int i11 = 0; i11 < _Severity.length; ++i11) {
            sysModuleIndex[1] = _Severity[i11].getValue();
            ProxyStub.createTable(_SysModule, sysModuleIndex);
        }
        int[] radiusIndex = new int[5];
        radiusIndex[0] = 1;
        radiusIndex[1] = 127;
        int i12 = 0;
        while (i12 < 2) {
            radiusIndex[4] = i12++;
            ProxyStub.createTable(_SysRadius, radiusIndex);
        }
        ProxyStub.createScalars(_WwnM);
        ProxyStub.createScalars(_FcRouteScalar);
        int[] fcRouteIndex = new int[7];
        fcRouteIndex[0] = 1;
        fcRouteIndex[4] = 255;
        int i13 = 1;
        while (i13 <= 16) {
            fcRouteIndex[1] = i13++;
            ProxyStub.createTable(_FcRouteEntry, fcRouteIndex);
        }
        ProxyStub.createScalars(_CallHome);
        int[][] callHomeIndex = new int[][]{{116, 101, 115, 116}, {112, 97, 103, 101, 114}};
        ProxyStub.createTable(_CallHomeProfile, callHomeIndex[0]);
        ProxyStub.createTable(_CallHomeProfile, callHomeIndex[1]);
        int[] callHomeEmailIndex = new int[]{116, 101, 115, 116, 1};
        ProxyStub.createTable(_CallHomeEmail, callHomeEmailIndex);
        _Out.println("#end");
    }

    static void createIfTable(String[] vars) {
        switch (_numCards) {
            case 2: {
                ProxyStub.createIfTable(vars, 1);
                break;
            }
            case 6: {
                ProxyStub.createIfTable(vars, 0);
                ProxyStub.createIfTable(vars, 1);
                ProxyStub.createIfTable(vars, 4);
                ProxyStub.createIfTable(vars, 5);
                break;
            }
            case 9: {
                int i;
                for (i = 0; i < 4; ++i) {
                    ProxyStub.createIfTable(vars, i);
                }
                for (i = 6; i < 9; ++i) {
                    ProxyStub.createIfTable(vars, i);
                }
                break;
            }
            case 13: {
                int i;
                for (i = 0; i < 6; ++i) {
                    ProxyStub.createIfTable(vars, i);
                }
                for (i = 8; i < 13; ++i) {
                    ProxyStub.createIfTable(vars, i);
                }
                break;
            }
        }
    }

    static void createIfTable(String[] vars, int cardNo) {
        int[] singleIndex = new int[1];
        for (int i = 0; i < 32; ++i) {
            singleIndex[0] = 0x1000000 + (cardNo << 19) + (i << 12);
            ProxyStub.createTable(vars, singleIndex);
        }
    }

    static void createTable(String[] vars, int[] index) {
        String instance = SnmpOID.toString(index);
        for (int i = 0; i < vars.length; ++i) {
            _Out.println(vars[i] + "." + instance + " " + Integer.toString(MibNode.get(vars[i]).getType()) + " " + ProxyStub.getValue(index, vars[i]));
        }
    }

    static void createScalars(String[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            _Out.println(vars[i] + ".0 " + Integer.toString(MibNode.get(vars[i]).getType()) + " " + ProxyStub.getValue(_ScalarIndex, vars[i]));
        }
    }

    static String getValue(int[] index, String v) {
        Method m = (Method)_Methods.get(v);
        if (m != null) {
            try {
                Object[] args = new Object[]{index};
                return (String)m.invoke(ProxyStub.class, args);
            }
            catch (InvocationTargetException ex) {
                Exception realEx = (Exception)ex.getTargetException();
                System.err.println(v + " getValue: " + realEx);
            }
            catch (Exception ex) {
                System.err.println(v + " getValue: " + ex);
            }
        }
        MibNode n = MibNode.get(v);
        byte t = MibNode.get(v).getType();
        if (t == 4) {
            return "\"";
        }
        if (t == 2 || t == 66) {
            if (n.getDefVal() != -1) {
                return Integer.toString(n.getDefVal());
            }
            MibEnum[] me = MibNode.get(v).getEnums();
            if (me != null) {
                return Integer.toString(me[0].getValue());
            }
        } else {
            if (t == 64) {
                return "0.0.0.0";
            }
            if (t == 67) {
                return "100";
            }
        }
        return "0";
    }

    static String sysDescr(int[] index) {
        return "\"Andiamo 9500 Fiber Channel Switch. Version 1, Build 0";
    }

    static String sysObjectID(int[] index) {
        switch (_numCards) {
            case 2: {
                return ".1.3.6.1.4.1.9524.6.1.1.1.5";
            }
            case 6: {
                return ".1.3.6.1.4.1.9524.6.1.1.1.2";
            }
            case 13: {
                return ".1.3.6.1.4.1.9524.6.1.1.1.4";
            }
        }
        return ".1.3.6.1.4.1.9524.6.1.1.1.3";
    }

    static String ifIndex(int[] index) {
        return Integer.toString(index[0]);
    }

    static String ifDescr(int[] index) {
        return ProxyStub.ifName(index);
    }

    static String ifName(int[] index) {
        int card = (index[0] >> 19 & 0x1F) + 1;
        int port = (index[0] >> 12 & 0x7F) + 1;
        return "\"fc " + card + "/" + port;
    }

    static String ifType(int[] index) {
        return Integer.toString(56);
    }

    static String ifMtu(int[] index) {
        return Integer.toString(2012);
    }

    static String fcIfNxClass2RxDataFieldSize(int[] index) {
        return ProxyStub.ifMtu(index);
    }

    static String fcIfNxClass3RxDataFieldSize(int[] index) {
        return ProxyStub.ifMtu(index);
    }

    static String ifPhysAddress(int[] index) {
        return ProxyStub.fcIfWwn(index);
    }

    static String ifSpeed(int[] index) {
        return Integer.toString(1000000000);
    }

    static String ifHighSpeed(int[] index) {
        return Integer.toString(1000);
    }

    static String fcNameServerPortName(int[] index) {
        return index[3] % 2 == 0 ? ProxyStub.getHBAWwn(index[2], index[3], false) : ProxyStub.getDiskWwn(index[2], index[3], false);
    }

    static String fcNameServerNodeIpAddress(int[] index) {
        int[] ip = new int[]{10, 0, 0, index[3]};
        return SnmpString.toHexString(ip, 0, ip.length, true);
    }

    static String fcIfCapFcphVersionLow(int[] index) {
        return "1";
    }

    static String fcIfCapFcphVersionHigh(int[] index) {
        return "2";
    }

    static String fcIfCapBbCreditMax(int[] index) {
        return "12";
    }

    static String fcIfCapRxDataFieldSizeMax(int[] index) {
        return "1024";
    }

    static String fcIfCapHoldTimeMax(int[] index) {
        return "100";
    }

    static String fcNameServerNodeName(int[] index) {
        return index[3] % 2 == 0 ? ProxyStub.getHBAWwn(index[2], index[3], true) : ProxyStub.getDiskWwn(index[2], index[3], true);
    }

    static String fcIfNxPortNodeName(int[] index) {
        int port = (index[0] >> 12 & 0x7F) + 1;
        int card = (index[0] >> 19 & 0x1F) + 1;
        return port % 2 == 0 ? ProxyStub.getHBAWwn(card, port, true) : ProxyStub.getDiskWwn(card, port, true);
    }

    static String fcIfNxPortName(int[] index) {
        return ProxyStub.fcIfNxPortNodeName(index);
    }

    static String fcIfNxPortAddress(int[] index) {
        int[] fcId = new int[]{1, (index[0] >> 19 & 0x1F) + 1, (index[0] >> 12 & 0x7F) + 1};
        return SnmpString.toHexString(fcId, 0, 3, true);
    }

    static String fcIfNxCosSuppAgreed(int[] index) {
        return "08:00";
    }

    static String fcNameServerClassOfSvc(int[] index) {
        return "0d:00";
    }

    static String fcNameServerProcAssoc(int[] index) {
        return "ff:ff:ff:ff:ff:ff:ff:ff";
    }

    static String fcNameServerPortType(int[] index) {
        return "2";
    }

    static String fcNameServerFabricPortName(int[] index) {
        int[] wwn = new int[]{80, 5, 48, 0, 0, 0, index[2], index[3]};
        return SnmpString.toHexString(wwn, 0, wwn.length, true);
    }

    static String fcNameServerHardAddress(int[] index) {
        return "00:00:00";
    }

    static String fcNameServerFC4Type(int[] index) {
        return index[3] % 2 == 0 ? "\"" : "00:01";
    }

    static String dmAssignedAreaIdList(int[] index) {
        return "17:2d:38:eb";
    }

    static String dmAreaAssignedPortIdList(int[] index) {
        return "17:2d:38:eb";
    }

    static String dmDatabaseSwitchWwn(int[] index) {
        return ProxyStub.getSwitchWwn(index);
    }

    static String vsanName(int[] index) {
        return "Vsan" + index[0];
    }

    static String fspfIfNbrPortIndex(int[] index) {
        return Integer.toString(index[0]);
    }

    static String fspfLsrAdvDomainId(int[] index) {
        return Integer.toString(index[1]);
    }

    static String fspfLsrLinks(int[] index) {
        return "2";
    }

    static String fspfLsrAge(int[] index) {
        return ProxyStub.getRand(10);
    }

    static String fspfLsrIncarnationNumber(int[] index) {
        return "1";
    }

    static String fspfLsrCheckSum(int[] index) {
        return ProxyStub.getRand(1000);
    }

    static String fspfLinkNbrDomainId(int[] index) {
        int nd = index[1] + 1;
        if (nd == 4) {
            nd = 1;
        }
        return Integer.toString(nd);
    }

    static String fspfLinkPortIndex(int[] index) {
        return Integer.toString(0x1000000 + (index[3] << 12));
    }

    static String fspfLinkNbrPortIndex(int[] index) {
        return Integer.toString(0x1000000 + (index[3] << 12));
    }

    static String fspfLinkCost(int[] index) {
        return ProxyStub.getRand(10);
    }

    static String getRand(int n) {
        return Integer.toString((int)((double)n * Math.random()));
    }

    static String zoneSetName(int[] index) {
        return "ZoneSet" + index[1];
    }

    static String zoneSetZoneList(int[] index) {
        return index[1] == 1 ? "e0:00" : "1c:00";
    }

    static String zoneSetAdminStatus(int[] index) {
        return index[1] == 1 ? "1" : "2";
    }

    static String zoneSetOperStatus(int[] index) {
        return index[1] == 1 ? "1" : "2";
    }

    static String zoneAliasName(int[] index) {
        return "Alias" + index[1];
    }

    static String zoneName(int[] index) {
        return "Zone" + index[1];
    }

    static String zoneMemberList(int[] index) {
        byte[] b = new byte[4];
        int j = index[1] * 2 - 1;
        SnmpString.setBit(b, j);
        SnmpString.setBit(b, j + 1);
        return SnmpString.toHexString(b);
    }

    static String zoneMemberFormat(int[] index) {
        return "1";
    }

    static String zoneMemberID(int[] index) {
        if (index[1] == 2) {
            int id = index[3] % 6 + 2;
            return index[2] % 2 == 0 ? ProxyStub.getHBAWwn(1, id, false) : ProxyStub.getDiskWwn(1, id, false);
        }
        int id = index[3] % 8;
        return index[3] % 2 == 0 ? ProxyStub.getHBAWwn(1, id, false) : ProxyStub.getDiskWwn(1, id, false);
    }

    static String fcIfWwn(int[] index) {
        int[] wwn = new int[]{80, 5, 48, 0, 0, 0, index[0] >> 19 & 0x1F, index[0] >> 12 & 0x7F};
        return SnmpString.toHexString(wwn, 0, wwn.length, true);
    }

    static String ifAdminStatus(int[] index) {
        int port = index[0] >> 12 & 0x7F;
        if (port == 15) {
            return "1";
        }
        if (port <= 7) {
            return "1";
        }
        return "2";
    }

    static String ifOperStatus(int[] index) {
        int port = index[0] >> 12 & 0x7F;
        if (port <= 7) {
            return "1";
        }
        return "2";
    }

    static String fcIfOperMode(int[] index) {
        int port = index[0] >> 12 & 0x7F;
        if (port <= 2) {
            return "4";
        }
        if (port <= 7) {
            return "2";
        }
        return "1";
    }

    static String fcIfAdminTrunkMode(int[] index) {
        if ((index[0] >> 12 & 0x7F) < 3) {
            return "2";
        }
        return "1";
    }

    static String fcIfOperTrunkMode(int[] index) {
        if ((index[0] >> 12 & 0x7F) < 3) {
            return "2";
        }
        return "1";
    }

    static String fcIfOperStatusCause(int[] index) {
        int port = index[0] >> 12 & 0x7F;
        if (port == 15) {
            int error = (index[0] >> 19 & 0x1F) + 2;
            return Integer.toString(error);
        }
        if (port <= 8) {
            return "1";
        }
        return "1";
    }

    static String fcIfAdminSpeed(int[] index) {
        return "1";
    }

    static String fcIfBeaconMode(int[] index) {
        return "1";
    }

    static String fcIfPortChannelIfIndex(int[] index) {
        if ((index[0] >> 19 & 0x1F) == 0 && (index[0] >> 12 & 0x7F) < 2) {
            return "67108864";
        }
        return "0";
    }

    static String fcIfIcpIsolationCause(int[] index) {
        return "1";
    }

    static String fcIfFcphVersionHigh(int[] index) {
        return "2";
    }

    static String fcIfFcphVersionLow(int[] index) {
        return "2";
    }

    static String fcIfInBbCredit(int[] index) {
        return "1";
    }

    static String fcIfBbCreditAvailable(int[] index) {
        return "1";
    }

    static String fcIfBbCreditModel(int[] index) {
        return "1";
    }

    static String fcTimerRatov(int[] index) {
        return "50";
    }

    static String fcTimerEdtov(int[] index) {
        return "50";
    }

    static String fcTimerFstov(int[] index) {
        return "100";
    }

    static String fcTimerDstov(int[] index) {
        return "100";
    }

    static String fcIfHoldTime(int[] index) {
        return "200";
    }

    static String fcIfClass2SeqDeliv(int[] index) {
        return "1";
    }

    static String fcIfClass3SeqDeliv(int[] index) {
        return "1";
    }

    static String fcIfTransmitterType(int[] index) {
        return "3";
    }

    static String fcIfConnectorType(int[] index) {
        return "6";
    }

    static String fcIfSerialNo(int[] index) {
        return "\"" + index[0];
    }

    static String fcIfRevision(int[] index) {
        return "\"0.1";
    }

    static String fcIfVendor(int[] index) {
        return "\"QLogic";
    }

    static String fcIfElpCosSuppAgreed(int[] index) {
        return "0d:00";
    }

    static String fcIfCapCos(int[] index) {
        return "0d:00";
    }

    static String fcIfElpRxBbCredit(int[] index) {
        return "16";
    }

    static String fcIfElpTxBbCredit(int[] index) {
        return "16";
    }

    static String fcIfElpClass2SeqDelivAgreed(int[] index) {
        return "1024";
    }

    static String fcIfElpClass3SeqDelivAgreed(int[] index) {
        return "1024";
    }

    static String fcIfElpClassFRxDataFieldSize(int[] index) {
        return "1024";
    }

    static String fcIfElpClassFConcurrentSeq(int[] index) {
        return "1";
    }

    static String fcIfElpClassFEndToEndCredit(int[] index) {
        return "1";
    }

    static String fcIfElpClassFOpenSeq(int[] index) {
        return "1";
    }

    static String fcIfElpNbrNodeName(int[] index) {
        return ProxyStub.getSwitchWwn(index);
    }

    static String fcIfElpNbrPortName(int[] index) {
        return ProxyStub.getSwitchWwn(index);
    }

    static String entPhysicalDescr(int[] index) {
        switch (index[0]) {
            case 21: {
                return "\"Andiamo 9500 Backplane";
            }
            case 38: {
                return "\"AC1360W power supply";
            }
            case 39: {
                return "\"DC1360W power supply";
            }
            case 40: {
                return "\"Fan";
            }
        }
        return "\"Andiamo 9500 Module";
    }

    static String entPhysicalVendorType(int[] index) {
        if (index[0] < 22 || index[0] > 34) {
            return "1.3.6.1.4.1.9524.1";
        }
        int slot = index[0] - 22;
        switch (_numCards) {
            case 9: {
                if (slot < 4 || slot > 5) break;
                return "1.3.6.1.4.1.9524.6.1.1.7.4.1";
            }
            case 2: {
                if (slot != 0) break;
                return "1.3.6.1.4.1.9524.6.1.1.7.4.1";
            }
            case 6: {
                if (slot != 2 && slot != 3) break;
                return "1.3.6.1.4.1.9524.6.1.1.7.4.1";
            }
            case 13: {
                if (slot < 6 || slot > 7) break;
                return "1.3.6.1.4.1.9524.6.1.1.7.4.1";
            }
        }
        return "1.3.6.1.4.1.9524.6.1.1.7.2.2";
    }

    static String entPhysicalContainedIn(int[] index) {
        return "1";
    }

    static String entPhysicalClass(int[] index) {
        switch (index[0]) {
            case 21: {
                return "4";
            }
            case 38: 
            case 39: {
                return "6";
            }
            case 40: {
                return "7";
            }
        }
        return "9";
    }

    static String entPhysicalName(int[] index) {
        return ProxyStub.entPhysicalDescr(index);
    }

    static String entPhysicalHardwareRev(int[] index) {
        return "\"1.0";
    }

    static String entPhysicalFirmwareRev(int[] index) {
        return "\"1.0";
    }

    static String entPhysicalSoftwareRev(int[] index) {
        return "\"1.0";
    }

    static String entPhysicalMfgName(int[] index) {
        return "\"Cisco";
    }

    static String entPhysicalModelName(int[] index) {
        return "\"Andiamo 9500";
    }

    static String cefcPowerUnits(int[] index) {
        return "\"MilliAmps @ 42V";
    }

    static String entSensorThresholdSeverity(int[] index) {
        return "10";
    }

    static String entSensorThresholdRelation(int[] index) {
        return "1";
    }

    static String ciscoImageString(int[] index) {
        return "SoftwareImage V" + index[0];
    }

    static String cefcModuleOperStatus(int[] index) {
        return "2";
    }

    static String cefcFRUPowerOperStatus(int[] index) {
        return "2";
    }

    static String portChannelIfIndex(int[] index) {
        return Integer.toString(0x4000000 + index[0]);
    }

    static String portChannelMemberList(int[] index) {
        return "01:00:00:00:01:00:10:00";
    }

    static String cpmProcessName(int[] index) {
        int id = index[1];
        for (int i = 0; i < _Severity.length; ++i) {
            if (_Severity[i].getValue() != id) continue;
            return _Severity[i].getLabel();
        }
        return "huh?";
    }

    static String crRadiusServerType(int[] index) {
        return index[4] == 1 ? "1" : "2";
    }

    static String syslogMessageSeverity(int[] index) {
        return "4";
    }

    static String fcRouteDomainId(int[] index) {
        return Integer.toString(index[1]);
    }

    static String fcRouteInterface(int[] index) {
        return index[1] / 8 == 0 ? "16777216" : "16781312";
    }

    static String getSwitchWwn(int[] index) {
        byte[] b = new byte[]{(byte)index[0]};
        return _SwitchWwn[index[0] % _SwitchWwn.length] + ":00:00:" + SnmpString.toHexString(b);
    }

    static String getHBAWwn(int card, int port, boolean isNode) {
        byte[] b = new byte[3];
        b[1] = (byte)card;
        b[2] = (byte)port;
        if (isNode) {
            b[0] = 1;
        }
        return _HBAWwn[card % _HBAWwn.length] + ":" + SnmpString.toHexString(b);
    }

    static String getDiskWwn(int card, int port, boolean isNode) {
        byte[] b = new byte[3];
        b[1] = (byte)card;
        b[2] = (byte)port;
        if (isNode) {
            b[0] = 1;
        }
        return _DiskWwn[card % _DiskWwn.length] + ":" + SnmpString.toHexString(b);
    }

    static {
        _ScalarIndex = new int[]{0};
        _CardTypes = new int[]{2, 2, 2, 2, 4, 4, 2, 2, 2};
        _Methods = new HashMap();
        _System = new String[]{"sysDescr", "sysObjectID", "sysUpTime", "sysContact", "sysName", "sysLocation", "sysServices", "sysORUpTime", "entLastChangeTime", "fcTimerRatov", "fcTimerEdtov", "fcTimerFstov", "fcTimerDstov"};
        _SnmpStats = new String[]{"snmpInPkts", "snmpOutPkts", "snmpInTotalReqVars", "snmpInTotalSetVars", "snmpInGetRequests", "snmpInGetNexts", "snmpInSetRequests", "snmpInGetResponses", "snmpOutTraps", "snmpOutTooBigs", "snmpOutNoSuchNames", "snmpOutBadValues", "snmpOutGenErrs", "snmpInBadVersions", "snmpInBadCommunityNames", "snmpInBadCommunityUses", "snmpInASNParseErrs", "snmpInTooBigs", "snmpInNoSuchNames", "snmpInBadValues", "snmpInReadOnlys", "snmpInGenErrs", "snmpEnableAuthenTraps"};
        _If = new String[]{"ifIndex", "ifDescr", "ifType", "ifMtu", "ifSpeed", "ifPhysAddress", "ifAdminStatus", "ifOperStatus", "ifLastChange", "ifInOctets", "ifInUcastPkts", "ifInDiscards", "ifInErrors", "ifInUnknownProtos", "ifOutOctets", "ifOutUcastPkts", "ifOutDiscards", "ifOutErrors"};
        _IfX = new String[]{"ifName", "ifInMulticastPkts", "ifInBroadcastPkts", "ifOutMulticastPkts", "ifOutBroadcastPkts", "ifHCInOctets", "ifHCInUcastPkts", "ifHCInMulticastPkts", "ifHCInBroadcastPkts", "ifHCOutOctets", "ifHCOutUcastPkts", "ifHCOutMulticastPkts", "ifHCOutBroadcastPkts", "ifLinkUpDownTrapEnable", "ifHighSpeed", "ifPromiscuousMode", "ifConnectorPresent", "ifAlias", "ifCounterDiscontinuityTime"};
        _Ent = new String[]{"entPhysicalDescr", "entPhysicalVendorType", "entPhysicalContainedIn", "entPhysicalClass", "entPhysicalParentRelPos", "entPhysicalName", "entPhysicalHardwareRev", "entPhysicalFirmwareRev", "entPhysicalSoftwareRev", "entPhysicalSerialNum", "entPhysicalMfgName", "entPhysicalModelName", "entPhysicalAlias", "entPhysicalAssetID", "entPhysicalIsFRU"};
        _CefcModule = new String[]{"cefcModuleAdminStatus", "cefcModuleOperStatus", "cefcModuleResetReason", "cefcModuleStatusLastChangeTime", "cefcFRUPowerAdminStatus", "cefcFRUPowerOperStatus", "cefcFRUCurrent"};
        _EntPower = new String[]{"cefcFRUPowerAdminStatus", "cefcFRUPowerOperStatus", "cefcFRUCurrent", "cefcPowerRedundancyMode", "cefcPowerUnits", "cefcTotalAvailableCurrent", "cefcTotalDrawnCurrent", "entSensorType", "entSensorScale", "entSensorPrecision", "entSensorValue", "entSensorStatus", "entSensorValueTimeStamp", "entSensorValueUpdateRate"};
        _EntFan = new String[]{"andPhysEntFanOperStatus"};
        _EntSensorThreshold = new String[]{"entSensorThresholdSeverity", "entSensorThresholdRelation", "entSensorThresholdValue", "entSensorThresholdEvaluation", "entSensorThresholdNotificationEnable"};
        _PortChannel = new String[]{"portChannelIfIndex", "portChannelAdminChannelMode", "portChannelOperChannelMode", "portChannelAddType", "portChannelLastActionStatus", "portChannelLastActionStatusCause", "portChannelLastActionTime", "portChannelMemberList", "portChannelCreationTime", "portChannelRowStatus"};
        _CcCopy = new String[]{"ccCopyIndex", "ccCopyProtocol", "ccCopySourceFileType", "ccCopyDestFileType", "ccCopyServerAddress", "ccCopyFileName", "ccCopyUserName", "ccCopyUserPassword", "ccCopyNotificationOnCompletion", "ccCopyState", "ccCopyTimeStarted", "ccCopyTimeCompleted", "ccCopyFailCause", "ccCopyEntryRowStatus"};
        _CImage = new String[]{"ciscoImageIndex", "ciscoImageString"};
        _IpStat = new String[]{"ipDefaultTTL", "ipInReceives", "ipInHdrErrors", "ipInAddrErrors", "ipForwDatagrams", "ipInUnknownProtos", "ipInDiscards", "ipInDelivers", "ipOutRequests", "ipOutDiscards", "ipOutNoRoutes", "ipReasmTimeout", "ipReasmReqds", "ipReasmOKs", "ipReasmFails", "ipFragOKs", "ipFragFails", "ipFragCreates"};
        _IcmpStat = new String[]{"icmpInMsgs", "icmpInErrors", "icmpInDestUnreachs", "icmpInTimeExcds", "icmpInParmProbs", "icmpInSrcQuenchs", "icmpInRedirects", "icmpInEchos", "icmpInEchoReps", "icmpInTimestamps", "icmpInTimestampReps", "icmpInAddrMasks", "icmpInAddrMaskReps", "icmpOutMsgs", "icmpOutErrors", "icmpOutDestUnreachs", "icmpOutTimeExcds", "icmpOutParmProbs", "icmpOutSrcQuenchs", "icmpOutRedirects", "icmpOutEchos", "icmpOutEchoReps", "icmpOutTimestamps", "icmpOutTimestampReps", "icmpOutAddrMasks", "icmpOutAddrMaskReps"};
        _Domain = new String[]{"dmConfigDomainId", "dmConfigDomainIdType", "dmEnable", "dmAutoReconfigure", "dmContiguousAllocation", "dmPriority", "dmRestart", "dmFabricName", "dmPrincipalSwitchWwn", "dmLocalSwitchWwn", "dmAssignedAreaIdList", "dmFcIdsGranted", "dmFcIdsRecovered"};
        _DomainArea = new String[]{"dmAreaAssignedPortIdList"};
        _DomainDB = new String[]{"dmDatabaseSwitchWwn"};
        _DomainCache = new String[]{"dmFcIdCacheAreaIdPortId", "dmFcIdCachePortIds", "dmFcIdCacheAge"};
        _Vsan = new String[]{"vsanName", "vsanMediaType", "vsanAdminState", "vsanMtu", "vsanInorderDelivery", "vsanRowStatus"};
        _VsanIf = new String[]{"vsanIfVsan"};
        _FcIf = new String[]{"fcIfWwn", "fcIfAdminMode", "fcIfOperMode", "fcIfAdminSpeed", "fcIfBeaconMode", "fcIfPortChannelIfIndex", "fcIfOperStatusCause", "fcIfAdminTrunkMode", "fcIfOperTrunkMode", "fcIfAllowedVsanList2k", "fcIfAllowedVsanList4k", "fcIfActiveVsanList2k", "fcIfActiveVsanList4k", "fcIfBbCreditModel", "fcIfHoldTime", "fcIfTransmitterType", "fcIfConnectorType", "fcIfSerialNo", "fcIfRevision", "fcIfVendor"};
        _FcFlogi = new String[]{"fcIfNxPortNodeName", "fcIfNxPortName", "fcIfNxPortAddress", "fcIfNxFcphVersionAgreed", "fcIfNxRxBbCredit", "fcIfNxTxBbCredit", "fcIfNxClass2RxDataFieldSize", "fcIfNxClass3RxDataFieldSize", "fcIfNxCosSuppAgreed", "fcIfNxClass2SeqDelivAgreed", "fcIfNxClass3SeqDelivAgreed"};
        _FcCap = new String[]{"fcIfCapFcphVersionHigh", "fcIfCapFcphVersionLow", "fcIfCapBbCreditMax", "fcIfCapBbCreditMin", "fcIfCapRxDataFieldSizeMax", "fcIfCapRxDataFieldSizeMin", "fcIfCapCos", "fcIfCapClass2SeqDeliv", "fcIfCapClass3SeqDeliv", "fcIfCapHoldTimeMax", "fcIfCapHoldTimeMin"};
        _FcELP = new String[]{"fcIfElpNbrNodeName", "fcIfElpNbrPortName", "fcIfElpRxBbCredit", "fcIfElpTxBbCredit", "fcIfElpCosSuppAgreed", "fcIfElpClass2SeqDelivAgreed", "fcIfElpClass2RxDataFieldSize", "fcIfElpClass3SeqDelivAgreed", "fcIfElpClass3RxDataFieldSize", "fcIfElpClassFXII", "fcIfElpClassFRxDataFieldSize", "fcIfElpClassFConcurrentSeq", "fcIfElpClassFEndToEndCredit", "fcIfElpClassFOpenSeq"};
        _FcStat = new String[]{"fcIfLinkFailures", "fcIfSyncLosses", "fcIfSigLosses", "fcIfPrimSeqProtoErrors", "fcIfInvalidTxWords", "fcIfInvalidCrcs", "fcIfDelimiterErrors", "fcIfAddressIdErrors", "fcIfLinkResetIns", "fcIfLinkResetOuts", "fcIfOlsIns", "fcIfOlsOuts", "fcIfRuntFramesIn", "fcIfJabberFramesIn", "fcIfTxWaitCount", "fcIfFramesTooLong", "fcIfFramesTooShort", "fcIfLRRIn", "fcIfLRROut", "fcIfNOSIn", "fcIfNOSOut", "fcIfFragFrames", "fcIfEOFaFrames", "fcIfUnknownClassFrames", "fcIf8b10bDisparityErrors", "fcIfFramesDiscard", "fcIfELPFailures", "fcIfBBCreditTransistionFromZero", "fcIfFramingErrorFrames", "fcIfEISLFramesDiscard"};
        _FcC2Stat = new String[]{"fcIfC2InFrames", "fcIfC2OutFrames", "fcIfC2InOctets", "fcIfC2OutOctets", "fcIfC2Discards", "fcIfC2FbsyFrames", "fcIfC2FrjtFrames", "fcIfC2PBSYFrames", "fcIfC2PRJTFrames"};
        _FcC3Stat = new String[]{"fcIfC3InFrames", "fcIfC3OutFrames", "fcIfC3InOctets", "fcIfC3OutOctets", "fcIfC3Discards"};
        _FcCfStat = new String[]{"fcIfCfInFrames", "fcIfCfOutFrames", "fcIfCfInOctets", "fcIfCfOutOctets", "fcIfCfDiscards"};
        _FcName = new String[]{"fcNameServerPortName", "fcNameServerNodeName", "fcNameServerClassOfSvc", "fcNameServerNodeIpAddress", "fcNameServerProcAssoc", "fcNameServerFC4Type", "fcNameServerPortType", "fcNameServerPortIpAddress", "fcNameServerFabricPortName", "fcNameServerHardAddress", "fcNameServerSymbolicPortName", "fcNameServerSymbolicNodeName", "fcNameServerFC4Features"};
        _FcNameStat = new String[]{"fcNameServerInGetReqs", "fcNameServerOutGetReqs", "fcNameServerInRegReqs", "fcNameServerInDeRegReqs", "fcNameServerInRscns", "fcNameServerOutRscns", "fcNameServerRejects"};
        _Fspf = new String[]{"fspfRegionId", "fspfDomainId", "fspfSpfDelay", "fspfSpfHoldTime", "fspfMinLsArrival", "fspfMinLsInterval", "fspfLsRefreshTime", "fspfMaxAge", "fspfMaxAgeCount", "fspfSpfComputations", "fspfChecksumErrors", "fspfLsuRxPkts", "fspfLsaRxPkts", "fspfLsuTxPkts", "fspfLsaTxPkts", "fspfHelloTxPkts", "fspfHelloRxPkts", "fspfRetransmittedLsuTxPkts", "fspfErrorRxPkts", "fspfLsrs", "fspfCreateTime", "fspfAdminStatus", "fspfOperStatus", "fspfSetToDefault", "fspfRowStatus"};
        _FspfIf = new String[]{"fspfIfCost", "fspfIfHelloInterval", "fspfIfDeadInterval", "fspfIfRetransmitInterval", "fspfIfLsuRxPkts", "fspfIfLsaRxPkts", "fspfIfLsuTxPkts", "fspfIfLsaTxPkts", "fspfIfHelloTxPkts", "fspfIfHelloRxPkts", "fspfIfRetransmittedLsuTxPkts", "fspfIfErrorRxPkts", "fspfIfInactivityExpirations", "fspfIfNbrDomainId", "fspfIfNbrPortIndex", "fspfIfNbrState", "fspfIfAdminStatus", "fspfIfCreateTime", "fspfIfRowStatus"};
        _FspfLsr = new String[]{"fspfLsrAdvDomainId", "fspfLsrAge", "fspfLsrIncarnationNumber", "fspfLsrCheckSum", "fspfLsrLinks"};
        _FspfLink = new String[]{"fspfLinkNbrDomainId", "fspfLinkPortIndex", "fspfLinkNbrPortIndex", "fspfLinkType", "fspfLinkCost"};
        _ZoneSet = new String[]{"zoneSetName", "zoneSetZoneList", "zoneSetRowStatus"};
        _Zone = new String[]{"zoneName", "zoneMemberList", "zoneAliasList", "zoneRowStatus"};
        _ZoneAlias = new String[]{"zoneAliasName", "zoneAliasMemberList", "zoneAliasRowStatus"};
        _ZoneMember = new String[]{"zoneMemberFormat", "zoneMemberID", "zoneMemberLunID", "zoneMemberRowStatus"};
        _ZoneScalar = new String[]{"zoneDefaultZoneBehaviour", "zoneServiceReqRejNotifyEnable", "zoneMergeSuccessNotifyEnable", "zoneMergeFailureNotifyEnable", "zoneTotalGS3Rejects"};
        _ZoneStats = new String[]{"zoneTxMergeReqs", "zoneRxMergeAccepts", "zoneRxMergeReqs", "zoneTxMergeAccepts", "zoneTxChangeReqs", "zoneRxChangeAccepts", "zoneRxChangeReqs", "zoneTxChangeAccepts", "zoneRxGS3Reqs", "zoneTxGS3Rejects"};
        _TcpConn = new String[]{"tcpConnState"};
        _Tcp = new String[]{"tcpRtoAlgorithm", "tcpRtoMin", "tcpRtoMax", "tcpMaxConn", "tcpActiveOpens", "tcpPassiveOpens", "tcpAttemptFails", "tcpEstabResets", "tcpCurrEstab", "tcpInSegs", "tcpOutSegs", "tcpRetransSegs", "tcpInErrs", "tcpOutRsts"};
        _Vrrp = new String[]{"vrrpOperState", "vrrpOperAdminState", "vrrpOperPriority", "vrrpOperIpAddrCount", "vrrpOperMasterIpAddr", "vrrpOperPrimaryIpAddr", "vrrpOperAuthType", "vrrpOperAuthKey", "vrrpOperAdvertisementInterval", "vrrpOperPreemptMode", "vrrpOperVirtualRouterUpTime", "vrrpOperProtocol", "vrrpOperRowStatus", "vrrpStatsBecomeMaster", "vrrpStatsAdvertiseRcvd", "vrrpStatsAdvertiseIntervalErrors", "vrrpStatsAuthFailures", "vrrpStatsIpTtlErrors", "vrrpStatsPriorityZeroPktsRcvd", "vrrpStatsPriorityZeroPktsSent", "vrrpStatsInvalidTypePktsRcvd", "vrrpStatsAddressListErrors", "vrrpStatsInvalidAuthType", "vrrpStatsAuthTypeMismatch", "vrrpStatsPacketLengthErrors"};
        _VrrpScalars = new String[]{"vrrpNotificationCntl", "vrrpRouterChecksumErrors", "vrrpRouterVersionErrors", "vrrpRouterVrIdErrors"};
        _SysModule = new String[]{"cpmProcessName", "cpmProcessuSecs", "cpmProcessTimeCreated", "cpmProcExtMemAllocated", "cpmProcExtMemFreed", "cpmProcExtInvoked", "cpmProcExtRuntime", "cpmProcExtMemAllocated", "cpmProcExtUtil5Sec", "cpmProcExtUtil1Min", "cpmProcExtUtil5Min", "cpmProcExtPriority"};
        _SysScalars = new String[]{"sysCPUUtilization", "sysMemoryUtilization", "crRadiusLoginAuthentication", "crRadiusDeadtime", "crRadiusAuthKey", "crRadiusTimeout", "crRadiusRetransmits", "crRadiusServerTableMaxEntries", "syslogConsoleEnable", "syslogConsoleMsgSeverity", "syslogLogFileName", "syslogLogFileMsgSeverity", "syslogServerTableMaxEntries"};
        _SysRadius = new String[]{"crRadiusServerAuthPort", "crRadiusServerType"};
        _SysLog = new String[]{"syslogServerAddressType", "syslogServerAddress", "syslogServerMsgSeverity", "syslogServerStatus"};
        _SysLogSeverity = new String[]{"syslogMessageSeverity"};
        _FcRouteEntry = new String[]{"fcRouteInterface", "fcRouteDomainId", "fcRouteMetric", "fcRouteType", "fcRoutePermanent"};
        _FcRouteScalar = new String[]{"fcRouteLastChangeTime", "fcRoutePreference", "fcRouteVerifyAction", "fcRouteVerifyType", "fcRouteVerifyModule", "fcRouteVerifyVsanID", "fcRouteVerifyRouteType", "fcRouteVerifyResult", "fcRouteVerifyLock"};
        _WwnM = new String[]{"wwnmSecondaryBaseMacAddress", "wwnmSecondaryMacAddressRange", "wwnmType1MaxWwns", "wwnmType1AvailableWwns", "wwnmTypeOtherMaxWwns", "wwnmTypeOtherAvailableWwns"};
        _CallHome = new String[]{"callHomeEnable", "sysContactPhoneNumber", "sysContactEmailAddress", "sysStreetAddress", "callHomeCustomerId", "callHomeContractId", "callHomeSiteId", "callHomeDeviceServicePriority", "callHomeEmailFrom", "callHomeEmailReplyTo", "callHomeEmailMsgDispNotification", "callHomeSmtpServerAddrType", "callHomeSmtpServerAddr", "callHomeSmtpServerPort", "callHomeLastAlertSent", "callHomeAlerts"};
        _CallHomeProfile = new String[]{"callHomeDestProfileMsgFormat", "callHomeDestProfileMaxMsgSize", "callHomeDestProfileTrnsprtMthd", "callHomeDestProfileStatus"};
        _CallHomeEmail = new String[]{"callHomeDestEmailAddress", "callHomeDestEmailAddressStatus"};
        _SwitchWwn = new String[]{"10:00:00:c0:dd", "10:00:00:60:69", "10:00:00:00:88", "10:00:00:60:df", "10:00:00:10:9b", "50:05:30:00:00"};
        _HBAWwn = new String[]{"10:00:00:01:79", "10:00:00:00:c9", "10:00:00:07:96", "10:00:00:90:66", "10:00:00:00:77", "10:00:00:a0:b8"};
        _DiskWwn = new String[]{"20:00:00:60:48", "20:00:00:e0:02", "20:00:00:e0:10", "20:00:00:20:37", "20:00:00:02:55", "20:00:00:20:F2", "50:1f:e1:00:00"};
    }
}

