/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SnmpWalk {
    static void walk(String addr, int port, String outFile, String community, int timeout, int retries) throws SocketException, SnmpException, UnknownHostException, IOException {
        SnmpSession session = SnmpSession.getInstance();
        session.open();
        SnmpPeer peer = new SnmpPeer(InetAddress.getByName(addr));
        peer.setSession(session);
        SnmpPeer.addPeer(peer);
        peer.setPort(port);
        peer.setReadCommunity(community);
        peer.setTimeout(timeout);
        peer.setRetries(retries);
        PrintStream os = new PrintStream(new FileOutputStream(outFile));
        os.println("# <OID> <TYPE> <VALUE>");
        os.println("# <TYPE>: integer(1), string(4), objectId(6), ipAddress(64), counter(65), gauge(66), unsigned32(66), timeTicks(67)");
        SnmpPDU pdu = new SnmpPDU(-95, new VarBindList(1));
        int[] index = new int[]{1};
        pdu.addNull(new SnmpOID(index));
        try {
            SnmpWalk.walk(peer, pdu, os);
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
        System.out.println("#end");
        os.close();
    }

    static void walk(SnmpPeer peer, SnmpPDU pdu, PrintStream os) throws Exception {
        while (true) {
            SnmpVarBind vb;
            SnmpPDU resp;
            if ((resp = peer.send(pdu)).getError() != 0) {
                System.out.println(resp);
            }
            if ((vb = resp.getVariables().getVb(0)).getError() == 21) {
                return;
            }
            SnmpWalk.dumpVb(vb, os);
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(vb.getOid()));
            pdu = new SnmpPDU(-95, vbl);
        }
    }

    static void dumpVb(SnmpVarBind vb, PrintStream os) {
        StringBuffer sb = new StringBuffer(80);
        sb.append(MibNode.oidToName(vb.getOid().getValue()));
        sb.append(' ');
        sb.append(vb.getVar().getType());
        sb.append(' ');
        if (vb.getVar().getType() == 67) {
            sb.append(((SnmpTimeticks)vb.getVar()).getValue());
        } else {
            sb.append(vb.getVar());
        }
        os.println(sb.toString());
    }
}

