/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.tools.Agent;
import com.cisco.dcbu.tools.OidRegisterIf;
import java.net.InetAddress;

public class TestOidRegistration
implements OidRegisterIf {
    static final int[] _IfIndex = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 1};
    static final int[] _IfAdminStatus = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 7};
    static final int[] _IfOperStatus = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 8};

    @Override
    public void init(Agent agent) {
        agent.oidRegister(_IfAdminStatus, this);
    }

    @Override
    public void oidRegisterCallback(Agent agent, VarBindList vblist, int index, InetAddress sourceAddress) {
        SnmpVarBind vb = vblist.getVb(index);
        int[] oid = vb.getOid().getValue();
        int ifIndex = oid[oid.length - 1];
        oid[oid.length - 2] = 8;
        int k = agent.findKey(oid);
        if (k != -1) {
            agent.setValue(vb.getVar(), k);
        }
        VarBindList vbl = new VarBindList();
        int[] trapInstance = new int[2];
        int type = ((SnmpInt)vb.getVar()).getValue() == 1 ? 4 : 3;
        trapInstance[0] = type - 1;
        vbl.add(new SnmpVarBind(new SnmpOID(SnmpPDU.getTrapPrefix(), trapInstance), new SnmpInt(1)));
        vbl.add(new SnmpVarBind(new SnmpOID(_IfIndex, 0), new SnmpInt(ifIndex)));
        int status = type == 3 ? 2 : 1;
        vbl.add(new SnmpVarBind(new SnmpOID(_IfAdminStatus, 0), new SnmpInt(status)));
        vbl.add(new SnmpVarBind(new SnmpOID(_IfOperStatus, 0), new SnmpInt(status)));
        agent.sendTrap(sourceAddress, vbl);
    }
}

