/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.vi.discover;

import com.cisco.dcbu.lib.util.NameValuePair;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.ScheduledTask;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.sm.common.dto.DiscoveryState;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.model.DataCenterImpl;
import com.cisco.dcbu.sm.server.model.DataStoreImpl;
import com.cisco.dcbu.sm.server.model.GlobalViManager;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.vi.discover.AbstractVmWareWorker;
import com.cisco.dcbu.vi.discover.DataCenterWorker;
import com.cisco.dcbu.vi.discover.DiscProc;
import com.cisco.dcbu.vi.discover.WorkerCallbackIf;
import com.cisco.dcbu.vi.discover.WorkerIf;
import com.cisco.dcbu.vi.model.ViManager;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.DatacenterEvent;
import com.vmware.vim25.DatastoreEvent;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.Event;
import com.vmware.vim25.EventFilterSpec;
import com.vmware.vim25.EventFilterSpecByEntity;
import com.vmware.vim25.EventFilterSpecByTime;
import com.vmware.vim25.EventFilterSpecRecursionOption;
import com.vmware.vim25.HostEvent;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotImplemented;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VmEvent;
import com.vmware.vim25.mo.EventHistoryCollector;
import com.vmware.vim25.mo.EventManager;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VCenterWorker
extends ScheduledTask
implements WorkerIf,
WorkerCallbackIf {
    static final int DISC_ALL = 65535;
    AtomicInteger _status = new AtomicInteger(0);
    private VirtualCenterImpl _vc;
    DiscoveryType _discType;
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    List<WorkerIf> _workers = Collections.synchronizedList(new ArrayList());
    boolean _timeout = false;
    int _pollNumber = 0;
    private ServiceInstance _si = null;
    private ServiceContent _sc = null;
    Collection<NameKey> _preVHostPKs = null;
    Collection<NameKey> _preDsPKs = null;
    private Lock runlocker = new ReentrantLock();
    boolean _needRediscover = false;

    public VCenterWorker(VirtualCenterImpl vc, int pollInterval) {
        super("VCenterWorker-" + vc.getPK().toString(), new Schedule(pollInterval * 1000, (long)(pollInterval * 1000), false));
        this._vc = vc;
        SchedulerSingleton.getInstance().addTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block15: {
            if (!this.runlocker.tryLock()) break block15;
            if (this._status.get() == 1) {
                if (System.currentTimeMillis() - this._vc.getLastScanTime() < this._vc.getDiscoveryTimeout()) {
                    return;
                }
                VCenterWorker._Logger.info((Object)(this + ": Start Discovery at " + new Date() + " while previous still running at " + new Date(this._vc.getLastScanTime())));
            }
            while (true) lbl-1000:
            // 5 sources

            {
                try {
                    if (VCenterWorker._Logger.isInfoEnabled()) {
                        VCenterWorker._Logger.info((Object)(this + " starts a discovery"));
                    }
                    this._needRediscover = false;
                    this.discover();
                    if (!VCenterWorker._Logger.isInfoEnabled()) ** GOTO lbl-1000
                    VCenterWorker._Logger.info((Object)(this + " ends a discovery"));
                }
                catch (Throwable ex) {
                    this.setTimeout(true);
                    VCenterWorker._Logger.error((Object)(this + " error: " + ex.getMessage()), ex);
                }
                finally {
                    if (!this._needRediscover) {
                        this._status.compareAndSet(1, 5);
                        ** continue;
                    }
                    this._discType = DiscoveryType.VI_POLL;
                    continue;
                }
lbl16:
                // 1 sources

                while (true) {
                    break block15;
                    break;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                this.runlocker.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " stops the VCenter worker"));
        }
        Object object = this._status;
        synchronized (object) {
            if (this._status.get() == 1) {
                this._status.set(2);
                this._status.notifyAll();
            }
        }
        object = this._workers;
        synchronized (object) {
            Iterator<WorkerIf> it = this._workers.iterator();
            while (it.hasNext()) {
                it.next().stop();
                it.remove();
            }
        }
    }

    public boolean isDiscovering() {
        return this._status.get() == 1;
    }

    public String toString() {
        return this._vc.getIpAddress() + "-VCenterWorker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(WorkerIf worker, DiscProc proc, int status) {
        if (worker.getStatus() != 1) {
            List<WorkerIf> list = this._workers;
            synchronized (list) {
                if (this._workers.remove(worker)) {
                    if (worker.getStatus() == 4) {
                        this.setTimeout(true);
                    }
                    if (this._workers.size() == 0) {
                        this._workers.notifyAll();
                    }
                }
            }
        }
    }

    public void start(DiscoveryType type) {
        if (this._status.get() == 1 && System.currentTimeMillis() - this._vc.getLastScanTime() < this._vc.getDiscoveryTimeout()) {
            if (this._discType == DiscoveryType.VI_POLL && type == DiscoveryType.VI_ONDEMAND) {
                this._needRediscover = true;
            }
            return;
        }
        this._discType = type;
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " starts a vi discovery -- " + (Object)((Object)type)));
        }
        DiscoveryManager.getInstance().getViWorkerExecutor().execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    void discover() {
        block60: {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " enter discover()"));
            }
            if (!this._vc.getDiscovery()) {
                return;
            }
            AtomicInteger atomicInteger = this._status;
            synchronized (atomicInteger) {
                if (this._status.get() == 1) {
                    _Logger.debug((Object)(this + ": Skip this discovery cycle because another one is in progress."));
                    return;
                }
                this._status.set(1);
            }
            if (this._vc == null || this._vc.getIpAddress() == null) {
                return;
            }
            if (this._vc.getNumHosts() == 0) {
                this._discType = DiscoveryType.VI_INITIAL;
            } else if (this._discType == null) {
                this._discType = DiscoveryType.VI_POLL;
            }
            if (this._discType == DiscoveryType.VI_POLL && ++this._pollNumber % this._vc.getRediscoverInterval() == 0) {
                this._discType = DiscoveryType.VI_ONDEMAND;
            }
            if (this._discType == DiscoveryType.VI_ONDEMAND) {
                this._pollNumber = 0;
            }
            this.resetTimeout();
            DiscoveryState state = DiscoveryState.STARTED;
            StringBuffer errMsg = new StringBuffer();
            try {
                _Logger.log((Priority)(this._discType == DiscoveryType.VI_POLL ? Level.DEBUG : Level.INFO), (Object)(this._vc.getIpAddress() + " start " + (Object)((Object)this._discType)));
                this._vc.preDiscovery(this._discType);
                this._workers.clear();
                this._vc.setStatusDescription("Discovering");
                InventoryPersistentManager.getInstance().persistDBObject(this._vc);
                String serverAddr = this._vc.getIpAddress().getHostAddress();
                String username = this._vc.getUserName();
                String password = this._vc.getPassword();
                try {
                    URL url = ViManager.getInstance().createHttpsURL("https://" + serverAddr + "/sdk");
                    this._si = new ServiceInstance(url, username, password, true);
                    this._sc = this._si.getServiceContent();
                }
                catch (InvalidLogin e) {
                    this._vc.setLastUpdateTime(System.currentTimeMillis());
                    this._vc.setManageState(false);
                    this._vc.setStatusDescription("Invalid credential");
                    InventoryPersistentManager.getInstance().persistDBObject(this._vc);
                    _Logger.error((Object)"VCenter invalid login", (Throwable)e);
                    this._workers.clear();
                    this._discType = null;
                    if (this._si != null) {
                        this._si.getServerConnection().logout();
                    }
                    return;
                }
                catch (Exception e1) {
                    block59: {
                        this._vc.setLastUpdateTime(System.currentTimeMillis());
                        this._vc.setManageState(false);
                        this._vc.setStatusDescription("Failed to connect");
                        InventoryPersistentManager.getInstance().persistDBObject(this._vc);
                        _Logger.error((Object)"VCenterWorker create service instance failed", (Throwable)e1);
                        this._workers.clear();
                        this._discType = null;
                        if (this._si == null) break block59;
                        this._si.getServerConnection().logout();
                    }
                    return;
                }
                Folder rootFolder = this._si.getRootFolder();
                if (this._discType == DiscoveryType.VI_POLL) {
                    if (this.discoverEvents()) {
                        return;
                    }
                } else {
                    Calendar siCurrentTime = this._si.currentTime();
                    _Logger.debug((Object)("siCurrentTime is " + siCurrentTime.getTime()));
                    this._vc.setVcLastScanTime(siCurrentTime.getTimeInMillis());
                }
                _Logger.info((Object)("===Discover dataCenters for vCenter " + serverAddr + " ==="));
                ObjectContent[] ocs = this.getDatacenters();
                this.printObjectContent(ocs, "All Datacenters");
                if (ocs == null || ocs.length == 0) {
                    return;
                }
                this._preVHostPKs = this._vc.getAllHostPKs();
                this._preDsPKs = this._vc.getAllDataStorePKs();
                NameKey pkey = this._vc.getPK() == null ? null : (NameKey)this._vc.getPK();
                int ii = 0;
                for (ObjectContent oc : ocs) {
                    try {
                        ManagedObjectReference dcMoRef = oc.getObj();
                        if (dcMoRef == null) {
                            _Logger.warn((Object)("Datacenter[" + ii + "] : " + " has null MoRef"));
                            continue;
                        }
                        String dcName = (String)this.getProperties(dcMoRef, new String[]{"name"})[0];
                        _Logger.info((Object)("Datacenter[" + ii + "]=" + dcMoRef.getVal() + ":" + dcName));
                        ++ii;
                        this.startDataCenterWorker(new DataCenterImpl(null, dcName, dcMoRef), this._vc);
                    }
                    catch (Exception ex) {
                        _Logger.warn((Object)("starting data center worker failed" + ex.getMessage()));
                    }
                }
                Object arr$ = this._workers;
                synchronized (arr$) {
                    try {
                        if (this._workers.size() != 0) {
                            this._workers.wait(this._vc.getDiscoveryTimeout());
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (this._workers.size() != 0) {
                    this.setTimeout(true);
                    errMsg.append(this._workers.size()).append(" workers timed out").append('\n');
                    _Logger.warn((Object)(pkey + " " + (Object)((Object)this._discType) + " has " + this._workers.size() + " workers timed out"));
                    Iterator<WorkerIf> it = this._workers.iterator();
                    while (it.hasNext()) {
                        it.next().stop();
                        it.remove();
                    }
                } else {
                    _Logger.info((Object)(pkey + " " + (Object)((Object)this._discType) + " all dataCenter workers done in " + (System.currentTimeMillis() - this._vc.getLastScanTime()) + " ms"));
                }
                VirtualCenterBase vcBase = this._vc.getBaseObject() == null ? null : (VirtualCenterBase)this._vc.getBaseObject();
                String[] counters = new String[]{"disk.read.average", "disk.write.average"};
                List<NameValuePair> dUsages = ViManager.getInstance().getRealTimePMData("VirtualMachine", counters, this._si);
                List<VmImpl> vms = this._vc.getAllVms();
                if (dUsages == null) {
                    dUsages = new ArrayList<NameValuePair>();
                }
                for (NameValuePair dUsage : dUsages) {
                    double[][] iostat;
                    String moRef;
                    VmImpl vm;
                    ManagedObjectReference mor = (ManagedObjectReference)dUsage.getName();
                    if (mor == null || (vm = this._vc.findVmByPK(new NameKey(moRef = mor.getVal()))) == null) continue;
                    double[][] dArray = iostat = dUsage.getValue() == null ? (double[][])null : (double[][])dUsage.getValue();
                    if (iostat.length != 2) continue;
                    vm.setDiskReadAvg(iostat[0][1]);
                    vm.setDiskWriteAvg(iostat[1][1]);
                }
                this._vc.setManageState(true);
                this._vc.setStatusDescription("OK");
                try {
                    InventoryPersistentManager.getInstance().persistVmWare(this._vc);
                }
                catch (Throwable se) {
                    _Logger.warn((Object)("persist virtual center failed: " + se.getMessage()), se);
                }
                if (this._discType == DiscoveryType.VI_INITIAL || this._discType == DiscoveryType.VI_ONDEMAND) {
                    try {
                        if (this._vc.getVcPK() != null) {
                            GlobalViManager.getInstance().persistVCenterWithServer((VcenterPK)this._vc.getVcPK(), null);
                        }
                    }
                    catch (Exception ex) {
                        _Logger.warn((Object)(this.prefix() + "failed to register to the logic server map"), (Throwable)ex);
                    }
                }
                List<VHostImpl> hosts = this._vc.loadHostsFromDB();
                for (VHostImpl h : hosts) {
                    if (!this._preVHostPKs.contains(h.getPK())) continue;
                    this._preVHostPKs.remove(h.getPK());
                }
                for (NameKey vhostPK : this._preVHostPKs) {
                    try {
                        this._vc.removeHost(vhostPK);
                    }
                    catch (Exception e) {
                        _Logger.warn((Object)e.getMessage());
                    }
                }
                List<DataStoreImpl> dataStores = this._vc.loadDataStoresFromDB();
                for (DataStoreImpl d : dataStores) {
                    if (!this._preDsPKs.contains(d.getPK())) continue;
                    this._preDsPKs.remove(d.getPK());
                }
                for (NameKey dsPk : this._preDsPKs) {
                    this._vc.removeDataStore(dsPk);
                }
                state = DiscoveryState.ALL_FINISHED;
                DiscoveryManager.getInstance().notifyListenersDiscovery(pkey, this._discType, state, errMsg.toString());
                break block60;
                {
                    catch (Exception ex) {
                        state = DiscoveryState.FAILED;
                        errMsg.append(ex).append('\n');
                        _Logger.warn((Object)(this._vc + " " + (Object)((Object)this._discType) + " failed"), (Throwable)ex);
                        this._vc.setManageState(false);
                        this._vc.setStatusDescription("Discovery failed");
                        try {
                            InventoryPersistentManager.getInstance().persistDBObject(this._vc);
                        }
                        catch (Exception e) {
                            _Logger.warn((Object)("Failed to persist Virtualcenter " + this._vc.getVcIpStr() + ". " + e.toString()));
                        }
                        break block60;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this._workers.clear();
                this._discType = null;
                if (this._si != null) {
                    this._si.getServerConnection().logout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startDataCenterWorker(DataCenterImpl dc, VirtualCenterImpl vc) throws DiscoveryException {
        if (dc.getNameKey() == null) {
            throw new DiscoveryException("unknown data center: " + dc);
        }
        DataCenterWorker worker = null;
        try {
            worker = new DataCenterWorker(dc, vc, this);
            List<WorkerIf> list = this._workers;
            synchronized (list) {
                this._workers.add(worker);
            }
            DiscoveryManager.getInstance().getDcWorkerExecutor().execute(worker);
            return true;
        }
        catch (Throwable ex) {
            _Logger.warn((Object)("executing " + worker + " failed: " + ex.getMessage()));
            return false;
        }
    }

    public boolean isTimedOut() {
        return this._timeout;
    }

    void resetTimeout() {
        this._timeout = false;
    }

    void setTimeout(boolean timeout) {
        this._timeout |= timeout;
    }

    public InetAddress getServerAddr() {
        return this._vc.getIpAddress();
    }

    public VirtualCenterImpl getVirtualCenter() {
        return this._vc;
    }

    public ServiceInstance getServiceInstance() {
        return this._si;
    }

    public Collection<NameKey> getPreVHostPKs() {
        return this._preVHostPKs;
    }

    public Collection<NameKey> getPreDsPKs() {
        return this._preDsPKs;
    }

    @Override
    public int getStatus() {
        return this._status.get();
    }

    @Override
    public String getStatusDescr() {
        if (this._workers.size() == 0) {
            return AbstractVmWareWorker.toStatusDescr(this._status.get());
        }
        StringBuilder sb = new StringBuilder(AbstractVmWareWorker.toStatusDescr(this._status.get()));
        for (WorkerIf worker : this._workers) {
            sb.append("\n\t").append(worker).append(": ").append(worker.getStatusDescr());
        }
        return sb.toString();
    }

    public DiscoveryType getDiscoveryType() {
        return this._discType;
    }

    public void setDiscoveryType(DiscoveryType discType) {
        this._discType = discType;
    }

    private ObjectContent[] getDatacenters() throws InvalidProperty, RemoteException {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType("Datacenter");
        pSpec.setPathSet(new String[]{"name", "vmFolder", "hostFolder"});
        SelectionSpec recurseFolders = new SelectionSpec();
        recurseFolders.setName("folder2childEntity");
        TraversalSpec folder2childEntity = new TraversalSpec();
        folder2childEntity.setType("Folder");
        folder2childEntity.setPath("childEntity");
        folder2childEntity.setName(recurseFolders.getName());
        folder2childEntity.setSelectSet(new SelectionSpec[]{recurseFolders});
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(this._sc.getRootFolder());
        oSpec.setSkip(Boolean.TRUE);
        oSpec.setSelectSet(new SelectionSpec[]{folder2childEntity});
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        return this._si.getPropertyCollector().retrieveProperties(new PropertyFilterSpec[]{pfSpec});
    }

    private Object[] getProperties(ManagedObjectReference moRef, String[] properties) throws RuntimeFault, RemoteException {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(moRef.getType());
        pSpec.setPathSet(properties);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(moRef);
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        ObjectContent[] ocs = this._si.getPropertyCollector().retrieveProperties(new PropertyFilterSpec[]{pfSpec});
        Object[] ret = new Object[properties.length];
        if (ocs != null) {
            for (int i = 0; i < ocs.length; ++i) {
                ObjectContent oc = ocs[i];
                DynamicProperty[] dps = oc.getPropSet();
                if (dps == null) continue;
                for (int j = 0; j < dps.length; ++j) {
                    DynamicProperty dp = dps[j];
                    for (int p = 0; p < ret.length; ++p) {
                        if (!properties[p].equals(dp.getName())) continue;
                        ret[p] = dp.getVal();
                    }
                }
            }
        }
        return ret;
    }

    private void printObjectContent(ObjectContent[] ocs, String title) {
        if (ocs != null) {
            _Logger.info((Object)(title + "****Size****" + ocs.length));
            for (int i = 0; i < ocs.length; ++i) {
                ObjectContent oc = ocs[i];
                _Logger.debug((Object)oc.getObj().getType());
                _Logger.debug((Object)"  Property Name:Value");
                DynamicProperty[] dps = oc.getPropSet();
                if (dps == null) continue;
                for (int j = 0; j < dps.length; ++j) {
                    DynamicProperty dp = dps[j];
                    _Logger.debug((Object)("  " + dp.getName() + ": " + dp.getVal()));
                }
            }
        }
    }

    private String prefix() {
        return this.toString() + ": ";
    }

    boolean discoverEvents() {
        try {
            EventManager evtMgr = this._si.getEventManager();
            Event latestEvent = evtMgr.getLatestEvent();
            VCenterWorker.printEvent(latestEvent);
            EventFilterSpec efs = new EventFilterSpec();
            EventFilterSpecByEntity eFilter = new EventFilterSpecByEntity();
            eFilter.setEntity(this._si.getRootFolder().getMOR());
            eFilter.setRecursion(EventFilterSpecRecursionOption.children);
            EventFilterSpecByTime tFilter = new EventFilterSpecByTime();
            Calendar siCurrentTime = (Calendar)this._si.currentTime().clone();
            _Logger.debug((Object)("siCurrentTime was " + siCurrentTime.getTime()));
            long siCurrentTimeMs = siCurrentTime.getTimeInMillis();
            siCurrentTime.setTimeInMillis(this._vc.getVcLastScanTime());
            _Logger.debug((Object)("siCurrentTime is now " + siCurrentTime.getTime()));
            tFilter.setBeginTime(siCurrentTime);
            efs.setTime(tFilter);
            this._vc.setVcLastScanTime(siCurrentTimeMs);
            Event[] events = null;
            try {
                AboutInfo about = this._si.getAboutInfo();
                if (about != null && about.apiVersion != null && about.apiVersion.compareTo("5.0") < 0) {
                    events = evtMgr.queryEvents(efs);
                } else {
                    int MAX_EVENTS = 100;
                    EventHistoryCollector evtHist = evtMgr.createCollectorForEvents(efs);
                    evtHist.resetCollector();
                    ArrayList<Event> eventList = new ArrayList<Event>();
                    Event[] evts = evtHist.readNextEvents(MAX_EVENTS);
                    while (evts != null && evts.length > 0) {
                        eventList.addAll(Arrays.asList(evts));
                        evts = evtHist.readNextEvents(MAX_EVENTS);
                    }
                    events = eventList.toArray(new Event[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof NotImplemented) {
                    _Logger.warn((Object)"vim.queryEvents(): not implemented");
                }
                _Logger.warn((Object)("vim.queryEvents(): " + e.getMessage()));
            }
            for (int i = 0; events != null && i < events.length; ++i) {
                _Logger.debug((Object)("\nEvent #" + i));
                VCenterWorker.printEvent(events[i]);
                if (!(events[i] instanceof DatacenterEvent) && !(events[i] instanceof HostEvent) && !(events[i] instanceof VmEvent) && !(events[i] instanceof DatastoreEvent)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)(this + " error: " + ex.getMessage()), (Throwable)ex);
        }
        return false;
    }

    static void printEvent(Event evt) {
        String typeName = evt.getClass().getName();
        int lastDot = typeName.lastIndexOf(46);
        if (lastDot != -1) {
            typeName = typeName.substring(lastDot + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Type:" + typeName);
        sb.append("\nKey:" + evt.getKey());
        sb.append("\nChainId:" + evt.getChainId());
        sb.append("\nUser:" + evt.getUserName());
        sb.append("\nTime:" + evt.getCreatedTime().getTime());
        sb.append("\nFormattedMessage:" + evt.getFullFormattedMessage());
        if (evt.getDatacenter() != null) {
            sb.append("\nDatacenter:" + evt.getDatacenter().getDatacenter());
        }
        if (evt.getComputeResource() != null) {
            sb.append("\nComputeResource:" + evt.getComputeResource().getComputeResource());
        }
        if (evt.getHost() != null) {
            sb.append("\nHost:" + evt.getHost().getHost());
        }
        if (evt.getVm() != null) {
            sb.append("\nVM:" + evt.getVm().getVm());
        }
        _Logger.debug((Object)sb.toString());
    }
}

